/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.formats.html;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.tools.doclets.formats.html.ConfigurationImpl;
import com.sun.tools.doclets.formats.html.ConstructorWriterImpl;
import com.sun.tools.doclets.formats.html.FieldWriterImpl;
import com.sun.tools.doclets.formats.html.LinkInfoImpl;
import com.sun.tools.doclets.formats.html.MethodWriterImpl;
import com.sun.tools.doclets.formats.html.NestedClassWriterImpl;
import com.sun.tools.doclets.formats.html.PackageUseWriter;
import com.sun.tools.doclets.formats.html.SubWriterHolderWriter;
import com.sun.tools.doclets.formats.html.markup.HtmlConstants;
import com.sun.tools.doclets.formats.html.markup.HtmlStyle;
import com.sun.tools.doclets.formats.html.markup.HtmlTag;
import com.sun.tools.doclets.formats.html.markup.HtmlTree;
import com.sun.tools.doclets.formats.html.markup.RawHtml;
import com.sun.tools.doclets.formats.html.markup.StringContent;
import com.sun.tools.doclets.internal.toolkit.Content;
import com.sun.tools.doclets.internal.toolkit.util.ClassTree;
import com.sun.tools.doclets.internal.toolkit.util.ClassUseMapper;
import com.sun.tools.doclets.internal.toolkit.util.DirectoryManager;
import com.sun.tools.doclets.internal.toolkit.util.DocletAbortException;
import com.sun.tools.doclets.internal.toolkit.util.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class ClassUseWriter
extends SubWriterHolderWriter {
    final ClassDoc classdoc;
    Set<PackageDoc> pkgToPackageAnnotations = null;
    final Map<String, List<ProgramElementDoc>> pkgToClassTypeParameter;
    final Map<String, List<ProgramElementDoc>> pkgToClassAnnotations;
    final Map<String, List<ProgramElementDoc>> pkgToMethodTypeParameter;
    final Map<String, List<ProgramElementDoc>> pkgToMethodArgTypeParameter;
    final Map<String, List<ProgramElementDoc>> pkgToMethodReturnTypeParameter;
    final Map<String, List<ProgramElementDoc>> pkgToMethodAnnotations;
    final Map<String, List<ProgramElementDoc>> pkgToMethodParameterAnnotations;
    final Map<String, List<ProgramElementDoc>> pkgToFieldTypeParameter;
    final Map<String, List<ProgramElementDoc>> pkgToFieldAnnotations;
    final Map<String, List<ProgramElementDoc>> pkgToSubclass;
    final Map<String, List<ProgramElementDoc>> pkgToSubinterface;
    final Map<String, List<ProgramElementDoc>> pkgToImplementingClass;
    final Map<String, List<ProgramElementDoc>> pkgToField;
    final Map<String, List<ProgramElementDoc>> pkgToMethodReturn;
    final Map<String, List<ProgramElementDoc>> pkgToMethodArgs;
    final Map<String, List<ProgramElementDoc>> pkgToMethodThrows;
    final Map<String, List<ProgramElementDoc>> pkgToConstructorAnnotations;
    final Map<String, List<ProgramElementDoc>> pkgToConstructorParameterAnnotations;
    final Map<String, List<ProgramElementDoc>> pkgToConstructorArgs;
    final Map<String, List<ProgramElementDoc>> pkgToConstructorArgTypeParameter;
    final Map<String, List<ProgramElementDoc>> pkgToConstructorThrows;
    final SortedSet<PackageDoc> pkgSet;
    final MethodWriterImpl methodSubWriter;
    final ConstructorWriterImpl constrSubWriter;
    final FieldWriterImpl fieldSubWriter;
    final NestedClassWriterImpl classSubWriter;
    final String classUseTableSummary;
    final String subclassUseTableSummary;
    final String subinterfaceUseTableSummary;
    final String fieldUseTableSummary;
    final String methodUseTableSummary;
    final String constructorUseTableSummary;

    public ClassUseWriter(ConfigurationImpl configurationImpl, ClassUseMapper classUseMapper, String string, String string2, String string3, ClassDoc classDoc) throws IOException {
        super(configurationImpl, string, string2, string3);
        this.classdoc = classDoc;
        if (classUseMapper.classToPackageAnnotations.containsKey(classDoc.qualifiedName())) {
            this.pkgToPackageAnnotations = new HashSet<PackageDoc>((Collection)classUseMapper.classToPackageAnnotations.get(classDoc.qualifiedName()));
        }
        configurationImpl.currentcd = classDoc;
        this.pkgSet = new TreeSet<PackageDoc>();
        this.pkgToClassTypeParameter = this.pkgDivide(classUseMapper.classToClassTypeParam);
        this.pkgToClassAnnotations = this.pkgDivide(classUseMapper.classToClassAnnotations);
        this.pkgToMethodTypeParameter = this.pkgDivide(classUseMapper.classToExecMemberDocTypeParam);
        this.pkgToMethodArgTypeParameter = this.pkgDivide(classUseMapper.classToExecMemberDocArgTypeParam);
        this.pkgToFieldTypeParameter = this.pkgDivide(classUseMapper.classToFieldDocTypeParam);
        this.pkgToFieldAnnotations = this.pkgDivide(classUseMapper.annotationToFieldDoc);
        this.pkgToMethodReturnTypeParameter = this.pkgDivide(classUseMapper.classToExecMemberDocReturnTypeParam);
        this.pkgToMethodAnnotations = this.pkgDivide(classUseMapper.classToExecMemberDocAnnotations);
        this.pkgToMethodParameterAnnotations = this.pkgDivide(classUseMapper.classToExecMemberDocParamAnnotation);
        this.pkgToSubclass = this.pkgDivide(classUseMapper.classToSubclass);
        this.pkgToSubinterface = this.pkgDivide(classUseMapper.classToSubinterface);
        this.pkgToImplementingClass = this.pkgDivide(classUseMapper.classToImplementingClass);
        this.pkgToField = this.pkgDivide(classUseMapper.classToField);
        this.pkgToMethodReturn = this.pkgDivide(classUseMapper.classToMethodReturn);
        this.pkgToMethodArgs = this.pkgDivide(classUseMapper.classToMethodArgs);
        this.pkgToMethodThrows = this.pkgDivide(classUseMapper.classToMethodThrows);
        this.pkgToConstructorAnnotations = this.pkgDivide(classUseMapper.classToConstructorAnnotations);
        this.pkgToConstructorParameterAnnotations = this.pkgDivide(classUseMapper.classToConstructorParamAnnotation);
        this.pkgToConstructorArgs = this.pkgDivide(classUseMapper.classToConstructorArgs);
        this.pkgToConstructorArgTypeParameter = this.pkgDivide(classUseMapper.classToConstructorDocArgTypeParam);
        this.pkgToConstructorThrows = this.pkgDivide(classUseMapper.classToConstructorThrows);
        if (this.pkgSet.size() > 0 && classUseMapper.classToPackage.containsKey(classDoc.qualifiedName()) && !this.pkgSet.equals(classUseMapper.classToPackage.get(classDoc.qualifiedName()))) {
            configurationImpl.root.printWarning("Internal error: package sets don't match: " + this.pkgSet + " with: " + classUseMapper.classToPackage.get(classDoc.qualifiedName()));
        }
        this.methodSubWriter = new MethodWriterImpl(this);
        this.constrSubWriter = new ConstructorWriterImpl(this);
        this.fieldSubWriter = new FieldWriterImpl(this);
        this.classSubWriter = new NestedClassWriterImpl(this);
        this.classUseTableSummary = configurationImpl.getText("doclet.Use_Table_Summary", configurationImpl.getText("doclet.classes"));
        this.subclassUseTableSummary = configurationImpl.getText("doclet.Use_Table_Summary", configurationImpl.getText("doclet.subclasses"));
        this.subinterfaceUseTableSummary = configurationImpl.getText("doclet.Use_Table_Summary", configurationImpl.getText("doclet.subinterfaces"));
        this.fieldUseTableSummary = configurationImpl.getText("doclet.Use_Table_Summary", configurationImpl.getText("doclet.fields"));
        this.methodUseTableSummary = configurationImpl.getText("doclet.Use_Table_Summary", configurationImpl.getText("doclet.methods"));
        this.constructorUseTableSummary = configurationImpl.getText("doclet.Use_Table_Summary", configurationImpl.getText("doclet.constructors"));
    }

    public static void generate(ConfigurationImpl configurationImpl, ClassTree classTree) {
        ClassUseMapper classUseMapper = new ClassUseMapper(configurationImpl.root, classTree);
        ClassDoc[] classDocArray = configurationImpl.root.classes();
        for (int i = 0; i < classDocArray.length; ++i) {
            if (configurationImpl.nodeprecated && Util.isDeprecated(classDocArray[i].containingPackage())) continue;
            ClassUseWriter.generate(configurationImpl, classUseMapper, classDocArray[i]);
        }
        PackageDoc[] packageDocArray = configurationImpl.packages;
        for (int i = 0; i < packageDocArray.length; ++i) {
            if (configurationImpl.nodeprecated && Util.isDeprecated(packageDocArray[i])) continue;
            PackageUseWriter.generate(configurationImpl, classUseMapper, packageDocArray[i]);
        }
    }

    private Map<String, List<ProgramElementDoc>> pkgDivide(Map<String, ? extends List<? extends ProgramElementDoc>> map) {
        HashMap<String, List<ProgramElementDoc>> hashMap = new HashMap<String, List<ProgramElementDoc>>();
        List<? extends ProgramElementDoc> list = map.get(this.classdoc.qualifiedName());
        if (list != null) {
            Collections.sort(list);
            for (ProgramElementDoc programElementDoc : list) {
                PackageDoc packageDoc = programElementDoc.containingPackage();
                this.pkgSet.add(packageDoc);
                ArrayList<ProgramElementDoc> arrayList = (ArrayList<ProgramElementDoc>)hashMap.get(packageDoc.name());
                if (arrayList == null) {
                    arrayList = new ArrayList<ProgramElementDoc>();
                    hashMap.put(packageDoc.name(), arrayList);
                }
                arrayList.add(programElementDoc);
            }
        }
        return hashMap;
    }

    public static void generate(ConfigurationImpl configurationImpl, ClassUseMapper classUseMapper, ClassDoc classDoc) {
        String string = DirectoryManager.getDirectoryPath(classDoc.containingPackage());
        string = string + "class-use/";
        String string2 = classDoc.name() + ".html";
        String string3 = classDoc.containingPackage().name();
        string3 = string3 + (string3.length() > 0 ? ".class-use" : "class-use");
        String string4 = DirectoryManager.getRelativePath(string3);
        try {
            ClassUseWriter classUseWriter = new ClassUseWriter(configurationImpl, classUseMapper, string, string2, string4, classDoc);
            classUseWriter.generateClassUseFile();
            classUseWriter.close();
        }
        catch (IOException iOException) {
            configurationImpl.standardmessage.error("doclet.exception_encountered", iOException.toString(), string2);
            throw new DocletAbortException();
        }
    }

    protected void generateClassUseFile() throws IOException {
        Content content = this.getClassUseHeader();
        HtmlTree htmlTree = new HtmlTree(HtmlTag.DIV);
        htmlTree.addStyle(HtmlStyle.classUseContainer);
        if (this.pkgSet.size() > 0) {
            this.addClassUse(htmlTree);
        } else {
            htmlTree.addContent(this.getResource("doclet.ClassUse_No.usage.of.0", this.classdoc.qualifiedName()));
        }
        content.addContent(htmlTree);
        this.addNavLinks(false, content);
        this.addBottom(content);
        this.printHtmlDocument(null, true, content);
    }

    protected void addClassUse(Content content) throws IOException {
        HtmlTree htmlTree = new HtmlTree(HtmlTag.UL);
        htmlTree.addStyle(HtmlStyle.blockList);
        if (this.configuration.packages.length > 1) {
            this.addPackageList(htmlTree);
            this.addPackageAnnotationList(htmlTree);
        }
        this.addClassList(htmlTree);
        content.addContent(htmlTree);
    }

    protected void addPackageList(Content content) throws IOException {
        HtmlTree htmlTree = HtmlTree.TABLE(0, 3, 0, this.useTableSummary, this.getTableCaption(this.configuration().getText("doclet.ClassUse_Packages.that.use.0", this.getLink(new LinkInfoImpl(33, this.classdoc, false)))));
        ((Content)htmlTree).addContent(this.getSummaryTableHeader(this.packageTableHeader, "col"));
        HtmlTree htmlTree2 = new HtmlTree(HtmlTag.TBODY);
        Iterator iterator = this.pkgSet.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            PackageDoc packageDoc = (PackageDoc)iterator.next();
            HtmlTree htmlTree3 = new HtmlTree(HtmlTag.TR);
            if (n % 2 == 0) {
                htmlTree3.addStyle(HtmlStyle.altColor);
            } else {
                htmlTree3.addStyle(HtmlStyle.rowColor);
            }
            this.addPackageUse(packageDoc, htmlTree3);
            ((Content)htmlTree2).addContent(htmlTree3);
            ++n;
        }
        ((Content)htmlTree).addContent(htmlTree2);
        HtmlTree htmlTree4 = HtmlTree.LI(HtmlStyle.blockList, htmlTree);
        content.addContent(htmlTree4);
    }

    protected void addPackageAnnotationList(Content content) throws IOException {
        if (!this.classdoc.isAnnotationType() || this.pkgToPackageAnnotations == null || this.pkgToPackageAnnotations.size() == 0) {
            return;
        }
        HtmlTree htmlTree = HtmlTree.TABLE(0, 3, 0, this.useTableSummary, this.getTableCaption(this.configuration().getText("doclet.ClassUse_PackageAnnotation", this.getLink(new LinkInfoImpl(33, this.classdoc, false)))));
        ((Content)htmlTree).addContent(this.getSummaryTableHeader(this.packageTableHeader, "col"));
        HtmlTree htmlTree2 = new HtmlTree(HtmlTag.TBODY);
        Iterator<PackageDoc> iterator = this.pkgToPackageAnnotations.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            PackageDoc packageDoc = iterator.next();
            HtmlTree htmlTree3 = new HtmlTree(HtmlTag.TR);
            if (n % 2 == 0) {
                htmlTree3.addStyle(HtmlStyle.altColor);
            } else {
                htmlTree3.addStyle(HtmlStyle.rowColor);
            }
            HtmlTree htmlTree4 = HtmlTree.TD(HtmlStyle.colFirst, this.getPackageLink(packageDoc, new StringContent(packageDoc.name())));
            htmlTree3.addContent(htmlTree4);
            HtmlTree htmlTree5 = new HtmlTree(HtmlTag.TD);
            htmlTree5.addStyle(HtmlStyle.colLast);
            this.addSummaryComment(packageDoc, htmlTree5);
            htmlTree3.addContent(htmlTree5);
            ((Content)htmlTree2).addContent(htmlTree3);
            ++n;
        }
        ((Content)htmlTree).addContent(htmlTree2);
        HtmlTree htmlTree6 = HtmlTree.LI(HtmlStyle.blockList, htmlTree);
        content.addContent(htmlTree6);
    }

    protected void addClassList(Content content) throws IOException {
        HtmlTree htmlTree = new HtmlTree(HtmlTag.UL);
        htmlTree.addStyle(HtmlStyle.blockList);
        for (PackageDoc packageDoc : this.pkgSet) {
            HtmlTree htmlTree2 = HtmlTree.LI(HtmlStyle.blockList, this.getMarkerAnchor(packageDoc.name()));
            RawHtml rawHtml = new RawHtml(this.configuration.getText("doclet.ClassUse_Uses.of.0.in.1", this.getLink(new LinkInfoImpl(33, this.classdoc, false)), this.getPackageLinkString(packageDoc, Util.getPackageName(packageDoc), false)));
            HtmlTree htmlTree3 = HtmlTree.HEADING(HtmlConstants.SUMMARY_HEADING, rawHtml);
            ((Content)htmlTree2).addContent(htmlTree3);
            this.addClassUse(packageDoc, htmlTree2);
            htmlTree.addContent(htmlTree2);
        }
        HtmlTree htmlTree4 = HtmlTree.LI(HtmlStyle.blockList, htmlTree);
        content.addContent(htmlTree4);
    }

    protected void addPackageUse(PackageDoc packageDoc, Content content) throws IOException {
        HtmlTree htmlTree = HtmlTree.TD(HtmlStyle.colFirst, this.getHyperLink("", packageDoc.name(), new StringContent(Util.getPackageName(packageDoc))));
        content.addContent(htmlTree);
        HtmlTree htmlTree2 = new HtmlTree(HtmlTag.TD);
        htmlTree2.addStyle(HtmlStyle.colLast);
        this.addSummaryComment(packageDoc, htmlTree2);
        content.addContent(htmlTree2);
    }

    protected void addClassUse(PackageDoc packageDoc, Content content) throws IOException {
        String string = this.getLink(new LinkInfoImpl(33, this.classdoc, false));
        String string2 = this.getPackageLinkString(packageDoc, Util.getPackageName(packageDoc), false);
        this.classSubWriter.addUseInfo(this.pkgToClassAnnotations.get(packageDoc.name()), this.configuration.getText("doclet.ClassUse_Annotation", string, string2), this.classUseTableSummary, content);
        this.classSubWriter.addUseInfo(this.pkgToClassTypeParameter.get(packageDoc.name()), this.configuration.getText("doclet.ClassUse_TypeParameter", string, string2), this.classUseTableSummary, content);
        this.classSubWriter.addUseInfo(this.pkgToSubclass.get(packageDoc.name()), this.configuration.getText("doclet.ClassUse_Subclass", string, string2), this.subclassUseTableSummary, content);
        this.classSubWriter.addUseInfo(this.pkgToSubinterface.get(packageDoc.name()), this.configuration.getText("doclet.ClassUse_Subinterface", string, string2), this.subinterfaceUseTableSummary, content);
        this.classSubWriter.addUseInfo(this.pkgToImplementingClass.get(packageDoc.name()), this.configuration.getText("doclet.ClassUse_ImplementingClass", string, string2), this.classUseTableSummary, content);
        this.fieldSubWriter.addUseInfo(this.pkgToField.get(packageDoc.name()), this.configuration.getText("doclet.ClassUse_Field", string, string2), this.fieldUseTableSummary, content);
        this.fieldSubWriter.addUseInfo(this.pkgToFieldAnnotations.get(packageDoc.name()), this.configuration.getText("doclet.ClassUse_FieldAnnotations", string, string2), this.fieldUseTableSummary, content);
        this.fieldSubWriter.addUseInfo(this.pkgToFieldTypeParameter.get(packageDoc.name()), this.configuration.getText("doclet.ClassUse_FieldTypeParameter", string, string2), this.fieldUseTableSummary, content);
        this.methodSubWriter.addUseInfo(this.pkgToMethodAnnotations.get(packageDoc.name()), this.configuration.getText("doclet.ClassUse_MethodAnnotations", string, string2), this.methodUseTableSummary, content);
        this.methodSubWriter.addUseInfo(this.pkgToMethodParameterAnnotations.get(packageDoc.name()), this.configuration.getText("doclet.ClassUse_MethodParameterAnnotations", string, string2), this.methodUseTableSummary, content);
        this.methodSubWriter.addUseInfo(this.pkgToMethodTypeParameter.get(packageDoc.name()), this.configuration.getText("doclet.ClassUse_MethodTypeParameter", string, string2), this.methodUseTableSummary, content);
        this.methodSubWriter.addUseInfo(this.pkgToMethodReturn.get(packageDoc.name()), this.configuration.getText("doclet.ClassUse_MethodReturn", string, string2), this.methodUseTableSummary, content);
        this.methodSubWriter.addUseInfo(this.pkgToMethodReturnTypeParameter.get(packageDoc.name()), this.configuration.getText("doclet.ClassUse_MethodReturnTypeParameter", string, string2), this.methodUseTableSummary, content);
        this.methodSubWriter.addUseInfo(this.pkgToMethodArgs.get(packageDoc.name()), this.configuration.getText("doclet.ClassUse_MethodArgs", string, string2), this.methodUseTableSummary, content);
        this.methodSubWriter.addUseInfo(this.pkgToMethodArgTypeParameter.get(packageDoc.name()), this.configuration.getText("doclet.ClassUse_MethodArgsTypeParameters", string, string2), this.methodUseTableSummary, content);
        this.methodSubWriter.addUseInfo(this.pkgToMethodThrows.get(packageDoc.name()), this.configuration.getText("doclet.ClassUse_MethodThrows", string, string2), this.methodUseTableSummary, content);
        this.constrSubWriter.addUseInfo(this.pkgToConstructorAnnotations.get(packageDoc.name()), this.configuration.getText("doclet.ClassUse_ConstructorAnnotations", string, string2), this.constructorUseTableSummary, content);
        this.constrSubWriter.addUseInfo(this.pkgToConstructorParameterAnnotations.get(packageDoc.name()), this.configuration.getText("doclet.ClassUse_ConstructorParameterAnnotations", string, string2), this.constructorUseTableSummary, content);
        this.constrSubWriter.addUseInfo(this.pkgToConstructorArgs.get(packageDoc.name()), this.configuration.getText("doclet.ClassUse_ConstructorArgs", string, string2), this.constructorUseTableSummary, content);
        this.constrSubWriter.addUseInfo(this.pkgToConstructorArgTypeParameter.get(packageDoc.name()), this.configuration.getText("doclet.ClassUse_ConstructorArgsTypeParameters", string, string2), this.constructorUseTableSummary, content);
        this.constrSubWriter.addUseInfo(this.pkgToConstructorThrows.get(packageDoc.name()), this.configuration.getText("doclet.ClassUse_ConstructorThrows", string, string2), this.constructorUseTableSummary, content);
    }

    protected Content getClassUseHeader() {
        String string = this.configuration.getText(this.classdoc.isInterface() ? "doclet.Interface" : "doclet.Class");
        String string2 = this.classdoc.qualifiedName();
        String string3 = this.configuration.getText("doclet.Window_ClassUse_Header", string, string2);
        HtmlTree htmlTree = this.getBody(true, this.getWindowTitle(string3));
        this.addTop(htmlTree);
        this.addNavLinks(true, htmlTree);
        Content content = this.getResource("doclet.ClassUse_Title", string, string2);
        HtmlTree htmlTree2 = HtmlTree.HEADING(HtmlConstants.CLASS_PAGE_HEADING, true, HtmlStyle.title, content);
        HtmlTree htmlTree3 = HtmlTree.DIV(HtmlStyle.header, htmlTree2);
        ((Content)htmlTree).addContent(htmlTree3);
        return htmlTree;
    }

    @Override
    protected Content getNavLinkPackage() {
        Content content = this.getHyperLink("../package-summary.html", "", this.packageLabel);
        HtmlTree htmlTree = HtmlTree.LI(content);
        return htmlTree;
    }

    @Override
    protected Content getNavLinkClass() {
        RawHtml rawHtml = new RawHtml(this.getLink(new LinkInfoImpl(33, this.classdoc, "", this.configuration.getText("doclet.Class"), false)));
        HtmlTree htmlTree = HtmlTree.LI(rawHtml);
        return htmlTree;
    }

    @Override
    protected Content getNavLinkClassUse() {
        HtmlTree htmlTree = HtmlTree.LI(HtmlStyle.navBarCell1Rev, this.useLabel);
        return htmlTree;
    }

    @Override
    protected Content getNavLinkTree() {
        Content content = this.classdoc.containingPackage().isIncluded() ? this.getHyperLink("../package-tree.html", "", this.treeLabel) : this.getHyperLink(this.relativePath + "overview-tree.html", "", this.treeLabel);
        HtmlTree htmlTree = HtmlTree.LI(content);
        return htmlTree;
    }
}

