/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jcmd;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;

class Arguments {
    private boolean listProcesses;
    private boolean listCounters;
    private boolean showUsage;
    private int pid;
    private String command;
    private String processSubstring;

    public boolean isListProcesses() {
        return this.listProcesses;
    }

    public boolean isListCounters() {
        return this.listCounters;
    }

    public boolean isShowUsage() {
        return this.showUsage;
    }

    public int getPid() {
        return this.pid;
    }

    public String getCommand() {
        return this.command;
    }

    public String getProcessSubstring() {
        return this.processSubstring;
    }

    public Arguments(String[] stringArray) {
        block12: {
            this.listProcesses = false;
            this.listCounters = false;
            this.showUsage = false;
            this.pid = -1;
            this.command = null;
            if (stringArray.length == 0 || stringArray[0].equals("-l")) {
                this.listProcesses = true;
                return;
            }
            if (stringArray[0].equals("-h") || stringArray[0].equals("-help")) {
                this.showUsage = true;
                return;
            }
            try {
                this.pid = Integer.parseInt(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                if (stringArray[0].charAt(0) == '-') break block12;
                this.processSubstring = stringArray[0];
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 1; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-f")) {
                if (stringArray.length == i + 1) {
                    throw new IllegalArgumentException("No file specified for parameter -f");
                }
                if (stringArray.length == i + 2) {
                    try {
                        this.readCommandFile(stringArray[i + 1]);
                    }
                    catch (IOException iOException) {
                        throw new IllegalArgumentException("Could not read from file specified with -f option: " + stringArray[i + 1]);
                    }
                    return;
                }
                throw new IllegalArgumentException("Options after -f are not allowed");
            }
            if (stringArray[i].equals("PerfCounter.print")) {
                this.listCounters = true;
                continue;
            }
            stringBuilder.append(stringArray[i]).append(" ");
        }
        if (!this.listCounters && stringBuilder.length() == 0) {
            throw new IllegalArgumentException("No command specified");
        }
        this.command = stringBuilder.toString().trim();
    }

    private void readCommandFile(String string) throws IOException {
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(string));){
            String string2;
            StringBuilder stringBuilder = new StringBuilder();
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuilder.append(string2).append("\n");
            }
            this.command = stringBuilder.toString();
        }
    }

    public static void usage() {
        System.out.println("Usage: jcmd <pid | main class> <command ...|PerfCounter.print|-f file>");
        System.out.println("   or: jcmd -l                                                    ");
        System.out.println("   or: jcmd -h                                                    ");
        System.out.println("                                                                  ");
        System.out.println("  command must be a valid jcmd command for the selected jvm.      ");
        System.out.println("  Use the command \"help\" to see which commands are available.   ");
        System.out.println("  If the pid is 0, commands will be sent to all Java processes.   ");
        System.out.println("  The main class argument will be used to match (either partially ");
        System.out.println("  or fully) the class used to start Java.                         ");
        System.out.println("  If no options are given, lists Java processes (same as -p).     ");
        System.out.println("                                                                  ");
        System.out.println("  PerfCounter.print display the counters exposed by this process  ");
        System.out.println("  -f  read and execute commands from the file                     ");
        System.out.println("  -l  list JVM processes on the local machine                     ");
        System.out.println("  -h  this help                                                   ");
    }
}

