/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.org.objectweb.asm.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.checkerframework.org.objectweb.asm.AnnotationVisitor;
import org.checkerframework.org.objectweb.asm.ClassVisitor;
import org.checkerframework.org.objectweb.asm.ClassWriter;
import org.checkerframework.org.objectweb.asm.FieldVisitor;
import org.checkerframework.org.objectweb.asm.Label;
import org.checkerframework.org.objectweb.asm.MethodVisitor;
import org.checkerframework.org.objectweb.asm.Opcodes;
import org.checkerframework.org.objectweb.asm.Type;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ASMContentHandler
extends DefaultHandler
implements Opcodes {
    private List stack = new ArrayList();
    private String match = "";
    protected boolean computeMax;
    protected OutputStream os;
    protected ClassWriter cw;
    protected Map labels;
    private static final String BASE = "class";
    private final RuleSet RULES = new RuleSet();
    static final Map OPCODES = new HashMap();

    public ASMContentHandler(OutputStream os, boolean computeMax) {
        this.RULES.add(BASE, new ClassRule());
        this.RULES.add("class/interfaces/interface", new InterfaceRule());
        this.RULES.add("class/interfaces", new InterfacesRule());
        this.RULES.add("class/outerclass", new OuterClassRule());
        this.RULES.add("class/innerclass", new InnerClassRule());
        this.RULES.add("class/source", new SourceRule());
        this.RULES.add("class/field", new FieldRule());
        this.RULES.add("class/method", new MethodRule());
        this.RULES.add("class/method/exceptions/exception", new ExceptionRule());
        this.RULES.add("class/method/exceptions", new ExceptionsRule());
        this.RULES.add("class/method/annotationDefault", new AnnotationDefaultRule());
        this.RULES.add("class/method/code/*", new OpcodesRule());
        this.RULES.add("class/method/code/TABLESWITCH", new TableSwitchRule());
        this.RULES.add("class/method/code/TABLESWITCH/label", new TableSwitchLabelRule());
        this.RULES.add("class/method/code/LOOKUPSWITCH", new LookupSwitchRule());
        this.RULES.add("class/method/code/LOOKUPSWITCH/label", new LookupSwitchLabelRule());
        this.RULES.add("class/method/code/Label", new LabelRule());
        this.RULES.add("class/method/code/TryCatch", new TryCatchRule());
        this.RULES.add("class/method/code/LineNumber", new LineNumberRule());
        this.RULES.add("class/method/code/LocalVar", new LocalVarRule());
        this.RULES.add("class/method/code/Max", new MaxRule());
        this.RULES.add("*/annotation", new AnnotationRule());
        this.RULES.add("*/parameterAnnotation", new AnnotationParameterRule());
        this.RULES.add("*/annotationValue", new AnnotationValueRule());
        this.RULES.add("*/annotationValueAnnotation", new AnnotationValueAnnotationRule());
        this.RULES.add("*/annotationValueEnum", new AnnotationValueEnumRule());
        this.RULES.add("*/annotationValueArray", new AnnotationValueArrayRule());
        this.os = os;
        this.computeMax = computeMax;
    }

    public byte[] toByteArray() {
        return this.cw == null ? null : this.cw.toByteArray();
    }

    @Override
    public final void startElement(String ns, String localName, String qName, Attributes list) throws SAXException {
        String name = localName;
        if (name == null || name.length() < 1) {
            name = qName;
        }
        StringBuffer sb = new StringBuffer(this.match);
        if (this.match.length() > 0) {
            sb.append('/');
        }
        sb.append(name);
        this.match = sb.toString();
        Rule r = (Rule)this.RULES.match(this.match);
        if (r != null) {
            r.begin(name, list);
        }
    }

    @Override
    public final void endElement(String ns, String localName, String qName) throws SAXException {
        int slash;
        Rule r;
        String name = localName;
        if (name == null || name.length() < 1) {
            name = qName;
        }
        if ((r = (Rule)this.RULES.match(this.match)) != null) {
            r.end(name);
        }
        this.match = (slash = this.match.lastIndexOf(47)) >= 0 ? this.match.substring(0, slash) : "";
    }

    @Override
    public final void endDocument() throws SAXException {
        try {
            this.os.write(this.cw.toByteArray());
        }
        catch (IOException ex) {
            throw new SAXException(ex.toString(), ex);
        }
    }

    final Object peek() {
        return this.stack.size() == 0 ? null : this.stack.get(this.stack.size() - 1);
    }

    final Object peek(int n) {
        return this.stack.size() < n + 1 ? null : this.stack.get(n);
    }

    final Object pop() {
        return this.stack.size() == 0 ? null : this.stack.remove(this.stack.size() - 1);
    }

    final void push(Object object) {
        this.stack.add(object);
    }

    static {
        OPCODES.put("NOP", new Opcode(0, 0));
        OPCODES.put("ACONST_NULL", new Opcode(1, 0));
        OPCODES.put("ICONST_M1", new Opcode(2, 0));
        OPCODES.put("ICONST_0", new Opcode(3, 0));
        OPCODES.put("ICONST_1", new Opcode(4, 0));
        OPCODES.put("ICONST_2", new Opcode(5, 0));
        OPCODES.put("ICONST_3", new Opcode(6, 0));
        OPCODES.put("ICONST_4", new Opcode(7, 0));
        OPCODES.put("ICONST_5", new Opcode(8, 0));
        OPCODES.put("LCONST_0", new Opcode(9, 0));
        OPCODES.put("LCONST_1", new Opcode(10, 0));
        OPCODES.put("FCONST_0", new Opcode(11, 0));
        OPCODES.put("FCONST_1", new Opcode(12, 0));
        OPCODES.put("FCONST_2", new Opcode(13, 0));
        OPCODES.put("DCONST_0", new Opcode(14, 0));
        OPCODES.put("DCONST_1", new Opcode(15, 0));
        OPCODES.put("BIPUSH", new Opcode(16, 1));
        OPCODES.put("SIPUSH", new Opcode(17, 1));
        OPCODES.put("LDC", new Opcode(18, 7));
        OPCODES.put("ILOAD", new Opcode(21, 2));
        OPCODES.put("LLOAD", new Opcode(22, 2));
        OPCODES.put("FLOAD", new Opcode(23, 2));
        OPCODES.put("DLOAD", new Opcode(24, 2));
        OPCODES.put("ALOAD", new Opcode(25, 2));
        OPCODES.put("IALOAD", new Opcode(46, 0));
        OPCODES.put("LALOAD", new Opcode(47, 0));
        OPCODES.put("FALOAD", new Opcode(48, 0));
        OPCODES.put("DALOAD", new Opcode(49, 0));
        OPCODES.put("AALOAD", new Opcode(50, 0));
        OPCODES.put("BALOAD", new Opcode(51, 0));
        OPCODES.put("CALOAD", new Opcode(52, 0));
        OPCODES.put("SALOAD", new Opcode(53, 0));
        OPCODES.put("ISTORE", new Opcode(54, 2));
        OPCODES.put("LSTORE", new Opcode(55, 2));
        OPCODES.put("FSTORE", new Opcode(56, 2));
        OPCODES.put("DSTORE", new Opcode(57, 2));
        OPCODES.put("ASTORE", new Opcode(58, 2));
        OPCODES.put("IASTORE", new Opcode(79, 0));
        OPCODES.put("LASTORE", new Opcode(80, 0));
        OPCODES.put("FASTORE", new Opcode(81, 0));
        OPCODES.put("DASTORE", new Opcode(82, 0));
        OPCODES.put("AASTORE", new Opcode(83, 0));
        OPCODES.put("BASTORE", new Opcode(84, 0));
        OPCODES.put("CASTORE", new Opcode(85, 0));
        OPCODES.put("SASTORE", new Opcode(86, 0));
        OPCODES.put("POP", new Opcode(87, 0));
        OPCODES.put("POP2", new Opcode(88, 0));
        OPCODES.put("DUP", new Opcode(89, 0));
        OPCODES.put("DUP_X1", new Opcode(90, 0));
        OPCODES.put("DUP_X2", new Opcode(91, 0));
        OPCODES.put("DUP2", new Opcode(92, 0));
        OPCODES.put("DUP2_X1", new Opcode(93, 0));
        OPCODES.put("DUP2_X2", new Opcode(94, 0));
        OPCODES.put("SWAP", new Opcode(95, 0));
        OPCODES.put("IADD", new Opcode(96, 0));
        OPCODES.put("LADD", new Opcode(97, 0));
        OPCODES.put("FADD", new Opcode(98, 0));
        OPCODES.put("DADD", new Opcode(99, 0));
        OPCODES.put("ISUB", new Opcode(100, 0));
        OPCODES.put("LSUB", new Opcode(101, 0));
        OPCODES.put("FSUB", new Opcode(102, 0));
        OPCODES.put("DSUB", new Opcode(103, 0));
        OPCODES.put("IMUL", new Opcode(104, 0));
        OPCODES.put("LMUL", new Opcode(105, 0));
        OPCODES.put("FMUL", new Opcode(106, 0));
        OPCODES.put("DMUL", new Opcode(107, 0));
        OPCODES.put("IDIV", new Opcode(108, 0));
        OPCODES.put("LDIV", new Opcode(109, 0));
        OPCODES.put("FDIV", new Opcode(110, 0));
        OPCODES.put("DDIV", new Opcode(111, 0));
        OPCODES.put("IREM", new Opcode(112, 0));
        OPCODES.put("LREM", new Opcode(113, 0));
        OPCODES.put("FREM", new Opcode(114, 0));
        OPCODES.put("DREM", new Opcode(115, 0));
        OPCODES.put("INEG", new Opcode(116, 0));
        OPCODES.put("LNEG", new Opcode(117, 0));
        OPCODES.put("FNEG", new Opcode(118, 0));
        OPCODES.put("DNEG", new Opcode(119, 0));
        OPCODES.put("ISHL", new Opcode(120, 0));
        OPCODES.put("LSHL", new Opcode(121, 0));
        OPCODES.put("ISHR", new Opcode(122, 0));
        OPCODES.put("LSHR", new Opcode(123, 0));
        OPCODES.put("IUSHR", new Opcode(124, 0));
        OPCODES.put("LUSHR", new Opcode(125, 0));
        OPCODES.put("IAND", new Opcode(126, 0));
        OPCODES.put("LAND", new Opcode(127, 0));
        OPCODES.put("IOR", new Opcode(128, 0));
        OPCODES.put("LOR", new Opcode(129, 0));
        OPCODES.put("IXOR", new Opcode(130, 0));
        OPCODES.put("LXOR", new Opcode(131, 0));
        OPCODES.put("IINC", new Opcode(132, 8));
        OPCODES.put("I2L", new Opcode(133, 0));
        OPCODES.put("I2F", new Opcode(134, 0));
        OPCODES.put("I2D", new Opcode(135, 0));
        OPCODES.put("L2I", new Opcode(136, 0));
        OPCODES.put("L2F", new Opcode(137, 0));
        OPCODES.put("L2D", new Opcode(138, 0));
        OPCODES.put("F2I", new Opcode(139, 0));
        OPCODES.put("F2L", new Opcode(140, 0));
        OPCODES.put("F2D", new Opcode(141, 0));
        OPCODES.put("D2I", new Opcode(142, 0));
        OPCODES.put("D2L", new Opcode(143, 0));
        OPCODES.put("D2F", new Opcode(144, 0));
        OPCODES.put("I2B", new Opcode(145, 0));
        OPCODES.put("I2C", new Opcode(146, 0));
        OPCODES.put("I2S", new Opcode(147, 0));
        OPCODES.put("LCMP", new Opcode(148, 0));
        OPCODES.put("FCMPL", new Opcode(149, 0));
        OPCODES.put("FCMPG", new Opcode(150, 0));
        OPCODES.put("DCMPL", new Opcode(151, 0));
        OPCODES.put("DCMPG", new Opcode(152, 0));
        OPCODES.put("IFEQ", new Opcode(153, 6));
        OPCODES.put("IFNE", new Opcode(154, 6));
        OPCODES.put("IFLT", new Opcode(155, 6));
        OPCODES.put("IFGE", new Opcode(156, 6));
        OPCODES.put("IFGT", new Opcode(157, 6));
        OPCODES.put("IFLE", new Opcode(158, 6));
        OPCODES.put("IF_ICMPEQ", new Opcode(159, 6));
        OPCODES.put("IF_ICMPNE", new Opcode(160, 6));
        OPCODES.put("IF_ICMPLT", new Opcode(161, 6));
        OPCODES.put("IF_ICMPGE", new Opcode(162, 6));
        OPCODES.put("IF_ICMPGT", new Opcode(163, 6));
        OPCODES.put("IF_ICMPLE", new Opcode(164, 6));
        OPCODES.put("IF_ACMPEQ", new Opcode(165, 6));
        OPCODES.put("IF_ACMPNE", new Opcode(166, 6));
        OPCODES.put("GOTO", new Opcode(167, 6));
        OPCODES.put("JSR", new Opcode(168, 6));
        OPCODES.put("RET", new Opcode(169, 2));
        OPCODES.put("IRETURN", new Opcode(172, 0));
        OPCODES.put("LRETURN", new Opcode(173, 0));
        OPCODES.put("FRETURN", new Opcode(174, 0));
        OPCODES.put("DRETURN", new Opcode(175, 0));
        OPCODES.put("ARETURN", new Opcode(176, 0));
        OPCODES.put("RETURN", new Opcode(177, 0));
        OPCODES.put("GETSTATIC", new Opcode(178, 4));
        OPCODES.put("PUTSTATIC", new Opcode(179, 4));
        OPCODES.put("GETFIELD", new Opcode(180, 4));
        OPCODES.put("PUTFIELD", new Opcode(181, 4));
        OPCODES.put("INVOKEVIRTUAL", new Opcode(182, 5));
        OPCODES.put("INVOKESPECIAL", new Opcode(183, 5));
        OPCODES.put("INVOKESTATIC", new Opcode(184, 5));
        OPCODES.put("INVOKEINTERFACE", new Opcode(185, 5));
        OPCODES.put("NEW", new Opcode(187, 3));
        OPCODES.put("NEWARRAY", new Opcode(188, 1));
        OPCODES.put("ANEWARRAY", new Opcode(189, 3));
        OPCODES.put("ARRAYLENGTH", new Opcode(190, 0));
        OPCODES.put("ATHROW", new Opcode(191, 0));
        OPCODES.put("CHECKCAST", new Opcode(192, 3));
        OPCODES.put("INSTANCEOF", new Opcode(193, 3));
        OPCODES.put("MONITORENTER", new Opcode(194, 0));
        OPCODES.put("MONITOREXIT", new Opcode(195, 0));
        OPCODES.put("MULTIANEWARRAY", new Opcode(197, 9));
        OPCODES.put("IFNULL", new Opcode(198, 6));
        OPCODES.put("IFNONNULL", new Opcode(199, 6));
    }

    private static final class Opcode {
        public int opcode;
        public int type;

        public Opcode(int opcode, int type) {
            this.opcode = opcode;
            this.type = type;
        }
    }

    private final class AnnotationDefaultRule
    extends Rule {
        private AnnotationDefaultRule() {
        }

        @Override
        public void begin(String nm, Attributes attrs) {
            ASMContentHandler.this.push(((MethodVisitor)ASMContentHandler.this.peek()).visitAnnotationDefault());
        }

        @Override
        public void end(String name) {
            ((AnnotationVisitor)ASMContentHandler.this.pop()).visitEnd();
        }
    }

    private final class AnnotationValueArrayRule
    extends Rule {
        private AnnotationValueArrayRule() {
        }

        @Override
        public void begin(String nm, Attributes attrs) {
            String name = attrs.getValue("name");
            ASMContentHandler.this.push(((AnnotationVisitor)ASMContentHandler.this.peek()).visitArray(name));
        }

        @Override
        public void end(String name) {
            ((AnnotationVisitor)ASMContentHandler.this.pop()).visitEnd();
        }
    }

    private final class AnnotationValueAnnotationRule
    extends Rule {
        private AnnotationValueAnnotationRule() {
        }

        @Override
        public void begin(String nm, Attributes attrs) {
            String name = attrs.getValue("name");
            String desc = attrs.getValue("desc");
            ASMContentHandler.this.push(((AnnotationVisitor)ASMContentHandler.this.peek()).visitAnnotation(name, desc));
        }

        @Override
        public void end(String name) {
            ((AnnotationVisitor)ASMContentHandler.this.pop()).visitEnd();
        }
    }

    private final class AnnotationValueEnumRule
    extends Rule {
        private AnnotationValueEnumRule() {
        }

        @Override
        public void begin(String nm, Attributes attrs) {
            String name = attrs.getValue("name");
            String desc = attrs.getValue("desc");
            String value = attrs.getValue("value");
            ((AnnotationVisitor)ASMContentHandler.this.peek()).visitEnum(name, desc, value);
        }
    }

    private final class AnnotationValueRule
    extends Rule {
        private AnnotationValueRule() {
        }

        @Override
        public void begin(String nm, Attributes attrs) {
            String name = attrs.getValue("name");
            String desc = attrs.getValue("desc");
            String value = attrs.getValue("value");
            ((AnnotationVisitor)ASMContentHandler.this.peek()).visit(name, this.getValue(desc, value));
        }
    }

    private final class AnnotationParameterRule
    extends Rule {
        private AnnotationParameterRule() {
        }

        @Override
        public void begin(String name, Attributes attrs) {
            int parameter = Integer.parseInt(attrs.getValue("parameter"));
            String desc = attrs.getValue("desc");
            boolean visible = Boolean.valueOf(attrs.getValue("visible"));
            ASMContentHandler.this.push(((MethodVisitor)ASMContentHandler.this.peek()).visitParameterAnnotation(parameter, desc, visible));
        }

        @Override
        public void end(String name) {
            ((AnnotationVisitor)ASMContentHandler.this.pop()).visitEnd();
        }
    }

    private final class AnnotationRule
    extends Rule {
        private AnnotationRule() {
        }

        @Override
        public void begin(String name, Attributes attrs) {
            String desc = attrs.getValue("desc");
            boolean visible = Boolean.valueOf(attrs.getValue("visible"));
            Object v = ASMContentHandler.this.peek();
            if (v instanceof ClassVisitor) {
                ASMContentHandler.this.push(((ClassVisitor)v).visitAnnotation(desc, visible));
            } else if (v instanceof FieldVisitor) {
                ASMContentHandler.this.push(((FieldVisitor)v).visitAnnotation(desc, visible));
            } else if (v instanceof MethodVisitor) {
                ASMContentHandler.this.push(((MethodVisitor)v).visitAnnotation(desc, visible));
            }
        }

        @Override
        public void end(String name) {
            ((AnnotationVisitor)ASMContentHandler.this.pop()).visitEnd();
        }
    }

    private final class MaxRule
    extends Rule {
        private MaxRule() {
        }

        @Override
        public final void begin(String element, Attributes attrs) {
            int maxStack = Integer.parseInt(attrs.getValue("maxStack"));
            int maxLocals = Integer.parseInt(attrs.getValue("maxLocals"));
            this.getCodeVisitor().visitMaxs(maxStack, maxLocals);
        }
    }

    private final class OpcodesRule
    extends Rule {
        private OpcodesRule() {
        }

        @Override
        public final void begin(String element, Attributes attrs) {
            Opcode o = (Opcode)OPCODES.get(element);
            if (o == null) {
                return;
            }
            switch (o.type) {
                case 0: {
                    this.getCodeVisitor().visitInsn(o.opcode);
                    break;
                }
                case 4: {
                    this.getCodeVisitor().visitFieldInsn(o.opcode, attrs.getValue("owner"), attrs.getValue("name"), attrs.getValue("desc"));
                    break;
                }
                case 1: {
                    this.getCodeVisitor().visitIntInsn(o.opcode, Integer.parseInt(attrs.getValue("value")));
                    break;
                }
                case 6: {
                    this.getCodeVisitor().visitJumpInsn(o.opcode, this.getLabel(attrs.getValue("label")));
                    break;
                }
                case 5: {
                    this.getCodeVisitor().visitMethodInsn(o.opcode, attrs.getValue("owner"), attrs.getValue("name"), attrs.getValue("desc"));
                    break;
                }
                case 3: {
                    this.getCodeVisitor().visitTypeInsn(o.opcode, attrs.getValue("desc"));
                    break;
                }
                case 2: {
                    this.getCodeVisitor().visitVarInsn(o.opcode, Integer.parseInt(attrs.getValue("var")));
                    break;
                }
                case 8: {
                    this.getCodeVisitor().visitIincInsn(Integer.parseInt(attrs.getValue("var")), Integer.parseInt(attrs.getValue("inc")));
                    break;
                }
                case 7: {
                    this.getCodeVisitor().visitLdcInsn(this.getValue(attrs.getValue("desc"), attrs.getValue("cst")));
                    break;
                }
                case 9: {
                    this.getCodeVisitor().visitMultiANewArrayInsn(attrs.getValue("desc"), Integer.parseInt(attrs.getValue("dims")));
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid element: " + element + " at " + ASMContentHandler.this.match);
                }
            }
        }
    }

    private final class LocalVarRule
    extends Rule {
        private LocalVarRule() {
        }

        @Override
        public final void begin(String element, Attributes attrs) {
            String name = attrs.getValue("name");
            String desc = attrs.getValue("desc");
            String signature = attrs.getValue("signature");
            Label start = this.getLabel(attrs.getValue("start"));
            Label end = this.getLabel(attrs.getValue("end"));
            int var = Integer.parseInt(attrs.getValue("var"));
            this.getCodeVisitor().visitLocalVariable(name, desc, signature, start, end, var);
        }
    }

    private final class LineNumberRule
    extends Rule {
        private LineNumberRule() {
        }

        @Override
        public final void begin(String name, Attributes attrs) {
            int line = Integer.parseInt(attrs.getValue("line"));
            Label start = this.getLabel(attrs.getValue("start"));
            this.getCodeVisitor().visitLineNumber(line, start);
        }
    }

    private final class TryCatchRule
    extends Rule {
        private TryCatchRule() {
        }

        @Override
        public final void begin(String name, Attributes attrs) {
            Label start = this.getLabel(attrs.getValue("start"));
            Label end = this.getLabel(attrs.getValue("end"));
            Label handler = this.getLabel(attrs.getValue("handler"));
            String type = attrs.getValue("type");
            this.getCodeVisitor().visitTryCatchBlock(start, end, handler, type);
        }
    }

    private final class LabelRule
    extends Rule {
        private LabelRule() {
        }

        @Override
        public final void begin(String name, Attributes attrs) {
            this.getCodeVisitor().visitLabel(this.getLabel(attrs.getValue("name")));
        }
    }

    private final class LookupSwitchLabelRule
    extends Rule {
        private LookupSwitchLabelRule() {
        }

        @Override
        public final void begin(String name, Attributes attrs) {
            Map vals = (Map)ASMContentHandler.this.peek();
            ((List)vals.get("labels")).add(this.getLabel(attrs.getValue("name")));
            ((List)vals.get("keys")).add(attrs.getValue("key"));
        }
    }

    private final class LookupSwitchRule
    extends Rule {
        private LookupSwitchRule() {
        }

        @Override
        public final void begin(String name, Attributes attrs) {
            HashMap<String, Object> vals = new HashMap<String, Object>();
            vals.put("dflt", attrs.getValue("dflt"));
            vals.put("labels", new ArrayList());
            vals.put("keys", new ArrayList());
            ASMContentHandler.this.push(vals);
        }

        @Override
        public final void end(String name) {
            Map vals = (Map)ASMContentHandler.this.pop();
            Label dflt = this.getLabel(vals.get("dflt"));
            List keyList = (List)vals.get("keys");
            List lbls = (List)vals.get("labels");
            Label[] labels = lbls.toArray(new Label[lbls.size()]);
            int[] keys = new int[keyList.size()];
            for (int i = 0; i < keys.length; ++i) {
                keys[i] = Integer.parseInt((String)keyList.get(i));
            }
            this.getCodeVisitor().visitLookupSwitchInsn(dflt, keys, labels);
        }
    }

    private final class TableSwitchLabelRule
    extends Rule {
        private TableSwitchLabelRule() {
        }

        @Override
        public final void begin(String name, Attributes attrs) {
            ((List)((Map)ASMContentHandler.this.peek()).get("labels")).add(this.getLabel(attrs.getValue("name")));
        }
    }

    private class TableSwitchRule
    extends Rule {
        private TableSwitchRule() {
        }

        @Override
        public final void begin(String name, Attributes attrs) {
            HashMap<String, Object> vals = new HashMap<String, Object>();
            vals.put("min", attrs.getValue("min"));
            vals.put("max", attrs.getValue("max"));
            vals.put("dflt", attrs.getValue("dflt"));
            vals.put("labels", new ArrayList());
            ASMContentHandler.this.push(vals);
        }

        @Override
        public final void end(String name) {
            Map vals = (Map)ASMContentHandler.this.pop();
            int min2 = Integer.parseInt((String)vals.get("min"));
            int max = Integer.parseInt((String)vals.get("max"));
            Label dflt = this.getLabel(vals.get("dflt"));
            List lbls = (List)vals.get("labels");
            Label[] labels = lbls.toArray(new Label[lbls.size()]);
            this.getCodeVisitor().visitTableSwitchInsn(min2, max, dflt, labels);
        }
    }

    private final class ExceptionsRule
    extends Rule {
        private ExceptionsRule() {
        }

        @Override
        public final void end(String element) {
            Map vals = (Map)ASMContentHandler.this.pop();
            int access = this.getAccess((String)vals.get("access"));
            String name = (String)vals.get("name");
            String desc = (String)vals.get("desc");
            String signature = (String)vals.get("signature");
            List excs = (List)vals.get("exceptions");
            String[] exceptions = excs.toArray(new String[excs.size()]);
            ASMContentHandler.this.push(ASMContentHandler.this.cw.visitMethod(access, name, desc, signature, exceptions));
        }
    }

    private final class ExceptionRule
    extends Rule {
        private ExceptionRule() {
        }

        @Override
        public final void begin(String name, Attributes attrs) {
            ((List)((Map)ASMContentHandler.this.peek()).get("exceptions")).add(attrs.getValue("name"));
        }
    }

    private final class MethodRule
    extends Rule {
        private MethodRule() {
        }

        @Override
        public final void begin(String name, Attributes attrs) {
            ASMContentHandler.this.labels = new HashMap();
            HashMap<String, Object> vals = new HashMap<String, Object>();
            vals.put("access", attrs.getValue("access"));
            vals.put("name", attrs.getValue("name"));
            vals.put("desc", attrs.getValue("desc"));
            vals.put("signature", attrs.getValue("signature"));
            vals.put("exceptions", new ArrayList());
            ASMContentHandler.this.push(vals);
        }

        @Override
        public final void end(String name) {
            ((MethodVisitor)ASMContentHandler.this.pop()).visitEnd();
            ASMContentHandler.this.labels = null;
        }
    }

    private final class FieldRule
    extends Rule {
        private FieldRule() {
        }

        @Override
        public final void begin(String element, Attributes attrs) {
            int access = this.getAccess(attrs.getValue("access"));
            String name = attrs.getValue("name");
            String signature = attrs.getValue("signature");
            String desc = attrs.getValue("desc");
            Object value = this.getValue(desc, attrs.getValue("value"));
            ASMContentHandler.this.push(ASMContentHandler.this.cw.visitField(access, name, desc, signature, value));
        }

        @Override
        public void end(String name) {
            ((FieldVisitor)ASMContentHandler.this.pop()).visitEnd();
        }
    }

    private final class InnerClassRule
    extends Rule {
        private InnerClassRule() {
        }

        @Override
        public final void begin(String element, Attributes attrs) {
            int access = this.getAccess(attrs.getValue("access"));
            String name = attrs.getValue("name");
            String outerName = attrs.getValue("outerName");
            String innerName = attrs.getValue("innerName");
            ASMContentHandler.this.cw.visitInnerClass(name, outerName, innerName, access);
        }
    }

    private final class OuterClassRule
    extends Rule {
        private OuterClassRule() {
        }

        @Override
        public final void begin(String element, Attributes attrs) {
            String owner = attrs.getValue("owner");
            String name = attrs.getValue("name");
            String desc = attrs.getValue("desc");
            ASMContentHandler.this.cw.visitOuterClass(owner, name, desc);
        }
    }

    private final class InterfacesRule
    extends Rule {
        private InterfacesRule() {
        }

        @Override
        public final void end(String element) {
            Map vals = (Map)ASMContentHandler.this.pop();
            int version2 = (Integer)vals.get("version");
            int access = this.getAccess((String)vals.get("access"));
            String name = (String)vals.get("name");
            String signature = (String)vals.get("signature");
            String parent = (String)vals.get("parent");
            List infs = (List)vals.get("interfaces");
            String[] interfaces = infs.toArray(new String[infs.size()]);
            ASMContentHandler.this.cw.visit(version2, access, name, signature, parent, interfaces);
            ASMContentHandler.this.push(ASMContentHandler.this.cw);
        }
    }

    private final class InterfaceRule
    extends Rule {
        private InterfaceRule() {
        }

        @Override
        public final void begin(String name, Attributes attrs) {
            ((List)((Map)ASMContentHandler.this.peek()).get("interfaces")).add(attrs.getValue("name"));
        }
    }

    private final class SourceRule
    extends Rule {
        private SourceRule() {
        }

        @Override
        public void begin(String name, Attributes attrs) {
            String file = attrs.getValue("file");
            String debug = attrs.getValue("debug");
            ASMContentHandler.this.cw.visitSource(file, debug);
        }
    }

    private final class ClassRule
    extends Rule {
        private ClassRule() {
        }

        @Override
        public final void begin(String name, Attributes attrs) {
            int major = Integer.parseInt(attrs.getValue("major"));
            int minor = Integer.parseInt(attrs.getValue("minor"));
            ASMContentHandler.this.cw = new ClassWriter(ASMContentHandler.this.computeMax);
            HashMap<String, Object> vals = new HashMap<String, Object>();
            vals.put("version", new Integer(minor << 16 | major));
            vals.put("access", attrs.getValue("access"));
            vals.put("name", attrs.getValue("name"));
            vals.put("parent", attrs.getValue("parent"));
            vals.put("source", attrs.getValue("source"));
            vals.put("signature", attrs.getValue("signature"));
            vals.put("interfaces", new ArrayList());
            ASMContentHandler.this.push(vals);
        }
    }

    protected abstract class Rule {
        protected Rule() {
        }

        public void begin(String name, Attributes attrs) {
        }

        public void end(String name) {
        }

        protected final Object getValue(String desc, String val) {
            Object value = null;
            if (val != null) {
                if (desc.equals("Ljava/lang/String;")) {
                    value = this.decode(val);
                } else if ("Ljava/lang/Integer;".equals(desc) || "I".equals(desc) || "S".equals(desc) || "B".equals(desc) || "C".equals(desc) || desc.equals("Z")) {
                    value = new Integer(val);
                } else if ("Ljava/lang/Short;".equals(desc)) {
                    value = new Short(val);
                } else if ("Ljava/lang/Byte;".equals(desc)) {
                    value = new Byte(val);
                } else if ("Ljava/lang/Character;".equals(desc)) {
                    value = new Character(this.decode(val).charAt(0));
                } else if ("Ljava/lang/Boolean;".equals(desc)) {
                    value = Boolean.valueOf(val);
                } else if ("Ljava/lang/Long;".equals(desc) || desc.equals("J")) {
                    value = new Long(val);
                } else if ("Ljava/lang/Float;".equals(desc) || desc.equals("F")) {
                    value = new Float(val);
                } else if ("Ljava/lang/Double;".equals(desc) || desc.equals("D")) {
                    value = new Double(val);
                } else if (Type.getDescriptor(Type.class).equals(desc)) {
                    value = Type.getType(val);
                } else {
                    throw new RuntimeException("Invalid value:" + val + " desc:" + desc + " ctx:" + this);
                }
            }
            return value;
        }

        private final String decode(String val) {
            StringBuffer sb = new StringBuffer(val.length());
            try {
                for (int n = 0; n < val.length(); ++n) {
                    char c = val.charAt(n);
                    if (c == '\\') {
                        if ((c = val.charAt(++n)) == '\\') {
                            sb.append('\\');
                            continue;
                        }
                        sb.append((char)Integer.parseInt(val.substring(++n, n + 4), 16));
                        n += 3;
                        continue;
                    }
                    sb.append(c);
                }
            }
            catch (RuntimeException ex) {
                System.err.println(val + "\n" + ex.toString());
                ex.printStackTrace();
                throw ex;
            }
            return sb.toString();
        }

        protected final Label getLabel(Object label) {
            Label lbl = (Label)ASMContentHandler.this.labels.get(label);
            if (lbl == null) {
                lbl = new Label();
                ASMContentHandler.this.labels.put(label, lbl);
            }
            return lbl;
        }

        protected final MethodVisitor getCodeVisitor() {
            return (MethodVisitor)ASMContentHandler.this.peek();
        }

        protected final int getAccess(String s2) {
            int access = 0;
            if (s2.indexOf("public") != -1) {
                access |= 1;
            }
            if (s2.indexOf("private") != -1) {
                access |= 2;
            }
            if (s2.indexOf("protected") != -1) {
                access |= 4;
            }
            if (s2.indexOf("static") != -1) {
                access |= 8;
            }
            if (s2.indexOf("final") != -1) {
                access |= 0x10;
            }
            if (s2.indexOf("super") != -1) {
                access |= 0x20;
            }
            if (s2.indexOf("synchronized") != -1) {
                access |= 0x20;
            }
            if (s2.indexOf("volatile") != -1) {
                access |= 0x40;
            }
            if (s2.indexOf("bridge") != -1) {
                access |= 0x40;
            }
            if (s2.indexOf("varargs") != -1) {
                access |= 0x80;
            }
            if (s2.indexOf("transient") != -1) {
                access |= 0x80;
            }
            if (s2.indexOf("native") != -1) {
                access |= 0x100;
            }
            if (s2.indexOf("interface") != -1) {
                access |= 0x200;
            }
            if (s2.indexOf("abstract") != -1) {
                access |= 0x400;
            }
            if (s2.indexOf("strict") != -1) {
                access |= 0x800;
            }
            if (s2.indexOf("synthetic") != -1) {
                access |= 0x1000;
            }
            if (s2.indexOf("annotation") != -1) {
                access |= 0x2000;
            }
            if (s2.indexOf("enum") != -1) {
                access |= 0x4000;
            }
            if (s2.indexOf("deprecated") != -1) {
                access |= 0x20000;
            }
            return access;
        }
    }

    private static final class RuleSet {
        private Map rules = new HashMap();
        private List lpatterns = new ArrayList();
        private List rpatterns = new ArrayList();

        private RuleSet() {
        }

        public void add(String path, Object rule) {
            String pattern = path;
            if (path.startsWith("*/")) {
                pattern = path.substring(1);
                this.lpatterns.add(pattern);
            } else if (path.endsWith("/*")) {
                pattern = path.substring(0, path.length() - 1);
                this.rpatterns.add(pattern);
            }
            this.rules.put(pattern, rule);
        }

        public Object match(String path) {
            if (this.rules.containsKey(path)) {
                return this.rules.get(path);
            }
            int n = path.lastIndexOf(47);
            for (String pattern : this.lpatterns) {
                if (!path.substring(n).endsWith(pattern)) continue;
                return this.rules.get(pattern);
            }
            for (String pattern : this.rpatterns) {
                if (!path.startsWith(pattern)) continue;
                return this.rules.get(pattern);
            }
            return null;
        }
    }

    private static interface OpcodeGroup {
        public static final int INSN = 0;
        public static final int INSN_INT = 1;
        public static final int INSN_VAR = 2;
        public static final int INSN_TYPE = 3;
        public static final int INSN_FIELD = 4;
        public static final int INSN_METHOD = 5;
        public static final int INSN_JUMP = 6;
        public static final int INSN_LDC = 7;
        public static final int INSN_IINC = 8;
        public static final int INSN_MULTIANEWARRAY = 9;
    }
}

