/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.util.element;

import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.TargetType;
import java.util.List;
import javax.lang.model.element.TypeElement;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.util.element.ElementAnnotationUtil;
import org.checkerframework.framework.util.element.IndexedElementAnnotationApplier;

public class SuperTypeApplier
extends IndexedElementAnnotationApplier {
    private final Symbol.ClassSymbol subclassSymbol;
    private final int index;

    public static void annotateSupers(List<AnnotatedTypeMirror.AnnotatedDeclaredType> supertypes, TypeElement subtypeElement) {
        for (int i = 0; i < supertypes.size(); ++i) {
            AnnotatedTypeMirror supertype = supertypes.get(i);
            int typeIndex = i - 1;
            new SuperTypeApplier(supertype, subtypeElement, typeIndex).extractAndApply();
        }
    }

    SuperTypeApplier(AnnotatedTypeMirror supertype, TypeElement subclassElement, int index) {
        super(supertype, subclassElement);
        this.subclassSymbol = (Symbol.ClassSymbol)subclassElement;
        this.index = index;
    }

    @Override
    public int getElementIndex() {
        return this.index;
    }

    @Override
    public int getTypeCompoundIndex(Attribute.TypeCompound anno) {
        int type_index = anno.getPosition().type_index;
        return type_index == 65535 ? -1 : type_index;
    }

    @Override
    protected TargetType[] annotatedTargets() {
        return new TargetType[]{TargetType.CLASS_EXTENDS};
    }

    @Override
    protected TargetType[] validTargets() {
        return new TargetType[]{TargetType.CLASS_TYPE_PARAMETER, TargetType.CLASS_TYPE_PARAMETER_BOUND};
    }

    @Override
    protected Iterable<Attribute.TypeCompound> getRawTypeAttributes() {
        return this.subclassSymbol.getRawTypeAttributes();
    }

    @Override
    protected void handleTargeted(List<Attribute.TypeCompound> targeted) {
        ElementAnnotationUtil.annotateViaTypeAnnoPosition(this.type, targeted);
    }

    @Override
    protected boolean isAccepted() {
        return true;
    }
}

