/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javah;

import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileObject;

public class Util {
    public boolean verbose = false;
    public PrintWriter log;
    public DiagnosticListener<? super JavaFileObject> dl;
    private ResourceBundle m;

    Util(PrintWriter printWriter, DiagnosticListener<? super JavaFileObject> diagnosticListener) {
        this.log = printWriter;
        this.dl = diagnosticListener;
    }

    public void log(String string) {
        this.log.println(string);
    }

    private void initMessages() throws Exit {
        try {
            this.m = ResourceBundle.getBundle("com.sun.tools.javah.resources.l10n");
        }
        catch (MissingResourceException missingResourceException) {
            this.fatal("Error loading resources.  Please file a bug report.", missingResourceException);
        }
    }

    private String getText(String string, Object ... objectArray) throws Exit {
        if (this.m == null) {
            this.initMessages();
        }
        try {
            return MessageFormat.format(this.m.getString(string), objectArray);
        }
        catch (MissingResourceException missingResourceException) {
            this.fatal("Key " + string + " not found in resources.", missingResourceException);
            return null;
        }
    }

    public void usage() throws Exit {
        this.log.println(this.getText("usage", new Object[0]));
    }

    public void version() throws Exit {
        this.log.println(this.getText("javah.version", System.getProperty("java.version"), null));
    }

    public void bug(String string) throws Exit {
        this.bug(string, null);
    }

    public void bug(String string, Exception exception) throws Exit {
        this.dl.report(this.createDiagnostic(Diagnostic.Kind.ERROR, string, new Object[0]));
        this.dl.report(this.createDiagnostic(Diagnostic.Kind.NOTE, "bug.report", new Object[0]));
        throw new Exit(11, (Throwable)exception);
    }

    public void error(String string, Object ... objectArray) throws Exit {
        this.dl.report(this.createDiagnostic(Diagnostic.Kind.ERROR, string, objectArray));
        throw new Exit(15);
    }

    private void fatal(String string) throws Exit {
        this.fatal(string, null);
    }

    private void fatal(String string, Exception exception) throws Exit {
        this.dl.report(this.createDiagnostic(Diagnostic.Kind.ERROR, "", string));
        throw new Exit(10, (Throwable)exception);
    }

    private Diagnostic<JavaFileObject> createDiagnostic(final Diagnostic.Kind kind, final String string, final Object ... objectArray) {
        return new Diagnostic<JavaFileObject>(){

            @Override
            public String getCode() {
                return string;
            }

            @Override
            public long getColumnNumber() {
                return -1L;
            }

            @Override
            public long getEndPosition() {
                return -1L;
            }

            @Override
            public Diagnostic.Kind getKind() {
                return kind;
            }

            @Override
            public long getLineNumber() {
                return -1L;
            }

            @Override
            public String getMessage(Locale locale) {
                if (string.length() == 0) {
                    return (String)objectArray[0];
                }
                return Util.this.getText(string, objectArray);
            }

            @Override
            public long getPosition() {
                return -1L;
            }

            @Override
            public JavaFileObject getSource() {
                return null;
            }

            @Override
            public long getStartPosition() {
                return -1L;
            }
        };
    }

    public static class Exit
    extends Error {
        private static final long serialVersionUID = 430820978114067221L;
        public final int exitValue;
        public final Throwable cause;

        Exit(int n) {
            this(n, null);
        }

        Exit(int n, Throwable throwable) {
            super(throwable);
            this.exitValue = n;
            this.cause = throwable;
        }

        Exit(Exit exit) {
            this(exit.exitValue, exit.cause);
        }
    }
}

