/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.parser;

import com.sun.tools.javac.parser.Token;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;

public class Keywords {
    public static final Context.Key<Keywords> keywordsKey = new Context.Key();
    private final Names names;
    private final Token[] key;
    private int maxKey = 0;
    private Name[] tokenName = new Name[Token.values().length];

    public static Keywords instance(Context context) {
        Keywords keywords = context.get(keywordsKey);
        if (keywords == null) {
            keywords = new Keywords(context);
        }
        return keywords;
    }

    protected Keywords(Context context) {
        context.put(keywordsKey, this);
        this.names = Names.instance(context);
        for (Token token : Token.values()) {
            if (token.name != null) {
                this.enterKeyword(token.name, token);
                continue;
            }
            this.tokenName[token.ordinal()] = null;
        }
        this.key = new Token[this.maxKey + 1];
        for (int i = 0; i <= this.maxKey; ++i) {
            this.key[i] = Token.IDENTIFIER;
        }
        for (Token token : Token.values()) {
            if (token.name == null) continue;
            this.key[this.tokenName[token.ordinal()].getIndex()] = token;
        }
    }

    public Token key(Name name) {
        return name.getIndex() > this.maxKey ? Token.IDENTIFIER : this.key[name.getIndex()];
    }

    private void enterKeyword(String string, Token token) {
        Name name;
        this.tokenName[token.ordinal()] = name = this.names.fromString(string);
        if (name.getIndex() > this.maxKey) {
            this.maxKey = name.getIndex();
        }
    }
}

