/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.xjc.util;

import com.sun.tools.internal.xjc.util.StringCutter;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;

public class MimeTypeRange {
    public final String majorType;
    public final String subType;
    public final Map<String, String> parameters = new HashMap<String, String>();
    public final float q;
    public static final MimeTypeRange ALL = MimeTypeRange.create("*/*");

    public static List<MimeTypeRange> parseRanges(String s2) throws ParseException {
        StringCutter cutter = new StringCutter(s2, true);
        ArrayList<MimeTypeRange> r = new ArrayList<MimeTypeRange>();
        while (cutter.length() > 0) {
            r.add(new MimeTypeRange(cutter));
        }
        return r;
    }

    public MimeTypeRange(String s2) throws ParseException {
        this(new StringCutter(s2, true));
    }

    private static MimeTypeRange create(String s2) {
        try {
            return new MimeTypeRange(s2);
        }
        catch (ParseException e) {
            throw new Error(e);
        }
    }

    private MimeTypeRange(StringCutter cutter) throws ParseException {
        String sep;
        this.majorType = cutter.until("/");
        cutter.next("/");
        this.subType = cutter.until("[;,]");
        float q = 1.0f;
        while (cutter.length() > 0 && !(sep = cutter.next("[;,]")).equals(",")) {
            String value;
            String key = cutter.until("=");
            cutter.next("=");
            char ch = cutter.peek();
            if (ch == '\"') {
                cutter.next("\"");
                value = cutter.until("\"");
                cutter.next("\"");
            } else {
                value = cutter.until("[;,]");
            }
            if (key.equals("q")) {
                q = Float.parseFloat(value);
                continue;
            }
            this.parameters.put(key, value);
        }
        this.q = q;
    }

    public MimeType toMimeType() throws MimeTypeParseException {
        return new MimeType(this.toString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.majorType + '/' + this.subType);
        if (this.q != 1.0f) {
            sb.append("; q=").append(this.q);
        }
        for (Map.Entry<String, String> p : this.parameters.entrySet()) {
            sb.append("; ").append(p.getKey()).append('=').append(p.getValue());
        }
        return sb.toString();
    }

    public static MimeTypeRange merge(Collection<MimeTypeRange> types) {
        if (types.size() == 0) {
            throw new IllegalArgumentException();
        }
        if (types.size() == 1) {
            return types.iterator().next();
        }
        String majorType = null;
        for (MimeTypeRange mt : types) {
            if (majorType == null) {
                majorType = mt.majorType;
            }
            if (majorType.equals(mt.majorType)) continue;
            return ALL;
        }
        return MimeTypeRange.create(majorType + "/*");
    }

    public static void main(String[] args) throws ParseException {
        for (MimeTypeRange m3 : MimeTypeRange.parseRanges(args[0])) {
            System.out.println(m3.toString());
        }
    }
}

