/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.xjc.reader.dtd;

import com.sun.tools.internal.xjc.reader.dtd.Block;
import com.sun.tools.internal.xjc.reader.dtd.Term;
import java.util.List;

final class Occurence
extends Term {
    final Term term;
    final boolean isOptional;
    final boolean isRepeated;

    Occurence(Term term, boolean optional, boolean repeated) {
        this.term = term;
        this.isOptional = optional;
        this.isRepeated = repeated;
    }

    static Term wrap(Term t, int occurence) {
        switch (occurence) {
            case 3: {
                return t;
            }
            case 1: {
                return new Occurence(t, false, true);
            }
            case 0: {
                return new Occurence(t, true, true);
            }
            case 2: {
                return new Occurence(t, true, false);
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    void normalize(List<Block> r, boolean optional) {
        if (this.isRepeated) {
            Block b = new Block(this.isOptional || optional, true);
            this.addAllElements(b);
            r.add(b);
        } else {
            this.term.normalize(r, optional || this.isOptional);
        }
    }

    @Override
    void addAllElements(Block b) {
        this.term.addAllElements(b);
    }

    @Override
    boolean isOptional() {
        return this.isOptional || this.term.isOptional();
    }

    @Override
    boolean isRepeated() {
        return this.isRepeated || this.term.isRepeated();
    }
}

