/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.ws.processor.modeler.annotation;

import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.ArrayType;
import com.sun.mirror.type.DeclaredType;
import com.sun.mirror.type.PrimitiveType;
import com.sun.mirror.type.TypeMirror;
import com.sun.tools.internal.ws.processor.modeler.annotation.TypeMoniker;
import java.util.ArrayList;
import java.util.Collection;

public class TypeMonikerFactory {
    public static TypeMoniker getTypeMoniker(TypeMirror typeMirror) {
        if (typeMirror instanceof PrimitiveType) {
            return new PrimitiveTypeMoniker((PrimitiveType)typeMirror);
        }
        if (typeMirror instanceof ArrayType) {
            return new ArrayTypeMoniker((ArrayType)typeMirror);
        }
        if (typeMirror instanceof DeclaredType) {
            return new DeclaredTypeMoniker((DeclaredType)typeMirror);
        }
        return TypeMonikerFactory.getTypeMoniker(typeMirror.toString());
    }

    public static TypeMoniker getTypeMoniker(String typeName) {
        return new StringMoniker(typeName);
    }

    static class ArrayTypeMoniker
    implements TypeMoniker {
        private TypeMoniker arrayType;

        public ArrayTypeMoniker(ArrayType type) {
            this.arrayType = TypeMonikerFactory.getTypeMoniker(type.getComponentType());
        }

        @Override
        public TypeMirror create(AnnotationProcessorEnvironment apEnv) {
            return apEnv.getTypeUtils().getArrayType(this.arrayType.create(apEnv));
        }
    }

    static class DeclaredTypeMoniker
    implements TypeMoniker {
        private String typeDeclName;
        private Collection<TypeMoniker> typeArgs = new ArrayList<TypeMoniker>();

        public DeclaredTypeMoniker(DeclaredType type) {
            this.typeDeclName = type.getDeclaration().getQualifiedName();
            for (TypeMirror arg : type.getActualTypeArguments()) {
                this.typeArgs.add(TypeMonikerFactory.getTypeMoniker(arg));
            }
        }

        @Override
        public TypeMirror create(AnnotationProcessorEnvironment apEnv) {
            TypeDeclaration typeDecl = apEnv.getTypeDeclaration(this.typeDeclName);
            TypeMirror[] tmpArgs = new TypeMirror[this.typeArgs.size()];
            int idx = 0;
            for (TypeMoniker moniker : this.typeArgs) {
                tmpArgs[idx++] = moniker.create(apEnv);
            }
            return apEnv.getTypeUtils().getDeclaredType(typeDecl, tmpArgs);
        }
    }

    static class PrimitiveTypeMoniker
    implements TypeMoniker {
        private PrimitiveType.Kind kind;

        public PrimitiveTypeMoniker(PrimitiveType type) {
            this.kind = type.getKind();
        }

        @Override
        public TypeMirror create(AnnotationProcessorEnvironment apEnv) {
            return apEnv.getTypeUtils().getPrimitiveType(this.kind);
        }
    }

    static class StringMoniker
    implements TypeMoniker {
        private String typeName;

        public StringMoniker(String typeName) {
            this.typeName = typeName;
        }

        @Override
        public TypeMirror create(AnnotationProcessorEnvironment apEnv) {
            return apEnv.getTypeUtils().getDeclaredType(apEnv.getTypeDeclaration(this.typeName), new TypeMirror[0]);
        }
    }
}

