/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.hat.internal.server;

import com.sun.tools.hat.internal.model.JavaClass;
import com.sun.tools.hat.internal.model.JavaField;
import com.sun.tools.hat.internal.model.JavaHeapObject;
import com.sun.tools.hat.internal.model.JavaObject;
import com.sun.tools.hat.internal.model.JavaObjectArray;
import com.sun.tools.hat.internal.model.JavaThing;
import com.sun.tools.hat.internal.model.JavaValueArray;
import com.sun.tools.hat.internal.model.StackTrace;
import com.sun.tools.hat.internal.server.ClassQuery;
import com.sun.tools.hat.internal.util.ArraySorter;
import com.sun.tools.hat.internal.util.Comparer;

class ObjectQuery
extends ClassQuery {
    @Override
    public void run() {
        this.startHtml("Object at " + this.query);
        long l = this.parseHex(this.query);
        JavaHeapObject javaHeapObject = this.snapshot.findThing(l);
        if (javaHeapObject == null) {
            this.error("object not found");
        } else if (javaHeapObject instanceof JavaClass) {
            this.printFullClass((JavaClass)javaHeapObject);
        } else if (javaHeapObject instanceof JavaValueArray) {
            this.print(((JavaValueArray)javaHeapObject).valueString(true));
            this.printAllocationSite(javaHeapObject);
            this.printReferencesTo(javaHeapObject);
        } else if (javaHeapObject instanceof JavaObjectArray) {
            this.printFullObjectArray((JavaObjectArray)javaHeapObject);
            this.printAllocationSite(javaHeapObject);
            this.printReferencesTo(javaHeapObject);
        } else if (javaHeapObject instanceof JavaObject) {
            this.printFullObject((JavaObject)javaHeapObject);
            this.printAllocationSite(javaHeapObject);
            this.printReferencesTo(javaHeapObject);
        } else {
            this.print(javaHeapObject.toString());
            this.printReferencesTo(javaHeapObject);
        }
        this.endHtml();
    }

    private void printFullObject(JavaObject javaObject) {
        int n;
        this.out.print("<h1>instance of ");
        this.print(javaObject.toString());
        this.out.print(" <small>(" + javaObject.getSize() + " bytes)</small>");
        this.out.println("</h1>\n");
        this.out.println("<h2>Class:</h2>");
        this.printClass(javaObject.getClazz());
        this.out.println("<h2>Instance data members:</h2>");
        JavaThing[] javaThingArray = javaObject.getFields();
        final JavaField[] javaFieldArray = javaObject.getClazz().getFieldsForInstance();
        Object[] objectArray = new Integer[javaThingArray.length];
        for (n = 0; n < javaThingArray.length; ++n) {
            objectArray[n] = new Integer(n);
        }
        ArraySorter.sort(objectArray, new Comparer(){

            @Override
            public int compare(Object object, Object object2) {
                JavaField javaField = javaFieldArray[(Integer)object];
                JavaField javaField2 = javaFieldArray[(Integer)object2];
                return javaField.getName().compareTo(javaField2.getName());
            }
        });
        for (n = 0; n < javaThingArray.length; ++n) {
            int n2 = (Integer)objectArray[n];
            this.printField(javaFieldArray[n2]);
            this.out.print(" : ");
            this.printThing(javaThingArray[n2]);
            this.out.println("<br>");
        }
    }

    private void printFullObjectArray(JavaObjectArray javaObjectArray) {
        JavaThing[] javaThingArray = javaObjectArray.getElements();
        this.out.println("<h1>Array of " + javaThingArray.length + " objects</h1>");
        this.out.println("<h2>Class:</h2>");
        this.printClass(javaObjectArray.getClazz());
        this.out.println("<h2>Values</h2>");
        for (int i = 0; i < javaThingArray.length; ++i) {
            this.out.print("" + i + " : ");
            this.printThing(javaThingArray[i]);
            this.out.println("<br>");
        }
    }

    private void printAllocationSite(JavaHeapObject javaHeapObject) {
        StackTrace stackTrace = javaHeapObject.getAllocatedFrom();
        if (stackTrace == null || stackTrace.getFrames().length == 0) {
            return;
        }
        this.out.println("<h2>Object allocated from:</h2>");
        this.printStackTrace(stackTrace);
    }
}

