/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.hat.internal.server;

import com.sun.tools.hat.internal.model.JavaClass;
import com.sun.tools.hat.internal.model.JavaHeapObject;
import com.sun.tools.hat.internal.server.PlatformClasses;
import com.sun.tools.hat.internal.server.QueryHandler;
import com.sun.tools.hat.internal.util.ArraySorter;
import com.sun.tools.hat.internal.util.Comparer;
import java.util.Enumeration;

class InstancesCountQuery
extends QueryHandler {
    private boolean excludePlatform;

    public InstancesCountQuery(boolean bl) {
        this.excludePlatform = bl;
    }

    @Override
    public void run() {
        if (this.excludePlatform) {
            this.startHtml("Instance Counts for All Classes (excluding platform)");
        } else {
            this.startHtml("Instance Counts for All Classes (including platform)");
        }
        Object[] objectArray = this.snapshot.getClassesArray();
        if (this.excludePlatform) {
            int n = 0;
            for (int i = 0; i < objectArray.length; ++i) {
                if (PlatformClasses.isPlatformClass((JavaClass)objectArray[i])) continue;
                objectArray[n++] = objectArray[i];
            }
            JavaClass[] javaClassArray = new JavaClass[n];
            System.arraycopy(objectArray, 0, javaClassArray, 0, javaClassArray.length);
            objectArray = javaClassArray;
        }
        ArraySorter.sort(objectArray, new Comparer(){

            @Override
            public int compare(Object object, Object object2) {
                JavaClass javaClass = (JavaClass)object;
                JavaClass javaClass2 = (JavaClass)object2;
                int n = javaClass.getInstancesCount(false) - javaClass2.getInstancesCount(false);
                if (n != 0) {
                    return -n;
                }
                String string = javaClass.getName();
                String string2 = javaClass2.getName();
                if (string.startsWith("[") != string2.startsWith("[")) {
                    if (string.startsWith("[")) {
                        return 1;
                    }
                    return -1;
                }
                return string.compareTo(string2);
            }
        });
        Object var2_3 = null;
        long l = 0L;
        long l2 = 0L;
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            int n = ((JavaClass)object).getInstancesCount(false);
            this.print("" + n);
            this.printAnchorStart();
            this.print("instances/" + this.encodeForURL((JavaClass)objectArray[i]));
            this.out.print("\"> ");
            if (n == 1) {
                this.print("instance");
            } else {
                this.print("instances");
            }
            this.out.print("</a> ");
            if (this.snapshot.getHasNewSet()) {
                Enumeration enumeration = ((JavaClass)object).getInstances(false);
                int n2 = 0;
                while (enumeration.hasMoreElements()) {
                    JavaHeapObject javaHeapObject = (JavaHeapObject)enumeration.nextElement();
                    if (!javaHeapObject.isNew()) continue;
                    ++n2;
                }
                this.print("(");
                this.printAnchorStart();
                this.print("newInstances/" + this.encodeForURL((JavaClass)objectArray[i]));
                this.out.print("\">");
                this.print("" + n2 + " new");
                this.out.print("</a>) ");
            }
            this.print("of ");
            this.printClass((JavaClass)objectArray[i]);
            this.out.println("<br>");
            l2 += (long)n;
            l += ((JavaClass)objectArray[i]).getTotalInstanceSize();
        }
        this.out.println("<h2>Total of " + l2 + " instances occupying " + l + " bytes.</h2>");
        this.out.println("<h2>Other Queries</h2>");
        this.out.println("<ul>");
        this.out.print("<li>");
        this.printAnchorStart();
        if (!this.excludePlatform) {
            this.out.print("showInstanceCounts/\">");
            this.print("Show instance counts for all classes (excluding platform)");
        } else {
            this.out.print("showInstanceCounts/includePlatform/\">");
            this.print("Show instance counts for all classes (including platform)");
        }
        this.out.println("</a>");
        this.out.print("<li>");
        this.printAnchorStart();
        this.out.print("allClassesWithPlatform/\">");
        this.print("Show All Classes (including platform)");
        this.out.println("</a>");
        this.out.print("<li>");
        this.printAnchorStart();
        this.out.print("\">");
        this.print("Show All Classes (excluding platform)");
        this.out.println("</a>");
        this.out.println("</ul>");
        this.endHtml();
    }
}

