/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.internal.toolkit.builders;

import com.sun.tools.doclets.internal.toolkit.Configuration;
import com.sun.tools.doclets.internal.toolkit.builders.XMLNode;
import com.sun.tools.doclets.internal.toolkit.util.DocletAbortException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class LayoutParser
extends DefaultHandler {
    private Map<String, XMLNode> xmlElementsMap = new HashMap<String, XMLNode>();
    private XMLNode currentNode;
    private Configuration configuration;
    private static LayoutParser instance;
    private String currentRoot;
    private boolean isParsing;

    private LayoutParser(Configuration configuration) {
        this.configuration = configuration;
    }

    public static LayoutParser getInstance(Configuration configuration) {
        if (instance == null) {
            instance = new LayoutParser(configuration);
        }
        return instance;
    }

    public XMLNode parseXML(String string) {
        if (this.xmlElementsMap.containsKey(string)) {
            return this.xmlElementsMap.get(string);
        }
        try {
            this.currentRoot = string;
            this.isParsing = false;
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            InputStream inputStream = this.configuration.getBuilderXML();
            sAXParser.parse(inputStream, (DefaultHandler)this);
            return this.xmlElementsMap.get(string);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new DocletAbortException();
        }
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.isParsing || string3.equals(this.currentRoot)) {
            this.isParsing = true;
            this.currentNode = new XMLNode(this.currentNode, string3);
            for (int i = 0; i < attributes.getLength(); ++i) {
                this.currentNode.attrs.put(attributes.getLocalName(i), attributes.getValue(i));
            }
            if (string3.equals(this.currentRoot)) {
                this.xmlElementsMap.put(string3, this.currentNode);
            }
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if (!this.isParsing) {
            return;
        }
        this.currentNode = this.currentNode.parent;
        this.isParsing = !string3.equals(this.currentRoot);
    }
}

