/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.internal.toolkit.builders;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ConstructorDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.tools.doclets.internal.toolkit.Configuration;
import com.sun.tools.doclets.internal.toolkit.ConstructorWriter;
import com.sun.tools.doclets.internal.toolkit.Content;
import com.sun.tools.doclets.internal.toolkit.builders.AbstractMemberBuilder;
import com.sun.tools.doclets.internal.toolkit.builders.XMLNode;
import com.sun.tools.doclets.internal.toolkit.util.VisibleMemberMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ConstructorBuilder
extends AbstractMemberBuilder {
    public static final String NAME = "ConstructorDetails";
    private int currentConstructorIndex;
    private ClassDoc classDoc;
    private VisibleMemberMap visibleMemberMap;
    private ConstructorWriter writer;
    private List<ProgramElementDoc> constructors;

    private ConstructorBuilder(Configuration configuration) {
        super(configuration);
    }

    public static ConstructorBuilder getInstance(Configuration configuration, ClassDoc classDoc, ConstructorWriter constructorWriter) {
        ConstructorBuilder constructorBuilder = new ConstructorBuilder(configuration);
        constructorBuilder.classDoc = classDoc;
        constructorBuilder.writer = constructorWriter;
        constructorBuilder.visibleMemberMap = new VisibleMemberMap(classDoc, 3, configuration.nodeprecated);
        constructorBuilder.constructors = new ArrayList<ProgramElementDoc>(constructorBuilder.visibleMemberMap.getMembersFor(classDoc));
        for (int i = 0; i < constructorBuilder.constructors.size(); ++i) {
            if (!constructorBuilder.constructors.get(i).isProtected() && !constructorBuilder.constructors.get(i).isPrivate()) continue;
            constructorWriter.setFoundNonPubConstructor(true);
        }
        if (configuration.getMemberComparator() != null) {
            Collections.sort(constructorBuilder.constructors, configuration.getMemberComparator());
        }
        return constructorBuilder;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean hasMembersToDocument() {
        return this.constructors.size() > 0;
    }

    public List<ProgramElementDoc> members(ClassDoc classDoc) {
        return this.visibleMemberMap.getMembersFor(classDoc);
    }

    public ConstructorWriter getWriter() {
        return this.writer;
    }

    public void buildConstructorDoc(XMLNode xMLNode, Content content) {
        if (this.writer == null) {
            return;
        }
        int n = this.constructors.size();
        if (n > 0) {
            Content content2 = this.writer.getConstructorDetailsTreeHeader(this.classDoc, content);
            this.currentConstructorIndex = 0;
            while (this.currentConstructorIndex < n) {
                Content content3 = this.writer.getConstructorDocTreeHeader((ConstructorDoc)this.constructors.get(this.currentConstructorIndex), content2);
                this.buildChildren(xMLNode, content3);
                content2.addContent(this.writer.getConstructorDoc(content3, this.currentConstructorIndex == n - 1));
                ++this.currentConstructorIndex;
            }
            content.addContent(this.writer.getConstructorDetails(content2));
        }
    }

    public void buildSignature(XMLNode xMLNode, Content content) {
        content.addContent(this.writer.getSignature((ConstructorDoc)this.constructors.get(this.currentConstructorIndex)));
    }

    public void buildDeprecationInfo(XMLNode xMLNode, Content content) {
        this.writer.addDeprecated((ConstructorDoc)this.constructors.get(this.currentConstructorIndex), content);
    }

    public void buildConstructorComments(XMLNode xMLNode, Content content) {
        if (!this.configuration.nocomment) {
            this.writer.addComments((ConstructorDoc)this.constructors.get(this.currentConstructorIndex), content);
        }
    }

    public void buildTagInfo(XMLNode xMLNode, Content content) {
        this.writer.addTags((ConstructorDoc)this.constructors.get(this.currentConstructorIndex), content);
    }
}

