/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.internal.toolkit;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.RootDoc;
import com.sun.tools.doclets.internal.toolkit.WriterFactory;
import com.sun.tools.doclets.internal.toolkit.builders.BuilderFactory;
import com.sun.tools.doclets.internal.toolkit.taglets.TagletManager;
import com.sun.tools.doclets.internal.toolkit.util.ClassDocCatalog;
import com.sun.tools.doclets.internal.toolkit.util.Extern;
import com.sun.tools.doclets.internal.toolkit.util.Group;
import com.sun.tools.doclets.internal.toolkit.util.MessageRetriever;
import com.sun.tools.doclets.internal.toolkit.util.MetaKeywords;
import com.sun.tools.doclets.internal.toolkit.util.Util;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;

public abstract class Configuration {
    protected BuilderFactory builderFactory;
    public TagletManager tagletManager;
    public String builderXMLPath;
    private static final String DEFAULT_BUILDER_XML = "resources/doclet.xml";
    public String tagletpath = "";
    public boolean serialwarn = false;
    public int sourcetab = 8;
    public boolean linksource = false;
    public boolean nosince = false;
    public boolean copydocfilesubdirs = false;
    public String charset = "";
    public boolean keywords = false;
    public final MetaKeywords metakeywords = new MetaKeywords(this);
    protected Set<String> excludedDocFileDirs;
    protected Set<String> excludedQualifiers;
    public RootDoc root;
    public String destDirName = "";
    public String docFileDestDirName = "";
    public String docencoding = null;
    public boolean nocomment = false;
    public String encoding = null;
    public boolean showauthor = false;
    public boolean showversion = false;
    public String sourcepath = "";
    public boolean nodeprecated = false;
    public ClassDocCatalog classDocCatalog;
    public MessageRetriever message = null;
    public boolean notimestamp = false;
    public final Group group = new Group(this);
    public final Extern extern = new Extern(this);
    public static final String DOCLETS_RESOURCE = "com.sun.tools.doclets.internal.toolkit.resources.doclets";
    public PackageDoc[] packages;

    public static boolean getJavafxJavadoc() {
        return Boolean.getBoolean("javafx.javadoc");
    }

    public abstract String getDocletSpecificBuildDate();

    public abstract void setSpecificDocletOptions(String[][] var1);

    public abstract MessageRetriever getDocletSpecificMsg();

    public Configuration() {
        this.message = new MessageRetriever(this, DOCLETS_RESOURCE);
        this.excludedDocFileDirs = new HashSet<String>();
        this.excludedQualifiers = new HashSet<String>();
    }

    public BuilderFactory getBuilderFactory() {
        if (this.builderFactory == null) {
            this.builderFactory = new BuilderFactory(this);
        }
        return this.builderFactory;
    }

    public int optionLength(String string) {
        if ((string = string.toLowerCase()).equals("-author") || string.equals("-docfilessubdirs") || string.equals("-keywords") || string.equals("-linksource") || string.equals("-nocomment") || string.equals("-nodeprecated") || string.equals("-nosince") || string.equals("-notimestamp") || string.equals("-quiet") || string.equals("-xnodate") || string.equals("-version")) {
            return 1;
        }
        if (string.equals("-d") || string.equals("-docencoding") || string.equals("-encoding") || string.equals("-excludedocfilessubdir") || string.equals("-link") || string.equals("-sourcetab") || string.equals("-noqualifier") || string.equals("-output") || string.equals("-sourcepath") || string.equals("-tag") || string.equals("-taglet") || string.equals("-tagletpath")) {
            return 2;
        }
        if (string.equals("-group") || string.equals("-linkoffline")) {
            return 3;
        }
        return -1;
    }

    public abstract boolean validOptions(String[][] var1, DocErrorReporter var2);

    private void initPackageArray() {
        HashSet<PackageDoc> hashSet = new HashSet<PackageDoc>(Arrays.asList(this.root.specifiedPackages()));
        ClassDoc[] classDocArray = this.root.specifiedClasses();
        for (int i = 0; i < classDocArray.length; ++i) {
            hashSet.add(classDocArray[i].containingPackage());
        }
        ArrayList<PackageDoc> arrayList = new ArrayList<PackageDoc>(hashSet);
        Collections.sort(arrayList);
        this.packages = arrayList.toArray(new PackageDoc[0]);
    }

    public void setOptions(String[][] stringArray) {
        LinkedHashSet<String[]> linkedHashSet = new LinkedHashSet<String[]>();
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            String[] stringArray2 = stringArray[i];
            String string2 = stringArray2[0].toLowerCase();
            if (string2.equals("-d")) {
                this.docFileDestDirName = this.destDirName = this.addTrailingFileSep(stringArray2[1]);
                continue;
            }
            if (string2.equals("-docfilessubdirs")) {
                this.copydocfilesubdirs = true;
                continue;
            }
            if (string2.equals("-docencoding")) {
                this.docencoding = stringArray2[1];
                continue;
            }
            if (string2.equals("-encoding")) {
                this.encoding = stringArray2[1];
                continue;
            }
            if (string2.equals("-author")) {
                this.showauthor = true;
                continue;
            }
            if (string2.equals("-nosince")) {
                this.nosince = true;
                continue;
            }
            if (string2.equals("-version")) {
                this.showversion = true;
                continue;
            }
            if (string2.equals("-nodeprecated")) {
                this.nodeprecated = true;
                continue;
            }
            if (string2.equals("-sourcepath")) {
                this.sourcepath = stringArray2[1];
                continue;
            }
            if (string2.equals("-classpath") && this.sourcepath.length() == 0) {
                this.sourcepath = stringArray2[1];
                continue;
            }
            if (string2.equals("-excludedocfilessubdir")) {
                this.addToSet(this.excludedDocFileDirs, stringArray2[1]);
                continue;
            }
            if (string2.equals("-noqualifier")) {
                this.addToSet(this.excludedQualifiers, stringArray2[1]);
                continue;
            }
            if (string2.equals("-linksource")) {
                this.linksource = true;
                continue;
            }
            if (string2.equals("-sourcetab")) {
                this.linksource = true;
                try {
                    this.sourcetab = Integer.parseInt(stringArray2[1]);
                }
                catch (NumberFormatException numberFormatException) {
                    this.sourcetab = -1;
                }
                if (this.sourcetab > 0) continue;
                this.message.warning("doclet.sourcetab_warning", new Object[0]);
                this.sourcetab = 8;
                continue;
            }
            if (string2.equals("-notimestamp")) {
                this.notimestamp = true;
                continue;
            }
            if (string2.equals("-nocomment")) {
                this.nocomment = true;
                continue;
            }
            if (string2.equals("-tag") || string2.equals("-taglet")) {
                linkedHashSet.add(stringArray2);
                continue;
            }
            if (string2.equals("-tagletpath")) {
                this.tagletpath = stringArray2[1];
                continue;
            }
            if (string2.equals("-keywords")) {
                this.keywords = true;
                continue;
            }
            if (string2.equals("-serialwarn")) {
                this.serialwarn = true;
                continue;
            }
            if (string2.equals("-group")) {
                this.group.checkPackageGroups(stringArray2[1], stringArray2[2]);
                continue;
            }
            if (string2.equals("-link")) {
                string = stringArray2[1];
                this.extern.url(string, string, this.root, false);
                continue;
            }
            if (!string2.equals("-linkoffline")) continue;
            string = stringArray2[1];
            String string3 = stringArray2[2];
            this.extern.url(string, string3, this.root, true);
        }
        if (this.sourcepath.length() == 0) {
            String string = this.sourcepath = System.getProperty("env.class.path") == null ? "" : System.getProperty("env.class.path");
        }
        if (this.docencoding == null) {
            this.docencoding = this.encoding;
        }
        this.classDocCatalog = new ClassDocCatalog(this.root.specifiedClasses(), this);
        this.initTagletManager(linkedHashSet);
    }

    public void setOptions() {
        this.initPackageArray();
        this.setOptions(this.root.options());
        this.setSpecificDocletOptions(this.root.options());
    }

    private void initTagletManager(Set<String[]> set) {
        this.tagletManager = this.tagletManager == null ? new TagletManager(this.nosince, this.showversion, this.showauthor, this.message) : this.tagletManager;
        for (String[] stringArray : set) {
            if (stringArray[0].equals("-taglet")) {
                this.tagletManager.addCustomTag(stringArray[1], this.tagletpath);
                continue;
            }
            String[] stringArray2 = Util.tokenize(stringArray[1], ':', 3);
            if (stringArray2.length == 1) {
                String string = stringArray[1];
                if (this.tagletManager.isKnownCustomTag(string)) {
                    this.tagletManager.addNewSimpleCustomTag(string, null, "");
                    continue;
                }
                StringBuffer stringBuffer = new StringBuffer(string + ":");
                stringBuffer.setCharAt(0, Character.toUpperCase(string.charAt(0)));
                this.tagletManager.addNewSimpleCustomTag(string, stringBuffer.toString(), "a");
                continue;
            }
            if (stringArray2.length == 2) {
                this.tagletManager.addNewSimpleCustomTag(stringArray2[0], stringArray2[1], "");
                continue;
            }
            if (stringArray2.length >= 3) {
                this.tagletManager.addNewSimpleCustomTag(stringArray2[0], stringArray2[2], stringArray2[1]);
                continue;
            }
            this.message.error("doclet.Error_invalid_custom_tag_argument", stringArray[1]);
        }
    }

    private void addToSet(Set<String> set, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            set.add(string2);
        }
    }

    String addTrailingFileSep(String string) {
        int n;
        String string2 = System.getProperty("file.separator");
        String string3 = string2 + string2;
        while ((n = string.indexOf(string3)) >= 0) {
            string = string.substring(0, n) + string.substring(n + string2.length());
        }
        if (!string.endsWith(string2)) {
            string = string + string2;
        }
        return string;
    }

    public boolean generalValidOptions(String[][] stringArray, DocErrorReporter docErrorReporter) {
        boolean bl = false;
        String string = "";
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i];
            String string2 = stringArray2[0].toLowerCase();
            if (string2.equals("-d")) {
                String string3 = this.addTrailingFileSep(stringArray2[1]);
                File file = new File(string3);
                if (!file.exists()) {
                    docErrorReporter.printNotice(this.getText("doclet.dest_dir_create", string3));
                    new File(string3).mkdirs();
                    continue;
                }
                if (!file.isDirectory()) {
                    docErrorReporter.printError(this.getText("doclet.destination_directory_not_directory_0", file.getPath()));
                    return false;
                }
                if (file.canWrite()) continue;
                docErrorReporter.printError(this.getText("doclet.destination_directory_not_writable_0", file.getPath()));
                return false;
            }
            if (string2.equals("-docencoding")) {
                bl = true;
                if (this.checkOutputFileEncoding(stringArray2[1], docErrorReporter)) continue;
                return false;
            }
            if (!string2.equals("-encoding")) continue;
            string = stringArray2[1];
        }
        return bl || string.length() <= 0 || this.checkOutputFileEncoding(string, docErrorReporter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkOutputFileEncoding(String string, DocErrorReporter docErrorReporter) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputStreamWriter outputStreamWriter = null;
        try {
            outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            docErrorReporter.printError(this.getText("doclet.Encoding_not_supported", string));
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (outputStreamWriter != null) {
                    outputStreamWriter.close();
                }
            }
            catch (IOException iOException) {}
        }
        return true;
    }

    public boolean shouldExcludeDocFileDir(String string) {
        return this.excludedDocFileDirs.contains(string);
    }

    public boolean shouldExcludeQualifier(String string) {
        if (this.excludedQualifiers.contains("all") || this.excludedQualifiers.contains(string) || this.excludedQualifiers.contains(string + ".*")) {
            return true;
        }
        int n = -1;
        while ((n = string.indexOf(".", n + 1)) != -1) {
            if (!this.excludedQualifiers.contains(string.substring(0, n + 1) + "*")) continue;
            return true;
        }
        return false;
    }

    public String getClassName(ClassDoc classDoc) {
        PackageDoc packageDoc = classDoc.containingPackage();
        if (packageDoc != null && this.shouldExcludeQualifier(classDoc.containingPackage().name())) {
            return classDoc.name();
        }
        return classDoc.qualifiedName();
    }

    public String getText(String string) {
        try {
            return this.getDocletSpecificMsg().getText(string, new Object[0]);
        }
        catch (Exception exception) {
            return this.message.getText(string, new Object[0]);
        }
    }

    public String getText(String string, String string2) {
        try {
            return this.getDocletSpecificMsg().getText(string, string2);
        }
        catch (Exception exception) {
            return this.message.getText(string, string2);
        }
    }

    public String getText(String string, String string2, String string3) {
        try {
            return this.getDocletSpecificMsg().getText(string, string2, string3);
        }
        catch (Exception exception) {
            return this.message.getText(string, string2, string3);
        }
    }

    public String getText(String string, String string2, String string3, String string4) {
        try {
            return this.getDocletSpecificMsg().getText(string, string2, string3, string4);
        }
        catch (Exception exception) {
            return this.message.getText(string, string2, string3, string4);
        }
    }

    public boolean isGeneratedDoc(ClassDoc classDoc) {
        if (!this.nodeprecated) {
            return true;
        }
        return !Util.isDeprecated(classDoc) && !Util.isDeprecated(classDoc.containingPackage());
    }

    public abstract WriterFactory getWriterFactory();

    public InputStream getBuilderXML() throws FileNotFoundException {
        return this.builderXMLPath == null ? Configuration.class.getResourceAsStream(DEFAULT_BUILDER_XML) : new FileInputStream(new File(this.builderXMLPath));
    }

    public abstract Locale getLocale();

    public abstract Comparator<ProgramElementDoc> getMemberComparator();
}

