/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.classfile;

import com.sun.tools.classfile.ClassReader;
import com.sun.tools.classfile.ConstantPoolException;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;

public class ConstantPool {
    public static final int CONSTANT_Utf8 = 1;
    public static final int CONSTANT_Integer = 3;
    public static final int CONSTANT_Float = 4;
    public static final int CONSTANT_Long = 5;
    public static final int CONSTANT_Double = 6;
    public static final int CONSTANT_Class = 7;
    public static final int CONSTANT_String = 8;
    public static final int CONSTANT_Fieldref = 9;
    public static final int CONSTANT_Methodref = 10;
    public static final int CONSTANT_InterfaceMethodref = 11;
    public static final int CONSTANT_NameAndType = 12;
    public static final int CONSTANT_MethodHandle = 15;
    public static final int CONSTANT_MethodType = 16;
    public static final int CONSTANT_InvokeDynamic = 18;
    private CPInfo[] pool;

    ConstantPool(ClassReader classReader) throws IOException, InvalidEntry {
        int n = classReader.readUnsignedShort();
        this.pool = new CPInfo[n];
        block16: for (int i = 1; i < n; ++i) {
            int n2 = classReader.readUnsignedByte();
            switch (n2) {
                case 7: {
                    this.pool[i] = new CONSTANT_Class_info(this, classReader);
                    continue block16;
                }
                case 6: {
                    this.pool[i] = new CONSTANT_Double_info(classReader);
                    ++i;
                    continue block16;
                }
                case 9: {
                    this.pool[i] = new CONSTANT_Fieldref_info(this, classReader);
                    continue block16;
                }
                case 4: {
                    this.pool[i] = new CONSTANT_Float_info(classReader);
                    continue block16;
                }
                case 3: {
                    this.pool[i] = new CONSTANT_Integer_info(classReader);
                    continue block16;
                }
                case 11: {
                    this.pool[i] = new CONSTANT_InterfaceMethodref_info(this, classReader);
                    continue block16;
                }
                case 18: {
                    this.pool[i] = new CONSTANT_InvokeDynamic_info(this, classReader);
                    continue block16;
                }
                case 5: {
                    this.pool[i] = new CONSTANT_Long_info(classReader);
                    ++i;
                    continue block16;
                }
                case 15: {
                    this.pool[i] = new CONSTANT_MethodHandle_info(this, classReader);
                    continue block16;
                }
                case 16: {
                    this.pool[i] = new CONSTANT_MethodType_info(this, classReader);
                    continue block16;
                }
                case 10: {
                    this.pool[i] = new CONSTANT_Methodref_info(this, classReader);
                    continue block16;
                }
                case 12: {
                    this.pool[i] = new CONSTANT_NameAndType_info(this, classReader);
                    continue block16;
                }
                case 8: {
                    this.pool[i] = new CONSTANT_String_info(this, classReader);
                    continue block16;
                }
                case 1: {
                    this.pool[i] = new CONSTANT_Utf8_info(classReader);
                    continue block16;
                }
                default: {
                    throw new InvalidEntry(i, n2);
                }
            }
        }
    }

    public ConstantPool(CPInfo[] cPInfoArray) {
        this.pool = cPInfoArray;
    }

    public int size() {
        return this.pool.length;
    }

    public int byteLength() {
        CPInfo cPInfo;
        int n = 2;
        for (int i = 1; i < this.size(); i += cPInfo.size()) {
            cPInfo = this.pool[i];
            n += cPInfo.byteLength();
        }
        return n;
    }

    public CPInfo get(int n) throws InvalidIndex {
        if (n <= 0 || n >= this.pool.length) {
            throw new InvalidIndex(n);
        }
        CPInfo cPInfo = this.pool[n];
        if (cPInfo == null) {
            throw new InvalidIndex(n);
        }
        return this.pool[n];
    }

    private CPInfo get(int n, int n2) throws InvalidIndex, UnexpectedEntry {
        CPInfo cPInfo = this.get(n);
        if (cPInfo.getTag() != n2) {
            throw new UnexpectedEntry(n, n2, cPInfo.getTag());
        }
        return cPInfo;
    }

    public CONSTANT_Utf8_info getUTF8Info(int n) throws InvalidIndex, UnexpectedEntry {
        return (CONSTANT_Utf8_info)this.get(n, 1);
    }

    public CONSTANT_Class_info getClassInfo(int n) throws InvalidIndex, UnexpectedEntry {
        return (CONSTANT_Class_info)this.get(n, 7);
    }

    public CONSTANT_NameAndType_info getNameAndTypeInfo(int n) throws InvalidIndex, UnexpectedEntry {
        return (CONSTANT_NameAndType_info)this.get(n, 12);
    }

    public String getUTF8Value(int n) throws InvalidIndex, UnexpectedEntry {
        return this.getUTF8Info((int)n).value;
    }

    public int getUTF8Index(String string) throws EntryNotFound {
        for (int i = 1; i < this.pool.length; ++i) {
            CPInfo cPInfo = this.pool[i];
            if (!(cPInfo instanceof CONSTANT_Utf8_info) || !((CONSTANT_Utf8_info)cPInfo).value.equals(string)) continue;
            return i;
        }
        throw new EntryNotFound((Object)string);
    }

    public Iterable<CPInfo> entries() {
        return new Iterable<CPInfo>(){

            @Override
            public Iterator<CPInfo> iterator() {
                return new Iterator<CPInfo>(){
                    private CPInfo current;
                    private int next = 1;

                    @Override
                    public boolean hasNext() {
                        return this.next < ConstantPool.this.pool.length;
                    }

                    @Override
                    public CPInfo next() {
                        this.current = ConstantPool.this.pool[this.next];
                        switch (this.current.getTag()) {
                            case 5: 
                            case 6: {
                                this.next += 2;
                                break;
                            }
                            default: {
                                ++this.next;
                            }
                        }
                        return this.current;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static class CONSTANT_Class_info
    extends CPInfo {
        public final int name_index;

        CONSTANT_Class_info(ConstantPool constantPool, ClassReader classReader) throws IOException {
            super(constantPool);
            this.name_index = classReader.readUnsignedShort();
        }

        public CONSTANT_Class_info(ConstantPool constantPool, int n) {
            super(constantPool);
            this.name_index = n;
        }

        @Override
        public int getTag() {
            return 7;
        }

        @Override
        public int byteLength() {
            return 3;
        }

        public String getName() throws ConstantPoolException {
            return this.cp.getUTF8Value(this.name_index);
        }

        public String getBaseName() throws ConstantPoolException {
            String string = this.getName();
            if (string.startsWith("[")) {
                int n = string.indexOf("[L");
                if (n == -1) {
                    return null;
                }
                return string.substring(n + 2, string.length() - 1);
            }
            return string;
        }

        public int getDimensionCount() throws ConstantPoolException {
            String string = this.getName();
            int n = 0;
            while (string.charAt(n) == '[') {
                ++n;
            }
            return n;
        }

        public String toString() {
            return "CONSTANT_Class_info[name_index: " + this.name_index + "]";
        }

        @Override
        public <R, D> R accept(Visitor<R, D> visitor, D d) {
            return visitor.visitClass(this, d);
        }
    }

    public static class CONSTANT_Double_info
    extends CPInfo {
        public final double value;

        CONSTANT_Double_info(ClassReader classReader) throws IOException {
            this.value = classReader.readDouble();
        }

        public CONSTANT_Double_info(double d) {
            this.value = d;
        }

        @Override
        public int getTag() {
            return 6;
        }

        @Override
        public int byteLength() {
            return 9;
        }

        @Override
        public int size() {
            return 2;
        }

        public String toString() {
            return "CONSTANT_Double_info[value: " + this.value + "]";
        }

        @Override
        public <R, D> R accept(Visitor<R, D> visitor, D d) {
            return visitor.visitDouble(this, d);
        }
    }

    public static class CONSTANT_Fieldref_info
    extends CPRefInfo {
        CONSTANT_Fieldref_info(ConstantPool constantPool, ClassReader classReader) throws IOException {
            super(constantPool, classReader, 9);
        }

        public CONSTANT_Fieldref_info(ConstantPool constantPool, int n, int n2) {
            super(constantPool, 9, n, n2);
        }

        public String toString() {
            return "CONSTANT_Fieldref_info[class_index: " + this.class_index + ", name_and_type_index: " + this.name_and_type_index + "]";
        }

        @Override
        public <R, D> R accept(Visitor<R, D> visitor, D d) {
            return visitor.visitFieldref(this, d);
        }
    }

    public static class CONSTANT_Float_info
    extends CPInfo {
        public final float value;

        CONSTANT_Float_info(ClassReader classReader) throws IOException {
            this.value = classReader.readFloat();
        }

        public CONSTANT_Float_info(float f) {
            this.value = f;
        }

        @Override
        public int getTag() {
            return 4;
        }

        @Override
        public int byteLength() {
            return 5;
        }

        public String toString() {
            return "CONSTANT_Float_info[value: " + this.value + "]";
        }

        @Override
        public <R, D> R accept(Visitor<R, D> visitor, D d) {
            return visitor.visitFloat(this, d);
        }
    }

    public static class CONSTANT_Integer_info
    extends CPInfo {
        public final int value;

        CONSTANT_Integer_info(ClassReader classReader) throws IOException {
            this.value = classReader.readInt();
        }

        public CONSTANT_Integer_info(int n) {
            this.value = n;
        }

        @Override
        public int getTag() {
            return 3;
        }

        @Override
        public int byteLength() {
            return 5;
        }

        public String toString() {
            return "CONSTANT_Integer_info[value: " + this.value + "]";
        }

        @Override
        public <R, D> R accept(Visitor<R, D> visitor, D d) {
            return visitor.visitInteger(this, d);
        }
    }

    public static class CONSTANT_InterfaceMethodref_info
    extends CPRefInfo {
        CONSTANT_InterfaceMethodref_info(ConstantPool constantPool, ClassReader classReader) throws IOException {
            super(constantPool, classReader, 11);
        }

        public CONSTANT_InterfaceMethodref_info(ConstantPool constantPool, int n, int n2) {
            super(constantPool, 11, n, n2);
        }

        public String toString() {
            return "CONSTANT_InterfaceMethodref_info[class_index: " + this.class_index + ", name_and_type_index: " + this.name_and_type_index + "]";
        }

        @Override
        public <R, D> R accept(Visitor<R, D> visitor, D d) {
            return visitor.visitInterfaceMethodref(this, d);
        }
    }

    public static class CONSTANT_InvokeDynamic_info
    extends CPInfo {
        public final int bootstrap_method_attr_index;
        public final int name_and_type_index;

        CONSTANT_InvokeDynamic_info(ConstantPool constantPool, ClassReader classReader) throws IOException {
            super(constantPool);
            this.bootstrap_method_attr_index = classReader.readUnsignedShort();
            this.name_and_type_index = classReader.readUnsignedShort();
        }

        public CONSTANT_InvokeDynamic_info(ConstantPool constantPool, int n, int n2) {
            super(constantPool);
            this.bootstrap_method_attr_index = n;
            this.name_and_type_index = n2;
        }

        @Override
        public int getTag() {
            return 18;
        }

        @Override
        public int byteLength() {
            return 5;
        }

        public String toString() {
            return "CONSTANT_InvokeDynamic_info[bootstrap_method_index: " + this.bootstrap_method_attr_index + ", name_and_type_index: " + this.name_and_type_index + "]";
        }

        @Override
        public <R, D> R accept(Visitor<R, D> visitor, D d) {
            return visitor.visitInvokeDynamic(this, d);
        }

        public CONSTANT_NameAndType_info getNameAndTypeInfo() throws ConstantPoolException {
            return this.cp.getNameAndTypeInfo(this.name_and_type_index);
        }
    }

    public static class CONSTANT_Long_info
    extends CPInfo {
        public final long value;

        CONSTANT_Long_info(ClassReader classReader) throws IOException {
            this.value = classReader.readLong();
        }

        public CONSTANT_Long_info(long l) {
            this.value = l;
        }

        @Override
        public int getTag() {
            return 5;
        }

        @Override
        public int size() {
            return 2;
        }

        @Override
        public int byteLength() {
            return 9;
        }

        public String toString() {
            return "CONSTANT_Long_info[value: " + this.value + "]";
        }

        @Override
        public <R, D> R accept(Visitor<R, D> visitor, D d) {
            return visitor.visitLong(this, d);
        }
    }

    public static class CONSTANT_MethodHandle_info
    extends CPInfo {
        public final RefKind reference_kind;
        public final int reference_index;

        CONSTANT_MethodHandle_info(ConstantPool constantPool, ClassReader classReader) throws IOException {
            super(constantPool);
            this.reference_kind = RefKind.getRefkind(classReader.readUnsignedByte());
            this.reference_index = classReader.readUnsignedShort();
        }

        public CONSTANT_MethodHandle_info(ConstantPool constantPool, RefKind refKind, int n) {
            super(constantPool);
            this.reference_kind = refKind;
            this.reference_index = n;
        }

        @Override
        public int getTag() {
            return 15;
        }

        @Override
        public int byteLength() {
            return 4;
        }

        public String toString() {
            return "CONSTANT_MethodHandle_info[ref_kind: " + (Object)((Object)this.reference_kind) + ", member_index: " + this.reference_index + "]";
        }

        @Override
        public <R, D> R accept(Visitor<R, D> visitor, D d) {
            return visitor.visitMethodHandle(this, d);
        }

        public CPRefInfo getCPRefInfo() throws ConstantPoolException {
            int n = 10;
            int n2 = this.cp.get(this.reference_index).getTag();
            switch (n2) {
                case 9: 
                case 11: {
                    n = n2;
                }
            }
            return (CPRefInfo)this.cp.get(this.reference_index, n);
        }
    }

    public static class CONSTANT_MethodType_info
    extends CPInfo {
        public final int descriptor_index;

        CONSTANT_MethodType_info(ConstantPool constantPool, ClassReader classReader) throws IOException {
            super(constantPool);
            this.descriptor_index = classReader.readUnsignedShort();
        }

        public CONSTANT_MethodType_info(ConstantPool constantPool, int n) {
            super(constantPool);
            this.descriptor_index = n;
        }

        @Override
        public int getTag() {
            return 16;
        }

        @Override
        public int byteLength() {
            return 3;
        }

        public String toString() {
            return "CONSTANT_MethodType_info[signature_index: " + this.descriptor_index + "]";
        }

        @Override
        public <R, D> R accept(Visitor<R, D> visitor, D d) {
            return visitor.visitMethodType(this, d);
        }

        public String getType() throws ConstantPoolException {
            return this.cp.getUTF8Value(this.descriptor_index);
        }
    }

    public static class CONSTANT_Methodref_info
    extends CPRefInfo {
        CONSTANT_Methodref_info(ConstantPool constantPool, ClassReader classReader) throws IOException {
            super(constantPool, classReader, 10);
        }

        public CONSTANT_Methodref_info(ConstantPool constantPool, int n, int n2) {
            super(constantPool, 10, n, n2);
        }

        public String toString() {
            return "CONSTANT_Methodref_info[class_index: " + this.class_index + ", name_and_type_index: " + this.name_and_type_index + "]";
        }

        @Override
        public <R, D> R accept(Visitor<R, D> visitor, D d) {
            return visitor.visitMethodref(this, d);
        }
    }

    public static class CONSTANT_NameAndType_info
    extends CPInfo {
        public final int name_index;
        public final int type_index;

        CONSTANT_NameAndType_info(ConstantPool constantPool, ClassReader classReader) throws IOException {
            super(constantPool);
            this.name_index = classReader.readUnsignedShort();
            this.type_index = classReader.readUnsignedShort();
        }

        public CONSTANT_NameAndType_info(ConstantPool constantPool, int n, int n2) {
            super(constantPool);
            this.name_index = n;
            this.type_index = n2;
        }

        @Override
        public int getTag() {
            return 12;
        }

        @Override
        public int byteLength() {
            return 5;
        }

        public String getName() throws ConstantPoolException {
            return this.cp.getUTF8Value(this.name_index);
        }

        public String getType() throws ConstantPoolException {
            return this.cp.getUTF8Value(this.type_index);
        }

        @Override
        public <R, D> R accept(Visitor<R, D> visitor, D d) {
            return visitor.visitNameAndType(this, d);
        }

        public String toString() {
            return "CONSTANT_NameAndType_info[name_index: " + this.name_index + ", type_index: " + this.type_index + "]";
        }
    }

    public static class CONSTANT_String_info
    extends CPInfo {
        public final int string_index;

        CONSTANT_String_info(ConstantPool constantPool, ClassReader classReader) throws IOException {
            super(constantPool);
            this.string_index = classReader.readUnsignedShort();
        }

        public CONSTANT_String_info(ConstantPool constantPool, int n) {
            super(constantPool);
            this.string_index = n;
        }

        @Override
        public int getTag() {
            return 8;
        }

        @Override
        public int byteLength() {
            return 3;
        }

        public String getString() throws ConstantPoolException {
            return this.cp.getUTF8Value(this.string_index);
        }

        @Override
        public <R, D> R accept(Visitor<R, D> visitor, D d) {
            return visitor.visitString(this, d);
        }

        public String toString() {
            return "CONSTANT_String_info[class_index: " + this.string_index + "]";
        }
    }

    public static class CONSTANT_Utf8_info
    extends CPInfo {
        public final String value;

        CONSTANT_Utf8_info(ClassReader classReader) throws IOException {
            this.value = classReader.readUTF();
        }

        public CONSTANT_Utf8_info(String string) {
            this.value = string;
        }

        @Override
        public int getTag() {
            return 1;
        }

        @Override
        public int byteLength() {
            class SizeOutputStream
            extends OutputStream {
                int size;

                SizeOutputStream() {
                }

                @Override
                public void write(int n) {
                    ++this.size;
                }
            }
            SizeOutputStream sizeOutputStream = new SizeOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(sizeOutputStream);
            try {
                dataOutputStream.writeUTF(this.value);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return 1 + sizeOutputStream.size;
        }

        public String toString() {
            if (this.value.length() < 32 && CONSTANT_Utf8_info.isPrintableAscii(this.value)) {
                return "CONSTANT_Utf8_info[value: \"" + this.value + "\"]";
            }
            return "CONSTANT_Utf8_info[value: (" + this.value.length() + " chars)]";
        }

        static boolean isPrintableAscii(String string) {
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c >= ' ' && c < '\u007f') continue;
                return false;
            }
            return true;
        }

        @Override
        public <R, D> R accept(Visitor<R, D> visitor, D d) {
            return visitor.visitUtf8(this, d);
        }
    }

    public static abstract class CPInfo {
        protected final ConstantPool cp;

        CPInfo() {
            this.cp = null;
        }

        CPInfo(ConstantPool constantPool) {
            this.cp = constantPool;
        }

        public abstract int getTag();

        public int size() {
            return 1;
        }

        public abstract int byteLength();

        public abstract <R, D> R accept(Visitor<R, D> var1, D var2);
    }

    public static abstract class CPRefInfo
    extends CPInfo {
        public final int tag;
        public final int class_index;
        public final int name_and_type_index;

        protected CPRefInfo(ConstantPool constantPool, ClassReader classReader, int n) throws IOException {
            super(constantPool);
            this.tag = n;
            this.class_index = classReader.readUnsignedShort();
            this.name_and_type_index = classReader.readUnsignedShort();
        }

        protected CPRefInfo(ConstantPool constantPool, int n, int n2, int n3) {
            super(constantPool);
            this.tag = n;
            this.class_index = n2;
            this.name_and_type_index = n3;
        }

        @Override
        public int getTag() {
            return this.tag;
        }

        @Override
        public int byteLength() {
            return 5;
        }

        public CONSTANT_Class_info getClassInfo() throws ConstantPoolException {
            return this.cp.getClassInfo(this.class_index);
        }

        public String getClassName() throws ConstantPoolException {
            return this.cp.getClassInfo(this.class_index).getName();
        }

        public CONSTANT_NameAndType_info getNameAndTypeInfo() throws ConstantPoolException {
            return this.cp.getNameAndTypeInfo(this.name_and_type_index);
        }
    }

    public static class EntryNotFound
    extends ConstantPoolException {
        private static final long serialVersionUID = 2885537606468581850L;
        public final Object value;

        EntryNotFound(Object object) {
            super(-1);
            this.value = object;
        }

        @Override
        public String getMessage() {
            return "value not found: " + this.value;
        }
    }

    public static class InvalidEntry
    extends ConstantPoolException {
        private static final long serialVersionUID = 1000087545585204447L;
        public final int tag;

        InvalidEntry(int n, int n2) {
            super(n);
            this.tag = n2;
        }

        @Override
        public String getMessage() {
            return "unexpected tag at #" + this.index + ": " + this.tag;
        }
    }

    public static class InvalidIndex
    extends ConstantPoolException {
        private static final long serialVersionUID = -4350294289300939730L;

        InvalidIndex(int n) {
            super(n);
        }

        @Override
        public String getMessage() {
            return "invalid index #" + this.index;
        }
    }

    public static enum RefKind {
        REF_getField(1, "getfield"),
        REF_getStatic(2, "getstatic"),
        REF_putField(3, "putfield"),
        REF_putStatic(4, "putstatic"),
        REF_invokeVirtual(5, "invokevirtual"),
        REF_invokeStatic(6, "invokestatic"),
        REF_invokeSpecial(7, "invokespecial"),
        REF_newInvokeSpecial(8, "newinvokespecial"),
        REF_invokeInterface(9, "invokeinterface");

        public final int tag;
        public final String name;

        private RefKind(int n2, String string2) {
            this.tag = n2;
            this.name = string2;
        }

        static RefKind getRefkind(int n) {
            switch (n) {
                case 1: {
                    return REF_getField;
                }
                case 2: {
                    return REF_getStatic;
                }
                case 3: {
                    return REF_putField;
                }
                case 4: {
                    return REF_putStatic;
                }
                case 5: {
                    return REF_invokeVirtual;
                }
                case 6: {
                    return REF_invokeStatic;
                }
                case 7: {
                    return REF_invokeSpecial;
                }
                case 8: {
                    return REF_newInvokeSpecial;
                }
                case 9: {
                    return REF_invokeInterface;
                }
            }
            return null;
        }
    }

    public static class UnexpectedEntry
    extends ConstantPoolException {
        private static final long serialVersionUID = 6986335935377933211L;
        public final int expected_tag;
        public final int found_tag;

        UnexpectedEntry(int n, int n2, int n3) {
            super(n);
            this.expected_tag = n2;
            this.found_tag = n3;
        }

        @Override
        public String getMessage() {
            return "unexpected entry at #" + this.index + " -- expected tag " + this.expected_tag + ", found " + this.found_tag;
        }
    }

    public static interface Visitor<R, P> {
        public R visitClass(CONSTANT_Class_info var1, P var2);

        public R visitDouble(CONSTANT_Double_info var1, P var2);

        public R visitFieldref(CONSTANT_Fieldref_info var1, P var2);

        public R visitFloat(CONSTANT_Float_info var1, P var2);

        public R visitInteger(CONSTANT_Integer_info var1, P var2);

        public R visitInterfaceMethodref(CONSTANT_InterfaceMethodref_info var1, P var2);

        public R visitInvokeDynamic(CONSTANT_InvokeDynamic_info var1, P var2);

        public R visitLong(CONSTANT_Long_info var1, P var2);

        public R visitNameAndType(CONSTANT_NameAndType_info var1, P var2);

        public R visitMethodref(CONSTANT_Methodref_info var1, P var2);

        public R visitMethodHandle(CONSTANT_MethodHandle_info var1, P var2);

        public R visitMethodType(CONSTANT_MethodType_info var1, P var2);

        public R visitString(CONSTANT_String_info var1, P var2);

        public R visitUtf8(CONSTANT_Utf8_info var1, P var2);
    }
}

