/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.attach;

import com.sun.tools.attach.AgentInitializationException;
import com.sun.tools.attach.AgentLoadException;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachineDescriptor;
import com.sun.tools.attach.spi.AttachProvider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public abstract class VirtualMachine {
    private AttachProvider provider;
    private String id;
    private volatile int hash;

    protected VirtualMachine(AttachProvider attachProvider, String string) {
        if (attachProvider == null) {
            throw new NullPointerException("provider cannot be null");
        }
        if (string == null) {
            throw new NullPointerException("id cannot be null");
        }
        this.provider = attachProvider;
        this.id = string;
    }

    public static List<VirtualMachineDescriptor> list() {
        ArrayList<VirtualMachineDescriptor> arrayList = new ArrayList<VirtualMachineDescriptor>();
        List<AttachProvider> list = AttachProvider.providers();
        for (AttachProvider attachProvider : list) {
            arrayList.addAll(attachProvider.listVirtualMachines());
        }
        return arrayList;
    }

    public static VirtualMachine attach(String string) throws AttachNotSupportedException, IOException {
        if (string == null) {
            throw new NullPointerException("id cannot be null");
        }
        List<AttachProvider> list = AttachProvider.providers();
        if (list.size() == 0) {
            throw new AttachNotSupportedException("no providers installed");
        }
        AttachNotSupportedException attachNotSupportedException = null;
        for (AttachProvider attachProvider : list) {
            try {
                return attachProvider.attachVirtualMachine(string);
            }
            catch (AttachNotSupportedException attachNotSupportedException2) {
                attachNotSupportedException = attachNotSupportedException2;
            }
        }
        throw attachNotSupportedException;
    }

    public static VirtualMachine attach(VirtualMachineDescriptor virtualMachineDescriptor) throws AttachNotSupportedException, IOException {
        return virtualMachineDescriptor.provider().attachVirtualMachine(virtualMachineDescriptor);
    }

    public abstract void detach() throws IOException;

    public final AttachProvider provider() {
        return this.provider;
    }

    public final String id() {
        return this.id;
    }

    public abstract void loadAgentLibrary(String var1, String var2) throws AgentLoadException, AgentInitializationException, IOException;

    public void loadAgentLibrary(String string) throws AgentLoadException, AgentInitializationException, IOException {
        this.loadAgentLibrary(string, null);
    }

    public abstract void loadAgentPath(String var1, String var2) throws AgentLoadException, AgentInitializationException, IOException;

    public void loadAgentPath(String string) throws AgentLoadException, AgentInitializationException, IOException {
        this.loadAgentPath(string, null);
    }

    public abstract void loadAgent(String var1, String var2) throws AgentLoadException, AgentInitializationException, IOException;

    public void loadAgent(String string) throws AgentLoadException, AgentInitializationException, IOException {
        this.loadAgent(string, null);
    }

    public abstract Properties getSystemProperties() throws IOException;

    public abstract Properties getAgentProperties() throws IOException;

    public int hashCode() {
        if (this.hash != 0) {
            return this.hash;
        }
        this.hash = this.provider.hashCode() * 127 + this.id.hashCode();
        return this.hash;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof VirtualMachine)) {
            return false;
        }
        VirtualMachine virtualMachine = (VirtualMachine)object;
        if (virtualMachine.provider() != this.provider()) {
            return false;
        }
        return virtualMachine.id().equals(this.id());
    }

    public String toString() {
        return this.provider.toString() + ": " + this.id;
    }
}

