/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.apt.mirror.declaration;

import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.AnnotationValue;
import com.sun.mirror.declaration.EnumConstantDeclaration;
import com.sun.mirror.type.TypeMirror;
import com.sun.tools.apt.mirror.declaration.AnnotationMirrorImpl;
import com.sun.tools.apt.mirror.declaration.EnumConstantDeclarationImpl;
import com.sun.tools.apt.mirror.type.TypeMirrorImpl;
import com.sun.tools.javac.code.Type;
import java.util.Collection;

class Constants {
    Constants() {
    }

    static Object decodeConstant(Object object, Type type) {
        if (object instanceof Integer) {
            int n = (Integer)object;
            switch (type.tag) {
                case 8: {
                    return n != 0;
                }
                case 2: {
                    return Character.valueOf((char)n);
                }
                case 1: {
                    return (byte)n;
                }
                case 3: {
                    return (short)n;
                }
            }
        }
        return object;
    }

    static Formatter getFormatter() {
        return new Formatter(new StringBuilder());
    }

    static Formatter getFormatter(StringBuilder stringBuilder) {
        return new Formatter(stringBuilder);
    }

    static class Formatter {
        private StringBuilder buf;

        private Formatter(StringBuilder stringBuilder) {
            this.buf = stringBuilder;
        }

        public String toString() {
            return this.buf.toString();
        }

        void append(Object object) {
            if (object instanceof String) {
                this.append((String)object);
            } else if (object instanceof Character) {
                this.append((Character)object);
            } else if (object instanceof Boolean) {
                this.append((Boolean)object);
            } else if (object instanceof Byte) {
                this.append((Byte)object);
            } else if (object instanceof Short) {
                this.append((Short)object);
            } else if (object instanceof Integer) {
                this.append((Integer)object);
            } else if (object instanceof Long) {
                this.append((Long)object);
            } else if (object instanceof Float) {
                this.append((Float)object);
            } else if (object instanceof Double) {
                this.append((Double)object);
            } else if (object instanceof TypeMirror) {
                this.append((TypeMirrorImpl)object);
            } else if (object instanceof EnumConstantDeclaration) {
                this.append((EnumConstantDeclarationImpl)object);
            } else if (object instanceof AnnotationMirror) {
                this.append((AnnotationMirrorImpl)object);
            } else if (object instanceof Collection) {
                this.append((Collection)object);
            } else {
                this.appendUnquoted(object.toString());
            }
        }

        void append(String string) {
            this.buf.append('\"');
            this.appendUnquoted(string);
            this.buf.append('\"');
        }

        void append(Character c) {
            this.buf.append('\'');
            this.appendUnquoted(c.charValue());
            this.buf.append('\'');
        }

        void append(Boolean bl) {
            this.buf.append(bl);
        }

        void append(Byte by) {
            this.buf.append(String.format("0x%02x", by));
        }

        void append(Short s2) {
            this.buf.append(s2);
        }

        void append(Integer n) {
            this.buf.append(n);
        }

        void append(Long l) {
            this.buf.append(l).append('L');
        }

        void append(Float f) {
            if (f.isNaN()) {
                this.buf.append("0.0f/0.0f");
            } else if (f.isInfinite()) {
                if (f.floatValue() < 0.0f) {
                    this.buf.append('-');
                }
                this.buf.append("1.0f/0.0f");
            } else {
                this.buf.append(f).append('f');
            }
        }

        void append(Double d) {
            if (d.isNaN()) {
                this.buf.append("0.0/0.0");
            } else if (d.isInfinite()) {
                if (d < 0.0) {
                    this.buf.append('-');
                }
                this.buf.append("1.0/0.0");
            } else {
                this.buf.append(d);
            }
        }

        void append(TypeMirrorImpl typeMirrorImpl) {
            this.appendUnquoted(typeMirrorImpl.type.toString());
            this.buf.append(".class");
        }

        void append(EnumConstantDeclarationImpl enumConstantDeclarationImpl) {
            this.appendUnquoted(enumConstantDeclarationImpl.sym.enclClass() + "." + enumConstantDeclarationImpl);
        }

        void append(AnnotationMirrorImpl annotationMirrorImpl) {
            this.appendUnquoted(annotationMirrorImpl.toString());
        }

        void append(Collection<?> collection) {
            this.buf.append('{');
            boolean bl = true;
            for (Object obj : collection) {
                if (bl) {
                    bl = false;
                } else {
                    this.buf.append(", ");
                }
                this.append(((AnnotationValue)obj).getValue());
            }
            this.buf.append('}');
        }

        private void appendUnquoted(String string) {
            for (char c : string.toCharArray()) {
                this.appendUnquoted(c);
            }
        }

        private void appendUnquoted(char c) {
            switch (c) {
                case '\b': {
                    this.buf.append("\\b");
                    break;
                }
                case '\t': {
                    this.buf.append("\\t");
                    break;
                }
                case '\n': {
                    this.buf.append("\\n");
                    break;
                }
                case '\f': {
                    this.buf.append("\\f");
                    break;
                }
                case '\r': {
                    this.buf.append("\\r");
                    break;
                }
                case '\"': {
                    this.buf.append("\\\"");
                    break;
                }
                case '\'': {
                    this.buf.append("\\'");
                    break;
                }
                case '\\': {
                    this.buf.append("\\\\");
                    break;
                }
                default: {
                    if (Formatter.isPrintableAscii(c)) {
                        this.buf.append(c);
                        break;
                    }
                    this.buf.append(String.format("\\u%04x", c));
                }
            }
        }

        private static boolean isPrintableAscii(char c) {
            return c >= ' ' && c <= '~';
        }
    }
}

