/*
 * Decompiled with CFR 0.152.
 */
package annotator.scanner;

import annotator.scanner.CommonScanner;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;

public class AnonymousClassScanner
extends TreePathScanner<Void, Integer> {
    private int index = 1;
    private boolean found = false;
    private Tree anonclass;

    public static int indexOfClassTree(TreePath path, Tree anonclass) {
        int classesFound = 0;
        boolean anonclassFound = false;
        while (path.getParentPath() != null && classesFound < 1) {
            if (path.getLeaf() == anonclass) {
                anonclassFound = true;
            }
            path = path.getParentPath();
            if (!anonclassFound || !CommonScanner.hasClassKind(path.getLeaf())) continue;
            ++classesFound;
        }
        AnonymousClassScanner lvts = new AnonymousClassScanner(anonclass);
        lvts.scan(path, Integer.valueOf(0));
        if (lvts.found) {
            return lvts.index;
        }
        return -1;
    }

    private AnonymousClassScanner(Tree anonclass) {
        this.anonclass = anonclass;
    }

    @Override
    public Void visitClass(ClassTree node, Integer level) {
        if (level < 2) {
            if (!this.found && CommonScanner.hasClassKind(this.anonclass)) {
                if (this.anonclass == node) {
                    this.found = true;
                } else if (node.getSimpleName().toString().trim().isEmpty()) {
                    ++this.index;
                }
            }
            super.visitClass(node, level + 1);
        }
        return null;
    }

    @Override
    public Void visitNewClass(NewClassTree node, Integer level) {
        if (!this.found && this.anonclass.getKind() == Tree.Kind.NEW_CLASS) {
            if (this.anonclass == node) {
                this.found = true;
            } else if (node.getClassBody() != null) {
                ++this.index;
            } else {
                return null;
            }
        }
        super.visitNewClass(node, level + 1);
        return null;
    }
}

