/*
 * Decompiled with CFR 0.152.
 */
package annotator.find;

import annotator.find.Criterion;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import scenelib.annotations.io.ASTPath;

final class NotInMethodCriterion
implements Criterion {
    NotInMethodCriterion() {
    }

    @Override
    public Criterion.Kind getKind() {
        return Criterion.Kind.NOT_IN_METHOD;
    }

    @Override
    public boolean isSatisfiedBy(TreePath path, Tree leaf) {
        if (path == null) {
            return false;
        }
        assert (path.getLeaf() == leaf);
        return this.isSatisfiedBy(path);
    }

    @Override
    public boolean isSatisfiedBy(TreePath path) {
        do {
            Tree.Kind kind;
            if ((kind = path.getLeaf().getKind()) == Tree.Kind.METHOD) {
                return false;
            }
            if (!ASTPath.isClassEquiv(kind)) continue;
            return true;
        } while ((path = path.getParentPath()) != null && path.getLeaf() != null);
        return true;
    }

    public String toString() {
        return "not in method";
    }
}

