/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.type;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import javax.lang.model.type.TypeKind;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.TypeFromClassVisitor;
import org.checkerframework.framework.type.TypeFromExpressionVisitor;
import org.checkerframework.framework.type.TypeFromMemberVisitor;
import org.checkerframework.framework.type.TypeFromTypeTreeVisitor;
import org.checkerframework.javacutil.ErrorReporter;

class TypeFromTree {
    private static final TypeFromTypeTreeVisitor typeTreeVisitor = new TypeFromTypeTreeVisitor();
    private static final TypeFromMemberVisitor memberVisitor = new TypeFromMemberVisitor();
    private static final TypeFromClassVisitor classVisitor = new TypeFromClassVisitor();
    private static final TypeFromExpressionVisitor expressionVisitor = new TypeFromExpressionVisitor();

    TypeFromTree() {
    }

    public static AnnotatedTypeMirror fromExpression(AnnotatedTypeFactory typeFactory, ExpressionTree tree) {
        TypeFromTree.abortIfTreeIsNull(typeFactory, tree);
        AnnotatedTypeMirror type = (AnnotatedTypeMirror)expressionVisitor.visit(tree, typeFactory);
        TypeFromTree.ifExecutableCheckElement(typeFactory, tree, type);
        return type;
    }

    public static AnnotatedTypeMirror fromMember(AnnotatedTypeFactory typeFactory, Tree tree) {
        TypeFromTree.abortIfTreeIsNull(typeFactory, tree);
        AnnotatedTypeMirror type = (AnnotatedTypeMirror)memberVisitor.visit(tree, typeFactory);
        TypeFromTree.ifExecutableCheckElement(typeFactory, tree, type);
        return type;
    }

    public static AnnotatedTypeMirror fromTypeTree(AnnotatedTypeFactory typeFactory, Tree tree) {
        TypeFromTree.abortIfTreeIsNull(typeFactory, tree);
        AnnotatedTypeMirror type = (AnnotatedTypeMirror)typeTreeVisitor.visit(tree, typeFactory);
        TypeFromTree.abortIfTypeIsExecutable(typeFactory, tree, type);
        return type;
    }

    public static AnnotatedTypeMirror.AnnotatedDeclaredType fromClassTree(AnnotatedTypeFactory typeFactory, ClassTree tree) {
        TypeFromTree.abortIfTreeIsNull(typeFactory, tree);
        AnnotatedTypeMirror.AnnotatedDeclaredType type = (AnnotatedTypeMirror.AnnotatedDeclaredType)classVisitor.visit(tree, typeFactory);
        TypeFromTree.abortIfTypeIsExecutable(typeFactory, tree, type);
        return type;
    }

    protected static void abortIfTreeIsNull(AnnotatedTypeFactory typeFactory, Tree tree) {
        if (tree == null) {
            ErrorReporter.errorAbort("Encountered null tree" + TypeFromTree.summarize(typeFactory, tree));
        }
    }

    protected static void ifExecutableCheckElement(AnnotatedTypeFactory typeFactory, Tree tree, AnnotatedTypeMirror type) {
        if (type.getKind() == TypeKind.EXECUTABLE && ((AnnotatedTypeMirror.AnnotatedExecutableType)type).getElement() == null) {
            ErrorReporter.errorAbort("Executable has no element:\n" + TypeFromTree.summarize(typeFactory, tree, type));
        }
    }

    protected static void abortIfTypeIsExecutable(AnnotatedTypeFactory typeFactory, Tree tree, AnnotatedTypeMirror type) {
        if (type.getKind() == TypeKind.EXECUTABLE) {
            ErrorReporter.errorAbort("Unexpected Executable typekind:\n" + TypeFromTree.summarize(typeFactory, tree, type));
        }
    }

    protected static String summarize(AnnotatedTypeFactory typeFactory, Tree tree) {
        return "tree=" + tree + "\ntypeFactory=" + typeFactory.getClass().getSimpleName();
    }

    protected static String summarize(AnnotatedTypeFactory typeFactory, Tree tree, AnnotatedTypeMirror type) {
        return "type=" + type + "\n" + TypeFromTree.summarize(typeFactory, tree);
    }
}

