/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.test;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.checkerframework.framework.test.CompilationResult;
import org.checkerframework.framework.test.TestConfiguration;
import org.checkerframework.framework.test.TestUtilities;
import org.checkerframework.framework.test.diagnostics.TestDiagnostic;
import org.checkerframework.framework.test.diagnostics.TestDiagnosticUtils;
import org.checkerframework.framework.util.PluginUtil;

public class TypecheckResult {
    private final TestConfiguration configuration;
    private final CompilationResult compilationResult;
    private final List<TestDiagnostic> expectedDiagnostics;
    private final boolean testFailed;
    private final List<TestDiagnostic> missingDiagnostics;
    private final List<TestDiagnostic> unexpectedDiagnostics;

    protected TypecheckResult(TestConfiguration configuration, CompilationResult compilationResult, List<TestDiagnostic> expectedDiagnostics, boolean testFailed, List<TestDiagnostic> missingDiagnostics, List<TestDiagnostic> unexpectedDiagnostics) {
        this.configuration = configuration;
        this.compilationResult = compilationResult;
        this.expectedDiagnostics = expectedDiagnostics;
        this.testFailed = testFailed;
        this.missingDiagnostics = missingDiagnostics;
        this.unexpectedDiagnostics = unexpectedDiagnostics;
    }

    public TestConfiguration getConfiguration() {
        return this.configuration;
    }

    public CompilationResult getCompilationResult() {
        return this.compilationResult;
    }

    public List<Diagnostic<? extends JavaFileObject>> getActualDiagnostics() {
        return this.compilationResult.getDiagnostics();
    }

    public List<TestDiagnostic> getExpectedDiagnostics() {
        return this.expectedDiagnostics;
    }

    public boolean didTestFail() {
        return this.testFailed;
    }

    public List<TestDiagnostic> getMissingDiagnostics() {
        return this.missingDiagnostics;
    }

    public List<TestDiagnostic> getUnexpectedDiagnostics() {
        return this.unexpectedDiagnostics;
    }

    public List<String> getErrorHeaders() {
        ArrayList<String> errorHeaders = new ArrayList<String>();
        if (this.testFailed) {
            if (this.compilationResult.compiledWithoutError() && !this.expectedDiagnostics.isEmpty()) {
                errorHeaders.add("The test run was expected to issue errors/warnings, but it did not.");
            } else if (!this.compilationResult.compiledWithoutError() && this.expectedDiagnostics.isEmpty()) {
                errorHeaders.add("The test run was not expected to issue errors/warnings, but it did.");
            }
            if (!this.unexpectedDiagnostics.isEmpty() || !this.missingDiagnostics.isEmpty()) {
                int numExpected = this.expectedDiagnostics.size();
                int numFound = numExpected - this.missingDiagnostics.size();
                errorHeaders.add(numFound + " out of " + numExpected + " expected diagnostics " + (numFound == 1 ? "was" : "were") + " found.");
            }
        }
        return errorHeaders;
    }

    public String summarize() {
        if (this.testFailed) {
            StringBuilder summaryBuilder = new StringBuilder();
            summaryBuilder.append(PluginUtil.join("\n", this.getErrorHeaders()));
            summaryBuilder.append("\n");
            if (!this.missingDiagnostics.isEmpty()) {
                summaryBuilder.append(this.missingDiagnostics.size() == 1 ? "1 expected diagnostic was not found:\n" : this.missingDiagnostics.size() + " expected diagnostics were not found:\n");
                for (TestDiagnostic missing : this.missingDiagnostics) {
                    summaryBuilder.append(missing);
                    summaryBuilder.append("\n");
                }
            }
            if (!this.unexpectedDiagnostics.isEmpty()) {
                summaryBuilder.append(this.unexpectedDiagnostics.size() == 1 ? "1 unexpected diagnostic was found:\n" : this.unexpectedDiagnostics.size() + " unexpected diagnostics were found:\n");
                for (TestDiagnostic unexpected : this.unexpectedDiagnostics) {
                    summaryBuilder.append(unexpected);
                    summaryBuilder.append("\n");
                }
            }
            summaryBuilder.append("While type-checking ").append(TestUtilities.summarizeSourceFiles(this.configuration.getTestSourceFiles()));
            return summaryBuilder.toString();
        }
        return "";
    }

    public static TypecheckResult fromCompilationResults(TestConfiguration configuration, CompilationResult result, List<TestDiagnostic> expectedDiagnostics) {
        boolean usingAnomsgtxt = configuration.getOptions().containsKey("-Anomsgtext");
        Set<TestDiagnostic> actualDiagnostics = TestDiagnosticUtils.fromJavaxDiagnosticList(result.getDiagnostics(), usingAnomsgtxt);
        LinkedHashSet<TestDiagnostic> unexpectedDiagnostics = new LinkedHashSet<TestDiagnostic>();
        unexpectedDiagnostics.addAll(actualDiagnostics);
        unexpectedDiagnostics.removeAll(expectedDiagnostics);
        LinkedList<TestDiagnostic> missingDiagnostics = new LinkedList<TestDiagnostic>(expectedDiagnostics);
        missingDiagnostics.removeAll(actualDiagnostics);
        boolean testFailed = !unexpectedDiagnostics.isEmpty() || !missingDiagnostics.isEmpty();
        return new TypecheckResult(configuration, result, expectedDiagnostics, testFailed, missingDiagnostics, new ArrayList<TestDiagnostic>(unexpectedDiagnostics));
    }

    public static TypecheckResult fromCompilationResultsExpectedDiagnostics(TestConfiguration configuration, CompilationResult result, List<TestDiagnostic> expectedDiagnostics) {
        boolean usingAnomsgtxt = configuration.getOptions().containsKey("-Anomsgtext");
        Set<TestDiagnostic> actualDiagnostics = TestDiagnosticUtils.fromJavaxDiagnosticList(result.getDiagnostics(), usingAnomsgtxt);
        LinkedHashSet<TestDiagnostic> unexpectedDiagnostics = new LinkedHashSet<TestDiagnostic>();
        unexpectedDiagnostics.addAll(actualDiagnostics);
        unexpectedDiagnostics.removeAll(expectedDiagnostics);
        LinkedList<TestDiagnostic> missingDiagnostics = new LinkedList<TestDiagnostic>(expectedDiagnostics);
        missingDiagnostics.removeAll(actualDiagnostics);
        boolean testFailed = !unexpectedDiagnostics.isEmpty() || !missingDiagnostics.isEmpty();
        return new TypecheckResult(configuration, result, expectedDiagnostics, testFailed, missingDiagnostics, new ArrayList<TestDiagnostic>(unexpectedDiagnostics));
    }
}

