/*
 * Decompiled with CFR 0.152.
 */
package plume;

import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import plume.Pair;

public class OrderedPairIterator<T>
implements Iterator<Pair<T, T>> {
    Iterator<T> itor1;
    Iterator<T> itor2;
    T next1;
    T next2;
    Comparator<? super T> comparator;

    public OrderedPairIterator(Iterator<T> itor1, Iterator<T> itor2) {
        this.itor1 = itor1;
        this.itor2 = itor2;
        this.setnext1();
        this.setnext2();
    }

    public OrderedPairIterator(Iterator<T> itor1, Iterator<T> itor2, Comparator<T> comparator) {
        this(itor1, itor2);
        this.comparator = comparator;
    }

    private void setnext1() {
        this.next1 = this.itor1.hasNext() ? this.itor1.next() : null;
    }

    private void setnext2() {
        this.next2 = this.itor2.hasNext() ? this.itor2.next() : null;
    }

    @Override
    public boolean hasNext() {
        return this.next1 != null || this.next2 != null;
    }

    private Pair<T, T> return1() {
        Pair<T, Object> result = Pair.of(this.next1, null);
        this.setnext1();
        return result;
    }

    private Pair<T, T> return2() {
        Pair<Object, T> result = Pair.of(null, this.next2);
        this.setnext2();
        return result;
    }

    private Pair<T, T> returnboth() {
        Pair<T, T> result = Pair.of(this.next1, this.next2);
        this.setnext1();
        this.setnext2();
        return result;
    }

    @Override
    public Pair<T, T> next() {
        int comparison;
        if (this.next1 == null) {
            if (this.next2 == null) {
                throw new NoSuchElementException();
            }
            return this.return2();
        }
        if (this.next2 == null) {
            return this.return1();
        }
        try {
            if (this.comparator == null) {
                Comparable cble1 = (Comparable)this.next1;
                comparison = cble1.compareTo(this.next2);
            } else {
                comparison = this.comparator.compare(this.next1, this.next2);
            }
        }
        catch (NullPointerException npe) {
            if (this.next1 == null && this.next2 == null) {
                comparison = 0;
            }
            if (this.next1 == null && this.next2 != null) {
                comparison = -1;
            }
            if (this.next1 != null && this.next2 == null) {
                comparison = 1;
            }
            throw new RuntimeException("this can't happen " + this.next1 + " " + this.next2);
        }
        if (comparison < 0) {
            return this.return1();
        }
        if (comparison > 0) {
            return this.return2();
        }
        return this.returnboth();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

