/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.type;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeAnnotationPosition;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.Types;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.GenericAnnotatedTypeFactory;
import org.checkerframework.framework.type.visitor.AnnotatedTypeScanner;
import org.checkerframework.javacutil.ErrorReporter;
import org.checkerframework.javacutil.TreeUtils;
import org.checkerframework.javacutil.TypeAnnotationUtils;

public class TypesIntoElements {
    public static void store(ProcessingEnvironment processingEnv, AnnotatedTypeFactory atypeFactory, ClassTree tree) {
        Symbol.ClassSymbol csym = (Symbol.ClassSymbol)TreeUtils.elementFromDeclaration(tree);
        Types types = processingEnv.getTypeUtils();
        TypesIntoElements.storeTypeParameters(processingEnv, types, atypeFactory, tree.getTypeParameters(), csym);
        for (Tree tree2 : tree.getMembers()) {
            if (tree2.getKind() == Tree.Kind.METHOD) {
                TypesIntoElements.storeMethod(processingEnv, types, atypeFactory, (MethodTree)tree2);
                continue;
            }
            if (tree2.getKind() != Tree.Kind.VARIABLE) continue;
            TypesIntoElements.storeVariable(processingEnv, types, atypeFactory, (VariableTree)tree2);
        }
    }

    private static void storeMethod(ProcessingEnvironment processingEnv, Types types, AnnotatedTypeFactory atypeFactory, MethodTree meth) {
        JCTree.JCVariableDecl recv;
        TypeAnnotationPosition tapos;
        AnnotatedTypeMirror.AnnotatedExecutableType mtype = atypeFactory.getAnnotatedType(meth);
        Symbol.MethodSymbol sym = (Symbol.MethodSymbol)TreeUtils.elementFromDeclaration(meth);
        List<Attribute.TypeCompound> tcs = List.nil();
        TypesIntoElements.storeTypeParameters(processingEnv, types, atypeFactory, meth.getTypeParameters(), sym);
        JCTree ret = ((JCTree.JCMethodDecl)meth).getReturnType();
        if (ret != null) {
            tapos = TypeAnnotationUtils.methodReturnTAPosition(ret.pos);
            tcs = tcs.appendList(TypesIntoElements.generateTypeCompounds(processingEnv, mtype.getReturnType(), tapos));
        }
        if ((recv = ((JCTree.JCMethodDecl)meth).getReceiverParameter()) != null) {
            tapos = TypeAnnotationUtils.methodReceiverTAPosition(recv.pos);
            tcs = tcs.appendList(TypesIntoElements.generateTypeCompounds(processingEnv, mtype.getReceiverType(), tapos));
        }
        int pidx = 0;
        java.util.List<AnnotatedTypeMirror> ptypes = mtype.getParameterTypes();
        for (JCTree param : ((JCTree.JCMethodDecl)meth).getParameters()) {
            tapos = TypeAnnotationUtils.methodParameterTAPosition(pidx, param.pos);
            tcs = tcs.appendList(TypesIntoElements.generateTypeCompounds(processingEnv, ptypes.get(pidx), tapos));
            ++pidx;
        }
        int tidx = 0;
        java.util.List<AnnotatedTypeMirror> ttypes = mtype.getThrownTypes();
        for (JCTree thr : ((JCTree.JCMethodDecl)meth).getThrows()) {
            tapos = TypeAnnotationUtils.methodThrowsTAPosition(tidx, thr.pos);
            tcs = tcs.appendList(TypesIntoElements.generateTypeCompounds(processingEnv, ttypes.get(tidx), tapos));
            ++tidx;
        }
        TypesIntoElements.addUniqueTypeCompounds(types, sym, tcs);
    }

    private static void storeVariable(ProcessingEnvironment processingEnv, Types types, AnnotatedTypeFactory atypeFactory, VariableTree var) {
        Symbol.VarSymbol sym = (Symbol.VarSymbol)TreeUtils.elementFromDeclaration(var);
        AnnotatedTypeMirror type = atypeFactory instanceof GenericAnnotatedTypeFactory ? ((GenericAnnotatedTypeFactory)atypeFactory).getAnnotatedTypeLhs(var) : atypeFactory.getAnnotatedType(var);
        TypeAnnotationPosition tapos = TypeAnnotationUtils.fieldTAPosition(((JCTree)((Object)var)).pos);
        List<Attribute.TypeCompound> tcs = TypesIntoElements.generateTypeCompounds(processingEnv, type, tapos);
        TypesIntoElements.addUniqueTypeCompounds(types, sym, tcs);
    }

    private static void storeClassExtends(ProcessingEnvironment processingEnv, Types types, AnnotatedTypeFactory atypeFactory, Tree ext, Symbol.ClassSymbol csym, int implidx) {
        int pos;
        AnnotatedTypeMirror type;
        if (ext == null) {
            type = atypeFactory.fromElement(csym.getSuperclass().asElement());
            pos = -1;
        } else {
            type = atypeFactory.getAnnotatedTypeFromTypeTree(ext);
            pos = ((JCTree)ext).pos;
        }
        TypeAnnotationPosition tapos = TypeAnnotationUtils.classExtendsTAPosition(implidx, pos);
        List<Attribute.TypeCompound> tcs = TypesIntoElements.generateTypeCompounds(processingEnv, type, tapos);
        TypesIntoElements.addUniqueTypeCompounds(types, csym, tcs);
    }

    private static void storeTypeParameters(ProcessingEnvironment processingEnv, Types types, AnnotatedTypeFactory atypeFactory, java.util.List<? extends TypeParameterTree> tps, Symbol sym) {
        boolean isClassOrInterface = sym.getKind().isClass() || sym.getKind().isInterface();
        List<Attribute.TypeCompound> tcs = List.nil();
        int tpidx = 0;
        for (TypeParameterTree typeParameterTree : tps) {
            AnnotatedTypeMirror.AnnotatedTypeVariable typeVar = (AnnotatedTypeMirror.AnnotatedTypeVariable)atypeFactory.getAnnotatedTypeFromTypeTree(typeParameterTree);
            TypeAnnotationPosition tapos = isClassOrInterface ? TypeAnnotationUtils.typeParameterTAPosition(tpidx, ((JCTree)((Object)typeParameterTree)).pos) : TypeAnnotationUtils.methodTypeParameterTAPosition(tpidx, ((JCTree)((Object)typeParameterTree)).pos);
            List<Attribute.TypeCompound> res = List.nil();
            for (AnnotationMirror am : typeVar.getLowerBound().getAnnotations()) {
                Attribute.TypeCompound tc = TypeAnnotationUtils.createTypeCompoundFromAnnotationMirror(processingEnv, am, tapos);
                res = res.prepend(tc);
            }
            tcs = tcs.appendList(res);
            AnnotatedTypeMirror tpbound = typeVar.getUpperBound();
            java.util.List<AnnotatedTypeMirror> bounds = tpbound.getKind() == TypeKind.INTERSECTION ? ((AnnotatedTypeMirror.AnnotatedIntersectionType)tpbound).directSuperTypes() : List.of(tpbound);
            int bndidx = 0;
            for (AnnotatedTypeMirror bound : bounds) {
                if (bndidx == 0 && ((Type)bound.getUnderlyingType()).isInterface()) {
                    ++bndidx;
                }
                tapos = isClassOrInterface ? TypeAnnotationUtils.typeParameterBoundTAPosition(tpidx, bndidx, ((JCTree)((Object)typeParameterTree)).pos) : TypeAnnotationUtils.methodTypeParameterBoundTAPosition(tpidx, bndidx, ((JCTree)((Object)typeParameterTree)).pos);
                tcs = tcs.appendList(TypesIntoElements.generateTypeCompounds(processingEnv, bound, tapos));
                ++bndidx;
            }
            ++tpidx;
        }
        TypesIntoElements.addUniqueTypeCompounds(types, sym, tcs);
    }

    private static void addUniqueTypeCompounds(Types types, Symbol sym, List<Attribute.TypeCompound> tcs) {
        List<Attribute.TypeCompound> raw = sym.getRawTypeAttributes();
        List<Attribute.TypeCompound> res = List.nil();
        for (Attribute.TypeCompound tc : tcs) {
            if (TypeAnnotationUtils.isTypeCompoundContained(types, raw, tc)) continue;
            res = res.append(tc);
        }
        sym.appendUniqueTypeAttributes(res);
    }

    private static List<Attribute.TypeCompound> generateTypeCompounds(ProcessingEnvironment processingEnv, AnnotatedTypeMirror type, TypeAnnotationPosition tapos) {
        return new TCConvert(processingEnv).scan(type, tapos);
    }

    private static class TCConvert
    extends AnnotatedTypeScanner<List<Attribute.TypeCompound>, TypeAnnotationPosition> {
        private final ProcessingEnvironment processingEnv;

        TCConvert(ProcessingEnvironment processingEnv) {
            this.processingEnv = processingEnv;
        }

        @Override
        public List<Attribute.TypeCompound> scan(AnnotatedTypeMirror type, TypeAnnotationPosition pos) {
            if (pos == null) {
                ErrorReporter.errorAbort("TypesIntoElements: invalid usage, null pos with type: " + type);
            }
            List res = (List)super.scan(type, pos);
            return res;
        }

        @Override
        protected List<Attribute.TypeCompound> scan(Iterable<? extends AnnotatedTypeMirror> types, TypeAnnotationPosition pos) {
            if (types == null) {
                return List.nil();
            }
            return (List)super.scan(types, pos);
        }

        @Override
        public List<Attribute.TypeCompound> reduce(List<Attribute.TypeCompound> r1, List<Attribute.TypeCompound> r2) {
            if (r1 == null) {
                return r2;
            }
            if (r2 == null) {
                return r1;
            }
            return r1.appendList(r2);
        }

        private List<Attribute.TypeCompound> directAnnotations(AnnotatedTypeMirror type, TypeAnnotationPosition tapos) {
            List<Attribute.TypeCompound> res = List.nil();
            for (AnnotationMirror am : type.getAnnotations()) {
                Attribute.TypeCompound tc = TypeAnnotationUtils.createTypeCompoundFromAnnotationMirror(this.processingEnv, am, tapos);
                res = res.prepend(tc);
            }
            return res;
        }

        @Override
        public List<Attribute.TypeCompound> visitDeclared(AnnotatedTypeMirror.AnnotatedDeclaredType type, TypeAnnotationPosition tapos) {
            AnnotatedTypeMirror.AnnotatedDeclaredType encl;
            if (this.visitedNodes.containsKey(type)) {
                return (List)this.visitedNodes.get(type);
            }
            this.visitedNodes.put(type, List.nil());
            TypeAnnotationPosition oldpos = TypeAnnotationUtils.copyTAPosition(tapos);
            this.locateNestedTypes(type, tapos);
            List<Attribute.TypeCompound> res = this.directAnnotations(type, tapos);
            if (!type.wasRaw()) {
                int arg = 0;
                for (AnnotatedTypeMirror ta : type.getTypeArguments()) {
                    TypeAnnotationPosition newpos = TypeAnnotationUtils.copyTAPosition(tapos);
                    newpos.location = tapos.location.append(new TypeAnnotationPosition.TypePathEntry(TypeAnnotationPosition.TypePathEntryKind.TYPE_ARGUMENT, arg));
                    res = this.scanAndReduce(ta, newpos, res);
                    ++arg;
                }
            }
            if ((encl = type.getEnclosingType()) != null && encl.getKind() != TypeKind.NONE && encl.getKind() != TypeKind.ERROR) {
                res = this.scanAndReduce(encl, oldpos, res);
            }
            this.visitedNodes.put(type, res);
            return res;
        }

        private void locateNestedTypes(AnnotatedTypeMirror.AnnotatedDeclaredType type, TypeAnnotationPosition p) {
            ListBuffer<TypeAnnotationPosition.TypePathEntry> depth = new ListBuffer<TypeAnnotationPosition.TypePathEntry>();
            for (Type encl = (Type)type.getUnderlyingType().getEnclosingType(); encl != null && encl.getKind() != TypeKind.NONE && encl.getKind() != TypeKind.ERROR; encl = encl.getEnclosingType()) {
                depth = depth.append(TypeAnnotationPosition.TypePathEntry.INNER_TYPE);
            }
            if (depth.nonEmpty()) {
                p.location = p.location.appendList(depth.toList());
            }
        }

        @Override
        public List<Attribute.TypeCompound> visitIntersection(AnnotatedTypeMirror.AnnotatedIntersectionType type, TypeAnnotationPosition tapos) {
            if (this.visitedNodes.containsKey(type)) {
                return (List)this.visitedNodes.get(type);
            }
            this.visitedNodes.put(type, List.nil());
            List<Attribute.TypeCompound> res = this.directAnnotations(type, tapos);
            int arg = 0;
            for (AnnotatedTypeMirror annotatedTypeMirror : type.directSuperTypes()) {
                TypeAnnotationPosition newpos = TypeAnnotationUtils.copyTAPosition(tapos);
                newpos.location = tapos.location.append(new TypeAnnotationPosition.TypePathEntry(TypeAnnotationPosition.TypePathEntryKind.TYPE_ARGUMENT, arg));
                res = this.scanAndReduce(annotatedTypeMirror, newpos, res);
                ++arg;
            }
            this.visitedNodes.put(type, res);
            return res;
        }

        @Override
        public List<Attribute.TypeCompound> visitUnion(AnnotatedTypeMirror.AnnotatedUnionType type, TypeAnnotationPosition tapos) {
            ErrorReporter.errorAbort("TypesIntoElement: encountered union type: " + type + " at position: " + tapos);
            return null;
        }

        @Override
        public List<Attribute.TypeCompound> visitArray(AnnotatedTypeMirror.AnnotatedArrayType type, TypeAnnotationPosition tapos) {
            List<Attribute.TypeCompound> res = this.directAnnotations(type, tapos);
            TypeAnnotationPosition newpos = TypeAnnotationUtils.copyTAPosition(tapos);
            newpos.location = tapos.location.append(TypeAnnotationPosition.TypePathEntry.ARRAY);
            return this.reduce((List)super.visitArray(type, newpos), res);
        }

        @Override
        public List<Attribute.TypeCompound> visitPrimitive(AnnotatedTypeMirror.AnnotatedPrimitiveType type, TypeAnnotationPosition tapos) {
            List<Attribute.TypeCompound> res = this.directAnnotations(type, tapos);
            return res;
        }

        @Override
        public List<Attribute.TypeCompound> visitTypeVariable(AnnotatedTypeMirror.AnnotatedTypeVariable type, TypeAnnotationPosition tapos) {
            List<Attribute.TypeCompound> res = this.directAnnotations(type, tapos);
            return res;
        }

        @Override
        public List<Attribute.TypeCompound> visitWildcard(AnnotatedTypeMirror.AnnotatedWildcardType type, TypeAnnotationPosition tapos) {
            List<Attribute.TypeCompound> res;
            if (this.visitedNodes.containsKey(type)) {
                return List.nil();
            }
            this.visitedNodes.put(type, List.nil());
            if (((Type.WildcardType)type.getUnderlyingType()).isExtendsBound()) {
                res = this.directAnnotations(type.getSuperBound(), tapos);
                AnnotatedTypeMirror ext = type.getExtendsBound();
                if (ext != null) {
                    TypeAnnotationPosition newpos = TypeAnnotationUtils.copyTAPosition(tapos);
                    newpos.location = tapos.location.append(TypeAnnotationPosition.TypePathEntry.WILDCARD);
                    res = this.scanAndReduce(ext, newpos, res);
                }
            } else {
                res = this.directAnnotations(type.getExtendsBound(), tapos);
                AnnotatedTypeMirror sup = type.getSuperBoundField();
                if (sup != null) {
                    TypeAnnotationPosition newpos = TypeAnnotationUtils.copyTAPosition(tapos);
                    newpos.location = tapos.location.append(TypeAnnotationPosition.TypePathEntry.WILDCARD);
                    res = this.scanAndReduce(sup, newpos, res);
                }
            }
            this.visitedNodes.put(type, res);
            return res;
        }

        @Override
        public List<Attribute.TypeCompound> visitNoType(AnnotatedTypeMirror.AnnotatedNoType type, TypeAnnotationPosition tapos) {
            return List.nil();
        }

        @Override
        public List<Attribute.TypeCompound> visitNull(AnnotatedTypeMirror.AnnotatedNullType type, TypeAnnotationPosition tapos) {
            return List.nil();
        }
    }
}

