/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.test;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.processing.AbstractProcessor;
import org.checkerframework.framework.test.PerFileSuite;
import org.checkerframework.framework.test.TestConfiguration;
import org.checkerframework.framework.test.TestConfigurationBuilder;
import org.checkerframework.framework.test.TestUtilities;
import org.checkerframework.framework.test.TypecheckExecutor;
import org.checkerframework.framework.test.TypecheckResult;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=PerFileSuite.class)
public abstract class CheckerFrameworkPerFileTest {
    protected final File testFile;
    protected final String checkerName;
    protected final String testDir;
    protected final List<String> checkerOptions;

    public CheckerFrameworkPerFileTest(File testFile, Class<? extends AbstractProcessor> checker, String testDir, String ... checkerOptions) {
        this.testFile = testFile;
        this.checkerName = checker.getName();
        this.testDir = "tests" + File.separator + testDir;
        this.checkerOptions = Arrays.asList(checkerOptions);
    }

    @Test
    public void run() {
        boolean shouldEmitDebugInfo = TestUtilities.getShouldEmitDebugInfo();
        List<String> customizedOptions = this.customizeOptions(Collections.unmodifiableList(this.checkerOptions));
        TestConfiguration config = TestConfigurationBuilder.buildDefaultConfiguration(this.testDir, this.testFile, this.checkerName, customizedOptions, shouldEmitDebugInfo);
        TypecheckResult testResult = new TypecheckExecutor().runTest(config);
        TestUtilities.assertResultsAreValid(testResult);
    }

    public List<String> customizeOptions(List<String> previousOptions) {
        return previousOptions;
    }
}

