/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.nullness;

import java.util.List;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.Types;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.visitor.AnnotatedTypeMerger;
import org.checkerframework.framework.util.TypeArgumentMapper;
import org.checkerframework.javacutil.AnnotationBuilder;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.Pair;

public class KeyForPropagator {
    private final AnnotationMirror UNKNOWN_KEYFOR;

    public KeyForPropagator(AnnotationMirror unknownKeyfor) {
        this.UNKNOWN_KEYFOR = unknownKeyfor;
    }

    public void propagate(AnnotatedTypeMirror.AnnotatedDeclaredType subtype, AnnotatedTypeMirror.AnnotatedDeclaredType supertype, PropagationDirection direction, AnnotatedTypeFactory typeFactory) {
        TypeElement subtypeElement = (TypeElement)subtype.getUnderlyingType().asElement();
        TypeElement supertypeElement = (TypeElement)supertype.getUnderlyingType().asElement();
        Types types = typeFactory.getProcessingEnv().getTypeUtils();
        if (subtype.getTypeArguments().isEmpty()) {
            return;
        }
        if (supertype.getTypeArguments().isEmpty()) {
            return;
        }
        Set<Pair<Integer, Integer>> typeParamMappings = TypeArgumentMapper.mapTypeArgumentIndices(subtypeElement, supertypeElement, types);
        KeyForPropagationMerger merger = new KeyForPropagationMerger(typeFactory.getProcessingEnv());
        List<AnnotatedTypeMirror> subtypeArgs = subtype.getTypeArguments();
        List<AnnotatedTypeMirror> supertypeArgs = supertype.getTypeArguments();
        for (Pair<Integer, Integer> path : typeParamMappings) {
            AnnotatedTypeMirror subtypeArg = subtypeArgs.get((Integer)path.first);
            AnnotatedTypeMirror supertypeArg = supertypeArgs.get((Integer)path.second);
            if (subtypeArg.getKind() == TypeKind.WILDCARD || supertypeArg.getKind() == TypeKind.WILDCARD) continue;
            switch (direction) {
                case TO_SUBTYPE: {
                    merger.visit(supertypeArg, subtypeArg);
                    break;
                }
                case TO_SUPERTYPE: {
                    merger.visit(subtypeArg, supertypeArg);
                    break;
                }
                case BOTH: {
                    merger.visit(subtypeArg, supertypeArg);
                    merger.visit(supertypeArg, subtypeArg);
                }
            }
        }
    }

    private class KeyForPropagationMerger
    extends AnnotatedTypeMerger {
        private final ProcessingEnvironment env;

        private KeyForPropagationMerger(ProcessingEnvironment env) {
            this.env = env;
        }

        @Override
        protected void replaceAnnotations(AnnotatedTypeMirror from, AnnotatedTypeMirror to) {
            boolean toNeedsAnnotation;
            AnnotationMirror fromKeyFor = from.getAnnotationInHierarchy(KeyForPropagator.this.UNKNOWN_KEYFOR);
            AnnotationMirror toKeyFor = to.getAnnotationInHierarchy(KeyForPropagator.this.UNKNOWN_KEYFOR);
            boolean bl = toNeedsAnnotation = toKeyFor == null || AnnotationUtils.areSame(toKeyFor, KeyForPropagator.this.UNKNOWN_KEYFOR);
            if (fromKeyFor != null && toNeedsAnnotation) {
                AnnotationBuilder annotationBuilder = new AnnotationBuilder(this.env, fromKeyFor);
                to.replaceAnnotation(annotationBuilder.build());
            }
        }
    }

    public static enum PropagationDirection {
        TO_SUBTYPE,
        TO_SUPERTYPE,
        BOTH;

    }
}

