/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.index.samelen;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import org.checkerframework.checker.index.IndexMethodIdentifier;
import org.checkerframework.checker.index.IndexUtil;
import org.checkerframework.checker.index.qual.PolyLength;
import org.checkerframework.checker.index.qual.PolySameLen;
import org.checkerframework.checker.index.qual.SameLen;
import org.checkerframework.checker.index.qual.SameLenBottom;
import org.checkerframework.checker.index.qual.SameLenUnknown;
import org.checkerframework.common.basetype.BaseAnnotatedTypeFactory;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.dataflow.analysis.FlowExpressions;
import org.checkerframework.framework.qual.PolyAll;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.framework.type.treeannotator.ImplicitsTreeAnnotator;
import org.checkerframework.framework.type.treeannotator.ListTreeAnnotator;
import org.checkerframework.framework.type.treeannotator.PropagationTreeAnnotator;
import org.checkerframework.framework.type.treeannotator.TreeAnnotator;
import org.checkerframework.framework.util.FlowExpressionParseUtil;
import org.checkerframework.framework.util.MultiGraphQualifierHierarchy;
import org.checkerframework.javacutil.AnnotationBuilder;
import org.checkerframework.javacutil.AnnotationProvider;
import org.checkerframework.javacutil.AnnotationUtils;

public class SameLenAnnotatedTypeFactory
extends BaseAnnotatedTypeFactory {
    public final AnnotationMirror UNKNOWN;
    private final AnnotationMirror BOTTOM;
    private final AnnotationMirror POLY;
    private final IndexMethodIdentifier imf;

    public SameLenAnnotatedTypeFactory(BaseTypeChecker checker) {
        super(checker);
        this.UNKNOWN = AnnotationBuilder.fromClass(this.elements, SameLenUnknown.class);
        this.BOTTOM = AnnotationBuilder.fromClass(this.elements, SameLenBottom.class);
        this.POLY = AnnotationBuilder.fromClass(this.elements, PolySameLen.class);
        this.addAliasedAnnotation(PolyAll.class, this.POLY);
        this.addAliasedAnnotation(PolyLength.class, this.POLY);
        this.imf = new IndexMethodIdentifier(this.processingEnv);
        this.postInit();
    }

    IndexMethodIdentifier getMethodIdentifier() {
        return this.imf;
    }

    @Override
    protected Set<Class<? extends Annotation>> createSupportedTypeQualifiers() {
        return new LinkedHashSet<Class<? extends Annotation>>(Arrays.asList(SameLen.class, SameLenBottom.class, SameLenUnknown.class, PolySameLen.class));
    }

    @Override
    public QualifierHierarchy createQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory factory) {
        return new SameLenQualifierHierarchy(factory);
    }

    @Override
    public AnnotatedTypeMirror getAnnotatedTypeLhs(Tree tree) {
        AnnotatedTypeMirror atm = super.getAnnotatedTypeLhs(tree);
        if (tree.getKind() == Tree.Kind.VARIABLE) {
            FlowExpressions.Receiver r;
            try {
                r = FlowExpressionParseUtil.internalReprOfVariable(this, (VariableTree)tree);
            }
            catch (FlowExpressionParseUtil.FlowExpressionParseException ex) {
                r = null;
            }
            if (r != null) {
                String varName = r.toString();
                AnnotationMirror anm = atm.getAnnotation(SameLen.class);
                if (anm != null) {
                    List<String> slArrays = IndexUtil.getValueOfAnnotationWithStringArgument(anm);
                    if (slArrays.contains(varName)) {
                        slArrays.remove(varName);
                    }
                    if (slArrays.size() == 0) {
                        atm.replaceAnnotation(this.UNKNOWN);
                    } else {
                        atm.replaceAnnotation(this.createSameLen(slArrays.toArray(new String[0])));
                    }
                }
            }
        }
        return atm;
    }

    private boolean overlap(List<String> listA, List<String> listB) {
        for (String a : listA) {
            for (String b : listB) {
                if (!a.equals(b)) continue;
                return true;
            }
        }
        return false;
    }

    public AnnotationMirror getCombinedSameLen(List<String> a1Names, List<String> a2Names) {
        HashSet<String> newValues = new HashSet<String>(a1Names.size() + a2Names.size());
        newValues.addAll(a1Names);
        newValues.addAll(a2Names);
        String[] names = newValues.toArray(new String[newValues.size()]);
        return this.createSameLen(names);
    }

    public AnnotationMirror createCombinedSameLen(FlowExpressions.Receiver rec1, FlowExpressions.Receiver rec2, AnnotationMirror a1, AnnotationMirror a2) {
        ArrayList<FlowExpressions.Receiver> receivers = new ArrayList<FlowExpressions.Receiver>();
        receivers.add(rec1);
        receivers.add(rec2);
        ArrayList<AnnotationMirror> annos = new ArrayList<AnnotationMirror>();
        annos.add(a1);
        annos.add(a2);
        return this.createCombinedSameLen(receivers, annos);
    }

    public AnnotationMirror createCombinedSameLen(List<FlowExpressions.Receiver> receivers, List<AnnotationMirror> annos) {
        assert (receivers.size() == annos.size());
        ArrayList<String> values = new ArrayList<String>();
        for (int i = 0; i < receivers.size(); ++i) {
            FlowExpressions.Receiver rec = receivers.get(i);
            AnnotationMirror anno = annos.get(i);
            if (SameLenAnnotatedTypeFactory.isReceiverToStringParsable(rec)) {
                values.add(rec.toString());
            }
            if (!AnnotationUtils.areSameByClass(anno, SameLen.class)) continue;
            values.addAll(IndexUtil.getValueOfAnnotationWithStringArgument(anno));
        }
        AnnotationMirror res = this.getCombinedSameLen(values, new ArrayList<String>());
        return res;
    }

    public static boolean isReceiverToStringParsable(FlowExpressions.Receiver receiver) {
        return !receiver.containsUnknown() && !(receiver instanceof FlowExpressions.ArrayCreation) && !(receiver instanceof FlowExpressions.ClassName);
    }

    @Override
    public TreeAnnotator createTreeAnnotator() {
        return new ListTreeAnnotator(super.createTreeAnnotator(), new SameLenTreeAnnotator(this), new PropagationTreeAnnotator(this), new ImplicitsTreeAnnotator(this));
    }

    public AnnotationMirror createSameLen(String ... val) {
        AnnotationBuilder builder = new AnnotationBuilder(this.processingEnv, SameLen.class);
        Arrays.sort(val);
        builder.setValue((CharSequence)"value", val);
        return builder.build();
    }

    public List<String> getSameLensFromString(String sequenceExpression, Tree tree, TreePath currentPath) {
        AnnotationMirror sameLenAnno = null;
        try {
            sameLenAnno = this.getAnnotationFromJavaExpressionString(sequenceExpression, tree, currentPath, SameLen.class);
        }
        catch (FlowExpressionParseUtil.FlowExpressionParseException flowExpressionParseException) {
            // empty catch block
        }
        if (sameLenAnno == null) {
            return new ArrayList<String>();
        }
        return IndexUtil.getValueOfAnnotationWithStringArgument(sameLenAnno);
    }

    protected class SameLenTreeAnnotator
    extends TreeAnnotator {
        public SameLenTreeAnnotator(SameLenAnnotatedTypeFactory factory) {
            super(factory);
        }

        @Override
        public Void visitNewArray(NewArrayTree node, AnnotatedTypeMirror type) {
            Tree dimensionTree;
            ExpressionTree sequenceTree;
            if (node.getDimensions().size() == 1 && (sequenceTree = IndexUtil.getLengthSequenceTree(dimensionTree = (Tree)node.getDimensions().get(0), SameLenAnnotatedTypeFactory.this.imf, SameLenAnnotatedTypeFactory.this.processingEnv)) != null) {
                AnnotationMirror sequenceAnno = SameLenAnnotatedTypeFactory.this.getAnnotatedType(sequenceTree).getAnnotationInHierarchy(SameLenAnnotatedTypeFactory.this.UNKNOWN);
                FlowExpressions.Receiver rec = FlowExpressions.internalReprOf((AnnotationProvider)this.atypeFactory, sequenceTree);
                if (SameLenAnnotatedTypeFactory.isReceiverToStringParsable(rec)) {
                    List<String> sequenceAnnoSequences;
                    if (AnnotationUtils.areSameByClass(sequenceAnno, SameLenUnknown.class)) {
                        sequenceAnno = SameLenAnnotatedTypeFactory.this.createSameLen(rec.toString());
                    } else if (AnnotationUtils.areSameByClass(sequenceAnno, SameLen.class) && !(sequenceAnnoSequences = IndexUtil.getValueOfAnnotationWithStringArgument(sequenceAnno)).contains(rec.toString())) {
                        sequenceAnnoSequences.add(rec.toString());
                        String[] newSequenceAnnoSequences = sequenceAnnoSequences.toArray(new String[0]);
                        sequenceAnno = SameLenAnnotatedTypeFactory.this.createSameLen(newSequenceAnnoSequences);
                    }
                }
                type.addAnnotation(sequenceAnno);
            }
            return null;
        }
    }

    private final class SameLenQualifierHierarchy
    extends MultiGraphQualifierHierarchy {
        public SameLenQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory factory) {
            super(factory);
        }

        @Override
        public AnnotationMirror getTopAnnotation(AnnotationMirror start) {
            return SameLenAnnotatedTypeFactory.this.UNKNOWN;
        }

        @Override
        public AnnotationMirror greatestLowerBound(AnnotationMirror a1, AnnotationMirror a2) {
            if (AnnotationUtils.hasElementValue(a1, "value") && AnnotationUtils.hasElementValue(a2, "value")) {
                List<String> a2Val;
                List<String> a1Val = IndexUtil.getValueOfAnnotationWithStringArgument(a1);
                if (SameLenAnnotatedTypeFactory.this.overlap(a1Val, a2Val = IndexUtil.getValueOfAnnotationWithStringArgument(a2))) {
                    return SameLenAnnotatedTypeFactory.this.getCombinedSameLen(a1Val, a2Val);
                }
                return SameLenAnnotatedTypeFactory.this.BOTTOM;
            }
            if (AnnotationUtils.areSameByClass(a1, SameLenUnknown.class)) {
                return a2;
            }
            if (AnnotationUtils.areSameByClass(a2, SameLenUnknown.class)) {
                return a1;
            }
            return SameLenAnnotatedTypeFactory.this.BOTTOM;
        }

        @Override
        public AnnotationMirror leastUpperBound(AnnotationMirror a1, AnnotationMirror a2) {
            if (AnnotationUtils.hasElementValue(a1, "value") && AnnotationUtils.hasElementValue(a2, "value")) {
                List<String> a2Val;
                List<String> a1Val = IndexUtil.getValueOfAnnotationWithStringArgument(a1);
                if (SameLenAnnotatedTypeFactory.this.overlap(a1Val, a2Val = IndexUtil.getValueOfAnnotationWithStringArgument(a2))) {
                    return SameLenAnnotatedTypeFactory.this.getCombinedSameLen(a1Val, a2Val);
                }
                return SameLenAnnotatedTypeFactory.this.UNKNOWN;
            }
            if (AnnotationUtils.areSameByClass(a1, SameLenBottom.class)) {
                return a2;
            }
            if (AnnotationUtils.areSameByClass(a2, SameLenBottom.class)) {
                return a1;
            }
            if (AnnotationUtils.areSameByClass(a1, PolySameLen.class) && AnnotationUtils.areSameByClass(a2, PolySameLen.class)) {
                return a1;
            }
            return SameLenAnnotatedTypeFactory.this.UNKNOWN;
        }

        @Override
        public boolean isSubtype(AnnotationMirror subAnno, AnnotationMirror superAnno) {
            List<String> superArrays;
            List<String> subArrays;
            if (AnnotationUtils.areSameByClass(subAnno, SameLenBottom.class)) {
                return true;
            }
            if (AnnotationUtils.areSameByClass(superAnno, SameLenUnknown.class)) {
                return true;
            }
            if (AnnotationUtils.areSameByClass(subAnno, PolySameLen.class)) {
                return AnnotationUtils.areSameByClass(superAnno, PolySameLen.class);
            }
            return AnnotationUtils.hasElementValue(subAnno, "value") && AnnotationUtils.hasElementValue(superAnno, "value") && (subArrays = IndexUtil.getValueOfAnnotationWithStringArgument(subAnno)).containsAll(superArrays = IndexUtil.getValueOfAnnotationWithStringArgument(superAnno));
        }
    }
}

