/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.util.typeinference.solver;

import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeVariable;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.framework.util.AnnotationMirrorSet;
import org.checkerframework.framework.util.typeinference.constraint.TIsU;
import org.checkerframework.framework.util.typeinference.constraint.TSuperU;
import org.checkerframework.framework.util.typeinference.constraint.TUConstraint;
import org.checkerframework.framework.util.typeinference.solver.ConstraintMap;
import org.checkerframework.javacutil.TypeAnnotationUtils;

public class ConstraintMapBuilder {
    public ConstraintMap build(Set<TypeVariable> targets, Set<TUConstraint> constraints, AnnotatedTypeFactory typeFactory) {
        QualifierHierarchy qualifierHierarchy = typeFactory.getQualifierHierarchy();
        AnnotationMirrorSet tops = new AnnotationMirrorSet(qualifierHierarchy.getTopAnnotations());
        ConstraintMap result = new ConstraintMap(targets);
        AnnotationMirrorSet tAnnos = new AnnotationMirrorSet();
        AnnotationMirrorSet uAnnos = new AnnotationMirrorSet();
        AnnotationMirrorSet hierarchiesInRelation = new AnnotationMirrorSet();
        for (TUConstraint constraint : constraints) {
            AnnotationMirror tAnno;
            tAnnos.clear();
            uAnnos.clear();
            hierarchiesInRelation.clear();
            AnnotatedTypeMirror.AnnotatedTypeVariable typeT = constraint.typeVariable;
            AnnotatedTypeMirror typeU = constraint.relatedType;
            if (typeU.getKind() == TypeKind.TYPEVAR && targets.contains(TypeAnnotationUtils.unannotatedType(typeU.getUnderlyingType()))) {
                if (typeT.getAnnotations().isEmpty() && typeU.getAnnotations().isEmpty()) {
                    hierarchiesInRelation.addAll(tops);
                } else {
                    for (AnnotationMirror top : tops) {
                        tAnno = typeT.getAnnotationInHierarchy(top);
                        AnnotationMirror uAnno = typeU.getAnnotationInHierarchy(top);
                        if (tAnno == null) {
                            if (uAnno == null) {
                                hierarchiesInRelation.add(top);
                                continue;
                            }
                            tAnnos.add(uAnno);
                            continue;
                        }
                        if (uAnno != null) continue;
                        uAnnos.add(tAnno);
                    }
                    if (!tAnnos.isEmpty()) {
                        this.addToPrimaryRelationship((TypeVariable)((Object)TypeAnnotationUtils.unannotatedType(typeT.getUnderlyingType())), constraint, result, tAnnos, qualifierHierarchy);
                    }
                    if (!uAnnos.isEmpty()) {
                        this.addToPrimaryRelationship((TypeVariable)((Object)TypeAnnotationUtils.unannotatedType(typeU.getUnderlyingType())), constraint, result, uAnnos, qualifierHierarchy);
                    }
                }
                if (TypeAnnotationUtils.unannotatedType(typeT.getUnderlyingType()).equals(TypeAnnotationUtils.unannotatedType(typeU.getUnderlyingType()))) continue;
                this.addToTargetRelationship((TypeVariable)((Object)TypeAnnotationUtils.unannotatedType(typeT.getUnderlyingType())), (TypeVariable)((Object)TypeAnnotationUtils.unannotatedType(typeU.getUnderlyingType())), result, constraint, hierarchiesInRelation);
                continue;
            }
            for (AnnotationMirror top : tops) {
                tAnno = typeT.getAnnotationInHierarchy(top);
                if (tAnno != null) continue;
                hierarchiesInRelation.add(top);
            }
            this.addToTypeRelationship((TypeVariable)((Object)TypeAnnotationUtils.unannotatedType(typeT.getUnderlyingType())), typeU, result, constraint, hierarchiesInRelation);
        }
        return result;
    }

    private void addToTargetRelationship(TypeVariable typeT, TypeVariable typeU, ConstraintMap result, TUConstraint constraint, AnnotationMirrorSet hierarchiesInRelation) {
        if (constraint instanceof TIsU) {
            result.addTargetEquality(typeT, typeU, hierarchiesInRelation);
        } else if (constraint instanceof TSuperU) {
            result.addTargetSupertype(typeT, typeU, hierarchiesInRelation);
        } else {
            result.addTargetSubtype(typeT, typeU, hierarchiesInRelation);
        }
    }

    public void addToPrimaryRelationship(TypeVariable typeVariable, TUConstraint constraint, ConstraintMap result, AnnotationMirrorSet annotationMirrors, QualifierHierarchy qualifierHierarchy) {
        if (constraint instanceof TIsU) {
            result.addPrimaryEqualities(typeVariable, qualifierHierarchy, annotationMirrors);
        } else if (constraint instanceof TSuperU) {
            result.addPrimarySupertype(typeVariable, qualifierHierarchy, annotationMirrors);
        } else {
            result.addPrimarySubtypes(typeVariable, qualifierHierarchy, annotationMirrors);
        }
    }

    public void addToTypeRelationship(TypeVariable target, AnnotatedTypeMirror type, ConstraintMap result, TUConstraint constraint, AnnotationMirrorSet hierarchies) {
        if (constraint instanceof TIsU) {
            result.addTypeEqualities(target, type, hierarchies);
        } else if (constraint instanceof TSuperU) {
            result.addTypeSupertype(target, type, hierarchies);
        } else {
            result.addTypeSubtype(target, type, hierarchies);
        }
    }
}

