/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.util.typeinference;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.framework.type.TypeHierarchy;
import org.checkerframework.framework.util.AnnotationMirrorMap;
import org.checkerframework.framework.util.AnnotationMirrorSet;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.TypesUtils;

public class GlbUtil {
    public static AnnotatedTypeMirror glbAll(Map<AnnotatedTypeMirror, AnnotationMirrorSet> typeMirrors, AnnotatedTypeFactory typeFactory) {
        QualifierHierarchy qualifierHierarchy = typeFactory.getQualifierHierarchy();
        if (typeMirrors.isEmpty()) {
            return null;
        }
        AnnotationMirrorMap<AnnotationMirror> glbPrimaries = new AnnotationMirrorMap<AnnotationMirror>();
        for (Map.Entry<AnnotatedTypeMirror, AnnotationMirrorSet> tmEntry : typeMirrors.entrySet()) {
            AnnotationMirrorSet typeAnnoHierarchies = tmEntry.getValue();
            AnnotatedTypeMirror type = tmEntry.getKey();
            Iterator<AnnotationMirror> iterator = typeAnnoHierarchies.iterator();
            while (iterator.hasNext()) {
                AnnotationMirror top = iterator.next();
                AnnotationMirror typeAnno = type.getEffectiveAnnotationInHierarchy(top);
                AnnotationMirror currentAnno = (AnnotationMirror)glbPrimaries.get(top);
                if (typeAnno != null && currentAnno != null) {
                    glbPrimaries.put(top, qualifierHierarchy.greatestLowerBound(currentAnno, typeAnno));
                    continue;
                }
                if (typeAnno == null) continue;
                glbPrimaries.put(top, typeAnno);
            }
        }
        ArrayList<AnnotatedTypeMirror> glbTypes = new ArrayList<AnnotatedTypeMirror>();
        AnnotationMirrorSet values = new AnnotationMirrorSet(glbPrimaries.values());
        for (AnnotatedTypeMirror type : typeMirrors.keySet()) {
            if (type.getKind() != TypeKind.TYPEVAR || !qualifierHierarchy.isSubtype(type.getEffectiveAnnotations(), values)) {
                AnnotatedTypeMirror copy = type.deepCopy();
                copy.replaceAnnotations(values);
                glbTypes.add(copy);
                continue;
            }
            glbTypes.add(type);
        }
        TypeHierarchy typeHierarchy = typeFactory.getTypeHierarchy();
        GlbUtil.sortForGlb(glbTypes, typeFactory);
        AnnotatedTypeMirror glbType = (AnnotatedTypeMirror)glbTypes.get(0);
        for (int index = 1; index < glbTypes.size(); ++index) {
            if (glbType.getKind() == TypeKind.NULL) continue;
            glbType = (AnnotatedTypeMirror)glbTypes.get(index);
        }
        boolean incomparable = false;
        for (AnnotatedTypeMirror type : glbTypes) {
            if (incomparable || type.getKind() == TypeKind.NULL || TypesUtils.isErasedSubtype(typeFactory.getContext().getTypeUtils(), glbType.getUnderlyingType(), type.getUnderlyingType()) && typeHierarchy.isSubtype(glbType, type)) continue;
            incomparable = true;
        }
        if (incomparable) {
            return GlbUtil.createBottom(typeFactory, glbType.getEffectiveAnnotations());
        }
        return glbType;
    }

    private static AnnotatedTypeMirror.AnnotatedNullType createBottom(AnnotatedTypeFactory typeFactory, Set<? extends AnnotationMirror> annos) {
        return typeFactory.getAnnotatedNullType(annos);
    }

    public static void sortForGlb(List<? extends AnnotatedTypeMirror> typeMirrors, AnnotatedTypeFactory typeFactory) {
        final QualifierHierarchy qualifierHierarchy = typeFactory.getQualifierHierarchy();
        final Types types = typeFactory.getProcessingEnv().getTypeUtils();
        Collections.sort(typeMirrors, new Comparator<AnnotatedTypeMirror>(){

            @Override
            public int compare(AnnotatedTypeMirror type1, AnnotatedTypeMirror type2) {
                TypeMirror underlyingType2;
                TypeMirror underlyingType1 = type1.getUnderlyingType();
                if (types.isSameType(underlyingType1, underlyingType2 = type2.getUnderlyingType())) {
                    return this.compareAnnotations(qualifierHierarchy, type1, type2);
                }
                if (types.isSubtype(underlyingType1, underlyingType2)) {
                    return 1;
                }
                return -1;
            }

            private int compareAnnotations(QualifierHierarchy qualHierarchy, AnnotatedTypeMirror type1, AnnotatedTypeMirror type2) {
                if (AnnotationUtils.areSame(type1.getAnnotations(), type2.getAnnotations())) {
                    return 0;
                }
                if (qualHierarchy.isSubtype(type1.getAnnotations(), type2.getAnnotations())) {
                    return 1;
                }
                return -1;
            }
        });
    }
}

