/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.printer.lexicalpreservation;

import com.github.javaparser.JavaParser;
import com.github.javaparser.JavaToken;
import com.github.javaparser.ParseResult;
import com.github.javaparser.ParseStart;
import com.github.javaparser.Provider;
import com.github.javaparser.Range;
import com.github.javaparser.TokenTypes;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.comments.Comment;
import com.github.javaparser.ast.comments.JavadocComment;
import com.github.javaparser.ast.nodeTypes.NodeWithVariables;
import com.github.javaparser.ast.observer.AstObserver;
import com.github.javaparser.ast.observer.ObservableProperty;
import com.github.javaparser.ast.observer.PropagatingAstObserver;
import com.github.javaparser.ast.type.PrimitiveType;
import com.github.javaparser.ast.visitor.TreeVisitor;
import com.github.javaparser.printer.ConcreteSyntaxModel;
import com.github.javaparser.printer.concretesyntaxmodel.CsmElement;
import com.github.javaparser.printer.concretesyntaxmodel.CsmMix;
import com.github.javaparser.printer.concretesyntaxmodel.CsmToken;
import com.github.javaparser.printer.lexicalpreservation.ChildTextElement;
import com.github.javaparser.printer.lexicalpreservation.LexicalDifferenceCalculator;
import com.github.javaparser.printer.lexicalpreservation.NodeText;
import com.github.javaparser.printer.lexicalpreservation.PhantomNodeLogic;
import com.github.javaparser.printer.lexicalpreservation.TextElement;
import com.github.javaparser.printer.lexicalpreservation.TextElementIteratorsFactory;
import com.github.javaparser.printer.lexicalpreservation.TextElementMatcher;
import com.github.javaparser.printer.lexicalpreservation.TokenTextElement;
import com.github.javaparser.utils.Pair;
import com.github.javaparser.utils.Utils;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class LexicalPreservingPrinter {
    private final Map<Node, NodeText> textForNodes = new IdentityHashMap<Node, NodeText>();

    public static <N extends Node> Pair<ParseResult<N>, LexicalPreservingPrinter> setup(ParseStart<N> parseStart, Provider provider) {
        ParseResult<N> parseResult = new JavaParser().parse(parseStart, provider);
        if (!parseResult.isSuccessful()) {
            throw new RuntimeException("Parsing failed, unable to setup the lexical preservation printer: " + parseResult.getProblems());
        }
        LexicalPreservingPrinter lexicalPreservingPrinter = new LexicalPreservingPrinter((Node)parseResult.getResult().get());
        return new Pair<ParseResult<N>, LexicalPreservingPrinter>(parseResult, lexicalPreservingPrinter);
    }

    public LexicalPreservingPrinter(Node node) {
        Utils.assertNotNull(node);
        node.getTokenRange().ifPresent(r -> {
            this.storeInitialText(node);
            AstObserver observer = LexicalPreservingPrinter.createObserver(this);
            node.registerForSubtree(observer);
        });
    }

    private static AstObserver createObserver(final LexicalPreservingPrinter lpp) {
        return new PropagatingAstObserver(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void concretePropertyChange(Node observedNode, ObservableProperty property, Object oldValue, Object newValue) {
                NodeText nodeText;
                if (oldValue != null && oldValue.equals(newValue) || oldValue == null && newValue == null) {
                    return;
                }
                if (property == ObservableProperty.RANGE || property == ObservableProperty.COMMENTED_NODE) {
                    return;
                }
                if (property == ObservableProperty.COMMENT) {
                    if (!observedNode.getParentNode().isPresent()) {
                        throw new IllegalStateException();
                    }
                    nodeText = lpp.getOrCreateNodeText(observedNode.getParentNode().get());
                    if (oldValue == null) {
                        int index = nodeText.findChild(observedNode);
                        nodeText.addChild(index, (Comment)newValue);
                        nodeText.addToken(index + 1, TokenTypes.eolTokenKind(), Utils.EOL);
                    } else if (newValue == null) {
                        if (!(oldValue instanceof JavadocComment)) throw new UnsupportedOperationException();
                        JavadocComment javadocComment = (JavadocComment)oldValue;
                        List matchingTokens = nodeText.getElements().stream().filter(e -> e.isToken(35) && ((TokenTextElement)e).getText().equals("/**" + javadocComment.getContent() + "*/")).map(e -> (TokenTextElement)e).collect(Collectors.toList());
                        if (matchingTokens.size() != 1) {
                            throw new IllegalStateException();
                        }
                        int index = nodeText.findElement((TextElementMatcher)matchingTokens.get(0));
                        nodeText.removeElement(index);
                        if (nodeText.getElements().get(index).isNewline()) {
                            nodeText.removeElement(index);
                        }
                    } else {
                        if (!(oldValue instanceof JavadocComment)) throw new UnsupportedOperationException();
                        JavadocComment oldJavadocComment = (JavadocComment)oldValue;
                        List matchingTokens = nodeText.getElements().stream().filter(e -> e.isToken(35) && ((TokenTextElement)e).getText().equals("/**" + oldJavadocComment.getContent() + "*/")).map(e -> (TokenTextElement)e).collect(Collectors.toList());
                        if (matchingTokens.size() != 1) {
                            throw new IllegalStateException();
                        }
                        JavadocComment newJavadocComment = (JavadocComment)newValue;
                        nodeText.replace((TextElementMatcher)matchingTokens.get(0), new TokenTextElement(35, "/**" + newJavadocComment.getContent() + "*/"));
                    }
                }
                if ((nodeText = lpp.getOrCreateNodeText(observedNode)) == null) {
                    throw new NullPointerException(observedNode.getClass().getSimpleName());
                }
                new LexicalDifferenceCalculator().calculatePropertyChange(nodeText, observedNode, property, oldValue, newValue);
            }

            @Override
            public void concreteListChange(NodeList changedList, AstObserver.ListChangeType type, int index, Node nodeAddedOrRemoved) {
                NodeText nodeText = lpp.getOrCreateNodeText(changedList.getParentNodeForChildren());
                if (type == AstObserver.ListChangeType.REMOVAL) {
                    new LexicalDifferenceCalculator().calculateListRemovalDifference(LexicalPreservingPrinter.findNodeListName(changedList), changedList, index).apply(nodeText, changedList.getParentNodeForChildren());
                } else if (type == AstObserver.ListChangeType.ADDITION) {
                    new LexicalDifferenceCalculator().calculateListAdditionDifference(LexicalPreservingPrinter.findNodeListName(changedList), changedList, index, nodeAddedOrRemoved).apply(nodeText, changedList.getParentNodeForChildren());
                } else {
                    throw new UnsupportedOperationException();
                }
            }

            @Override
            public void concreteListReplacement(NodeList changedList, int index, Node oldValue, Node newValue) {
                NodeText nodeText = lpp.getOrCreateNodeText(changedList.getParentNodeForChildren());
                new LexicalDifferenceCalculator().calculateListReplacementDifference(LexicalPreservingPrinter.findNodeListName(changedList), changedList, index, newValue).apply(nodeText, changedList.getParentNodeForChildren());
            }
        };
    }

    private void storeInitialText(Node root) {
        final IdentityHashMap tokensByNode = new IdentityHashMap();
        final LinkedList nodesDepthFirst = new LinkedList();
        new TreeVisitor(){

            @Override
            public void process(Node node) {
                if (!PhantomNodeLogic.isPhantomNode(node)) {
                    nodesDepthFirst.add(node);
                }
            }
        }.visitLeavesFirst(root);
        for (JavaToken token : root.getTokenRange().get()) {
            Range tokenRange = token.getRange().orElseThrow(() -> new RuntimeException("Token without range: " + token));
            Node owner = nodesDepthFirst.stream().filter(n -> n.getRange().get().contains(tokenRange)).findFirst().orElseThrow(() -> new RuntimeException("Token without node owning it: " + token));
            if (!tokensByNode.containsKey(owner)) {
                tokensByNode.put(owner, new LinkedList());
            }
            ((List)tokensByNode.get(owner)).add(token);
        }
        new TreeVisitor(){

            @Override
            public void process(Node node) {
                if (!PhantomNodeLogic.isPhantomNode(node)) {
                    LexicalPreservingPrinter.this.storeInitialTextForOneNode(node, (List)tokensByNode.get(node));
                }
            }
        }.visitBreadthFirst(root);
    }

    private void storeInitialTextForOneNode(Node node, List<JavaToken> nodeTokens) {
        if (nodeTokens == null) {
            nodeTokens = Collections.emptyList();
        }
        LinkedList<Pair> elements = new LinkedList<Pair>();
        for (Node child : node.getChildNodes()) {
            if (PhantomNodeLogic.isPhantomNode(child)) continue;
            if (!child.getRange().isPresent()) {
                throw new RuntimeException("Range not present on node " + child);
            }
            elements.add(new Pair<Range, ChildTextElement>(child.getRange().get(), new ChildTextElement(this, child)));
        }
        for (JavaToken token : nodeTokens) {
            elements.add(new Pair<Range, TokenTextElement>(token.getRange().get(), new TokenTextElement(token)));
        }
        elements.sort(Comparator.comparing(e -> ((Range)e.a).begin));
        this.textForNodes.put(node, new NodeText(this, elements.stream().map(p -> (TextElement)p.b).collect(Collectors.toList())));
    }

    private Iterator<TokenTextElement> tokensPreceeding(Node node) {
        if (!node.getParentNode().isPresent()) {
            return new TextElementIteratorsFactory.EmptyIterator<TokenTextElement>();
        }
        NodeText parentNodeText = this.getOrCreateNodeText(node.getParentNode().get());
        int index = parentNodeText.tryToFindChild(node);
        if (index == -1) {
            if (node.getParentNode().get() instanceof VariableDeclarator) {
                return this.tokensPreceeding(node.getParentNode().get());
            }
            throw new IllegalArgumentException(String.format("I could not find child '%s' in parent '%s'. parentNodeText: %s", node, node.getParentNode().get(), parentNodeText));
        }
        return new TextElementIteratorsFactory.CascadingIterator<TokenTextElement>(TextElementIteratorsFactory.partialReverseIterator(parentNodeText, index - 1), () -> this.tokensPreceeding(node.getParentNode().get()));
    }

    public String print(Node node) {
        StringWriter writer = new StringWriter();
        try {
            this.print(node, writer);
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected IOException on a StringWriter", e);
        }
        return writer.toString();
    }

    public void print(Node node, Writer writer) throws IOException {
        if (!this.textForNodes.containsKey(node)) {
            this.getOrCreateNodeText(node);
        }
        NodeText text = this.textForNodes.get(node);
        writer.append(text.expand());
    }

    private NodeText prettyPrintingTextNode(Node node, NodeText nodeText) {
        if (node instanceof PrimitiveType) {
            PrimitiveType primitiveType = (PrimitiveType)node;
            switch (primitiveType.getType()) {
                case BOOLEAN: {
                    nodeText.addToken(40, node.toString());
                    break;
                }
                case CHAR: {
                    nodeText.addToken(45, node.toString());
                    break;
                }
                case BYTE: {
                    nodeText.addToken(42, node.toString());
                    break;
                }
                case SHORT: {
                    nodeText.addToken(76, node.toString());
                    break;
                }
                case INT: {
                    nodeText.addToken(65, node.toString());
                    break;
                }
                case LONG: {
                    nodeText.addToken(67, node.toString());
                    break;
                }
                case FLOAT: {
                    nodeText.addToken(58, node.toString());
                    break;
                }
                case DOUBLE: {
                    nodeText.addToken(51, node.toString());
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            return nodeText;
        }
        if (node instanceof JavadocComment) {
            nodeText.addToken(35, "/**" + ((JavadocComment)node).getContent() + "*/");
            return nodeText;
        }
        return this.interpret(node, ConcreteSyntaxModel.forClass(node.getClass()), nodeText);
    }

    private NodeText interpret(Node node, CsmElement csm, NodeText nodeText) {
        LexicalDifferenceCalculator.CalculatedSyntaxModel calculatedSyntaxModel = new LexicalDifferenceCalculator().calculatedSyntaxModelForNode(csm, node);
        List<TokenTextElement> indentation = this.findIndentation(node);
        boolean pendingIndentation = false;
        for (CsmElement element : calculatedSyntaxModel.elements) {
            block10: {
                block11: {
                    if (!pendingIndentation) break block10;
                    if (!(element instanceof CsmToken)) break block11;
                    if (((CsmToken)element).isNewLine()) break block10;
                }
                indentation.forEach(nodeText::addElement);
            }
            pendingIndentation = false;
            if (element instanceof LexicalDifferenceCalculator.CsmChild) {
                nodeText.addChild(((LexicalDifferenceCalculator.CsmChild)element).getChild());
                continue;
            }
            if (element instanceof CsmToken) {
                CsmToken csmToken = (CsmToken)element;
                nodeText.addToken(csmToken.getTokenType(), csmToken.getContent(node));
                if (!csmToken.isNewLine()) continue;
                pendingIndentation = true;
                continue;
            }
            if (element instanceof CsmMix) {
                CsmMix csmMix = (CsmMix)element;
                csmMix.getElements().forEach(e -> this.interpret(node, (CsmElement)e, nodeText));
                continue;
            }
            throw new UnsupportedOperationException(element.getClass().getSimpleName());
        }
        if (node instanceof VariableDeclarator) {
            VariableDeclarator variableDeclarator = (VariableDeclarator)node;
            if (!variableDeclarator.getParentNode().isPresent()) {
                throw new RuntimeException("VariableDeclarator without parent: I cannot handle the array levels");
            }
            NodeWithVariables nodeWithVariables = (NodeWithVariables)((Object)variableDeclarator.getParentNode().get());
            int extraArrayLevels = variableDeclarator.getType().getArrayLevel() - nodeWithVariables.getMaximumCommonType().getArrayLevel();
            for (int i = 0; i < extraArrayLevels; ++i) {
                nodeText.addElement(new TokenTextElement(121));
                nodeText.addElement(new TokenTextElement(122));
            }
        }
        return nodeText;
    }

    NodeText getOrCreateNodeText(Node node) {
        if (!this.textForNodes.containsKey(node)) {
            NodeText nodeText = new NodeText(this);
            this.textForNodes.put(node, nodeText);
            this.prettyPrintingTextNode(node, nodeText);
        }
        return this.textForNodes.get(node);
    }

    List<TokenTextElement> findIndentation(Node node) {
        TokenTextElement tte;
        LinkedList<TokenTextElement> followingNewlines = new LinkedList<TokenTextElement>();
        Iterator<TokenTextElement> it = this.tokensPreceeding(node);
        while (it.hasNext() && (tte = it.next()).getTokenKind() != 32 && !tte.isNewline()) {
            followingNewlines.add(tte);
        }
        Collections.reverse(followingNewlines);
        for (int i = 0; i < followingNewlines.size(); ++i) {
            if (((TokenTextElement)followingNewlines.get(i)).isSpaceOrTab()) continue;
            return followingNewlines.subList(0, i);
        }
        return followingNewlines;
    }

    private static boolean isReturningOptionalNodeList(Method m3) {
        if (!m3.getReturnType().getCanonicalName().equals(Optional.class.getCanonicalName())) {
            return false;
        }
        if (!(m3.getGenericReturnType() instanceof ParameterizedType)) {
            return false;
        }
        ParameterizedType parameterizedType = (ParameterizedType)m3.getGenericReturnType();
        Type optionalArgument = parameterizedType.getActualTypeArguments()[0];
        return parameterizedType.getActualTypeArguments()[0].getTypeName().startsWith(NodeList.class.getCanonicalName());
    }

    private static ObservableProperty findNodeListName(NodeList nodeList) {
        Node parent = nodeList.getParentNodeForChildren();
        for (Method m3 : parent.getClass().getMethods()) {
            Object raw;
            if (m3.getParameterCount() == 0 && m3.getReturnType().getCanonicalName().equals(NodeList.class.getCanonicalName())) {
                try {
                    raw = m3.invoke((Object)parent, new Object[0]);
                    if (!(raw instanceof NodeList)) {
                        throw new IllegalStateException("Expected NodeList, found " + raw.getClass().getCanonicalName());
                    }
                    NodeList result = (NodeList)raw;
                    if (result != nodeList) continue;
                    String name = m3.getName();
                    if (name.startsWith("get")) {
                        name = name.substring("get".length());
                    }
                    return ObservableProperty.fromCamelCaseName(Utils.decapitalize(name));
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
            if (m3.getParameterCount() != 0 || !LexicalPreservingPrinter.isReturningOptionalNodeList(m3)) continue;
            try {
                raw = (Optional)m3.invoke((Object)parent, new Object[0]);
                if (!((Optional)raw).isPresent() || ((Optional)raw).get() != nodeList) continue;
                String name = m3.getName();
                if (name.startsWith("get")) {
                    name = name.substring("get".length());
                }
                return ObservableProperty.fromCamelCaseName(Utils.decapitalize(name));
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        throw new IllegalArgumentException("Cannot find list name of NodeList of size " + nodeList.size());
    }

    NodeText getTextForNode(Node node) {
        return this.textForNodes.get(node);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

