/*
 * Decompiled with CFR 0.152.
 */
package annotations.io;

import annotations.io.ASTPath;
import annotations.io.ASTRecord;
import annotations.util.JVMNames;
import annotations.util.coll.WrapperMap;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.sun.source.tree.AnnotatedTypeTree;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.AssertTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.IntersectionTypeTree;
import com.sun.source.tree.LabeledStatementTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.UnionTypeTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.tree.WildcardTree;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Name;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ASTIndex
extends WrapperMap<Tree, ASTRecord> {
    private static Tree cachedRoot = null;
    private static Map<Tree, ASTRecord> cachedIndex = null;
    private static final int EXPECTED_SIZE = 128;
    private final CompilationUnitTree cut;
    private final Map<String, Map<String, List<String>>> formals;

    public static Map<Tree, ASTRecord> indexOf(CompilationUnitTree root) {
        if (cachedRoot == null || !cachedRoot.equals(root)) {
            cachedRoot = root;
            cachedIndex = new ASTIndex(root);
        }
        return cachedIndex;
    }

    private ASTIndex(CompilationUnitTree root) {
        super(HashBiMap.create(128));
        this.cut = root;
        this.formals = new HashMap<String, Map<String, List<String>>>();
        this.cut.accept(new SimpleTreeVisitor<Void, ASTRecord>(){
            Deque<Integer> counters = new ArrayDeque<Integer>();
            String inMethod = null;

            private void save(Tree node, ASTRecord rec, Tree.Kind kind, String sel) {
                if (node != null) {
                    node.accept(this, rec.extend(kind, sel));
                }
            }

            private void save(Tree node, ASTRecord rec, Tree.Kind kind, String sel, int arg) {
                if (node != null) {
                    node.accept(this, rec.extend(kind, sel, arg));
                }
            }

            private void saveAll(Iterable<? extends Tree> nodes, ASTRecord rec, Tree.Kind kind, String sel) {
                if (nodes != null) {
                    int i = 0;
                    for (Tree tree : nodes) {
                        this.save(tree, rec, kind, sel, i++);
                    }
                }
            }

            private void saveClass(ClassTree node) {
                String className = ((JCTree.JCClassDecl)node).sym.flatname.toString();
                ASTRecord rec = new ASTRecord(ASTIndex.this.cut, className, null, null, ASTPath.empty());
                this.counters.push(0);
                node.accept(this, rec);
                this.counters.pop();
            }

            @Override
            public Void defaultAction(Tree node, ASTRecord rec) {
                switch (node.getKind()) {
                    case BREAK: 
                    case COMPILATION_UNIT: 
                    case CONTINUE: 
                    case IMPORT: 
                    case MODIFIERS: {
                        break;
                    }
                    default: {
                        ASTIndex.this.put(node, rec);
                    }
                }
                return null;
            }

            @Override
            public Void visitAnnotatedType(AnnotatedTypeTree node, ASTRecord rec) {
                Tree.Kind kind = node.getKind();
                this.saveAll(node.getAnnotations(), rec, kind, "annotation");
                this.save(node.getUnderlyingType(), rec, kind, "underlyingType");
                return this.defaultAction((Tree)node, rec);
            }

            @Override
            public Void visitAnnotation(AnnotationTree node, ASTRecord rec) {
                Tree.Kind kind = node.getKind();
                this.save(node.getAnnotationType(), rec, kind, "type");
                this.saveAll(node.getArguments(), rec, kind, "argument");
                return this.defaultAction((Tree)node, rec);
            }

            @Override
            public Void visitMethodInvocation(MethodInvocationTree node, ASTRecord rec) {
                Tree.Kind kind = node.getKind();
                this.saveAll(node.getTypeArguments(), rec, kind, "typeArgument");
                this.save(node.getMethodSelect(), rec, kind, "methodSelect");
                this.saveAll(node.getArguments(), rec, kind, "argument");
                return this.defaultAction((Tree)node, rec);
            }

            @Override
            public Void visitAssert(AssertTree node, ASTRecord rec) {
                Tree.Kind kind = node.getKind();
                this.save(node.getCondition(), rec, kind, "condition");
                this.save(node.getDetail(), rec, kind, "detail");
                return this.defaultAction((Tree)node, rec);
            }

            @Override
            public Void visitAssignment(AssignmentTree node, ASTRecord rec) {
                Tree.Kind kind = node.getKind();
                this.save(node.getExpression(), rec, kind, "expression");
                this.save(node.getVariable(), rec, kind, "variable");
                return this.defaultAction((Tree)node, rec);
            }

            @Override
            public Void visitCompoundAssignment(CompoundAssignmentTree node, ASTRecord rec) {
                Tree.Kind kind = node.getKind();
                this.save(node.getExpression(), rec, kind, "expression");
                this.save(node.getVariable(), rec, kind, "variable");
                return this.defaultAction((Tree)node, rec);
            }

            @Override
            public Void visitBinary(BinaryTree node, ASTRecord rec) {
                Tree.Kind kind = node.getKind();
                this.save(node.getLeftOperand(), rec, kind, "leftOperand");
                this.save(node.getRightOperand(), rec, kind, "rightOperand");
                return this.defaultAction((Tree)node, rec);
            }

            @Override
            public Void visitBlock(BlockTree node, ASTRecord rec) {
                List<? extends StatementTree> nodes = node.getStatements();
                if (nodes != null) {
                    int i = 0;
                    for (Tree tree : nodes) {
                        if (ASTPath.isClassEquiv(tree.getKind())) {
                            this.saveClass((ClassTree)tree);
                        } else {
                            this.save(tree, rec, node.getKind(), "statement", i);
                        }
                        ++i;
                    }
                }
                return this.defaultAction((Tree)node, rec);
            }

            @Override
            public Void visitCase(CaseTree node, ASTRecord rec) {
                Tree.Kind kind = node.getKind();
                this.save(node.getExpression(), rec, kind, "expression");
                this.saveAll(node.getStatements(), rec, kind, "statement");
                return this.defaultAction((Tree)node, rec);
            }

            @Override
            public Void visitCatch(CatchTree node, ASTRecord rec) {
                Tree.Kind kind = node.getKind();
                this.save(node.getBlock(), rec, kind, "block");
                this.save(node.getParameter(), rec, kind, "parameter");
                return this.defaultAction((Tree)node, rec);
            }

            @Override
            public Void visitClass(ClassTree node, ASTRecord rec) {
                Tree.Kind kind = Tree.Kind.CLASS;
                int i = 0;
                ASTIndex.this.formals.put(rec.className, new HashMap());
                if (node.getSimpleName().length() > 0) {
                    this.save(node.getExtendsClause(), rec, kind, "bound", -1);
                    this.saveAll(node.getImplementsClause(), rec, kind, "bound");
                }
                this.saveAll(node.getTypeParameters(), rec, kind, "typeParameter");
                for (Tree tree : node.getMembers()) {
                    if (tree.getKind() == Tree.Kind.BLOCK) {
                        this.save(tree, rec, kind, "initializer", i++);
                        continue;
                    }
                    if (ASTPath.isClassEquiv(tree.getKind())) {
                        String className = ((JCTree.JCClassDecl)tree).sym.flatname.toString();
                        tree.accept(this, new ASTRecord(ASTIndex.this.cut, className, null, null, ASTPath.empty()));
                        continue;
                    }
                    tree.accept(this, rec);
                }
                return this.defaultAction((Tree)node, rec);
            }

            @Override
            public Void visitConditionalExpression(ConditionalExpressionTree node, ASTRecord rec) {
                Tree.Kind kind = node.getKind();
                this.save(node.getCondition(), rec, kind, "condition");
                this.save(node.getFalseExpression(), rec, kind, "falseExpression");
                this.save(node.getTrueExpression(), rec, kind, "trueExpression");
                return this.defaultAction((Tree)node, rec);
            }

            @Override
            public Void visitDoWhileLoop(DoWhileLoopTree node, ASTRecord rec) {
                Tree.Kind kind = node.getKind();
                this.save(node.getCondition(), rec, kind, "condition");
                this.save(node.getStatement(), rec, kind, "statement");
                return this.defaultAction((Tree)node, rec);
            }

            @Override
            public Void visitExpressionStatement(ExpressionStatementTree node, ASTRecord rec) {
                this.save(node.getExpression(), rec, node.getKind(), "expression");
                return this.defaultAction((Tree)node, rec);
            }

            @Override
            public Void visitEnhancedForLoop(EnhancedForLoopTree node, ASTRecord rec) {
                Tree.Kind kind = node.getKind();
                this.save(node.getVariable(), rec, kind, "variable");
                this.save(node.getExpression(), rec, kind, "expression");
                this.save(node.getStatement(), rec, kind, "statement");
                return this.defaultAction((Tree)node, rec);
            }

            @Override
            public Void visitForLoop(ForLoopTree node, ASTRecord rec) {
                Tree.Kind kind = node.getKind();
                this.saveAll(node.getInitializer(), rec, kind, "initializer");
                this.save(node.getCondition(), rec, kind, "condition");
                this.save(node.getStatement(), rec, kind, "statement");
                this.saveAll(node.getUpdate(), rec, kind, "update");
                return this.defaultAction((Tree)node, rec);
            }

            @Override
            public Void visitIf(IfTree node, ASTRecord rec) {
                Tree.Kind kind = node.getKind();
                this.save(node.getCondition(), rec, kind, "condition");
                this.save(node.getThenStatement(), rec, kind, "thenStatement");
                this.save(node.getElseStatement(), rec, kind, "elseStatement");
                return this.defaultAction((Tree)node, rec);
            }

            @Override
            public Void visitArrayAccess(ArrayAccessTree node, ASTRecord rec) {
                Tree.Kind kind = node.getKind();
                this.save(node.getExpression(), rec, kind, "expression");
                this.save(node.getIndex(), rec, kind, "index");
                return this.defaultAction((Tree)node, rec);
            }

            @Override
            public Void visitLabeledStatement(LabeledStatementTree node, ASTRecord rec) {
                this.save(node.getStatement(), rec, node.getKind(), "statement");
                return this.defaultAction((Tree)node, rec);
            }

            @Override
            public Void visitMethod(MethodTree node, ASTRecord rec) {
                Tree.Kind kind = node.getKind();
                VariableTree rcvr = node.getReceiverParameter();
                ModifiersTree mods = node.getModifiers();
                List<? extends VariableTree> params = node.getParameters();
                String outMethod = this.inMethod;
                this.inMethod = JVMNames.getJVMMethodName(node);
                rec = new ASTRecord(ASTIndex.this.cut, rec.className, this.inMethod, null, ASTPath.empty());
                if (mods != null) {
                    this.save(mods, rec, kind, "modifiers");
                }
                if (rcvr != null) {
                    rcvr.accept(this, rec.extend(kind, "parameter", -1));
                }
                if (params != null && !params.isEmpty()) {
                    Map map = (Map)ASTIndex.this.formals.get(rec.className);
                    ArrayList<String> names = new ArrayList<String>(params.size());
                    int i = 0;
                    map.put(this.inMethod, names);
                    for (Tree tree : params) {
                        if (tree == null) continue;
                        names.add(((VariableTree)tree).getName().toString());
                        tree.accept(this, rec.extend(Tree.Kind.METHOD, "parameter", i++));
                    }
                }
                this.save(node.getReturnType(), rec, kind, "type");
                this.saveAll(node.getTypeParameters(), rec, kind, "typeParameter");
                this.saveAll(node.getThrows(), rec, kind, "throws");
                this.save(node.getBody(), rec, kind, "body");
                this.inMethod = outMethod;
                return this.defaultAction((Tree)node, rec);
            }

            @Override
            public Void visitModifiers(ModifiersTree node, ASTRecord rec) {
                Tree.Kind kind = node.getKind();
                this.saveAll(node.getAnnotations(), rec, kind, "annotation");
                return this.defaultAction((Tree)node, rec);
            }

            @Override
            public Void visitNewArray(NewArrayTree node, ASTRecord rec) {
                Tree.Kind kind = node.getKind();
                Tree type = node.getType();
                int n = node.getDimensions().size();
                do {
                    this.save(type, rec, kind, "type", n);
                } while (--n > 0);
                this.saveAll(node.getDimensions(), rec, kind, "dimension");
                this.saveAll(node.getInitializers(), rec, kind, "initializer");
                return this.defaultAction((Tree)node, rec);
            }

            @Override
            public Void visitNewClass(NewClassTree node, ASTRecord rec) {
                JCTree.JCClassDecl classBody = (JCTree.JCClassDecl)node.getClassBody();
                Tree.Kind kind = node.getKind();
                this.save(node.getEnclosingExpression(), rec, kind, "enclosingExpression");
                this.saveAll(node.getTypeArguments(), rec, kind, "typeArgument");
                this.save(node.getIdentifier(), rec, kind, "identifier");
                this.saveAll(node.getArguments(), rec, kind, "argument");
                if (classBody != null) {
                    Name name = classBody.getSimpleName();
                    String className = null;
                    if (name == null || ((Object)name).toString().isEmpty()) {
                        int i = this.counters.pop();
                        this.counters.push(++i);
                        className = rec.className + "$" + i;
                    } else {
                        String s2;
                        Symbol.ClassSymbol sym = classBody.sym;
                        String string = s2 = sym == null ? "" : sym.toString();
                        if (s2.startsWith("<anonymous ")) {
                            int i = this.counters.pop();
                            this.counters.push(++i);
                            className = s2.substring(11, s2.length() - 1);
                        } else {
                            className = rec.className + "$" + name;
                        }
                    }
                    this.counters.push(0);
                    classBody.accept(this, new ASTRecord(ASTIndex.this.cut, className, null, null, ASTPath.empty()));
                    this.counters.pop();
                }
                return this.defaultAction((Tree)node, rec);
            }

            @Override
            public Void visitLambdaExpression(LambdaExpressionTree node, ASTRecord rec) {
                Tree.Kind kind = node.getKind();
                String outMethod = this.inMethod;
                List<? extends VariableTree> nodes = node.getParameters();
                if (nodes != null) {
                    int i = 0;
                    for (Tree tree : nodes) {
                        ASTRecord newRec = rec.extend(kind, "parameter", i++);
                        Tree.Kind newKind = tree.getKind();
                        if (newKind == Tree.Kind.VARIABLE) {
                            VariableTree vt = (VariableTree)tree;
                            this.save(vt.getType(), newRec, newKind, "type");
                            this.save(vt.getInitializer(), newRec, newKind, "initializer");
                            this.defaultAction((Tree)vt, newRec);
                            continue;
                        }
                        tree.accept(this, rec.extend(kind, "parameter", i++));
                    }
                }
                this.save(node.getBody(), rec, kind, "body");
                this.inMethod = outMethod;
                return this.defaultAction((Tree)node, rec);
            }

            @Override
            public Void visitParenthesized(ParenthesizedTree node, ASTRecord rec) {
                this.save(node.getExpression(), rec, node.getKind(), "expression");
                return this.defaultAction((Tree)node, rec);
            }

            @Override
            public Void visitReturn(ReturnTree node, ASTRecord rec) {
                this.save(node.getExpression(), rec, node.getKind(), "expression");
                return this.defaultAction((Tree)node, rec);
            }

            @Override
            public Void visitMemberSelect(MemberSelectTree node, ASTRecord rec) {
                this.save(node.getExpression(), rec, node.getKind(), "expression");
                return this.defaultAction((Tree)node, rec);
            }

            @Override
            public Void visitMemberReference(MemberReferenceTree node, ASTRecord rec) {
                Tree.Kind kind = node.getKind();
                this.save(node.getQualifierExpression(), rec, kind, "qualifierExpression");
                this.saveAll(node.getTypeArguments(), rec, kind, "typeArgument");
                return this.defaultAction((Tree)node, rec);
            }

            @Override
            public Void visitSwitch(SwitchTree node, ASTRecord rec) {
                Tree.Kind kind = node.getKind();
                this.save(node.getExpression(), rec, kind, "expression");
                this.saveAll(node.getCases(), rec, kind, "case");
                return this.defaultAction((Tree)node, rec);
            }

            @Override
            public Void visitSynchronized(SynchronizedTree node, ASTRecord rec) {
                Tree.Kind kind = node.getKind();
                this.save(node.getExpression(), rec, kind, "expression");
                this.save(node.getBlock(), rec, kind, "block");
                return this.defaultAction((Tree)node, rec);
            }

            @Override
            public Void visitThrow(ThrowTree node, ASTRecord rec) {
                this.save(node.getExpression(), rec, node.getKind(), "expression");
                return this.defaultAction((Tree)node, rec);
            }

            @Override
            public Void visitCompilationUnit(CompilationUnitTree node, ASTRecord rec) {
                for (Tree tree : node.getTypeDecls()) {
                    if (!ASTPath.isClassEquiv(tree.getKind())) continue;
                    this.saveClass((ClassTree)tree);
                }
                return null;
            }

            @Override
            public Void visitTry(TryTree node, ASTRecord rec) {
                Tree.Kind kind = node.getKind();
                this.saveAll(node.getResources(), rec, kind, "resource");
                this.save(node.getBlock(), rec, kind, "block");
                this.saveAll(node.getCatches(), rec, kind, "catch");
                this.save(node.getFinallyBlock(), rec, kind, "finallyBlock");
                return this.defaultAction((Tree)node, rec);
            }

            @Override
            public Void visitParameterizedType(ParameterizedTypeTree node, ASTRecord rec) {
                Tree.Kind kind = node.getKind();
                this.save(node.getType(), rec, kind, "type");
                this.saveAll(node.getTypeArguments(), rec, kind, "typeArgument");
                return this.defaultAction((Tree)node, rec);
            }

            @Override
            public Void visitUnionType(UnionTypeTree node, ASTRecord rec) {
                this.saveAll(node.getTypeAlternatives(), rec, node.getKind(), "typeAlternative");
                return this.defaultAction((Tree)node, rec);
            }

            @Override
            public Void visitIntersectionType(IntersectionTypeTree node, ASTRecord rec) {
                this.saveAll(node.getBounds(), rec, node.getKind(), "bound");
                return this.defaultAction((Tree)node, rec);
            }

            @Override
            public Void visitArrayType(ArrayTypeTree node, ASTRecord rec) {
                this.save(node.getType(), rec, node.getKind(), "type");
                return this.defaultAction((Tree)node, rec);
            }

            @Override
            public Void visitTypeCast(TypeCastTree node, ASTRecord rec) {
                Tree.Kind kind = node.getKind();
                this.save(node.getType(), rec, kind, "type");
                this.save(node.getExpression(), rec, kind, "expression");
                return this.defaultAction((Tree)node, rec);
            }

            @Override
            public Void visitTypeParameter(TypeParameterTree node, ASTRecord rec) {
                this.saveAll(node.getBounds(), rec, node.getKind(), "bound");
                return this.defaultAction((Tree)node, rec);
            }

            @Override
            public Void visitInstanceOf(InstanceOfTree node, ASTRecord rec) {
                Tree.Kind kind = node.getKind();
                this.save(node.getExpression(), rec, kind, "expression");
                this.save(node.getType(), rec, kind, "type");
                return this.defaultAction((Tree)node, rec);
            }

            @Override
            public Void visitUnary(UnaryTree node, ASTRecord rec) {
                this.save(node.getExpression(), rec, node.getKind(), "expression");
                return this.defaultAction((Tree)node, rec);
            }

            @Override
            public Void visitVariable(VariableTree node, ASTRecord rec) {
                Tree.Kind kind = node.getKind();
                if (rec.methodName == null) {
                    rec = new ASTRecord(ASTIndex.this.cut, rec.className, rec.methodName, node.getName().toString(), rec.astPath);
                }
                this.save(node.getType(), rec, kind, "type");
                this.save(node.getInitializer(), rec, kind, "initializer");
                return this.defaultAction((Tree)node, rec);
            }

            @Override
            public Void visitWhileLoop(WhileLoopTree node, ASTRecord rec) {
                Tree.Kind kind = node.getKind();
                this.save(node.getCondition(), rec, kind, "condition");
                this.save(node.getStatement(), rec, kind, "statement");
                return this.defaultAction((Tree)node, rec);
            }

            @Override
            public Void visitWildcard(WildcardTree node, ASTRecord rec) {
                this.save(node.getBound(), rec, node.getKind(), "bound");
                return this.defaultAction((Tree)node, rec);
            }
        }, null);
    }

    public static ASTRecord getASTPath(CompilationUnitTree cut, Tree node) {
        return ASTIndex.indexOf(cut).get(node);
    }

    public static TreePath getTreePath(CompilationUnitTree cut, ASTRecord rec) {
        Tree node = ASTIndex.getNode(cut, rec);
        return node == null ? null : TreePath.getPath(cut, node);
    }

    public static Tree getNode(CompilationUnitTree cut, ASTRecord rec) {
        String pkg;
        Map fwdIndex = ((ASTIndex)ASTIndex.indexOf((CompilationUnitTree)cut)).back;
        BiMap revIndex = ((BiMap)fwdIndex).inverse();
        ExpressionTree et = cut.getPackageName();
        String string = pkg = et == null ? "" : et.toString();
        if (!pkg.isEmpty() && rec.className.indexOf(46) < 0) {
            rec = new ASTRecord(cut, pkg + "." + rec.className, rec.methodName, rec.varName, rec.astPath);
        }
        return (Tree)revIndex.get(rec);
    }

    public static String getParameterName(CompilationUnitTree cut, String className, String methodName, int index) {
        try {
            ASTIndex ai = (ASTIndex)ASTIndex.indexOf(cut);
            return ai.formals.get(className).get(methodName).get(index);
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public static Integer getParameterIndex(CompilationUnitTree cut, String className, String methodName, String varName) {
        if (cut != null && className != null && methodName != null && varName != null) {
            try {
                return Integer.valueOf(varName);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    ASTIndex ai = (ASTIndex)ASTIndex.indexOf(cut);
                    List<String> names = ai.formals.get(className).get(methodName);
                    int i = 0;
                    for (String name : names) {
                        if (varName.equals(name)) {
                            return i;
                        }
                        ++i;
                    }
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : this.entrySet()) {
            sb.append(((Tree)entry.getKey()).toString().replaceAll("\\s+", " ")).append(" # ").append(entry.getValue()).append("\n");
        }
        return sb.toString();
    }
}

