/*
 * Decompiled with CFR 0.152.
 */
package scenelib.annotations.el;

import java.util.Map;
import scenelib.annotations.el.ABlock;
import scenelib.annotations.el.ADeclaration;
import scenelib.annotations.el.AElement;
import scenelib.annotations.el.AField;
import scenelib.annotations.el.ATypeElement;
import scenelib.annotations.el.BoundLocation;
import scenelib.annotations.el.ElementVisitor;
import scenelib.annotations.el.TypeIndexLocation;
import scenelib.annotations.util.coll.VivifyingMap;

public final class AMethod
extends ADeclaration {
    public final VivifyingMap<BoundLocation, ATypeElement> bounds = ATypeElement.newVivifyingLHMap_ATE();
    public final ATypeElement returnType;
    public final AField receiver;
    public final VivifyingMap<Integer, AField> parameters = AField.newVivifyingLHMap_AF();
    public final VivifyingMap<TypeIndexLocation, ATypeElement> throwsException = ATypeElement.newVivifyingLHMap_ATE();
    public ABlock body;
    public final String methodName;

    AMethod(String methodName) {
        super("method: " + methodName);
        this.methodName = methodName;
        this.body = new ABlock(methodName);
        this.returnType = new ATypeElement("return type of " + methodName);
        this.receiver = new AField("receiver parameter type of " + methodName);
    }

    AMethod(AMethod method) {
        super((Object)("method: " + method.methodName), method);
        this.methodName = method.methodName;
        this.body = method.body.clone();
        this.returnType = method.returnType.clone();
        this.receiver = method.receiver.clone();
        AMethod.copyMapContents(method.bounds, this.bounds);
        AMethod.copyMapContents(method.parameters, this.parameters);
        AMethod.copyMapContents(method.throwsException, this.throwsException);
        AMethod.copyMapContents(method.bounds, this.bounds);
    }

    @Override
    public AMethod clone() {
        return new AMethod(this);
    }

    @Override
    public boolean equals(AElement o) {
        return o instanceof AMethod && ((AMethod)o).equalsMethod(this);
    }

    boolean equalsMethod(AMethod o) {
        this.parameters.prune();
        o.parameters.prune();
        return super.equals(o) && this.returnType.equalsTypeElement(o.returnType) && this.bounds.equals(o.bounds) && this.receiver.equals(o.receiver) && this.parameters.equals(o.parameters) && this.body.equals(o.body) && this.methodName.equals(o.methodName) && this.throwsException.equals(o.throwsException);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.bounds.hashCode() + this.receiver.hashCode() + this.parameters.hashCode() + this.throwsException.hashCode() + this.body.hashCode() + this.methodName.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && this.bounds.isEmpty() && this.returnType.isEmpty() && this.receiver.isEmpty() && this.parameters.isEmpty() && this.throwsException.isEmpty() && this.body.isEmpty();
    }

    @Override
    public void prune() {
        super.prune();
        this.bounds.prune();
        this.returnType.prune();
        this.receiver.prune();
        this.parameters.prune();
        this.throwsException.prune();
        this.body.prune();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AMethod ");
        sb.append(this.methodName);
        sb.append(": (");
        sb.append(" -1:");
        sb.append(this.receiver.toString());
        for (Map.Entry em : this.parameters.entrySet()) {
            Integer i = (Integer)em.getKey();
            sb.append(" ");
            sb.append(i);
            sb.append(":");
            AElement ae = (AElement)em.getValue();
            sb.append(ae.toString());
            sb.append(" ");
            ATypeElement ate = ae.type;
            sb.append(ate.toString());
        }
        sb.append(" ");
        sb.append("ret:");
        sb.append(this.returnType.toString());
        sb.append(") ");
        sb.append(this.body.toString());
        return sb.toString();
    }

    @Override
    public <R, T> R accept(ElementVisitor<R, T> v, T t) {
        return v.visitMethod(this, t);
    }
}

