/*
 * Decompiled with CFR 0.152.
 */
package scenelib.annotations.el;

import java.util.LinkedHashMap;
import org.checkerframework.org.plumelib.util.CollectionsPlume;
import scenelib.annotations.Annotation;
import scenelib.annotations.el.ABlock;
import scenelib.annotations.el.ADeclaration;
import scenelib.annotations.el.AExpression;
import scenelib.annotations.el.AField;
import scenelib.annotations.el.AMethod;
import scenelib.annotations.el.ATypeElement;
import scenelib.annotations.el.BoundLocation;
import scenelib.annotations.el.ElementVisitor;
import scenelib.annotations.el.TypeIndexLocation;
import scenelib.annotations.util.coll.VivifyingMap;

public final class AClass
extends ADeclaration {
    public final VivifyingMap<BoundLocation, ATypeElement> bounds = ATypeElement.newVivifyingLHMap_ATE();
    public final VivifyingMap<TypeIndexLocation, ATypeElement> extendsImplements = ATypeElement.newVivifyingLHMap_ATE();
    public final VivifyingMap<String, AMethod> methods = AClass.createMethodMap();
    public final VivifyingMap<Integer, ABlock> staticInits = AClass.createInitBlockMap();
    public final VivifyingMap<Integer, ABlock> instanceInits = AClass.createInitBlockMap();
    public final VivifyingMap<String, AField> fields = AField.newVivifyingLHMap_AF();
    public final VivifyingMap<String, AExpression> fieldInits = AClass.createFieldInitMap();
    private final String className;

    AClass(String className) {
        super("class: " + className);
        this.className = className;
    }

    AClass(AClass clazz) {
        super(clazz);
        this.className = clazz.className;
        AClass.copyMapContents(clazz.bounds, this.bounds);
        AClass.copyMapContents(clazz.extendsImplements, this.extendsImplements);
        AClass.copyMapContents(clazz.fieldInits, this.fieldInits);
        AClass.copyMapContents(clazz.fields, this.fields);
        AClass.copyMapContents(clazz.instanceInits, this.instanceInits);
        AClass.copyMapContents(clazz.methods, this.methods);
        AClass.copyMapContents(clazz.staticInits, this.staticInits);
    }

    @Override
    public AClass clone() {
        return new AClass(this);
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof AClass && ((AClass)o).equalsClass(this);
    }

    final boolean equalsClass(AClass o) {
        return super.equals(o) && this.className.equals(o.className) && this.bounds.equals(o.bounds) && this.methods.equals(o.methods) && this.fields.equals(o.fields) && this.extendsImplements.equals(o.extendsImplements);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.bounds.hashCode() + this.methods.hashCode() + this.fields.hashCode() + this.staticInits.hashCode() + this.instanceInits.hashCode() + this.extendsImplements.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && this.bounds.isEmpty() && this.methods.isEmpty() && this.fields.isEmpty() && this.staticInits.isEmpty() && this.instanceInits.isEmpty() && this.extendsImplements.isEmpty();
    }

    @Override
    public void prune() {
        super.prune();
        this.bounds.prune();
        this.methods.prune();
        this.fields.prune();
        this.staticInits.prune();
        this.instanceInits.prune();
        this.extendsImplements.prune();
    }

    @Override
    public String toString() {
        return "AClass: " + this.className;
    }

    public String unparse() {
        return this.unparse("");
    }

    public String unparse(String linePrefix) {
        StringBuilder sb = new StringBuilder();
        sb.append(linePrefix);
        sb.append(this.toString());
        sb.append("\n");
        sb.append(linePrefix);
        sb.append("Annotations:\n");
        for (Annotation a : this.tlAnnotationsHere) {
            sb.append(linePrefix);
            sb.append("  " + a + "\n");
        }
        sb.append(linePrefix);
        sb.append("Bounds:\n");
        CollectionsPlume.mapToString(sb, this.bounds, linePrefix + "  ");
        sb.append(linePrefix);
        sb.append("Extends/implements:\n");
        CollectionsPlume.mapToString(sb, this.extendsImplements, linePrefix + "  ");
        sb.append(linePrefix);
        sb.append("Fields:\n");
        CollectionsPlume.mapToString(sb, this.fields, linePrefix + "  ");
        sb.append(linePrefix);
        sb.append("Field Initializers:\n");
        CollectionsPlume.mapToString(sb, this.fieldInits, linePrefix + "  ");
        sb.append(linePrefix);
        sb.append("Static Initializers:\n");
        CollectionsPlume.mapToString(sb, this.staticInits, linePrefix + "  ");
        sb.append(linePrefix);
        sb.append("Instance Initializers:\n");
        CollectionsPlume.mapToString(sb, this.instanceInits, linePrefix + "  ");
        sb.append(linePrefix);
        sb.append("AST Typecasts:\n");
        CollectionsPlume.mapToString(sb, this.insertTypecasts, linePrefix + "  ");
        sb.append(linePrefix);
        sb.append("AST Annotations:\n");
        CollectionsPlume.mapToString(sb, this.insertAnnotations, linePrefix + "  ");
        sb.append(linePrefix);
        sb.append("Methods:\n");
        CollectionsPlume.mapToString(sb, this.methods, linePrefix + "  ");
        return sb.toString();
    }

    @Override
    public <R, T> R accept(ElementVisitor<R, T> v, T t) {
        return v.visitClass(this, t);
    }

    private static VivifyingMap<String, AMethod> createMethodMap() {
        return new VivifyingMap<String, AMethod>(new LinkedHashMap()){

            @Override
            public AMethod createValueFor(String k) {
                return new AMethod(k);
            }

            @Override
            public boolean isEmptyValue(AMethod v) {
                return v.isEmpty();
            }
        };
    }

    private static VivifyingMap<Integer, ABlock> createInitBlockMap() {
        return new VivifyingMap<Integer, ABlock>(new LinkedHashMap()){

            @Override
            public ABlock createValueFor(Integer k) {
                return new ABlock(k);
            }

            @Override
            public boolean isEmptyValue(ABlock v) {
                return v.isEmpty();
            }
        };
    }

    private static VivifyingMap<String, AExpression> createFieldInitMap() {
        return new VivifyingMap<String, AExpression>(new LinkedHashMap()){

            @Override
            public AExpression createValueFor(String k) {
                return new AExpression(k);
            }

            @Override
            public boolean isEmptyValue(AExpression v) {
                return v.isEmpty();
            }
        };
    }
}

