/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.org.plumelib.options;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.SeeTag;
import com.sun.javadoc.Tag;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.StringJoiner;
import org.checkerframework.checker.formatter.qual.Format;
import org.checkerframework.checker.formatter.qual.FormatBottom;
import org.checkerframework.checker.formatter.qual.UnknownFormat;
import org.checkerframework.checker.index.qual.LessThanBottom;
import org.checkerframework.checker.index.qual.LessThanUnknown;
import org.checkerframework.checker.index.qual.LowerBoundBottom;
import org.checkerframework.checker.index.qual.LowerBoundUnknown;
import org.checkerframework.checker.index.qual.SameLenBottom;
import org.checkerframework.checker.index.qual.SameLenUnknown;
import org.checkerframework.checker.index.qual.SearchIndexBottom;
import org.checkerframework.checker.index.qual.SearchIndexUnknown;
import org.checkerframework.checker.index.qual.SubstringIndexBottom;
import org.checkerframework.checker.index.qual.SubstringIndexUnknown;
import org.checkerframework.checker.index.qual.UpperBoundBottom;
import org.checkerframework.checker.index.qual.UpperBoundUnknown;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.interning.qual.Interned;
import org.checkerframework.checker.interning.qual.InternedDistinct;
import org.checkerframework.checker.interning.qual.UnknownInterned;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.checkerframework.checker.lock.qual.GuardedByBottom;
import org.checkerframework.checker.lock.qual.LockPossiblyHeld;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.NonRaw;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.regex.qual.RegexBottom;
import org.checkerframework.checker.regex.qual.UnknownRegex;
import org.checkerframework.checker.signature.qual.BinaryName;
import org.checkerframework.checker.signature.qual.SignatureBottom;
import org.checkerframework.checker.signature.qual.SignatureUnknown;
import org.checkerframework.common.value.qual.ArrayLenRange;
import org.checkerframework.common.value.qual.BottomVal;
import org.checkerframework.common.value.qual.MinLen;
import org.checkerframework.common.value.qual.UnknownVal;
import org.checkerframework.org.apache.commons.lang3.StringUtils;
import org.checkerframework.org.apache.commons.text.StringEscapeUtils;
import org.checkerframework.org.plumelib.options.Option;
import org.checkerframework.org.plumelib.options.Options;

public class OptionsDoclet {
    private static @UnknownVal @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown String eol = System.getProperty("line.separator");
    private static final @Format(value={}) @Format(value={}) @UnknownVal @LessThanUnknown @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown String USAGE = "Provided by Options doclet:%n-docfile <file>        Specify file into which options documentation is inserted%n-outfile <file>        Specify destination for resulting output%n-d <directory>         Destination directory for -outfile%n-i                     Edit the docfile in-place%n-format javadoc        Format output as a Javadoc comment%n-classdoc              Include 'main' class documentation in output%n-singledash            Use single dashes for long options (see org.plumelib.options.Options)%nSee the OptionsDoclet documentation for more details.%n";
    private static final @UnknownVal @LessThanUnknown @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown String LIST_HELP = "<code>[+]</code> marked option can be specified multiple times";
    private @UnknownVal @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown String startDelim = "<!-- start options doc (DO NOT EDIT BY HAND) -->";
    private @UnknownVal @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown String endDelim = "<!-- end options doc -->";
    private @Nullable @UnknownVal @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown File docFile = null;
    private @Nullable @UnknownVal @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown File outFile = null;
    private @UnknownVal @LessThanUnknown @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown boolean inPlace = false;
    private @UnknownVal @LessThanUnknown @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown boolean formatJavadoc = false;
    private @UnknownVal @LessThanUnknown @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown boolean includeClassDoc = false;
    private @UnknownVal @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown RootDoc root;
    private @UnknownVal @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown Options options;

    public OptionsDoclet(@UnknownVal @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown RootDoc root, @UnknownVal @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown Options options) {
        this.root = root;
        this.options = options;
    }

    public static @UnknownVal @LessThanUnknown @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown boolean start(@UnknownVal @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown RootDoc root) {
        ArrayList<Object> objs = new ArrayList<Object>();
        for (ClassDoc doc : root.specifiedClasses()) {
            Class<?> clazz;
            if (doc.containingClass() != null) continue;
            try {
                @BinaryName String className = doc.qualifiedName();
                clazz = Class.forName(className, true, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                Options.printClassPath();
                return false;
            }
            if (OptionsDoclet.needsInstantiation(clazz)) {
                try {
                    Constructor<?> c = clazz.getDeclaredConstructor(new Class[0]);
                    c.setAccessible(true);
                    objs.add(c.newInstance(new Object[0]));
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
            }
            objs.add(clazz);
        }
        if (objs.isEmpty()) {
            System.out.println("Error: no classes found");
            return false;
        }
        Object[] objarray = objs.toArray();
        Options options = new Options(objarray);
        if (options.getOptions().size() < 1) {
            System.out.println("Error: no @Option-annotated fields found");
            return false;
        }
        OptionsDoclet o = new OptionsDoclet(root, options);
        o.setOptions(root.options());
        o.processJavadoc();
        try {
            o.write();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static @UnknownVal @LessThanUnknown @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown int optionLength(@UnknownVal @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown String option) {
        if (option.equals("-help")) {
            System.out.printf(USAGE, new Object[0]);
            return 1;
        }
        if (option.equals("-i") || option.equals("-classdoc") || option.equals("-singledash")) {
            return 1;
        }
        if (option.equals("-docfile") || option.equals("-outfile") || option.equals("-format") || option.equals("-d")) {
            return 2;
        }
        return 0;
    }

    public static @UnknownVal @LessThanUnknown @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown boolean validOptions(@UnknownVal @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown String @UnknownVal @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown [] @ArrayLenRange(from=1, to=0x7FFFFFFF) @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @MinLen(value=1) @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown [] options, @UnknownVal @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown DocErrorReporter reporter) {
        boolean hasDocFile = false;
        boolean hasOutFile = false;
        boolean hasDestDir = false;
        boolean hasFormat = false;
        boolean inPlace = false;
        String docFile = null;
        String outFile = null;
        for (int oi = 0; oi < options.length; ++oi) {
            String[] os = options[oi];
            String opt = os[0].toLowerCase();
            if (opt.equals("-docfile")) {
                if (hasDocFile) {
                    reporter.printError("-docfile option specified twice");
                    return false;
                }
                docFile = os[1];
                File f = new File(docFile);
                if (!f.exists()) {
                    reporter.printError("-docfile file not found: " + docFile);
                    return false;
                }
                hasDocFile = true;
            }
            if (opt.equals("-outfile")) {
                if (hasOutFile) {
                    reporter.printError("-outfile option specified twice");
                    return false;
                }
                if (inPlace) {
                    reporter.printError("-i and -outfile can not be used at the same time");
                    return false;
                }
                outFile = os[1];
                hasOutFile = true;
            }
            if (opt.equals("-i")) {
                if (hasOutFile) {
                    reporter.printError("-i and -outfile can not be used at the same time");
                    return false;
                }
                inPlace = true;
            }
            if (opt.equals("-format")) {
                if (hasFormat) {
                    reporter.printError("-format option specified twice");
                    return false;
                }
                String format = os[1];
                if (!format.equals("javadoc") && !format.equals("html")) {
                    reporter.printError("unrecognized output format: " + format);
                    return false;
                }
                hasFormat = true;
            }
            if (!opt.equals("-d")) continue;
            if (hasDestDir) {
                reporter.printError("-d specified twice");
                return false;
            }
            hasDestDir = true;
        }
        if (docFile != null && outFile != null && outFile.equals(docFile)) {
            reporter.printError("docfile must be different from outfile");
            return false;
        }
        if (inPlace && docFile == null) {
            reporter.printError("-i supplied but -docfile was not");
            return false;
        }
        return true;
    }

    public void setOptions(@UnknownVal @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown String @UnknownVal @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown [] @ArrayLenRange(from=1, to=0x7FFFFFFF) @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @MinLen(value=1) @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown [] options) {
        String outFilename = null;
        File destDir = null;
        for (int oi = 0; oi < options.length; ++oi) {
            String[] os = options[oi];
            String opt = os[0].toLowerCase();
            if (opt.equals("-docfile")) {
                this.docFile = new File(os[1]);
                continue;
            }
            if (opt.equals("-d")) {
                destDir = new File(os[1]);
                continue;
            }
            if (opt.equals("-outfile")) {
                outFilename = os[1];
                continue;
            }
            if (opt.equals("-i")) {
                this.inPlace = true;
                continue;
            }
            if (opt.equals("-format")) {
                if (!os[1].equals("javadoc")) continue;
                this.setFormatJavadoc(true);
                continue;
            }
            if (opt.equals("-classdoc")) {
                this.includeClassDoc = true;
                continue;
            }
            if (!opt.equals("-singledash")) continue;
            this.setUseSingleDash(true);
        }
        if (outFilename != null) {
            this.outFile = destDir != null ? new File(destDir, outFilename) : new File(outFilename);
        }
    }

    private static @UnknownVal @LessThanUnknown @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown boolean needsInstantiation(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownVal @LessThanUnknown @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown Class<@SubstringIndexBottom @UnknownVal @SearchIndexBottom @SameLenBottom @LessThanUnknown @LessThanBottom @LowerBoundBottom @UpperBoundBottom @UnknownInterned @InternedDistinct @LockPossiblyHeld @GuardedBy @LockPossiblyHeld @GuardedByBottom @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @NonRaw @NonRaw @UnknownFormat @FormatBottom @SubstringIndexUnknown @BottomVal @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @RegexBottom @SignatureUnknown @SignatureBottom ?> clazz) {
        for (Field f : clazz.getDeclaredFields()) {
            if (!f.isAnnotationPresent(Option.class) || Modifier.isStatic(f.getModifiers())) continue;
            return true;
        }
        return false;
    }

    public void write() throws @UnknownVal @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown Exception {
        PrintWriter out;
        String output = this.output();
        if (this.outFile != null) {
            out = new PrintWriter(Files.newBufferedWriter(this.outFile.toPath(), StandardCharsets.UTF_8, new OpenOption[0]));
        } else if (this.inPlace) {
            assert (this.docFile != null) : "@AssumeAssertion(nullness): dependent: docFile is non-null if inPlace is true";
            out = new PrintWriter(Files.newBufferedWriter(this.docFile.toPath(), StandardCharsets.UTF_8, new OpenOption[0]));
        } else {
            out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)System.out, StandardCharsets.UTF_8)));
        }
        out.println(output);
        out.flush();
        out.close();
    }

    public @UnknownVal @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown String output() throws @UnknownVal @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown Exception {
        if (this.docFile == null) {
            if (this.formatJavadoc) {
                return this.optionsToJavadoc(0, 99);
            }
            return this.optionsToHtml(0);
        }
        return this.newDocFileText();
    }

    @RequiresNonNull(value={"docFile"})
    private @UnknownVal @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown String newDocFileText() throws @UnknownVal @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown Exception {
        String docline;
        StringJoiner b = new StringJoiner(eol);
        BufferedReader doc = Files.newBufferedReader(this.docFile.toPath(), StandardCharsets.UTF_8);
        boolean replacing = false;
        boolean replacedOnce = false;
        Object prefix = null;
        while ((docline = doc.readLine()) != null) {
            if (replacing) {
                if (!docline.trim().equals(this.endDelim)) continue;
                replacing = false;
            }
            b.add(docline);
            if (replacedOnce || !docline.trim().equals(this.startDelim)) continue;
            if (this.formatJavadoc) {
                int starIndex = docline.indexOf(42);
                b.add(docline.substring(0, starIndex + 1));
                String jdoc = this.optionsToJavadoc(starIndex, 100);
                b.add(jdoc);
                if (jdoc.endsWith("</ul>")) {
                    b.add(docline.substring(0, starIndex + 1));
                }
            } else {
                b.add(this.optionsToHtml(0));
            }
            replacedOnce = true;
            replacing = true;
        }
        doc.close();
        return b.toString();
    }

    public void processJavadoc() {
        for (Options.OptionInfo oi : this.options.getOptions()) {
            ClassDoc optDoc = this.root.classNamed(oi.getDeclaringClass().getName());
            if (optDoc != null) {
                String nameWithUnderscores = oi.longName.replace('-', '_');
                for (FieldDoc fd : optDoc.fields()) {
                    if (!fd.name().equals(nameWithUnderscores)) continue;
                    if (fd.getRawCommentText().length() == 0) {
                        oi.jdoc = StringEscapeUtils.escapeHtml4((String)oi.description);
                        break;
                    }
                    if (this.formatJavadoc) {
                        oi.jdoc = fd.commentText();
                        break;
                    }
                    oi.jdoc = OptionsDoclet.javadocToHtml((Doc)fd);
                    break;
                }
            }
            if (!oi.baseType.isEnum()) continue;
            this.processEnumJavadoc(oi);
        }
    }

    private void processEnumJavadoc(@UnknownVal @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown Options. @UnknownVal @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown OptionInfo oi) {
        Enum[] constants = (Enum[])oi.baseType.getEnumConstants();
        if (constants == null) {
            return;
        }
        oi.enumJdoc = new LinkedHashMap<String, String>();
        for (Enum constant : constants) {
            assert (oi.enumJdoc != null) : "@AssumeAssertion(nullness): bug in flow?";
            oi.enumJdoc.put(constant.name(), "");
        }
        ClassDoc enumDoc = this.root.classNamed(oi.baseType.getName());
        if (enumDoc == null) {
            return;
        }
        assert (oi.enumJdoc != null) : "@AssumeAssertion(nullness): bug in flow?";
        block1: for (String name : oi.enumJdoc.keySet()) {
            for (FieldDoc fd : enumDoc.fields()) {
                if (!fd.name().equals(name)) continue;
                if (this.formatJavadoc) {
                    oi.enumJdoc.put(name, fd.commentText());
                    continue block1;
                }
                oi.enumJdoc.put(name, OptionsDoclet.javadocToHtml((Doc)fd));
                continue block1;
            }
        }
    }

    public @UnknownVal @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown String optionsToHtml(@UnknownVal @LessThanUnknown @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown int refillWidth) {
        StringJoiner b = new StringJoiner(eol);
        if (this.includeClassDoc && this.root.classes().length > 0) {
            b.add(OptionsDoclet.javadocToHtml((Doc)this.root.classes()[0]));
            b.add("<p>Command line options:</p>");
        }
        b.add("<ul>");
        if (!this.options.hasGroups()) {
            b.add(this.optionListToHtml(this.options.getOptions(), 6, 2, refillWidth));
        } else {
            for (Options.OptionGroupInfo gi : this.options.getOptionGroups()) {
                if (!gi.anyPublicized()) continue;
                String ogroupHeader = "  <li id=\"optiongroup:" + gi.name.replace(" ", "-").replace("/", "-") + "\">" + gi.name;
                b.add(this.refill(ogroupHeader, 6, 2, refillWidth));
                b.add("      <ul>");
                b.add(this.optionListToHtml(gi.optionList, 12, 8, refillWidth));
                b.add("      </ul>");
            }
        }
        b.add("</ul>");
        for (Options.OptionInfo oi : this.options.getOptions()) {
            if (oi.list == null || oi.unpublicized) continue;
            b.add("");
            b.add(LIST_HELP);
            break;
        }
        return b.toString();
    }

    public @UnknownVal @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown String optionsToJavadoc(@UnknownVal @LessThanUnknown @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown int padding, @UnknownVal @LessThanUnknown @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown int refillWidth) {
        StringJoiner b = new StringJoiner(eol);
        Scanner s2 = new Scanner(this.optionsToHtml(refillWidth - padding - 2));
        while (s2.hasNextLine()) {
            String line = s2.nextLine();
            StringBuilder bb = new StringBuilder();
            bb.append(StringUtils.repeat((String)" ", (int)padding));
            if (line.trim().equals("")) {
                bb.append("*");
            } else {
                bb.append("* ").append(line);
            }
            b.add(bb);
        }
        return b.toString();
    }

    private @UnknownVal @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown String optionListToHtml(@UnknownVal @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown List<@UnknownVal @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown Options. @UnknownVal @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown OptionInfo> optList, @UnknownVal @LessThanUnknown @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown int padding, @UnknownVal @LessThanUnknown @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown int firstLinePadding, @UnknownVal @LessThanUnknown @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown int refillWidth) {
        StringJoiner b = new StringJoiner(eol);
        for (Options.OptionInfo oi : optList) {
            if (oi.unpublicized) continue;
            StringBuilder bb = new StringBuilder();
            String optHtml = this.optionToHtml(oi, padding);
            bb.append(StringUtils.repeat((String)" ", (int)padding));
            bb.append("<li id=\"option:" + oi.longName + "\">").append(optHtml);
            if (refillWidth <= 0) {
                b.add(bb);
                continue;
            }
            b.add(this.refill(bb.toString(), padding, firstLinePadding, refillWidth));
        }
        return b.toString();
    }

    private @UnknownVal @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown String refill(@UnknownVal @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown String in, @UnknownVal @LessThanUnknown @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown int padding, @UnknownVal @LessThanUnknown @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown int firstLinePadding, @UnknownVal @LessThanUnknown @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown int refillWidth) {
        String firstPart;
        int breakLoc;
        if (refillWidth <= 0) {
            return in;
        }
        String suffix = null;
        int ulPos = in.indexOf(eol + "<ul>" + eol);
        if (ulPos != -1) {
            String suffixTemp;
            suffix = suffixTemp = in.substring(ulPos + eol.length());
            in = in.substring(0, ulPos);
        }
        String compressedSpaces = in.replaceAll("[ \n\r]+", " ");
        if ((compressedSpaces = compressedSpaces.replaceAll("<code> ", "<code>")).startsWith(" ")) {
            compressedSpaces = compressedSpaces.substring(1);
        }
        String oneLine = StringUtils.repeat((String)" ", (int)firstLinePadding) + compressedSpaces;
        StringJoiner multiLine = new StringJoiner(eol);
        while (oneLine.length() > refillWidth && (breakLoc = oneLine.lastIndexOf(32, refillWidth)) != -1 && !(firstPart = oneLine.substring(0, breakLoc)).trim().isEmpty()) {
            multiLine.add(firstPart);
            oneLine = StringUtils.repeat((String)" ", (int)padding) + oneLine.substring(breakLoc + 1);
        }
        multiLine.add(oneLine);
        if (suffix != null) {
            Scanner s2 = new Scanner(suffix);
            while (s2.hasNextLine()) {
                multiLine.add(StringUtils.repeat((String)" ", (int)padding) + s2.nextLine());
            }
        }
        return multiLine.toString();
    }

    public @UnknownVal @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown String optionToHtml(@UnknownVal @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown Options. @UnknownVal @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown OptionInfo oi, @UnknownVal @LessThanUnknown @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown int padding) {
        String jdoc;
        StringBuilder b = new StringBuilder();
        Formatter f = new Formatter(b);
        if (oi.shortName != null) {
            f.format("<b>-%s</b> ", oi.shortName);
        }
        for (String a : oi.aliases) {
            f.format("<b>%s</b> ", a);
        }
        String prefix = this.getUseSingleDash() ? "-" : "--";
        f.format("<b>%s%s=</b><i>%s</i>", prefix, oi.longName, oi.typeName);
        if (oi.list != null) {
            b.append(" <code>[+]</code>");
        }
        f.format(".%n ", new Object[0]);
        f.format("%s", StringUtils.repeat((String)" ", (int)padding));
        String string = jdoc = oi.jdoc == null ? "" : oi.jdoc;
        if (oi.noDocDefault || oi.defaultStr == null) {
            f.format("%s", jdoc);
        } else {
            String defaultStr = "default " + oi.defaultStr;
            String suffix = "";
            if (jdoc.endsWith("</p>")) {
                suffix = "</p>";
                jdoc = jdoc.substring(0, jdoc.length() - suffix.length());
            }
            f.format("%s [%s]%s", jdoc, StringEscapeUtils.escapeHtml4((String)defaultStr), suffix);
        }
        if (oi.baseType.isEnum()) {
            b.append(eol).append("<ul>").append(eol);
            assert (oi.enumJdoc != null) : "@AssumeAssertion(nullness): dependent: non-null if oi.baseType is an enum";
            for (Map.Entry<String, String> entry : oi.enumJdoc.entrySet()) {
                b.append("  <li><b>").append(entry.getKey()).append("</b>");
                if (entry.getValue().length() != 0) {
                    b.append(" ").append(entry.getValue());
                }
                b.append(eol);
            }
            b.append("</ul>").append(eol);
        }
        return b.toString();
    }

    public static @UnknownVal @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown String javadocToHtml(@UnknownVal @LessThanUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown Doc doc) {
        Tag[] tags;
        StringBuilder b = new StringBuilder();
        for (Tag tag : tags = doc.inlineTags()) {
            String kind = tag.kind();
            String text = tag.text();
            if (tag instanceof SeeTag) {
                b.append("<code>" + text.replace('#', '.') + "</code>");
                continue;
            }
            if (kind.equals("@code")) {
                b.append("<code>" + StringEscapeUtils.escapeHtml4((String)text) + "</code>");
                continue;
            }
            b.append(text);
        }
        SeeTag[] seetags = doc.seeTags();
        if (seetags.length > 0) {
            b.append(" See: ");
            StringJoiner bb = new StringJoiner(", ");
            for (SeeTag tag : seetags) {
                bb.add("<code>" + tag.text() + "</code>");
            }
            b.append(bb);
            b.append(".");
        }
        return b.toString();
    }

    public @UnknownVal @LessThanUnknown @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown boolean getFormatJavadoc() {
        return this.formatJavadoc;
    }

    public void setFormatJavadoc(@UnknownVal @LessThanUnknown @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown boolean val) {
        if (val && !this.formatJavadoc) {
            this.startDelim = "* " + this.startDelim;
            this.endDelim = "* " + this.endDelim;
        } else if (!val && this.formatJavadoc) {
            this.startDelim = StringUtils.removeStart((String)"* ", (String)this.startDelim);
            this.endDelim = StringUtils.removeStart((String)"* ", (String)this.endDelim);
        }
        this.formatJavadoc = val;
    }

    public @UnknownVal @LessThanUnknown @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown boolean getUseSingleDash() {
        return this.options.getUseSingleDash();
    }

    public void setUseSingleDash(@UnknownVal @LessThanUnknown @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownRegex @SignatureUnknown boolean val) {
        this.options.setUseSingleDash(true);
    }
}

