/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.org.objectweb.asmx.tree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.checkerframework.org.objectweb.asmx.AnnotationVisitor;
import org.checkerframework.org.objectweb.asmx.Attribute;
import org.checkerframework.org.objectweb.asmx.ClassVisitor;
import org.checkerframework.org.objectweb.asmx.Handle;
import org.checkerframework.org.objectweb.asmx.Label;
import org.checkerframework.org.objectweb.asmx.MethodVisitor;
import org.checkerframework.org.objectweb.asmx.Type;
import org.checkerframework.org.objectweb.asmx.TypeAnnotationVisitor;
import org.checkerframework.org.objectweb.asmx.TypePath;
import org.checkerframework.org.objectweb.asmx.tree.AbstractInsnNode;
import org.checkerframework.org.objectweb.asmx.tree.AnnotationNode;
import org.checkerframework.org.objectweb.asmx.tree.FieldInsnNode;
import org.checkerframework.org.objectweb.asmx.tree.IincInsnNode;
import org.checkerframework.org.objectweb.asmx.tree.InsnNode;
import org.checkerframework.org.objectweb.asmx.tree.IntInsnNode;
import org.checkerframework.org.objectweb.asmx.tree.InvokeDynamicInsnNode;
import org.checkerframework.org.objectweb.asmx.tree.JumpInsnNode;
import org.checkerframework.org.objectweb.asmx.tree.LabelNode;
import org.checkerframework.org.objectweb.asmx.tree.LdcInsnNode;
import org.checkerframework.org.objectweb.asmx.tree.LineNumberNode;
import org.checkerframework.org.objectweb.asmx.tree.LocalVariableNode;
import org.checkerframework.org.objectweb.asmx.tree.LookupSwitchInsnNode;
import org.checkerframework.org.objectweb.asmx.tree.MemberNode;
import org.checkerframework.org.objectweb.asmx.tree.MethodInsnNode;
import org.checkerframework.org.objectweb.asmx.tree.MultiANewArrayInsnNode;
import org.checkerframework.org.objectweb.asmx.tree.TableSwitchInsnNode;
import org.checkerframework.org.objectweb.asmx.tree.TryCatchBlockNode;
import org.checkerframework.org.objectweb.asmx.tree.TypeInsnNode;
import org.checkerframework.org.objectweb.asmx.tree.VarInsnNode;

public class MethodNode
extends MemberNode
implements MethodVisitor {
    public int access;
    public String name;
    public String desc;
    public String signature;
    public List exceptions;
    public Object annotationDefault;
    public List[] visibleParameterAnnotations;
    public List[] invisibleParameterAnnotations;
    public List instructions;
    public List tryCatchBlocks;
    public int maxStack;
    public int maxLocals;
    public List localVariables;
    public List lineNumbers;

    @Override
    public TypeAnnotationVisitor visitTypeAnnotation(String desc, boolean visible, boolean inCode) {
        return null;
    }

    public MethodNode(int access, String name, String desc, String signature, String[] exceptions) {
        this.access = access;
        this.name = name;
        this.desc = desc;
        this.signature = signature;
        this.exceptions = new ArrayList(exceptions == null ? 0 : exceptions.length);
        boolean isAbstract = (access & 0x400) != 0;
        this.instructions = new ArrayList(isAbstract ? 0 : 24);
        if (!isAbstract) {
            this.localVariables = new ArrayList(5);
            this.lineNumbers = new ArrayList(5);
        }
        this.tryCatchBlocks = new ArrayList();
        if (exceptions != null) {
            this.exceptions.addAll(Arrays.asList(exceptions));
        }
    }

    @Override
    public AnnotationVisitor visitAnnotationDefault() {
        return new AnnotationNode(new ArrayList(0){

            @Override
            public boolean add(Object o) {
                MethodNode.this.annotationDefault = o;
                return super.add(o);
            }
        });
    }

    @Override
    public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
        AnnotationNode an = new AnnotationNode(desc);
        if (visible) {
            if (this.visibleParameterAnnotations == null) {
                int params = Type.getArgumentTypes(this.desc).length;
                this.visibleParameterAnnotations = new List[params];
            }
            if (this.visibleParameterAnnotations[parameter] == null) {
                this.visibleParameterAnnotations[parameter] = new ArrayList(1);
            }
            this.visibleParameterAnnotations[parameter].add(an);
        } else {
            if (this.invisibleParameterAnnotations == null) {
                int params = Type.getArgumentTypes(this.desc).length;
                this.invisibleParameterAnnotations = new List[params];
            }
            if (this.invisibleParameterAnnotations[parameter] == null) {
                this.invisibleParameterAnnotations[parameter] = new ArrayList(1);
            }
            this.invisibleParameterAnnotations[parameter].add(an);
        }
        return an;
    }

    @Override
    public void visitCode() {
    }

    @Override
    public void visitInsn(int opcode) {
        this.instructions.add(new InsnNode(opcode));
    }

    @Override
    public void visitIntInsn(int opcode, int operand) {
        this.instructions.add(new IntInsnNode(opcode, operand));
    }

    @Override
    public void visitVarInsn(int opcode, int var) {
        this.instructions.add(new VarInsnNode(opcode, var));
    }

    @Override
    public void visitTypeInsn(int opcode, String desc) {
        this.instructions.add(new TypeInsnNode(opcode, desc));
    }

    @Override
    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        this.instructions.add(new FieldInsnNode(opcode, owner, name, desc));
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        this.instructions.add(new MethodInsnNode(opcode, owner, name, desc));
    }

    @Override
    public void visitInvokeDynamicInsn(String name, String desc, Handle bsm, Object ... bsmArgs) {
        this.instructions.add(new InvokeDynamicInsnNode(name, desc, bsm, bsmArgs));
    }

    @Override
    public void visitJumpInsn(int opcode, Label label) {
        this.instructions.add(new JumpInsnNode(opcode, label));
    }

    @Override
    public void visitLabel(Label label) {
        this.instructions.add(new LabelNode(label));
    }

    @Override
    public void visitLdcInsn(Object cst) {
        this.instructions.add(new LdcInsnNode(cst));
    }

    @Override
    public void visitIincInsn(int var, int increment) {
        this.instructions.add(new IincInsnNode(var, increment));
    }

    @Override
    public void visitTableSwitchInsn(int min2, int max, Label dflt, Label[] labels) {
        this.instructions.add(new TableSwitchInsnNode(min2, max, dflt, labels));
    }

    @Override
    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        this.instructions.add(new LookupSwitchInsnNode(dflt, keys, labels));
    }

    @Override
    public void visitMultiANewArrayInsn(String desc, int dims) {
        this.instructions.add(new MultiANewArrayInsnNode(desc, dims));
    }

    @Override
    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        this.tryCatchBlocks.add(new TryCatchBlockNode(start, end, handler, type));
    }

    @Override
    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        this.localVariables.add(new LocalVariableNode(name, desc, signature, start, end, index));
    }

    @Override
    public void visitLineNumber(int line, Label start) {
        this.lineNumbers.add(new LineNumberNode(line, start));
    }

    @Override
    public void visitMaxs(int maxStack, int maxLocals) {
        this.maxStack = maxStack;
        this.maxLocals = maxLocals;
    }

    public void accept(ClassVisitor cv) {
        String[] exceptions = new String[this.exceptions.size()];
        this.exceptions.toArray(exceptions);
        MethodVisitor mv = cv.visitMethod(this.access, this.name, this.desc, this.signature, exceptions);
        if (mv != null) {
            this.accept(mv);
        }
    }

    public void accept(MethodVisitor mv) {
        AnnotationNode an;
        int j;
        List l;
        AnnotationNode an2;
        int i;
        if (this.annotationDefault != null) {
            AnnotationVisitor av = mv.visitAnnotationDefault();
            AnnotationNode.accept(av, null, this.annotationDefault);
            av.visitEnd();
        }
        int n = this.visibleAnnotations == null ? 0 : this.visibleAnnotations.size();
        for (i = 0; i < n; ++i) {
            an2 = (AnnotationNode)this.visibleAnnotations.get(i);
            an2.accept(mv.visitAnnotation(an2.desc, true));
        }
        n = this.invisibleAnnotations == null ? 0 : this.invisibleAnnotations.size();
        for (i = 0; i < n; ++i) {
            an2 = (AnnotationNode)this.invisibleAnnotations.get(i);
            an2.accept(mv.visitAnnotation(an2.desc, false));
        }
        n = this.visibleParameterAnnotations == null ? 0 : this.visibleParameterAnnotations.length;
        for (i = 0; i < n; ++i) {
            l = this.visibleParameterAnnotations[i];
            if (l == null) continue;
            for (j = 0; j < l.size(); ++j) {
                an = (AnnotationNode)l.get(j);
                an.accept(mv.visitParameterAnnotation(i, an.desc, true));
            }
        }
        n = this.invisibleParameterAnnotations == null ? 0 : this.invisibleParameterAnnotations.length;
        for (i = 0; i < n; ++i) {
            l = this.invisibleParameterAnnotations[i];
            if (l == null) continue;
            for (j = 0; j < l.size(); ++j) {
                an = (AnnotationNode)l.get(j);
                an.accept(mv.visitParameterAnnotation(i, an.desc, false));
            }
        }
        n = this.attrs == null ? 0 : this.attrs.size();
        for (i = 0; i < n; ++i) {
            mv.visitAttribute((Attribute)this.attrs.get(i));
        }
        if (this.instructions.size() > 0) {
            mv.visitCode();
            for (i = 0; i < this.tryCatchBlocks.size(); ++i) {
                ((TryCatchBlockNode)this.tryCatchBlocks.get(i)).accept(mv);
            }
            for (i = 0; i < this.instructions.size(); ++i) {
                ((AbstractInsnNode)this.instructions.get(i)).accept(mv);
            }
            n = this.localVariables == null ? 0 : this.localVariables.size();
            for (i = 0; i < n; ++i) {
                ((LocalVariableNode)this.localVariables.get(i)).accept(mv);
            }
            n = this.lineNumbers == null ? 0 : this.lineNumbers.size();
            for (i = 0; i < n; ++i) {
                ((LineNumberNode)this.lineNumbers.get(i)).accept(mv);
            }
            mv.visitMaxs(this.maxStack, this.maxLocals);
        }
        mv.visitEnd();
    }

    @Override
    public AnnotationVisitor visitInsnAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
        return null;
    }
}

