/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.util.typeinference.solver;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.Types;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.framework.util.AnnotatedTypes;
import org.checkerframework.framework.util.AnnotationMirrorMap;
import org.checkerframework.framework.util.AnnotationMirrorSet;
import org.checkerframework.framework.util.typeinference.TypeArgInferenceUtil;
import org.checkerframework.framework.util.typeinference.solver.ConstraintMap;
import org.checkerframework.framework.util.typeinference.solver.InferenceResult;
import org.checkerframework.framework.util.typeinference.solver.InferredValue;
import org.checkerframework.framework.util.typeinference.solver.TargetConstraints;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.BugInCF;

public class SupertypesSolver {
    public InferenceResult solveFromSupertypes(Set<TypeVariable> remainingTargets, ConstraintMap constraintMap, AnnotatedTypeFactory typeFactory) {
        Lubs lubs = this.targetToTypeLubs(remainingTargets, constraintMap, typeFactory);
        InferenceResult solution = new InferenceResult();
        for (TypeVariable target : remainingTargets) {
            AnnotatedTypeMirror lub = lubs.getType(target);
            AnnotationMirrorMap<AnnotationMirror> lubAnnos = lubs.getPrimaries(target);
            InferredValue.InferredType inferred = lub != null ? this.mergeLubTypeWithEqualities(target, lub, constraintMap, typeFactory) : (lubAnnos != null ? this.mergeLubAnnosWithEqualities(target, lubAnnos, constraintMap, typeFactory) : null);
            if (inferred == null) continue;
            solution.put(target, inferred);
        }
        return solution;
    }

    protected InferredValue.InferredType mergeLubTypeWithEqualities(TypeVariable target, AnnotatedTypeMirror lub, ConstraintMap constraintMap, AnnotatedTypeFactory typeFactory) {
        TargetConstraints.Equalities equalities = constraintMap.getConstraints((TypeVariable)target).equalities;
        AnnotationMirrorSet tops = new AnnotationMirrorSet(typeFactory.getQualifierHierarchy().getTopAnnotations());
        if (!equalities.types.isEmpty()) {
            Map.Entry<AnnotatedTypeMirror, AnnotationMirrorSet> eqEntry = equalities.types.entrySet().iterator().next();
            AnnotatedTypeMirror equalityType = eqEntry.getKey();
            AnnotationMirrorSet equalityAnnos = eqEntry.getValue();
            boolean failed = false;
            for (AnnotationMirror top : tops) {
                if (equalityAnnos.contains(top)) continue;
                AnnotationMirror lubAnno = lub.getAnnotationInHierarchy(top);
                if (lubAnno == null) {
                    if (lub.getKind() == TypeKind.TYPEVAR && typeFactory.types.isSameType(equalityType.getUnderlyingType(), lub.getUnderlyingType())) {
                        equalityAnnos.add(top);
                        continue;
                    }
                    failed = true;
                    continue;
                }
                equalityType.replaceAnnotation(lubAnno);
                equalityAnnos.add(top);
            }
            if (!failed) {
                return new InferredValue.InferredType(equalityType);
            }
        }
        return new InferredValue.InferredType(lub);
    }

    protected InferredValue.InferredType mergeLubAnnosWithEqualities(TypeVariable target, AnnotationMirrorMap<AnnotationMirror> lubAnnos, ConstraintMap constraintMap, AnnotatedTypeFactory typeFactory) {
        TargetConstraints.Equalities equalities = constraintMap.getConstraints((TypeVariable)target).equalities;
        AnnotationMirrorSet tops = new AnnotationMirrorSet(typeFactory.getQualifierHierarchy().getTopAnnotations());
        if (!equalities.types.isEmpty()) {
            Map.Entry<AnnotatedTypeMirror, AnnotationMirrorSet> eqEntry = equalities.types.entrySet().iterator().next();
            AnnotatedTypeMirror equalityType = eqEntry.getKey();
            AnnotationMirrorSet equalityAnnos = eqEntry.getValue();
            boolean failed = false;
            for (AnnotationMirror top : tops) {
                if (equalityAnnos.contains(top)) continue;
                AnnotationMirror lubAnno = lubAnnos.get(top);
                if (lubAnno == null) {
                    failed = true;
                    continue;
                }
                equalityType.replaceAnnotation(lubAnno);
                equalityAnnos.add(top);
            }
            if (!failed) {
                return new InferredValue.InferredType(equalityType);
            }
        }
        return null;
    }

    private Lubs targetToTypeLubs(Set<TypeVariable> remainingTargets, ConstraintMap constraintMap, AnnotatedTypeFactory typeFactory) {
        QualifierHierarchy qualifierHierarchy = typeFactory.getQualifierHierarchy();
        AnnotationMirrorSet tops = new AnnotationMirrorSet(qualifierHierarchy.getTopAnnotations());
        Lubs solution = new Lubs();
        AnnotationMirrorMap<AnnotationMirror> lubOfPrimaries = new AnnotationMirrorMap<AnnotationMirror>();
        ArrayList<TypeVariable> targetsSupertypesLast = new ArrayList<TypeVariable>(remainingTargets);
        final Types types = typeFactory.getProcessingEnv().getTypeUtils();
        Collections.sort(targetsSupertypesLast, new Comparator<TypeVariable>(){

            @Override
            public int compare(TypeVariable o1, TypeVariable o2) {
                if (types.isSubtype(o1, o2)) {
                    return -1;
                }
                if (types.isSubtype(o2, o1)) {
                    return 1;
                }
                return 0;
            }
        });
        for (TypeVariable target : targetsSupertypesLast) {
            TargetConstraints targetRecord = constraintMap.getConstraints(target);
            AnnotationMirrorMap<AnnotationMirrorSet> subtypeAnnos = targetRecord.supertypes.primaries;
            Map<AnnotatedTypeMirror, AnnotationMirrorSet> subtypesOfTarget = targetRecord.supertypes.types;
            SupertypesSolver.propagatePreviousLubs(targetRecord, solution, subtypesOfTarget);
            SupertypesSolver.lubPrimaries(lubOfPrimaries, subtypeAnnos, tops, qualifierHierarchy);
            solution.addPrimaries(target, lubOfPrimaries);
            if (subtypesOfTarget.isEmpty()) continue;
            AnnotatedTypeMirror lub = SupertypesSolver.leastUpperBound(target, typeFactory, subtypesOfTarget);
            AnnotationMirrorSet effectiveLubAnnos = new AnnotationMirrorSet(lub.getEffectiveAnnotations());
            for (AnnotationMirror lubAnno : effectiveLubAnnos) {
                AnnotationMirror hierarchy = qualifierHierarchy.getTopAnnotation(lubAnno);
                AnnotationMirror primaryLub = lubOfPrimaries.get(hierarchy);
                if (primaryLub == null || !qualifierHierarchy.isSubtype(lubAnno, primaryLub) || AnnotationUtils.areSame(lubAnno, primaryLub)) continue;
                lub.replaceAnnotation(primaryLub);
            }
            solution.addType(target, lub);
        }
        return solution;
    }

    protected static void propagatePreviousLubs(TargetConstraints targetRecord, Lubs solution, Map<AnnotatedTypeMirror, AnnotationMirrorSet> subtypesOfTarget) {
        for (Map.Entry<TypeVariable, AnnotationMirrorSet> supertypeTarget : targetRecord.supertypes.targets.entrySet()) {
            AnnotatedTypeMirror supertargetLub = solution.getType(supertypeTarget.getKey());
            if (supertargetLub == null) continue;
            AnnotationMirrorSet supertargetTypeAnnos = subtypesOfTarget.get(supertargetLub);
            if (supertargetTypeAnnos != null) {
                supertargetTypeAnnos.addAll(supertypeTarget.getValue());
                continue;
            }
            subtypesOfTarget.put(supertargetLub, supertypeTarget.getValue());
        }
    }

    protected static void lubPrimaries(AnnotationMirrorMap<AnnotationMirror> lubOfPrimaries, AnnotationMirrorMap<AnnotationMirrorSet> subtypeAnnos, AnnotationMirrorSet tops, QualifierHierarchy qualifierHierarchy) {
        lubOfPrimaries.clear();
        for (AnnotationMirror top : tops) {
            AnnotationMirrorSet annosInHierarchy = subtypeAnnos.get(top);
            if (annosInHierarchy != null && !annosInHierarchy.isEmpty()) {
                lubOfPrimaries.put(top, SupertypesSolver.leastUpperBound(annosInHierarchy, qualifierHierarchy));
                continue;
            }
            lubOfPrimaries.put(top, qualifierHierarchy.getBottomAnnotation(top));
        }
    }

    public static AnnotatedTypeMirror groundMissingHierarchies(Map.Entry<AnnotatedTypeMirror, AnnotationMirrorSet> typeToHierarchies, AnnotationMirrorMap<AnnotationMirror> lowerBoundAnnos) {
        AnnotationMirrorSet presentHierarchies = typeToHierarchies.getValue();
        AnnotationMirrorSet missingAnnos = new AnnotationMirrorSet();
        for (AnnotationMirror top : lowerBoundAnnos.keySet()) {
            if (presentHierarchies.contains(top)) continue;
            missingAnnos.add(lowerBoundAnnos.get(top));
        }
        if (!missingAnnos.isEmpty()) {
            AnnotatedTypeMirror copy = typeToHierarchies.getKey().deepCopy();
            copy.replaceAnnotations(missingAnnos);
            return copy;
        }
        return typeToHierarchies.getKey();
    }

    public static AnnotatedTypeMirror leastUpperBound(TypeVariable target, AnnotatedTypeFactory typeFactory, Map<AnnotatedTypeMirror, AnnotationMirrorSet> types) {
        QualifierHierarchy qualifierHierarchy = typeFactory.getQualifierHierarchy();
        AnnotatedTypeMirror.AnnotatedTypeVariable targetsDeclaredType = (AnnotatedTypeMirror.AnnotatedTypeVariable)typeFactory.getAnnotatedType(target.asElement());
        AnnotationMirrorMap<AnnotationMirror> lowerBoundAnnos = TypeArgInferenceUtil.createHierarchyMap(new AnnotationMirrorSet(targetsDeclaredType.getLowerBound().getEffectiveAnnotations()), qualifierHierarchy);
        Iterator<Map.Entry<AnnotatedTypeMirror, AnnotationMirrorSet>> typesIter = types.entrySet().iterator();
        if (!typesIter.hasNext()) {
            throw new BugInCF("Calling LUB on empty list.");
        }
        Map.Entry<AnnotatedTypeMirror, AnnotationMirrorSet> head = typesIter.next();
        AnnotatedTypeMirror lubType = SupertypesSolver.groundMissingHierarchies(head, lowerBoundAnnos);
        AnnotatedTypeMirror nextType = null;
        while (typesIter.hasNext()) {
            nextType = SupertypesSolver.groundMissingHierarchies(typesIter.next(), lowerBoundAnnos);
            if (lubType.getKind().isPrimitive()) {
                if (!nextType.getKind().isPrimitive()) {
                    lubType = typeFactory.getBoxedType((AnnotatedTypeMirror.AnnotatedPrimitiveType)lubType);
                }
            } else if (nextType.getKind().isPrimitive() && !lubType.getKind().isPrimitive()) {
                nextType = typeFactory.getBoxedType((AnnotatedTypeMirror.AnnotatedPrimitiveType)nextType);
            }
            lubType = AnnotatedTypes.leastUpperBound(typeFactory, lubType, nextType);
        }
        return lubType;
    }

    private static final AnnotationMirror leastUpperBound(Iterable<? extends AnnotationMirror> annos, QualifierHierarchy qualifierHierarchy) {
        Iterator<? extends AnnotationMirror> annoIter = annos.iterator();
        AnnotationMirror lub = annoIter.next();
        while (annoIter.hasNext()) {
            lub = qualifierHierarchy.leastUpperBound(lub, annoIter.next());
        }
        return lub;
    }

    static class Lubs {
        public final Map<TypeVariable, AnnotatedTypeMirror> types = new LinkedHashMap<TypeVariable, AnnotatedTypeMirror>();
        public final Map<TypeVariable, AnnotationMirrorMap<AnnotationMirror>> primaries = new LinkedHashMap<TypeVariable, AnnotationMirrorMap<AnnotationMirror>>();

        Lubs() {
        }

        public void addPrimaries(TypeVariable target, AnnotationMirrorMap<AnnotationMirror> primaries) {
            this.primaries.put(target, new AnnotationMirrorMap(primaries));
        }

        public void addType(TypeVariable target, AnnotatedTypeMirror type) {
            this.types.put(target, type);
        }

        public AnnotationMirrorMap<AnnotationMirror> getPrimaries(TypeVariable target) {
            return this.primaries.get(target);
        }

        public AnnotatedTypeMirror getType(TypeVariable target) {
            return this.types.get(target);
        }
    }
}

