/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.util.typeinference.constraint;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.lang.model.type.TypeVariable;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.util.typeinference.TypeArgInferenceUtil;
import org.checkerframework.framework.util.typeinference.constraint.TUConstraint;

public abstract class AFConstraint {
    public final AnnotatedTypeMirror argument;
    public final AnnotatedTypeMirror formalParameter;

    public AFConstraint(AnnotatedTypeMirror argument, AnnotatedTypeMirror formalParameter) {
        this.argument = argument;
        this.formalParameter = formalParameter;
        TypeArgInferenceUtil.checkForUninferredTypes(argument);
    }

    public boolean isIrreducible(Set<TypeVariable> targets) {
        return TypeArgInferenceUtil.isATarget(this.argument, targets) || TypeArgInferenceUtil.isATarget(this.formalParameter, targets);
    }

    public boolean equals(Object thatObject) {
        if (this == thatObject) {
            return true;
        }
        if (thatObject == null || this.getClass() != thatObject.getClass()) {
            return false;
        }
        AFConstraint that = (AFConstraint)thatObject;
        return this.argument.equals(that.argument) && this.formalParameter.equals(that.formalParameter);
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.formalParameter, this.argument);
    }

    public abstract TUConstraint toTUConstraint();

    public AFConstraint substitute(Map<TypeVariable, AnnotatedTypeMirror> substitutions) {
        AnnotatedTypeMirror newArgument = TypeArgInferenceUtil.substitute(substitutions, this.argument);
        AnnotatedTypeMirror newFormalParameter = TypeArgInferenceUtil.substitute(substitutions, this.formalParameter);
        return this.construct(newArgument, newFormalParameter);
    }

    protected abstract AFConstraint construct(AnnotatedTypeMirror var1, AnnotatedTypeMirror var2);
}

