/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;

public class ExecUtil {
    public static final int BLOCK_SIZE = 1024;

    public static int execute(String[] cmd, OutputStream std, OutputStream err) {
        Redirection outRedirect = new Redirection(std, 1024);
        Redirection errRedirect = new Redirection(err, 1024);
        try {
            Process proc = Runtime.getRuntime().exec(cmd);
            outRedirect.redirect(proc.getInputStream());
            errRedirect.redirect(proc.getErrorStream());
            IOException stdExc = outRedirect.join();
            IOException errExc = errRedirect.join();
            int exitStatus = proc.waitFor();
            if (stdExc != null) {
                throw stdExc;
            }
            if (errExc != null) {
                throw errExc;
            }
            return exitStatus;
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Exception executing command: " + String.join((CharSequence)" ", cmd), e);
        }
        catch (IOException e) {
            throw new RuntimeException("Exception executing command: " + String.join((CharSequence)" ", cmd), e);
        }
    }

    public static void quietlyClose(Writer writer) {
        try {
            writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void quietlyClose(Reader reader) {
        try {
            reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static class Redirection {
        private final char[] buffer;
        private final OutputStreamWriter out;
        private Thread thread;
        private IOException exception;

        public Redirection(OutputStream out, int bufferSize) {
            this.buffer = new char[bufferSize];
            this.out = new OutputStreamWriter(out);
        }

        public void redirect(InputStream inStream) {
            this.exception = null;
            this.thread = new Thread(() -> {
                InputStreamReader in = new InputStreamReader(inStream);
                try {
                    int read = 0;
                    while (read > -1) {
                        read = in.read(this.buffer);
                        if (read > 0) {
                            this.out.write(this.buffer, 0, read);
                        }
                        this.out.flush();
                    }
                }
                catch (IOException exc) {
                    this.exception = exc;
                }
                finally {
                    ExecUtil.quietlyClose(in);
                }
            });
            this.thread.start();
        }

        public IOException join() throws InterruptedException {
            this.thread.join();
            return this.exception;
        }
    }
}

