/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.type.typeannotator;

import java.lang.annotation.Annotation;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import org.checkerframework.framework.qual.DefaultFor;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.framework.type.typeannotator.TypeAnnotator;
import org.checkerframework.javacutil.AnnotationBuilder;
import org.checkerframework.javacutil.BugInCF;
import org.checkerframework.javacutil.TypesUtils;

public class DefaultForTypeAnnotator
extends TypeAnnotator {
    private final Map<TypeKind, Set<AnnotationMirror>> typeKinds = new EnumMap<TypeKind, Set<AnnotationMirror>>(TypeKind.class);
    private final Map<Class<? extends AnnotatedTypeMirror>, Set<AnnotationMirror>> atmClasses = new HashMap<Class<? extends AnnotatedTypeMirror>, Set<AnnotationMirror>>();
    private final Map<String, Set<AnnotationMirror>> types = new HashMap<String, Set<AnnotationMirror>>();
    private final QualifierHierarchy qualHierarchy;

    public DefaultForTypeAnnotator(AnnotatedTypeFactory typeFactory) {
        super(typeFactory);
        this.qualHierarchy = typeFactory.getQualifierHierarchy();
        Set<Class<? extends Annotation>> quals = typeFactory.getSupportedTypeQualifiers();
        for (Class<? extends Annotation> qual : quals) {
            DefaultFor defaultFor = qual.getAnnotation(DefaultFor.class);
            if (defaultFor == null) continue;
            AnnotationMirror theQual = AnnotationBuilder.fromClass(typeFactory.getElementUtils(), qual);
            for (org.checkerframework.framework.qual.TypeKind typeKind : defaultFor.typeKinds()) {
                TypeKind mappedTk = this.mapTypeKinds(typeKind);
                this.addTypeKind(mappedTk, theQual);
            }
            for (Class<?> clazz : defaultFor.types()) {
                this.addTypes(clazz, theQual);
            }
        }
    }

    private TypeKind mapTypeKinds(org.checkerframework.framework.qual.TypeKind typeKind) {
        return TypeKind.valueOf(typeKind.name());
    }

    public void addTypeKind(TypeKind typeKind, AnnotationMirror theQual) {
        boolean res = this.qualHierarchy.updateMappingToMutableSet(this.typeKinds, typeKind, theQual);
        if (!res) {
            throw new BugInCF("TypeAnnotator: invalid update of typeKinds " + this.typeKinds + " at " + (Object)((Object)typeKind) + " with " + theQual);
        }
    }

    public void addAtmClass(Class<? extends AnnotatedTypeMirror> typeClass, AnnotationMirror theQual) {
        boolean res = this.qualHierarchy.updateMappingToMutableSet(this.atmClasses, typeClass, theQual);
        if (!res) {
            throw new BugInCF("TypeAnnotator: invalid update of atmClasses " + this.atmClasses + " at " + typeClass + " with " + theQual);
        }
    }

    public void addTypes(Class<?> clazz, AnnotationMirror theQual) {
        String typeNameString = clazz.getCanonicalName();
        boolean res = this.qualHierarchy.updateMappingToMutableSet(this.types, typeNameString, theQual);
        if (!res) {
            throw new BugInCF("TypeAnnotator: invalid update of types " + this.types + " at " + clazz + " with " + theQual);
        }
    }

    @Override
    protected Void scan(AnnotatedTypeMirror type, Void p) {
        Class<?> t;
        Set<AnnotationMirror> fnd;
        String qname = null;
        if (type.getKind() == TypeKind.DECLARED) {
            qname = TypesUtils.getQualifiedName((DeclaredType)type.getUnderlyingType()).toString();
        } else if (type.getKind().isPrimitive()) {
            qname = type.getUnderlyingType().toString();
        }
        if (qname != null && this.types.containsKey(qname)) {
            fnd = this.types.get(qname);
            type.addMissingAnnotations(fnd);
        }
        if (this.typeKinds.containsKey((Object)type.getKind())) {
            fnd = this.typeKinds.get((Object)type.getKind());
            type.addMissingAnnotations(fnd);
        } else if (!this.atmClasses.isEmpty() && this.atmClasses.containsKey(t = type.getClass())) {
            Set<AnnotationMirror> fnd2 = this.atmClasses.get(t);
            type.addMissingAnnotations(fnd2);
        }
        return (Void)super.scan(type, p);
    }

    public DefaultForTypeAnnotator addStandardDefaults() {
        if (!this.types.containsKey(Void.class.getCanonicalName())) {
            for (AnnotationMirror annotationMirror : this.qualHierarchy.getBottomAnnotations()) {
                this.addTypes(Void.class, annotationMirror);
            }
        } else {
            Set<AnnotationMirror> annos = this.types.get(Void.class.getCanonicalName());
            for (AnnotationMirror annotationMirror : this.qualHierarchy.getTopAnnotations()) {
                if (this.qualHierarchy.findAnnotationInHierarchy(annos, annotationMirror) != null) continue;
                this.addTypes(Void.class, this.qualHierarchy.getBottomAnnotation(annotationMirror));
            }
        }
        return this;
    }
}

