/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.type;

import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.annotation.Target;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import javax.annotation.processing.ProcessingEnvironment;
import javax.tools.Diagnostic;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.framework.util.AnnotatedTypes;
import org.checkerframework.javacutil.BugInCF;
import org.checkerframework.javacutil.InternalUtils;
import org.checkerframework.javacutil.UserError;

public class AnnotationClassLoader {
    private final BaseTypeChecker checker;
    private final String packageName;
    private final String packageNameWithSlashes;
    private final List<String> fullyQualifiedPackageNameSegments;
    private static final String QUAL_PACKAGE_SUFFIX = ".qual";
    private static final String JAR_SUFFIX = ".jar";
    private static final String CLASS_SUFFIX = ".class";
    private static final char DOT = '.';
    private static final char SLASH = '/';
    protected final ProcessingEnvironment processingEnv;
    private final URL resourceURL;
    protected final URLClassLoader classLoader;
    private final Set<Class<? extends Annotation>> supportedBundledAnnotationClasses;

    public AnnotationClassLoader(BaseTypeChecker checker) {
        this.checker = checker;
        this.processingEnv = checker.getProcessingEnvironment();
        this.packageName = checker.getClass().getPackage() != null ? checker.getClass().getPackage().getName() + QUAL_PACKAGE_SUFFIX : QUAL_PACKAGE_SUFFIX.substring(1);
        this.packageNameWithSlashes = this.packageName.replace('.', '/');
        this.fullyQualifiedPackageNameSegments = new ArrayList<String>();
        this.fullyQualifiedPackageNameSegments.addAll(Arrays.asList(Pattern.compile(Character.toString('.'), 16).split(this.packageName)));
        this.classLoader = this.getClassLoader();
        this.resourceURL = this.classLoader != null ? this.classLoader.getResource(this.packageNameWithSlashes) : this.getURLFromClasspaths();
        this.supportedBundledAnnotationClasses = new LinkedHashSet<Class<? extends Annotation>>();
        this.loadBundledAnnotationClasses();
    }

    private final @Nullable URL getURLFromClasspaths() {
        URL url = null;
        Set<String> paths = this.getClasspaths();
        for (String path : paths) {
            if (path.endsWith(JAR_SUFFIX)) {
                url = this.getJarURL(path);
                if (url == null || !this.containsPackage(url)) continue;
                return url;
            }
            url = this.getDirectoryURL(path);
            if (url == null || !this.containsPackage(url)) continue;
            if (!path.endsWith(Character.toString('/'))) {
                path = path + '/';
            }
            url = this.getDirectoryURL(path + this.packageNameWithSlashes);
            return url;
        }
        return null;
    }

    private final boolean containsPackage(URL url) {
        if (url.getProtocol().equals("jar")) {
            try {
                JarURLConnection connection = (JarURLConnection)url.openConnection();
                JarFile jarFile = connection.getJarFile();
                return this.checkJarForPackage(jarFile);
            }
            catch (IOException connection) {}
        } else if (url.getProtocol().equals("file")) {
            File rootDir = new File(url.getFile());
            return this.checkDirForPackage(rootDir, this.fullyQualifiedPackageNameSegments.iterator());
        }
        return false;
    }

    private final boolean checkJarForPackage(JarFile jar) {
        Enumeration<JarEntry> jarEntries = jar.entries();
        while (jarEntries.hasMoreElements()) {
            JarEntry je = jarEntries.nextElement();
            String entryName = je.getName();
            if (!entryName.startsWith(this.packageNameWithSlashes)) continue;
            return true;
        }
        return false;
    }

    private final boolean checkDirForPackage(File currentDir, Iterator<String> pkgNames) {
        if (!pkgNames.hasNext()) {
            return true;
        }
        if (currentDir == null || !currentDir.isDirectory()) {
            return false;
        }
        String currentPackageDirName = pkgNames.next();
        for (File file : currentDir.listFiles()) {
            if (!file.isDirectory() || !file.getName().equals(currentPackageDirName)) continue;
            return this.checkDirForPackage(file, pkgNames);
        }
        return false;
    }

    private final @Nullable URL getDirectoryURL(String absolutePathToDirectory) {
        URL directoryURL = null;
        try {
            directoryURL = new File(absolutePathToDirectory).toURI().toURL();
        }
        catch (MalformedURLException e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Directory URL " + absolutePathToDirectory + " is malformed");
        }
        return directoryURL;
    }

    private final @Nullable URL getJarURL(String absolutePathToJarFile) {
        URL jarURL = null;
        try {
            jarURL = new URL("jar:file:" + absolutePathToJarFile + "!/");
        }
        catch (MalformedURLException e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Jar URL " + absolutePathToJarFile + " is malformed");
        }
        return jarURL;
    }

    private final Set<String> getClasspaths() {
        LinkedHashSet<String> paths = new LinkedHashSet<String>();
        String extdirs = System.getProperty("java.ext.dirs");
        if (extdirs != null && !extdirs.isEmpty()) {
            paths.addAll(Arrays.asList(extdirs.split(File.pathSeparator)));
        }
        paths.addAll(Arrays.asList(System.getProperty("java.class.path").split(File.pathSeparator)));
        if (this.classLoader != null) {
            URL[] urls = this.classLoader.getURLs();
            for (int i = 0; i < urls.length; ++i) {
                paths.add(urls[i].getFile().toString());
            }
        }
        return Collections.unmodifiableSet(paths);
    }

    private final @Nullable URLClassLoader getClassLoader() {
        ClassLoader result = InternalUtils.getClassLoaderForClass(this.checker.getClass());
        return (URLClassLoader)result;
    }

    protected final void printPaths() {
        String[] bootclassPaths = System.getProperty("sun.boot.class.path").split(File.pathSeparator);
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "bootclass path:");
        for (String path : bootclassPaths) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "\t" + path);
        }
        String[] extensionDirs = System.getProperty("java.ext.dirs").split(File.pathSeparator);
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "extension dirs:");
        for (String path : extensionDirs) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "\t" + path);
        }
        String[] javaclassPaths = System.getProperty("java.class.path").split(File.pathSeparator);
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "java classpaths:");
        for (String path : javaclassPaths) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "\t" + path);
        }
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "classloader examined paths:");
        if (this.classLoader != null) {
            URL[] urls = this.classLoader.getURLs();
            for (int i = 0; i < urls.length; ++i) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "\t" + urls[i].getFile());
            }
        } else {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "classloader unavailable");
        }
    }

    private void loadBundledAnnotationClasses() {
        Set<String> annotationNames;
        block20: {
            if (this.resourceURL == null) {
                return;
            }
            if (this.resourceURL.getProtocol().contentEquals("jar")) {
                JarURLConnection connection;
                try {
                    connection = (JarURLConnection)this.resourceURL.openConnection();
                    connection.setDefaultUseCaches(false);
                    connection.setUseCaches(false);
                    connection.connect();
                }
                catch (IOException e) {
                    throw new BugInCF("AnnotationClassLoader: cannot open a connection to the Jar file " + this.resourceURL.getFile());
                }
                try (JarFile jarFile = connection.getJarFile();){
                    annotationNames = this.getBundledAnnotationNamesFromJar(jarFile);
                    break block20;
                }
                catch (IOException e) {
                    throw new BugInCF("AnnotationClassLoader: cannot open the Jar file " + this.resourceURL.getFile());
                }
            }
            if (this.resourceURL.getProtocol().contentEquals("file")) {
                File packageDir = new File(this.resourceURL.getFile());
                annotationNames = this.getAnnotationNamesFromDirectory(this.packageName + '.', packageDir, packageDir);
            } else {
                annotationNames = Collections.emptySet();
            }
        }
        this.supportedBundledAnnotationClasses.addAll(this.loadAnnotationClasses(annotationNames));
    }

    public final Set<Class<? extends Annotation>> getBundledAnnotationClasses() {
        return this.supportedBundledAnnotationClasses;
    }

    private final Set<String> getBundledAnnotationNamesFromJar(JarFile jar) {
        LinkedHashSet<String> annos = new LinkedHashSet<String>();
        Enumeration<JarEntry> jarEntries = jar.entries();
        while (jarEntries.hasMoreElements()) {
            JarEntry je = jarEntries.nextElement();
            if (je.isDirectory() || !je.getName().endsWith(CLASS_SUFFIX)) continue;
            String className = je.getName().substring(0, je.getName().lastIndexOf(46));
            if (!(className = className.replace('/', '.')).startsWith(this.packageName)) continue;
            annos.add(className);
        }
        return annos;
    }

    public final @Nullable Class<? extends Annotation> loadExternalAnnotationClass(String annoName) {
        return this.loadAnnotationClass(annoName, true);
    }

    public final Set<Class<? extends Annotation>> loadExternalAnnotationClassesFromDirectory(String dirName) {
        File rootDirectory = new File(dirName);
        Set<String> annoNames = this.getAnnotationNamesFromDirectory("", rootDirectory, rootDirectory);
        return this.loadAnnotationClasses(annoNames);
    }

    private final Set<String> getAnnotationNamesFromDirectory(String packageName, File rootDirectory, File currentDirectory) {
        LinkedHashSet<String> results = new LinkedHashSet<String>();
        String rootPath = rootDirectory.getAbsolutePath();
        File[] directoryContents = currentDirectory.listFiles();
        Arrays.sort(directoryContents, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (File file : directoryContents) {
            if (file.isFile()) {
                String fullFileName = file.getAbsolutePath();
                String fileName = fullFileName.substring(fullFileName.lastIndexOf(File.separator) + 1, fullFileName.length());
                String filePath = fullFileName.substring(0, fullFileName.lastIndexOf(File.separator));
                String qualPackageName = "";
                if (!filePath.equals(rootPath)) {
                    qualPackageName = filePath.substring(rootPath.length() + 1, filePath.length()).replace('/', '.') + '.';
                }
                String annotationName = fileName;
                if (fileName.lastIndexOf(46) != -1) {
                    annotationName = fileName.substring(0, fileName.lastIndexOf(46));
                }
                String fullyQualifiedAnnoName = packageName + qualPackageName + annotationName;
                if (!fileName.endsWith(CLASS_SUFFIX)) continue;
                results.add(fullyQualifiedAnnoName);
                continue;
            }
            if (!file.isDirectory()) continue;
            results.addAll(this.getAnnotationNamesFromDirectory(packageName, rootDirectory, file));
        }
        return results;
    }

    protected final @Nullable Class<? extends Annotation> loadAnnotationClass(String fullyQualifiedClassName, boolean issueError) {
        if (this.classLoader == null) {
            throw new UserError(this.checker.getClass().getSimpleName() + ": no classloaders are available for use to load annotation class " + fullyQualifiedClassName + ".");
        }
        Class<?> cls = null;
        try {
            cls = Class.forName(fullyQualifiedClassName, true, this.classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new UserError(this.checker.getClass().getSimpleName() + ": could not load class for annotation: " + fullyQualifiedClassName + ". Ensure that it is a type annotation and your classpath is correct.");
        }
        if (!cls.isAnnotation()) {
            if (issueError) {
                throw new UserError(this.checker.getClass().getSimpleName() + ": the loaded class: " + cls.getCanonicalName() + " is not a type annotation.");
            }
            return null;
        }
        Class<Annotation> annoClass = cls.asSubclass(Annotation.class);
        if (this.hasWellDefinedTargetMetaAnnotation(annoClass)) {
            return this.isSupportedAnnotationClass(annoClass) ? annoClass : null;
        }
        if (issueError) {
            throw new UserError(this.checker.getClass().getSimpleName() + ": the loaded annotation: " + annoClass.getCanonicalName() + " is not a type annotation. Check its @Target meta-annotation.");
        }
        return null;
    }

    protected final Set<Class<? extends Annotation>> loadAnnotationClasses(@Nullable Set<String> fullyQualifiedAnnoNames) {
        LinkedHashSet<Class<? extends Annotation>> loadedClasses = new LinkedHashSet<Class<? extends Annotation>>();
        if (fullyQualifiedAnnoNames != null && !fullyQualifiedAnnoNames.isEmpty()) {
            for (String fullyQualifiedAnnoName : fullyQualifiedAnnoNames) {
                Class<? extends Annotation> annoClass = this.loadAnnotationClass(fullyQualifiedAnnoName, false);
                if (annoClass == null) continue;
                loadedClasses.add(annoClass);
            }
        }
        return loadedClasses;
    }

    protected boolean hasWellDefinedTargetMetaAnnotation(Class<? extends Annotation> annoClass) {
        return annoClass.getAnnotation(Target.class) != null && AnnotatedTypes.hasTypeQualifierElementTypes(annoClass.getAnnotation(Target.class).value(), annoClass);
    }

    protected boolean isSupportedAnnotationClass(Class<? extends Annotation> annoClass) {
        return true;
    }
}

