/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.common.value;

import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.common.value.ValueAnnotatedTypeFactory;
import org.checkerframework.common.value.ValueCheckerUtils;
import org.checkerframework.framework.source.Result;
import org.checkerframework.javacutil.ElementUtils;
import org.checkerframework.javacutil.PluginUtil;
import org.checkerframework.javacutil.TreeUtils;
import org.checkerframework.javacutil.TypesUtils;

public class ReflectiveEvaluator {
    private BaseTypeChecker checker;
    private boolean reportWarnings;

    public ReflectiveEvaluator(BaseTypeChecker checker, ValueAnnotatedTypeFactory factory, boolean reportWarnings) {
        this.checker = checker;
        this.reportWarnings = reportWarnings;
    }

    public List<?> evaluateMethodCall(List<List<?>> allArgValues, List<?> receiverValues, MethodInvocationTree tree) {
        List<Object> listOfArguments;
        Method method = this.getMethodObject(tree);
        if (method == null) {
            return null;
        }
        if (receiverValues == null) {
            receiverValues = Collections.singletonList(null);
        }
        if (allArgValues == null) {
            listOfArguments = new ArrayList<Object>();
            listOfArguments.add(null);
        } else {
            listOfArguments = this.cartesianProduct(allArgValues, allArgValues.size() - 1);
        }
        if (method.isVarArgs()) {
            ArrayList<Object[]> newList = new ArrayList<Object[]>();
            int numberOfParameters = method.getParameterTypes().length;
            for (Object[] objectArray : listOfArguments) {
                newList.add(this.normalizeVararg(objectArray, numberOfParameters));
            }
            listOfArguments = newList;
        }
        ArrayList<Object> results = new ArrayList<Object>();
        for (Object[] objectArray : listOfArguments) {
            for (Object receiver : receiverValues) {
                try {
                    results.add(method.invoke(receiver, objectArray));
                }
                catch (InvocationTargetException e) {
                    if (this.reportWarnings) {
                        this.checker.report(Result.warning("method.evaluation.exception", method, e.getTargetException().toString()), tree);
                    }
                    return null;
                }
                catch (ExceptionInInitializerError e) {
                    if (this.reportWarnings) {
                        this.checker.report(Result.warning("method.evaluation.exception", method, e.getCause().toString()), tree);
                    }
                    return null;
                }
                catch (IllegalArgumentException e) {
                    if (this.reportWarnings) {
                        String args = PluginUtil.join(", ", objectArray);
                        this.checker.report(Result.warning("method.evaluation.exception", method, e.getLocalizedMessage() + ": " + args), tree);
                    }
                    return null;
                }
                catch (Throwable e) {
                    if (this.reportWarnings) {
                        this.checker.report(Result.warning("method.evaluation.failed", method), tree);
                    }
                    return null;
                }
            }
        }
        return results;
    }

    private Object[] normalizeVararg(Object[] arguments, int numberOfParameters) {
        Object[] varArgsArray;
        if (arguments == null) {
            arguments = new Object[]{};
        }
        Object[] newArgs = new Object[numberOfParameters];
        int numOfVarArgs = arguments.length - numberOfParameters + 1;
        if (numOfVarArgs > 0) {
            System.arraycopy(arguments, 0, newArgs, 0, numberOfParameters - 1);
            varArgsArray = new Object[numOfVarArgs];
            System.arraycopy(arguments, numberOfParameters - 1, varArgsArray, 0, numOfVarArgs);
        } else {
            System.arraycopy(arguments, 0, newArgs, 0, numberOfParameters - 1);
            varArgsArray = new Object[]{};
        }
        newArgs[numberOfParameters - 1] = varArgsArray;
        return newArgs;
    }

    private Method getMethodObject(MethodInvocationTree tree) {
        try {
            ExecutableElement ele = TreeUtils.elementFromUse(tree);
            Name clazz = TypesUtils.getQualifiedName((DeclaredType)ele.getEnclosingElement().asType());
            List<Class<?>> paramClzz = this.getParameterClasses(ele);
            Class<?> clzz = Class.forName(clazz.toString());
            Method method = clzz.getMethod(ele.getSimpleName().toString(), paramClzz.toArray(new Class[0]));
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            return method;
        }
        catch (ClassNotFoundException | NoClassDefFoundError | UnsupportedClassVersionError e) {
            if (this.reportWarnings) {
                this.checker.report(Result.warning("class.find.failed", TreeUtils.elementFromUse(tree).getEnclosingElement()), tree);
            }
            return null;
        }
        catch (Throwable e) {
            Element classElem = TreeUtils.elementFromUse(tree).getEnclosingElement();
            if (classElem == null) {
                if (this.reportWarnings) {
                    this.checker.report(Result.warning("method.find.failed", new Object[0]), tree);
                }
            } else if (this.reportWarnings) {
                this.checker.report(Result.warning("method.find.failed.in.class", classElem), tree);
            }
            return null;
        }
    }

    private List<Class<?>> getParameterClasses(ExecutableElement ele) throws ClassNotFoundException {
        List<? extends VariableElement> paramEles = ele.getParameters();
        ArrayList paramClzz = new ArrayList();
        for (Element element : paramEles) {
            TypeMirror pType = ElementUtils.getType(element);
            paramClzz.add(ValueCheckerUtils.getClassFromType(pType));
        }
        return paramClzz;
    }

    private List<Object[]> cartesianProduct(List<List<?>> allArgValues, int whichArg) {
        List<?> argValues = allArgValues.get(whichArg);
        ArrayList<Object[]> tuples = new ArrayList<Object[]>();
        for (Object value : argValues) {
            if (whichArg == 0) {
                Object[] objects = new Object[allArgValues.size()];
                objects[0] = value;
                tuples.add(objects);
                continue;
            }
            List<Object[]> lastTuples = this.cartesianProduct(allArgValues, whichArg - 1);
            List<Object[]> copies = this.copy(lastTuples);
            for (Object[] copy : copies) {
                copy[whichArg] = value;
            }
            tuples.addAll(copies);
        }
        return tuples;
    }

    private List<Object[]> copy(List<Object[]> lastTuples) {
        ArrayList<Object[]> returnListOfLists = new ArrayList<Object[]>();
        for (Object[] list : lastTuples) {
            Object[] copy = Arrays.copyOf(list, list.length);
            returnListOfLists.add(copy);
        }
        return returnListOfLists;
    }

    public Object evaluateStaticFieldAccess(String classname, String fieldName, MemberSelectTree tree) {
        try {
            Class<?> recClass = Class.forName(classname);
            Field field = recClass.getField(fieldName);
            return field.get(recClass);
        }
        catch (ClassNotFoundException | NoClassDefFoundError | UnsupportedClassVersionError e) {
            if (this.reportWarnings) {
                this.checker.report(Result.warning("class.find.failed", classname), tree);
            }
            return null;
        }
        catch (Throwable e) {
            if (this.reportWarnings) {
                this.checker.report(Result.warning("field.access.failed", fieldName, classname), tree);
            }
            return null;
        }
    }

    public List<?> evaluteConstructorCall(ArrayList<List<?>> argValues, NewClassTree tree, TypeMirror typeToCreate) {
        List<Object> listOfArguments;
        Constructor<?> constructor;
        try {
            constructor = this.getConstructorObject(tree, typeToCreate);
        }
        catch (Throwable e) {
            if (this.reportWarnings) {
                this.checker.report(Result.warning("constructor.invocation.failed", new Object[0]), tree);
            }
            return null;
        }
        if (constructor == null) {
            return null;
        }
        if (argValues == null) {
            listOfArguments = new ArrayList<Object>();
            listOfArguments.add(null);
        } else {
            listOfArguments = this.cartesianProduct(argValues, argValues.size() - 1);
        }
        ArrayList results = new ArrayList();
        for (Object[] objectArray : listOfArguments) {
            try {
                results.add(constructor.newInstance(objectArray));
            }
            catch (Throwable e) {
                if (this.reportWarnings) {
                    this.checker.report(Result.warning("constructor.evaluation.failed", typeToCreate, PluginUtil.join(", ", objectArray)), tree);
                }
                return null;
            }
        }
        return results;
    }

    private Constructor<?> getConstructorObject(NewClassTree tree, TypeMirror typeToCreate) throws ClassNotFoundException, NoSuchMethodException {
        ExecutableElement ele = TreeUtils.elementFromUse(tree);
        List<Class<?>> paramClasses = this.getParameterClasses(ele);
        Class<?> recClass = ReflectiveEvaluator.boxPrimitives(ValueCheckerUtils.getClassFromType(typeToCreate));
        Constructor<?> constructor = recClass.getConstructor(paramClasses.toArray(new Class[0]));
        return constructor;
    }

    private static Class<?> boxPrimitives(Class<?> type) {
        if (type == Byte.TYPE) {
            return Byte.class;
        }
        if (type == Short.TYPE) {
            return Short.class;
        }
        if (type == Integer.TYPE) {
            return Integer.class;
        }
        if (type == Long.TYPE) {
            return Long.class;
        }
        if (type == Float.TYPE) {
            return Float.class;
        }
        if (type == Double.TYPE) {
            return Double.class;
        }
        if (type == Character.TYPE) {
            return Character.class;
        }
        if (type == Boolean.TYPE) {
            return Boolean.class;
        }
        return type;
    }
}

