/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.com.github.javaparser.printer.lexicalpreservation;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.checkerframework.com.github.javaparser.JavaToken;
import org.checkerframework.com.github.javaparser.Range;
import org.checkerframework.com.github.javaparser.TokenTypes;
import org.checkerframework.com.github.javaparser.ast.DataKey;
import org.checkerframework.com.github.javaparser.ast.Modifier;
import org.checkerframework.com.github.javaparser.ast.Node;
import org.checkerframework.com.github.javaparser.ast.NodeList;
import org.checkerframework.com.github.javaparser.ast.body.VariableDeclarator;
import org.checkerframework.com.github.javaparser.ast.comments.BlockComment;
import org.checkerframework.com.github.javaparser.ast.comments.Comment;
import org.checkerframework.com.github.javaparser.ast.comments.JavadocComment;
import org.checkerframework.com.github.javaparser.ast.comments.LineComment;
import org.checkerframework.com.github.javaparser.ast.nodeTypes.NodeWithVariables;
import org.checkerframework.com.github.javaparser.ast.observer.AstObserver;
import org.checkerframework.com.github.javaparser.ast.observer.ObservableProperty;
import org.checkerframework.com.github.javaparser.ast.observer.PropagatingAstObserver;
import org.checkerframework.com.github.javaparser.ast.type.PrimitiveType;
import org.checkerframework.com.github.javaparser.ast.visitor.TreeVisitor;
import org.checkerframework.com.github.javaparser.printer.ConcreteSyntaxModel;
import org.checkerframework.com.github.javaparser.printer.concretesyntaxmodel.CsmElement;
import org.checkerframework.com.github.javaparser.printer.concretesyntaxmodel.CsmIndent;
import org.checkerframework.com.github.javaparser.printer.concretesyntaxmodel.CsmMix;
import org.checkerframework.com.github.javaparser.printer.concretesyntaxmodel.CsmToken;
import org.checkerframework.com.github.javaparser.printer.concretesyntaxmodel.CsmUnindent;
import org.checkerframework.com.github.javaparser.printer.lexicalpreservation.ChildTextElement;
import org.checkerframework.com.github.javaparser.printer.lexicalpreservation.Difference;
import org.checkerframework.com.github.javaparser.printer.lexicalpreservation.DifferenceElement;
import org.checkerframework.com.github.javaparser.printer.lexicalpreservation.LexicalDifferenceCalculator;
import org.checkerframework.com.github.javaparser.printer.lexicalpreservation.NodeText;
import org.checkerframework.com.github.javaparser.printer.lexicalpreservation.PhantomNodeLogic;
import org.checkerframework.com.github.javaparser.printer.lexicalpreservation.TextElement;
import org.checkerframework.com.github.javaparser.printer.lexicalpreservation.TextElementIteratorsFactory;
import org.checkerframework.com.github.javaparser.printer.lexicalpreservation.TokenTextElement;
import org.checkerframework.com.github.javaparser.utils.Pair;
import org.checkerframework.com.github.javaparser.utils.Utils;

public class LexicalPreservingPrinter {
    private static AstObserver observer;
    public static final DataKey<NodeText> NODE_TEXT_DATA;
    private static final LexicalDifferenceCalculator LEXICAL_DIFFERENCE_CALCULATOR;

    public static <N extends Node> N setup(N node) {
        Utils.assertNotNull(node);
        if (observer == null) {
            observer = LexicalPreservingPrinter.createObserver();
        }
        node.getTokenRange().ifPresent(r -> {
            LexicalPreservingPrinter.storeInitialText(node);
            if (!node.isRegistered(observer)) {
                node.registerForSubtree(observer);
            }
        });
        return node;
    }

    private static AstObserver createObserver() {
        return new Observer();
    }

    private static void storeInitialText(Node root) {
        final IdentityHashMap tokensByNode = new IdentityHashMap();
        for (JavaToken token : root.getTokenRange().get()) {
            Range tokenRange = token.getRange().orElseThrow(() -> new RuntimeException("Token without range: " + token));
            Node owner = LexicalPreservingPrinter.findNodeForToken(root, tokenRange);
            if (owner == null) {
                throw new RuntimeException("Token without node owning it: " + token);
            }
            if (!tokensByNode.containsKey(owner)) {
                tokensByNode.put(owner, new LinkedList());
            }
            ((List)tokensByNode.get(owner)).add(token);
        }
        new TreeVisitor(){

            @Override
            public void process(Node node) {
                if (!PhantomNodeLogic.isPhantomNode(node)) {
                    LexicalPreservingPrinter.storeInitialTextForOneNode(node, (List)tokensByNode.get(node));
                }
            }
        }.visitBreadthFirst(root);
    }

    private static Node findNodeForToken(Node node, Range tokenRange) {
        if (PhantomNodeLogic.isPhantomNode(node)) {
            return null;
        }
        if (node.getRange().get().contains(tokenRange)) {
            for (Node child : node.getChildNodes()) {
                Node found = LexicalPreservingPrinter.findNodeForToken(child, tokenRange);
                if (found == null) continue;
                return found;
            }
            return node;
        }
        return null;
    }

    private static void storeInitialTextForOneNode(Node node, List<JavaToken> nodeTokens) {
        if (nodeTokens == null) {
            nodeTokens = Collections.emptyList();
        }
        LinkedList<Pair> elements = new LinkedList<Pair>();
        for (Node child : node.getChildNodes()) {
            if (PhantomNodeLogic.isPhantomNode(child)) continue;
            if (!child.getRange().isPresent()) {
                throw new RuntimeException("Range not present on node " + child);
            }
            elements.add(new Pair<Range, ChildTextElement>(child.getRange().get(), new ChildTextElement(child)));
        }
        for (JavaToken token : nodeTokens) {
            elements.add(new Pair<Range, TokenTextElement>(token.getRange().get(), new TokenTextElement(token)));
        }
        elements.sort(Comparator.comparing(e -> ((Range)e.a).begin));
        node.setData(NODE_TEXT_DATA, new NodeText(elements.stream().map(p -> (TextElement)p.b).collect(Collectors.toList())));
    }

    private static Iterator<TokenTextElement> tokensPreceeding(Node node) {
        if (!node.getParentNode().isPresent()) {
            return new TextElementIteratorsFactory.EmptyIterator<TokenTextElement>();
        }
        NodeText parentNodeText = LexicalPreservingPrinter.getOrCreateNodeText(node.getParentNode().get());
        int index = parentNodeText.tryToFindChild(node);
        if (index == -1) {
            if (node.getParentNode().get() instanceof VariableDeclarator) {
                return LexicalPreservingPrinter.tokensPreceeding(node.getParentNode().get());
            }
            throw new IllegalArgumentException(String.format("I could not find child '%s' in parent '%s'. parentNodeText: %s", node, node.getParentNode().get(), parentNodeText));
        }
        return new TextElementIteratorsFactory.CascadingIterator<TokenTextElement>(TextElementIteratorsFactory.partialReverseIterator(parentNodeText, index - 1), () -> LexicalPreservingPrinter.tokensPreceeding(node.getParentNode().get()));
    }

    public static String print(Node node) {
        StringWriter writer = new StringWriter();
        try {
            LexicalPreservingPrinter.print(node, writer);
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected IOException on a StringWriter", e);
        }
        return writer.toString();
    }

    public static void print(Node node, Writer writer) throws IOException {
        if (!node.containsData(NODE_TEXT_DATA)) {
            LexicalPreservingPrinter.getOrCreateNodeText(node);
        }
        NodeText text = node.getData(NODE_TEXT_DATA);
        writer.append(text.expand());
    }

    private static void prettyPrintingTextNode(Node node, NodeText nodeText) {
        if (node instanceof PrimitiveType) {
            PrimitiveType primitiveType = (PrimitiveType)node;
            switch (primitiveType.getType()) {
                case BOOLEAN: {
                    nodeText.addToken(13, node.toString());
                    break;
                }
                case CHAR: {
                    nodeText.addToken(18, node.toString());
                    break;
                }
                case BYTE: {
                    nodeText.addToken(15, node.toString());
                    break;
                }
                case SHORT: {
                    nodeText.addToken(49, node.toString());
                    break;
                }
                case INT: {
                    nodeText.addToken(38, node.toString());
                    break;
                }
                case LONG: {
                    nodeText.addToken(40, node.toString());
                    break;
                }
                case FLOAT: {
                    nodeText.addToken(31, node.toString());
                    break;
                }
                case DOUBLE: {
                    nodeText.addToken(24, node.toString());
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            return;
        }
        if (node instanceof JavadocComment) {
            nodeText.addToken(8, "/**" + ((JavadocComment)node).getContent() + "*/");
            return;
        }
        if (node instanceof BlockComment) {
            nodeText.addToken(9, "/*" + ((BlockComment)node).getContent() + "*/");
            return;
        }
        if (node instanceof LineComment) {
            nodeText.addToken(5, "//" + ((LineComment)node).getContent());
            return;
        }
        if (node instanceof Modifier) {
            Modifier modifier = (Modifier)node;
            nodeText.addToken(LexicalDifferenceCalculator.toToken(modifier), modifier.getKeyword().asString());
            return;
        }
        LexicalPreservingPrinter.interpret(node, ConcreteSyntaxModel.forClass(node.getClass()), nodeText);
    }

    private static NodeText interpret(Node node, CsmElement csm, NodeText nodeText) {
        LexicalDifferenceCalculator.CalculatedSyntaxModel calculatedSyntaxModel = new LexicalDifferenceCalculator().calculatedSyntaxModelForNode(csm, node);
        List<TokenTextElement> indentation = LexicalPreservingPrinter.findIndentation(node);
        boolean pendingIndentation = false;
        for (CsmElement element : calculatedSyntaxModel.elements) {
            block13: {
                block14: {
                    if (!pendingIndentation) break block13;
                    if (!(element instanceof CsmToken)) break block14;
                    if (((CsmToken)element).isNewLine()) break block13;
                }
                indentation.forEach(nodeText::addElement);
            }
            pendingIndentation = false;
            if (element instanceof LexicalDifferenceCalculator.CsmChild) {
                nodeText.addChild(((LexicalDifferenceCalculator.CsmChild)element).getChild());
                continue;
            }
            if (element instanceof CsmToken) {
                CsmToken csmToken = (CsmToken)element;
                nodeText.addToken(csmToken.getTokenType(), csmToken.getContent(node));
                if (!csmToken.isNewLine()) continue;
                pendingIndentation = true;
                continue;
            }
            if (element instanceof CsmMix) {
                CsmMix csmMix = (CsmMix)element;
                csmMix.getElements().forEach(e -> LexicalPreservingPrinter.interpret(node, e, nodeText));
                continue;
            }
            if (element instanceof CsmIndent) {
                for (int i = 0; i < 4; ++i) {
                    nodeText.addToken(1, " ");
                }
                continue;
            }
            if (element instanceof CsmUnindent) {
                for (int i = 0; i < 4; ++i) {
                    if (!nodeText.endWithSpace()) continue;
                    nodeText.removeLastElement();
                }
                continue;
            }
            throw new UnsupportedOperationException(element.getClass().getSimpleName());
        }
        if (node instanceof VariableDeclarator) {
            VariableDeclarator variableDeclarator = (VariableDeclarator)node;
            variableDeclarator.getParentNode().ifPresent(parent -> ((NodeWithVariables)((Object)parent)).getMaximumCommonType().ifPresent(mct -> {
                int extraArrayLevels = variableDeclarator.getType().getArrayLevel() - mct.getArrayLevel();
                for (int i = 0; i < extraArrayLevels; ++i) {
                    nodeText.addElement(new TokenTextElement(96));
                    nodeText.addElement(new TokenTextElement(97));
                }
            }));
        }
        return nodeText;
    }

    static NodeText getOrCreateNodeText(Node node) {
        if (!node.containsData(NODE_TEXT_DATA)) {
            NodeText nodeText = new NodeText();
            node.setData(NODE_TEXT_DATA, nodeText);
            LexicalPreservingPrinter.prettyPrintingTextNode(node, nodeText);
        }
        return node.getData(NODE_TEXT_DATA);
    }

    static List<TokenTextElement> findIndentation(Node node) {
        TokenTextElement tte;
        LinkedList<TokenTextElement> followingNewlines = new LinkedList<TokenTextElement>();
        Iterator<TokenTextElement> it = LexicalPreservingPrinter.tokensPreceeding(node);
        while (it.hasNext() && (tte = it.next()).getTokenKind() != 5 && !tte.isNewline()) {
            followingNewlines.add(tte);
        }
        Collections.reverse(followingNewlines);
        for (int i = 0; i < followingNewlines.size(); ++i) {
            if (((TokenTextElement)followingNewlines.get(i)).isSpaceOrTab()) continue;
            return followingNewlines.subList(0, i);
        }
        return followingNewlines;
    }

    private static boolean isReturningOptionalNodeList(Method m3) {
        if (!m3.getReturnType().getCanonicalName().equals(Optional.class.getCanonicalName())) {
            return false;
        }
        if (!(m3.getGenericReturnType() instanceof ParameterizedType)) {
            return false;
        }
        ParameterizedType parameterizedType = (ParameterizedType)m3.getGenericReturnType();
        Type optionalArgument = parameterizedType.getActualTypeArguments()[0];
        return optionalArgument.getTypeName().startsWith(NodeList.class.getCanonicalName());
    }

    private static ObservableProperty findNodeListName(NodeList nodeList) {
        Node parent = nodeList.getParentNodeForChildren();
        for (Method m3 : parent.getClass().getMethods()) {
            Object raw;
            if (m3.getParameterCount() == 0 && m3.getReturnType().getCanonicalName().equals(NodeList.class.getCanonicalName())) {
                try {
                    raw = m3.invoke((Object)parent, new Object[0]);
                    if (!(raw instanceof NodeList)) {
                        throw new IllegalStateException("Expected NodeList, found " + raw.getClass().getCanonicalName());
                    }
                    NodeList result = (NodeList)raw;
                    if (result != nodeList) continue;
                    String name = m3.getName();
                    if (name.startsWith("get")) {
                        name = name.substring("get".length());
                    }
                    return ObservableProperty.fromCamelCaseName(Utils.decapitalize(name));
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
            if (m3.getParameterCount() != 0 || !LexicalPreservingPrinter.isReturningOptionalNodeList(m3)) continue;
            try {
                raw = (Optional)m3.invoke((Object)parent, new Object[0]);
                if (!((Optional)raw).isPresent() || ((Optional)raw).get() != nodeList) continue;
                String name = m3.getName();
                if (name.startsWith("get")) {
                    name = name.substring("get".length());
                }
                return ObservableProperty.fromCamelCaseName(Utils.decapitalize(name));
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        throw new IllegalArgumentException("Cannot find list name of NodeList of size " + nodeList.size());
    }

    static {
        NODE_TEXT_DATA = new DataKey<NodeText>(){};
        LEXICAL_DIFFERENCE_CALCULATOR = new LexicalDifferenceCalculator();
    }

    private static class Observer
    extends PropagatingAstObserver {
        private Observer() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void concretePropertyChange(Node observedNode, ObservableProperty property, Object oldValue, Object newValue) {
            NodeText nodeText;
            if (oldValue != null && oldValue.equals(newValue) || oldValue == null && newValue == null) {
                return;
            }
            if (property == ObservableProperty.RANGE || property == ObservableProperty.COMMENTED_NODE) {
                return;
            }
            if (property == ObservableProperty.COMMENT) {
                if (!observedNode.getParentNode().isPresent()) {
                    throw new IllegalStateException();
                }
                nodeText = LexicalPreservingPrinter.getOrCreateNodeText(observedNode.getParentNode().get());
                if (oldValue == null) {
                    int index = nodeText.findChild(observedNode);
                    nodeText.addChild(index, (Comment)newValue);
                    nodeText.addToken(index + 1, TokenTypes.eolTokenKind(), Utils.EOL);
                } else if (newValue == null) {
                    if (!(oldValue instanceof Comment)) throw new UnsupportedOperationException();
                    if (((Comment)oldValue).isOrphan()) {
                        nodeText = LexicalPreservingPrinter.getOrCreateNodeText(observedNode);
                    }
                    int index = this.getIndexOfComment((Comment)oldValue, nodeText);
                    nodeText.removeElement(index);
                    if (nodeText.getElements().get(index).isNewline()) {
                        nodeText.removeElement(index);
                    }
                } else {
                    if (!(oldValue instanceof JavadocComment)) throw new UnsupportedOperationException();
                    List<TokenTextElement> matchingTokens = this.findTokenTextElementForComment((JavadocComment)oldValue, nodeText);
                    if (matchingTokens.size() != 1) {
                        throw new IllegalStateException("The matching comment to be replaced could not be found");
                    }
                    JavadocComment newJavadocComment = (JavadocComment)newValue;
                    TokenTextElement matchingElement = matchingTokens.get(0);
                    nodeText.replace(matchingElement.and(matchingElement.matchByRange()), new TokenTextElement(8, "/**" + newJavadocComment.getContent() + "*/"));
                }
            }
            if ((nodeText = LexicalPreservingPrinter.getOrCreateNodeText(observedNode)) == null) {
                throw new NullPointerException(observedNode.getClass().getSimpleName());
            }
            LEXICAL_DIFFERENCE_CALCULATOR.calculatePropertyChange(nodeText, observedNode, property, oldValue, newValue);
        }

        private int getIndexOfComment(Comment oldValue, NodeText nodeText) {
            int index;
            List<TokenTextElement> matchingTokens = this.findTokenTextElementForComment(oldValue, nodeText);
            if (!matchingTokens.isEmpty()) {
                TextElement matchingElement = matchingTokens.get(0);
                index = nodeText.findElement(matchingElement.and(matchingElement.matchByRange()));
            } else {
                List<ChildTextElement> matchingChilds = this.findChildTextElementForComment(oldValue, nodeText);
                ChildTextElement matchingChild = matchingChilds.get(0);
                index = nodeText.findElement(matchingChild.and(matchingChild.matchByRange()));
            }
            return index;
        }

        private List<ChildTextElement> findChildTextElementForComment(Comment oldValue, NodeText nodeText) {
            List<ChildTextElement> matchingChildElements = nodeText.getElements().stream().filter(e -> e.isChild()).map(c -> (ChildTextElement)c).filter(c -> c.isComment()).filter(c -> ((Comment)c.getChild()).getContent().equals(oldValue.getContent())).collect(Collectors.toList());
            if (matchingChildElements.size() > 1) {
                matchingChildElements = matchingChildElements.stream().filter(t -> this.isEqualRange(t.getChild().getRange(), oldValue.getRange())).collect(Collectors.toList());
            }
            if (matchingChildElements.size() != 1) {
                throw new IllegalStateException("The matching child text element for the comment to be removed could not be found.");
            }
            return matchingChildElements;
        }

        private List<TokenTextElement> findTokenTextElementForComment(Comment oldValue, NodeText nodeText) {
            List<TokenTextElement> matchingTokens = oldValue instanceof JavadocComment ? nodeText.getElements().stream().filter(e -> e.isToken(8)).map(e -> (TokenTextElement)e).filter(t -> t.getText().equals("/**" + oldValue.getContent() + "*/")).collect(Collectors.toList()) : (oldValue instanceof BlockComment ? nodeText.getElements().stream().filter(e -> e.isToken(9)).map(e -> (TokenTextElement)e).filter(t -> t.getText().equals("/*" + oldValue.getContent() + "*/")).collect(Collectors.toList()) : nodeText.getElements().stream().filter(e -> e.isToken(5)).map(e -> (TokenTextElement)e).filter(t -> t.getText().trim().equals(("//" + oldValue.getContent()).trim())).collect(Collectors.toList()));
            if (matchingTokens.size() > 1) {
                matchingTokens = matchingTokens.stream().filter(t -> this.isEqualRange(t.getToken().getRange(), oldValue.getRange())).collect(Collectors.toList());
            }
            return matchingTokens;
        }

        private boolean isEqualRange(Optional<Range> range1, Optional<Range> range2) {
            if (range1.isPresent() && range2.isPresent()) {
                return range1.get().equals(range2.get());
            }
            return false;
        }

        @Override
        public void concreteListChange(NodeList changedList, AstObserver.ListChangeType type, int index, Node nodeAddedOrRemoved) {
            List<DifferenceElement> differenceElements;
            NodeText nodeText = LexicalPreservingPrinter.getOrCreateNodeText(changedList.getParentNodeForChildren());
            if (type == AstObserver.ListChangeType.REMOVAL) {
                differenceElements = LEXICAL_DIFFERENCE_CALCULATOR.calculateListRemovalDifference(LexicalPreservingPrinter.findNodeListName(changedList), changedList, index);
            } else if (type == AstObserver.ListChangeType.ADDITION) {
                differenceElements = LEXICAL_DIFFERENCE_CALCULATOR.calculateListAdditionDifference(LexicalPreservingPrinter.findNodeListName(changedList), changedList, index, nodeAddedOrRemoved);
            } else {
                throw new UnsupportedOperationException();
            }
            Difference difference = new Difference(differenceElements, nodeText, changedList.getParentNodeForChildren());
            difference.apply();
        }

        @Override
        public void concreteListReplacement(NodeList changedList, int index, Node oldValue, Node newValue) {
            NodeText nodeText = LexicalPreservingPrinter.getOrCreateNodeText(changedList.getParentNodeForChildren());
            List<DifferenceElement> differenceElements = LEXICAL_DIFFERENCE_CALCULATOR.calculateListReplacementDifference(LexicalPreservingPrinter.findNodeListName(changedList), changedList, index, newValue);
            Difference difference = new Difference(differenceElements, nodeText, changedList.getParentNodeForChildren());
            difference.apply();
        }
    }
}

