/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.units;

import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.util.Elements;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.units.UnitsRelations;
import org.checkerframework.checker.units.UnitsRelationsTools;
import org.checkerframework.checker.units.qual.Prefix;
import org.checkerframework.checker.units.qual.h;
import org.checkerframework.checker.units.qual.km2;
import org.checkerframework.checker.units.qual.kmPERh;
import org.checkerframework.checker.units.qual.m;
import org.checkerframework.checker.units.qual.m2;
import org.checkerframework.checker.units.qual.mPERs;
import org.checkerframework.checker.units.qual.mPERs2;
import org.checkerframework.checker.units.qual.mm2;
import org.checkerframework.checker.units.qual.s;
import org.checkerframework.framework.type.AnnotatedTypeMirror;

public class UnitsRelationsDefault
implements UnitsRelations {
    protected AnnotationMirror m;
    protected AnnotationMirror km;
    protected AnnotationMirror mm;
    protected AnnotationMirror m2;
    protected AnnotationMirror km2;
    protected AnnotationMirror mm2;
    protected AnnotationMirror s;
    protected AnnotationMirror h;
    protected AnnotationMirror mPERs;
    protected AnnotationMirror kmPERh;
    protected AnnotationMirror mPERs2;
    protected Elements elements;

    @Override
    public UnitsRelations init(ProcessingEnvironment env) {
        this.elements = env.getElementUtils();
        this.m = UnitsRelationsTools.buildAnnoMirrorWithDefaultPrefix(env, m.class);
        this.km = UnitsRelationsTools.buildAnnoMirrorWithSpecificPrefix(env, m.class, Prefix.kilo);
        this.mm = UnitsRelationsTools.buildAnnoMirrorWithSpecificPrefix(env, m.class, Prefix.milli);
        this.m2 = UnitsRelationsTools.buildAnnoMirrorWithNoPrefix(env, m2.class);
        this.km2 = UnitsRelationsTools.buildAnnoMirrorWithNoPrefix(env, km2.class);
        this.mm2 = UnitsRelationsTools.buildAnnoMirrorWithNoPrefix(env, mm2.class);
        this.s = UnitsRelationsTools.buildAnnoMirrorWithDefaultPrefix(env, s.class);
        this.h = UnitsRelationsTools.buildAnnoMirrorWithNoPrefix(env, h.class);
        this.mPERs = UnitsRelationsTools.buildAnnoMirrorWithNoPrefix(env, mPERs.class);
        this.kmPERh = UnitsRelationsTools.buildAnnoMirrorWithNoPrefix(env, kmPERh.class);
        this.mPERs2 = UnitsRelationsTools.buildAnnoMirrorWithNoPrefix(env, mPERs2.class);
        return this;
    }

    @Override
    public @Nullable AnnotationMirror multiplication(AnnotatedTypeMirror lht, AnnotatedTypeMirror rht) {
        if (UnitsRelationsTools.hasSpecificUnitIgnoringPrefix(lht, this.m) && UnitsRelationsTools.hasSpecificUnitIgnoringPrefix(rht, this.m)) {
            Prefix rhtPrefix;
            if (UnitsRelationsTools.hasNoPrefix(lht) && UnitsRelationsTools.hasNoPrefix(rht)) {
                return this.m2;
            }
            Prefix lhtPrefix = UnitsRelationsTools.getPrefix(lht);
            if (this.bothHaveSpecificPrefix(lhtPrefix, rhtPrefix = UnitsRelationsTools.getPrefix(rht), Prefix.kilo)) {
                return this.km2;
            }
            if (this.bothHaveSpecificPrefix(lhtPrefix, rhtPrefix, Prefix.one)) {
                return this.m2;
            }
            if (this.bothHaveSpecificPrefix(lhtPrefix, rhtPrefix, Prefix.milli)) {
                return this.mm2;
            }
            return null;
        }
        if (this.havePairOfUnitsIgnoringOrder(lht, this.s, rht, this.mPERs)) {
            return this.m;
        }
        if (this.havePairOfUnitsIgnoringOrder(lht, this.s, rht, this.mPERs2)) {
            return this.mPERs;
        }
        if (this.havePairOfUnitsIgnoringOrder(lht, this.h, rht, this.kmPERh)) {
            return this.km;
        }
        return null;
    }

    @Override
    public @Nullable AnnotationMirror division(AnnotatedTypeMirror lht, AnnotatedTypeMirror rht) {
        if (this.havePairOfUnits(lht, this.m, rht, this.s)) {
            return this.mPERs;
        }
        if (this.havePairOfUnits(lht, this.km, rht, this.h)) {
            return this.kmPERh;
        }
        if (this.havePairOfUnits(lht, this.m2, rht, this.m)) {
            return this.m;
        }
        if (this.havePairOfUnits(lht, this.km2, rht, this.km)) {
            return this.km;
        }
        if (this.havePairOfUnits(lht, this.mm2, rht, this.mm)) {
            return this.mm;
        }
        if (this.havePairOfUnits(lht, this.m, rht, this.mPERs)) {
            return this.s;
        }
        if (this.havePairOfUnits(lht, this.km, rht, this.kmPERh)) {
            return this.h;
        }
        if (this.havePairOfUnits(lht, this.mPERs, rht, this.s)) {
            return this.mPERs2;
        }
        if (this.havePairOfUnits(lht, this.mPERs, rht, this.mPERs2)) {
            return this.s;
        }
        return null;
    }

    protected boolean bothHaveSpecificPrefix(Prefix lhtPrefix, Prefix rhtPrefix, Prefix specificPrefix) {
        if (lhtPrefix == null || rhtPrefix == null || specificPrefix == null) {
            return false;
        }
        return lhtPrefix.equals((Object)rhtPrefix) && rhtPrefix.equals((Object)specificPrefix);
    }

    protected boolean havePairOfUnits(AnnotatedTypeMirror lht, AnnotationMirror ul, AnnotatedTypeMirror rht, AnnotationMirror ur) {
        return UnitsRelationsTools.hasSpecificUnit(lht, ul) && UnitsRelationsTools.hasSpecificUnit(rht, ur);
    }

    protected boolean havePairOfUnitsIgnoringOrder(AnnotatedTypeMirror lht, AnnotationMirror u1, AnnotatedTypeMirror rht, AnnotationMirror u2) {
        return this.havePairOfUnits(lht, u1, rht, u2) || this.havePairOfUnits(lht, u2, rht, u1);
    }
}

