/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.lock;

import com.sun.source.tree.AnnotatedTypeTree;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.checkerframework.checker.compilermsgs.qual.CompilerMessageKey;
import org.checkerframework.checker.lock.LockAnnotatedTypeFactory;
import org.checkerframework.checker.lock.LockStore;
import org.checkerframework.checker.lock.qual.EnsuresLockHeld;
import org.checkerframework.checker.lock.qual.EnsuresLockHeldIf;
import org.checkerframework.checker.lock.qual.GuardSatisfied;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.checkerframework.checker.lock.qual.GuardedByBottom;
import org.checkerframework.checker.lock.qual.GuardedByUnknown;
import org.checkerframework.checker.lock.qual.Holding;
import org.checkerframework.checker.lock.qual.LockHeld;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.common.basetype.BaseTypeVisitor;
import org.checkerframework.dataflow.analysis.FlowExpressions;
import org.checkerframework.dataflow.qual.Deterministic;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.framework.flow.CFValue;
import org.checkerframework.framework.source.Result;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.framework.util.AnnotatedTypes;
import org.checkerframework.framework.util.FlowExpressionParseUtil;
import org.checkerframework.framework.util.dependenttypes.DependentTypesError;
import org.checkerframework.javacutil.AnnotationProvider;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.BugInCF;
import org.checkerframework.javacutil.ElementUtils;
import org.checkerframework.javacutil.TreeUtils;
import org.checkerframework.javacutil.TypesUtils;

public class LockVisitor
extends BaseTypeVisitor<LockAnnotatedTypeFactory> {
    private final Class<? extends Annotation> checkerGuardedByClass = GuardedBy.class;
    private final Class<? extends Annotation> checkerGuardSatisfiedClass = GuardSatisfied.class;
    protected static final Pattern SELF_RECEIVER_PATTERN = Pattern.compile("^<self>(\\.(.*))?$");

    public LockVisitor(BaseTypeChecker checker) {
        super(checker);
    }

    @Override
    public Void visitVariable(VariableTree node, Void p) {
        AnnotatedTypeMirror atm;
        TypeMirror tm = TreeUtils.typeOf(node);
        if ((TypesUtils.isBoxedPrimitive(tm) || TypesUtils.isPrimitive(tm) || TypesUtils.isString(tm)) && ((atm = ((LockAnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(node)).hasExplicitAnnotationRelaxed(((LockAnnotatedTypeFactory)this.atypeFactory).GUARDSATISFIED) || atm.hasExplicitAnnotationRelaxed(((LockAnnotatedTypeFactory)this.atypeFactory).GUARDEDBY) || atm.hasExplicitAnnotation(((LockAnnotatedTypeFactory)this.atypeFactory).GUARDEDBYUNKNOWN) || atm.hasExplicitAnnotation(((LockAnnotatedTypeFactory)this.atypeFactory).GUARDEDBYBOTTOM))) {
            this.checker.report(Result.failure("immutable.type.guardedby", new Object[0]), node);
        }
        this.issueErrorIfMoreThanOneGuardedByAnnotationPresent(node);
        return super.visitVariable(node, p);
    }

    private void issueErrorIfMoreThanOneGuardedByAnnotationPresent(VariableTree variableTree) {
        int guardedByAnnotationCount = 0;
        List<AnnotationMirror> annos = TreeUtils.annotationsFromTypeAnnotationTrees(variableTree.getModifiers().getAnnotations());
        for (AnnotationMirror anno : annos) {
            if (!AnnotationUtils.areSameByClass(anno, GuardedBy.class) && !AnnotationUtils.areSameByName(anno, "net.jcip.annotations.GuardedBy") && !AnnotationUtils.areSameByName(anno, "javax.annotation.concurrent.GuardedBy") || ++guardedByAnnotationCount <= 1) continue;
            this.checker.report(Result.failure("multiple.guardedby.annotations", new Object[0]), variableTree);
            return;
        }
    }

    @Override
    public LockAnnotatedTypeFactory createTypeFactory() {
        return new LockAnnotatedTypeFactory(this.checker);
    }

    @Override
    public Void visitMethod(MethodTree node, Void p) {
        int returnGuardSatisfiedIndex;
        AnnotatedTypeMirror returnTypeATM;
        ExecutableElement methodElement = TreeUtils.elementFromDeclaration(node);
        this.issueErrorIfMoreThanOneLockPreconditionMethodAnnotationPresent(methodElement, node);
        LockAnnotatedTypeFactory.SideEffectAnnotation sea = ((LockAnnotatedTypeFactory)this.atypeFactory).methodSideEffectAnnotation(methodElement, true);
        if (sea == LockAnnotatedTypeFactory.SideEffectAnnotation.MAYRELEASELOCKS) {
            boolean issueGSwithMRLWarning = false;
            VariableTree receiver = node.getReceiverParameter();
            if (receiver != null && ((LockAnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(receiver).hasAnnotation(this.checkerGuardSatisfiedClass)) {
                issueGSwithMRLWarning = true;
            }
            if (!issueGSwithMRLWarning) {
                for (VariableTree variableTree : node.getParameters()) {
                    if (!((LockAnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(variableTree).hasAnnotation(this.checkerGuardSatisfiedClass)) continue;
                    issueGSwithMRLWarning = true;
                    break;
                }
            }
            if (issueGSwithMRLWarning) {
                this.checker.report(Result.failure("guardsatisfied.with.mayreleaselocks", new Object[0]), node);
            }
        }
        if (methodElement != null && methodElement.getKind() != ElementKind.CONSTRUCTOR && (returnTypeATM = ((LockAnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(node).getReturnType()) != null && returnTypeATM.hasAnnotation(GuardSatisfied.class) && (returnGuardSatisfiedIndex = ((LockAnnotatedTypeFactory)this.atypeFactory).getGuardSatisfiedIndex(returnTypeATM)) == -1) {
            this.checker.report(Result.failure("guardsatisfied.return.must.have.index", new Object[0]), node);
        }
        if (!sea.isWeakerThan(LockAnnotatedTypeFactory.SideEffectAnnotation.LOCKINGFREE) && methodElement.getModifiers().contains((Object)Modifier.SYNCHRONIZED)) {
            this.checker.report(Result.failure("lockingfree.synchronized.method", new Object[]{sea}), node);
        }
        return super.visitMethod(node, p);
    }

    private void issueErrorIfMoreThanOneLockPreconditionMethodAnnotationPresent(ExecutableElement methodElement, MethodTree treeForErrorReporting) {
        int lockPreconditionAnnotationCount = 0;
        if (((LockAnnotatedTypeFactory)this.atypeFactory).getDeclAnnotation(methodElement, Holding.class) != null) {
            ++lockPreconditionAnnotationCount;
        }
        try {
            if (((LockAnnotatedTypeFactory)this.atypeFactory).jcipGuardedBy != null && ((LockAnnotatedTypeFactory)this.atypeFactory).getDeclAnnotation(methodElement, ((LockAnnotatedTypeFactory)this.atypeFactory).jcipGuardedBy) != null) {
                ++lockPreconditionAnnotationCount;
            }
            if (lockPreconditionAnnotationCount < 2 && ((LockAnnotatedTypeFactory)this.atypeFactory).javaxGuardedBy != null && ((LockAnnotatedTypeFactory)this.atypeFactory).getDeclAnnotation(methodElement, ((LockAnnotatedTypeFactory)this.atypeFactory).javaxGuardedBy) != null) {
                ++lockPreconditionAnnotationCount;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (lockPreconditionAnnotationCount > 1) {
            this.checker.report(Result.failure("multiple.lock.precondition.annotations", new Object[0]), treeForErrorReporting);
        }
    }

    @Override
    protected boolean skipReceiverSubtypeCheck(MethodInvocationTree methodInvocationTree, AnnotatedTypeMirror methodDefinitionReceiver, AnnotatedTypeMirror methodCallReceiver) {
        Set<AnnotationMirror> annos;
        AnnotationMirror guardSatisfied;
        AnnotationMirror primaryGbOnMethodDefinition;
        AnnotationMirror primaryGb = methodCallReceiver.getAnnotationInHierarchy(((LockAnnotatedTypeFactory)this.atypeFactory).GUARDEDBYUNKNOWN);
        AnnotationMirror effectiveGb = methodCallReceiver.getEffectiveAnnotationInHierarchy(((LockAnnotatedTypeFactory)this.atypeFactory).GUARDEDBYUNKNOWN);
        if (primaryGb != null && AnnotationUtils.areSameByClass(primaryGb, this.checkerGuardSatisfiedClass) && (primaryGbOnMethodDefinition = methodDefinitionReceiver.getAnnotationInHierarchy(((LockAnnotatedTypeFactory)this.atypeFactory).GUARDEDBYUNKNOWN)) != null && AnnotationUtils.areSameByClass(primaryGbOnMethodDefinition, this.checkerGuardSatisfiedClass)) {
            return true;
        }
        if (AnnotationUtils.areSameByClass(effectiveGb, this.checkerGuardedByClass) && (guardSatisfied = AnnotationUtils.getAnnotationByClass(annos = methodDefinitionReceiver.getAnnotations(), this.checkerGuardSatisfiedClass)) != null) {
            ExpressionTree receiverTree = TreeUtils.getReceiverTree(methodInvocationTree);
            if (receiverTree == null) {
                this.checkLockOfImplicitThis(methodInvocationTree, effectiveGb);
            } else {
                this.checkLock(receiverTree, effectiveGb);
            }
            return true;
        }
        return false;
    }

    @Override
    protected Set<? extends AnnotationMirror> getExceptionParameterLowerBoundAnnotations() {
        Set<? extends AnnotationMirror> tops = ((LockAnnotatedTypeFactory)this.atypeFactory).getQualifierHierarchy().getTopAnnotations();
        Set<AnnotationMirror> annotationSet = AnnotationUtils.createAnnotationSet();
        for (AnnotationMirror annotationMirror : tops) {
            if (AnnotationUtils.areSame(annotationMirror, ((LockAnnotatedTypeFactory)this.atypeFactory).GUARDEDBYUNKNOWN)) {
                annotationSet.add(((LockAnnotatedTypeFactory)this.atypeFactory).GUARDEDBY);
                continue;
            }
            annotationSet.add(annotationMirror);
        }
        return annotationSet;
    }

    @Override
    protected void checkConstructorResult(AnnotatedTypeMirror.AnnotatedExecutableType constructorType, ExecutableElement constructorElement) {
        AnnotationMirror anno = constructorType.getReturnType().getAnnotationInHierarchy(((LockAnnotatedTypeFactory)this.atypeFactory).GUARDEDBYUNKNOWN);
        if (!AnnotationUtils.areSame(anno, ((LockAnnotatedTypeFactory)this.atypeFactory).GUARDEDBY)) {
            super.checkConstructorResult(constructorType, constructorElement);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void commonAssignmentCheck(AnnotatedTypeMirror varType, AnnotatedTypeMirror valueType, Tree valueTree, @CompilerMessageKey String errorKey) {
        Tree.Kind valueTreeKind = valueTree.getKind();
        switch (valueTreeKind) {
            case NEW_CLASS: 
            case NEW_ARRAY: {
                if (varType.hasAnnotation(GuardedByBottom.class)) break;
                return;
            }
            case INT_LITERAL: 
            case LONG_LITERAL: 
            case FLOAT_LITERAL: 
            case DOUBLE_LITERAL: 
            case BOOLEAN_LITERAL: 
            case CHAR_LITERAL: 
            case STRING_LITERAL: {
                if (varType.hasAnnotation(GuardedByBottom.class)) break;
                return;
            }
        }
        if (varType.hasAnnotation(GuardSatisfied.class)) {
            if (valueType.hasAnnotation(GuardedBy.class)) {
                this.checkLock(valueTree, valueType.getAnnotation(GuardedBy.class));
                return;
            }
            if (valueType.hasAnnotation(GuardSatisfied.class)) {
                if (errorKey.equals("argument.type.incompatible")) return;
                int varTypeGuardSatisfiedIndex = ((LockAnnotatedTypeFactory)this.atypeFactory).getGuardSatisfiedIndex(varType);
                int valueTypeGuardSatisfiedIndex = ((LockAnnotatedTypeFactory)this.atypeFactory).getGuardSatisfiedIndex(valueType);
                if (varTypeGuardSatisfiedIndex == -1 && valueTypeGuardSatisfiedIndex == -1) {
                    this.checker.report(Result.failure("guardsatisfied.assignment.disallowed", varType, valueType), valueTree);
                }
            } else if (!((LockAnnotatedTypeFactory)this.atypeFactory).getTypeHierarchy().isSubtype(valueType, varType)) {
                AnnotatedTypeMirror varType2 = varType.deepCopy();
                varType2.replaceAnnotation(((LockAnnotatedTypeFactory)this.atypeFactory).GUARDEDBY);
                if (((LockAnnotatedTypeFactory)this.atypeFactory).getTypeHierarchy().isSubtype(valueType, varType2)) {
                    return;
                }
            }
        }
        super.commonAssignmentCheck(varType, valueType, valueTree, errorKey);
    }

    @Override
    public Void visitMemberSelect(MemberSelectTree tree, Void p) {
        AnnotatedTypeMirror atmOfReceiver;
        if (TreeUtils.isFieldAccess(tree) && (atmOfReceiver = ((LockAnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(tree.getExpression())).getKind() != TypeKind.VOID) {
            AnnotationMirror gb = atmOfReceiver.getEffectiveAnnotationInHierarchy(((LockAnnotatedTypeFactory)this.atypeFactory).GUARDEDBYUNKNOWN);
            this.checkLock(tree.getExpression(), gb);
        }
        return (Void)super.visitMemberSelect(tree, p);
    }

    private void reportFailure(@CompilerMessageKey String messageKey, MethodTree overriderTree, AnnotatedTypeMirror.AnnotatedDeclaredType enclosingType, AnnotatedTypeMirror.AnnotatedExecutableType overridden, AnnotatedTypeMirror.AnnotatedDeclaredType overriddenType, List<String> overriderLocks, List<String> overriddenLocks) {
        AnnotatedTypeMirror.AnnotatedExecutableType overrider = ((LockAnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(overriderTree);
        if (overrider.getTypeVariables().isEmpty() && !overridden.getTypeVariables().isEmpty()) {
            overridden = overridden.getErased();
        }
        String overriderMeth = overrider.toString();
        String overriderTyp = enclosingType.getUnderlyingType().asElement().toString();
        String overriddenMeth = overridden.toString();
        String overriddenTyp = overriddenType.getUnderlyingType().asElement().toString();
        if (overriderLocks == null || overriddenLocks == null) {
            this.checker.report(Result.failure(messageKey, overriderMeth, overriderTyp, overriddenMeth, overriddenTyp), overriderTree);
        } else {
            this.checker.report(Result.failure(messageKey, overriderMeth, overriderTyp, overriddenMeth, overriddenTyp, overriderLocks, overriddenLocks), overriderTree);
        }
    }

    @Override
    protected boolean checkOverride(MethodTree overriderTree, AnnotatedTypeMirror.AnnotatedDeclaredType enclosingType, AnnotatedTypeMirror.AnnotatedExecutableType overridden, AnnotatedTypeMirror.AnnotatedDeclaredType overriddenType) {
        LockAnnotatedTypeFactory.SideEffectAnnotation seaOfOverridenMethod;
        boolean isValid = true;
        LockAnnotatedTypeFactory.SideEffectAnnotation seaOfOverriderMethod = ((LockAnnotatedTypeFactory)this.atypeFactory).methodSideEffectAnnotation(TreeUtils.elementFromDeclaration(overriderTree), false);
        if (seaOfOverriderMethod.isWeakerThan(seaOfOverridenMethod = ((LockAnnotatedTypeFactory)this.atypeFactory).methodSideEffectAnnotation(overridden.getElement(), false))) {
            isValid = false;
            this.reportFailure("override.sideeffect.invalid", overriderTree, enclosingType, overridden, overriddenType, null, null);
        }
        return super.checkOverride(overriderTree, enclosingType, overridden, overriddenType) && isValid;
    }

    @Override
    public Void visitArrayAccess(ArrayAccessTree tree, Void p) {
        AnnotatedTypeMirror atmOfReceiver = ((LockAnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(tree.getExpression());
        AnnotationMirror gb = atmOfReceiver.getEffectiveAnnotationInHierarchy(((LockAnnotatedTypeFactory)this.atypeFactory).GUARDEDBYUNKNOWN);
        this.checkLock(tree.getExpression(), gb);
        return super.visitArrayAccess(tree, p);
    }

    @Override
    public boolean isValidUse(AnnotatedTypeMirror.AnnotatedDeclaredType declarationType, AnnotatedTypeMirror.AnnotatedDeclaredType useType, Tree tree) {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Void visitMethodInvocation(MethodInvocationTree node, Void p) {
        LockAnnotatedTypeFactory.SideEffectAnnotation seaOfContainingMethod;
        ExecutableElement methodElement = TreeUtils.elementFromUse(node);
        LockAnnotatedTypeFactory.SideEffectAnnotation seaOfInvokedMethod = ((LockAnnotatedTypeFactory)this.atypeFactory).methodSideEffectAnnotation(methodElement, false);
        MethodTree enclosingMethod = TreeUtils.enclosingMethod(((LockAnnotatedTypeFactory)this.atypeFactory).getPath(node));
        ExecutableElement enclosingMethodElement = null;
        if (enclosingMethod != null) {
            enclosingMethodElement = TreeUtils.elementFromDeclaration(enclosingMethod);
        }
        if (enclosingMethodElement != null && seaOfInvokedMethod.isWeakerThan(seaOfContainingMethod = ((LockAnnotatedTypeFactory)this.atypeFactory).methodSideEffectAnnotation(enclosingMethodElement, false))) {
            this.checker.report(Result.failure("method.guarantee.violated", seaOfContainingMethod.getNameOfSideEffectAnnotation(), enclosingMethodElement.toString(), methodElement.toString(), seaOfInvokedMethod.getNameOfSideEffectAnnotation()), node);
        }
        if (methodElement != null) {
            AnnotationMirror ensuresLockHeldIfAnno;
            ExpressionTree recvTree = TreeUtils.getReceiverTree(node);
            this.ensureReceiverOfExplicitUnlockCallIsEffectivelyFinal(methodElement, recvTree);
            AnnotationMirror ensuresLockHeldAnno = ((LockAnnotatedTypeFactory)this.atypeFactory).getDeclAnnotation(methodElement, EnsuresLockHeld.class);
            ArrayList<String> expressions = new ArrayList<String>();
            if (ensuresLockHeldAnno != null) {
                expressions.addAll(AnnotationUtils.getElementValueArray(ensuresLockHeldAnno, "value", String.class, false));
            }
            if ((ensuresLockHeldIfAnno = ((LockAnnotatedTypeFactory)this.atypeFactory).getDeclAnnotation(methodElement, EnsuresLockHeldIf.class)) != null) {
                expressions.addAll(AnnotationUtils.getElementValueArray(ensuresLockHeldIfAnno, "expression", String.class, false));
            }
            for (String expr : expressions) {
                ExpressionTree firstParameter;
                if (expr.equals("this")) {
                    if (recvTree == null) continue;
                    this.ensureExpressionIsEffectivelyFinal(recvTree);
                    continue;
                }
                if (!expr.equals("#1") || (firstParameter = node.getArguments().get(0)) == null) continue;
                this.ensureExpressionIsEffectivelyFinal(firstParameter);
            }
        }
        AnnotatedTypeFactory.ParameterizedExecutableType mType = ((LockAnnotatedTypeFactory)this.atypeFactory).methodFromUse(node);
        AnnotatedTypeMirror.AnnotatedExecutableType invokedMethod = mType.executableType;
        List<AnnotatedTypeMirror> requiredArgs = AnnotatedTypes.expandVarArgs(this.atypeFactory, invokedMethod, node.getArguments());
        int[] guardSatisfiedIndex = new int[requiredArgs.size() + 1];
        guardSatisfiedIndex[0] = -1;
        AnnotatedTypeMirror.AnnotatedDeclaredType methodDefinitionReceiver = null;
        AnnotatedTypeMirror methodCallReceiver = null;
        ExecutableElement invokedMethodElement = invokedMethod.getElement();
        if (!ElementUtils.isStatic(invokedMethodElement) && invokedMethod.getElement().getKind() != ElementKind.CONSTRUCTOR && (methodDefinitionReceiver = invokedMethod.getReceiverType()) != null && methodDefinitionReceiver.hasAnnotation(this.checkerGuardSatisfiedClass)) {
            guardSatisfiedIndex[0] = ((LockAnnotatedTypeFactory)this.atypeFactory).getGuardSatisfiedIndex(methodDefinitionReceiver);
            methodCallReceiver = ((LockAnnotatedTypeFactory)this.atypeFactory).getReceiverType(node);
        }
        for (int i = 0; i < requiredArgs.size(); ++i) {
            guardSatisfiedIndex[i + 1] = -1;
            AnnotatedTypeMirror arg = requiredArgs.get(i);
            if (!arg.hasAnnotation(this.checkerGuardSatisfiedClass)) continue;
            guardSatisfiedIndex[i + 1] = ((LockAnnotatedTypeFactory)this.atypeFactory).getGuardSatisfiedIndex(arg);
        }
        ArrayList<AnnotationMirror> passedArgAnnotations = new ArrayList<AnnotationMirror>(guardSatisfiedIndex.length);
        passedArgAnnotations.add(methodCallReceiver == null ? null : methodCallReceiver.getAnnotationInHierarchy(((LockAnnotatedTypeFactory)this.atypeFactory).GUARDEDBYUNKNOWN));
        for (ExpressionTree expressionTree : node.getArguments()) {
            passedArgAnnotations.add(((LockAnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(expressionTree).getAnnotationInHierarchy(((LockAnnotatedTypeFactory)this.atypeFactory).GUARDEDBYUNKNOWN));
        }
        for (int i = 0; i < guardSatisfiedIndex.length; ++i) {
            void var16_20;
            if (guardSatisfiedIndex[i] == -1) continue;
            int n = i + 1;
            while (var16_20 < guardSatisfiedIndex.length) {
                if (guardSatisfiedIndex[i] == guardSatisfiedIndex[var16_20]) {
                    AnnotationMirror arg1Anno = (AnnotationMirror)passedArgAnnotations.get(i);
                    AnnotationMirror arg2Anno = (AnnotationMirror)passedArgAnnotations.get((int)var16_20);
                    if (arg1Anno != null && arg2Anno != null) {
                        boolean bothAreGSwithNoIndex = false;
                        if (AnnotationUtils.areSameByClass(arg1Anno, this.checkerGuardSatisfiedClass) && AnnotationUtils.areSameByClass(arg2Anno, this.checkerGuardSatisfiedClass) && ((LockAnnotatedTypeFactory)this.atypeFactory).getGuardSatisfiedIndex(arg1Anno) == -1 && ((LockAnnotatedTypeFactory)this.atypeFactory).getGuardSatisfiedIndex(arg2Anno) == -1) {
                            bothAreGSwithNoIndex = true;
                        }
                        if (bothAreGSwithNoIndex || !((LockAnnotatedTypeFactory)this.atypeFactory).getQualifierHierarchy().isSubtype(arg1Anno, arg2Anno) && !((LockAnnotatedTypeFactory)this.atypeFactory).getQualifierHierarchy().isSubtype(arg2Anno, arg1Anno)) {
                            String formalParam1 = null;
                            formalParam1 = i == 0 ? "The receiver type" : "Parameter #" + i;
                            String formalParam2 = "parameter #" + (int)var16_20;
                            this.checker.report(Result.failure("guardsatisfied.parameters.must.match", formalParam1, formalParam2, invokedMethod.toString(), guardSatisfiedIndex[i], arg1Anno, arg2Anno), node);
                        }
                    }
                }
                ++var16_20;
            }
        }
        return super.visitMethodInvocation(node, p);
    }

    private void ensureReceiverOfExplicitUnlockCallIsEffectivelyFinal(ExecutableElement methodElement, ExpressionTree lockExpression) {
        if (lockExpression == null) {
            return;
        }
        if (!methodElement.getSimpleName().contentEquals("unlock")) {
            return;
        }
        TypeMirror lockExpressionType = TreeUtils.typeOf(lockExpression);
        ProcessingEnvironment processingEnvironment = this.checker.getProcessingEnvironment();
        Types types = processingEnvironment.getTypeUtils();
        TypeMirror lockInterfaceTypeMirror = TypesUtils.typeFromClass(Lock.class, types, processingEnvironment.getElementUtils());
        if (types.isSubtype(types.erasure(lockExpressionType), lockInterfaceTypeMirror)) {
            this.ensureExpressionIsEffectivelyFinal(lockExpression);
        }
    }

    @Override
    public Void visitSynchronized(SynchronizedTree node, Void p) {
        LockAnnotatedTypeFactory.SideEffectAnnotation seaOfContainingMethod;
        ProcessingEnvironment processingEnvironment = this.checker.getProcessingEnvironment();
        Types types = processingEnvironment.getTypeUtils();
        TypeMirror lockInterfaceTypeMirror = TypesUtils.typeFromClass(Lock.class, types, processingEnvironment.getElementUtils());
        ExpressionTree synchronizedExpression = node.getExpression();
        this.ensureExpressionIsEffectivelyFinal(synchronizedExpression);
        TypeMirror expressionType = types.erasure(((LockAnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(synchronizedExpression).getUnderlyingType());
        if (types.isSubtype(expressionType, lockInterfaceTypeMirror)) {
            this.checker.report(Result.failure("explicit.lock.synchronized", new Object[0]), node);
        }
        MethodTree enclosingMethod = TreeUtils.enclosingMethod(((LockAnnotatedTypeFactory)this.atypeFactory).getPath(node));
        ExecutableElement methodElement = null;
        if (enclosingMethod != null && !(seaOfContainingMethod = ((LockAnnotatedTypeFactory)this.atypeFactory).methodSideEffectAnnotation(methodElement = TreeUtils.elementFromDeclaration(enclosingMethod), false)).isWeakerThan(LockAnnotatedTypeFactory.SideEffectAnnotation.LOCKINGFREE)) {
            this.checker.report(Result.failure("synchronized.block.in.lockingfree.method", new Object[]{seaOfContainingMethod}), node);
        }
        return (Void)super.visitSynchronized(node, p);
    }

    private void ensureExpressionIsEffectivelyFinal(ExpressionTree lockExpressionTree) {
        ExpressionTree tree = lockExpressionTree;
        block5: while (true) {
            tree = TreeUtils.withoutParens(tree);
            switch (tree.getKind()) {
                case MEMBER_SELECT: {
                    if (!this.isTreeSymbolEffectivelyFinalOrUnmodifiable(tree)) {
                        this.checker.report(Result.failure("lock.expression.not.final", lockExpressionTree), tree);
                        return;
                    }
                    tree = ((MemberSelectTree)tree).getExpression();
                    continue block5;
                }
                case IDENTIFIER: {
                    if (!this.isTreeSymbolEffectivelyFinalOrUnmodifiable(tree)) {
                        this.checker.report(Result.failure("lock.expression.not.final", lockExpressionTree), tree);
                    }
                    return;
                }
                case METHOD_INVOCATION: {
                    Element elem = TreeUtils.elementFromUse(tree);
                    if (((LockAnnotatedTypeFactory)this.atypeFactory).getDeclAnnotationNoAliases(elem, Deterministic.class) == null && ((LockAnnotatedTypeFactory)this.atypeFactory).getDeclAnnotationNoAliases(elem, Pure.class) == null) {
                        this.checker.report(Result.failure("lock.expression.not.final", lockExpressionTree), tree);
                        return;
                    }
                    MethodInvocationTree methodInvocationTree = (MethodInvocationTree)tree;
                    for (ExpressionTree expressionTree : methodInvocationTree.getArguments()) {
                        this.ensureExpressionIsEffectivelyFinal(expressionTree);
                    }
                    tree = methodInvocationTree.getMethodSelect();
                    continue block5;
                }
            }
            break;
        }
        this.checker.report(Result.failure("lock.expression.possibly.not.final", lockExpressionTree), tree);
    }

    private void ensureExpressionIsEffectivelyFinal(FlowExpressions.Receiver lockExpr, String expressionForErrorReporting, Tree treeForErrorReporting) {
        if (!((LockAnnotatedTypeFactory)this.atypeFactory).isExpressionEffectivelyFinal(lockExpr)) {
            this.checker.report(Result.failure("lock.expression.not.final", expressionForErrorReporting), treeForErrorReporting);
        }
    }

    @Override
    public Void visitAnnotation(AnnotationTree tree, Void p) {
        ArrayList<AnnotationTree> annotationTreeList = new ArrayList<AnnotationTree>(1);
        annotationTreeList.add(tree);
        List<AnnotationMirror> amList = TreeUtils.annotationsFromTypeAnnotationTrees(annotationTreeList);
        if (amList != null) {
            for (AnnotationMirror annotationMirror : amList) {
                if (!AnnotationUtils.areSameByClass(annotationMirror, this.checkerGuardSatisfiedClass)) continue;
                this.issueErrorIfGuardSatisfiedAnnotationInUnsupportedLocation(tree);
            }
        }
        return super.visitAnnotation(tree, p);
    }

    private void issueErrorIfGuardSatisfiedAnnotationInUnsupportedLocation(AnnotationTree annotationTree) {
        TreePath currentPath = this.getCurrentPath();
        TreePath path = this.getPathForLocalVariableRetrieval(currentPath);
        if (path != null) {
            AnnotatedTypeTree annotatedTypeTree;
            Tree.Kind varTypeTreeKind;
            TreePath parentPath;
            VariableTree varTree;
            Tree varTypeTree;
            Tree tree = path.getLeaf();
            Tree.Kind kind = tree.getKind();
            if (kind == Tree.Kind.METHOD) {
                return;
            }
            if (kind == Tree.Kind.VARIABLE && (varTypeTree = (varTree = (VariableTree)tree).getType()) != null && (parentPath = path.getParentPath()) != null && parentPath.getLeaf().getKind() == Tree.Kind.METHOD && ((varTypeTreeKind = varTypeTree.getKind()) == Tree.Kind.ANNOTATED_TYPE ? (annotatedTypeTree = (AnnotatedTypeTree)varTypeTree).getUnderlyingType().getKind() != Tree.Kind.ARRAY_TYPE || annotatedTypeTree.getAnnotations().contains(annotationTree) : varTypeTreeKind != Tree.Kind.ARRAY_TYPE)) {
                return;
            }
        }
        this.checker.report(Result.failure("guardsatisfied.location.disallowed", new Object[0]), annotationTree);
    }

    private TreePath getPathForLocalVariableRetrieval(TreePath path) {
        assert (path.getLeaf() instanceof AnnotationTree);
        if ((path = path.getParentPath()) == null) {
            return null;
        }
        if ((path = path.getParentPath()) == null) {
            return null;
        }
        Tree tree = path.getLeaf();
        Tree.Kind kind = tree.getKind();
        switch (kind) {
            case NEW_ARRAY: 
            case ARRAY_TYPE: 
            case VARIABLE: 
            case TYPE_CAST: 
            case INSTANCE_OF: 
            case METHOD: 
            case TYPE_PARAMETER: {
                return path;
            }
        }
        return null;
    }

    private boolean isTreeSymbolEffectivelyFinalOrUnmodifiable(Tree tree) {
        Element elem = TreeUtils.elementFromTree(tree);
        ElementKind ek = elem.getKind();
        return ek == ElementKind.PACKAGE || ek == ElementKind.CLASS || ek == ElementKind.METHOD || ElementUtils.isEffectivelyFinal(elem);
    }

    @Override
    public Void visitIdentifier(IdentifierTree tree, Void p) {
        Tree parent;
        if (TreeUtils.isFieldAccess(tree) && ((parent = this.getCurrentPath().getParentPath().getLeaf()).getKind() != Tree.Kind.MEMBER_SELECT || ((MemberSelectTree)parent).getExpression() == tree)) {
            AnnotationMirror guardedBy = ((LockAnnotatedTypeFactory)this.atypeFactory).getSelfType(tree).getAnnotationInHierarchy(((LockAnnotatedTypeFactory)this.atypeFactory).GUARDEDBY);
            this.checkLockOfImplicitThis(tree, guardedBy);
        }
        return super.visitIdentifier(tree, p);
    }

    @Override
    public Void visitBinary(BinaryTree binaryTree, Void p) {
        if (TreeUtils.isStringConcatenation(binaryTree)) {
            ExpressionTree leftTree = binaryTree.getLeftOperand();
            ExpressionTree rightTree = binaryTree.getRightOperand();
            boolean lhsIsString = TypesUtils.isString(TreeUtils.typeOf(leftTree));
            boolean rhsIsString = TypesUtils.isString(TreeUtils.typeOf(rightTree));
            if (!lhsIsString) {
                this.checkPreconditionsForImplicitToStringCall(leftTree);
            } else if (!rhsIsString) {
                this.checkPreconditionsForImplicitToStringCall(rightTree);
            }
        }
        return (Void)super.visitBinary(binaryTree, p);
    }

    @Override
    public Void visitCompoundAssignment(CompoundAssignmentTree node, Void p) {
        ExpressionTree rightTree;
        if (TreeUtils.isStringCompoundConcatenation(node) && !TypesUtils.isString(TreeUtils.typeOf(rightTree = node.getExpression()))) {
            this.checkPreconditionsForImplicitToStringCall(rightTree);
        }
        return super.visitCompoundAssignment(node, p);
    }

    private void checkPreconditionsForImplicitToStringCall(ExpressionTree tree) {
        AnnotationMirror gbAnno = ((LockAnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(tree).getEffectiveAnnotationInHierarchy(((LockAnnotatedTypeFactory)this.atypeFactory).GUARDEDBY);
        this.checkLock(tree, gbAnno);
    }

    private void checkLockOfImplicitThis(Tree tree, AnnotationMirror gbAnno) {
        this.checkLockOfThisOrTree(tree, true, gbAnno);
    }

    private void checkLock(Tree tree, AnnotationMirror gbAnno) {
        this.checkLockOfThisOrTree(tree, false, gbAnno);
    }

    private void checkLockOfThisOrTree(Tree tree, boolean implicitThis, AnnotationMirror gbAnno) {
        if (gbAnno == null) {
            throw new BugInCF("LockVisitor.checkLock: gbAnno cannot be null");
        }
        if (AnnotationUtils.areSameByClass(gbAnno, GuardedByUnknown.class) || AnnotationUtils.areSameByClass(gbAnno, GuardedByBottom.class)) {
            this.checker.report(Result.failure("lock.not.held", "unknown lock " + gbAnno), tree);
            return;
        }
        if (AnnotationUtils.areSameByClass(gbAnno, GuardSatisfied.class)) {
            return;
        }
        List<LockExpression> expressions = this.getLockExpressions(implicitThis, gbAnno, tree);
        if (expressions.isEmpty()) {
            return;
        }
        LockStore store = (LockStore)((LockAnnotatedTypeFactory)this.atypeFactory).getStoreBefore(tree);
        for (LockExpression expression : expressions) {
            if (expression.error != null) {
                this.checker.report(Result.failure("expression.unparsable.type.invalid", expression.error.toString()), tree);
            } else if (expression.lockExpression == null) {
                this.checker.report(Result.failure("expression.unparsable.type.invalid", expression.expressionString), tree);
            } else if (!this.isLockHeld(expression.lockExpression, store)) {
                this.checker.report(Result.failure("lock.not.held", expression.lockExpression.toString()), tree);
            }
            if (expression.error == null || expression.lockExpression == null) continue;
            this.ensureExpressionIsEffectivelyFinal(expression.lockExpression, expression.expressionString, tree);
        }
    }

    private boolean isLockHeld(FlowExpressions.Receiver lock, LockStore store) {
        if (store == null) {
            return false;
        }
        CFValue value = store.getValue(lock);
        if (value == null) {
            return false;
        }
        Set<AnnotationMirror> annos = value.getAnnotations();
        QualifierHierarchy hierarchy = ((LockAnnotatedTypeFactory)this.atypeFactory).getQualifierHierarchy();
        AnnotationMirror lockAnno = hierarchy.findAnnotationInSameHierarchy(annos, ((LockAnnotatedTypeFactory)this.atypeFactory).LOCKHELD);
        return lockAnno != null && AnnotationUtils.areSameByClass(lockAnno, LockHeld.class);
    }

    private List<LockExpression> getLockExpressions(boolean implicitThis, AnnotationMirror gbAnno, Tree tree) {
        List<String> expressions = AnnotationUtils.getElementValueArray(gbAnno, "value", String.class, true);
        if (expressions.isEmpty()) {
            return Collections.emptyList();
        }
        TreePath currentPath = this.getCurrentPath();
        List<FlowExpressions.Receiver> params = FlowExpressions.getParametersOfEnclosingMethod(this.atypeFactory, currentPath);
        TypeMirror enclosingType = TreeUtils.typeOf(TreeUtils.enclosingClass(currentPath));
        FlowExpressions.Receiver pseudoReceiver = FlowExpressions.internalReprOfPseudoReceiver(currentPath, enclosingType);
        FlowExpressionParseUtil.FlowExpressionContext exprContext = new FlowExpressionParseUtil.FlowExpressionContext(pseudoReceiver, params, ((LockAnnotatedTypeFactory)this.atypeFactory).getContext());
        FlowExpressions.Receiver self = implicitThis ? pseudoReceiver : (TreeUtils.isExpressionTree(tree) ? FlowExpressions.internalReprOf((AnnotationProvider)this.atypeFactory, (ExpressionTree)tree) : new FlowExpressions.Unknown(TreeUtils.typeOf(tree)));
        ArrayList<LockExpression> lockExpressions = new ArrayList<LockExpression>();
        for (String expression : expressions) {
            lockExpressions.add(this.parseExpressionString(expression, exprContext, currentPath, self));
        }
        return lockExpressions;
    }

    private LockExpression parseExpressionString(String expression, FlowExpressionParseUtil.FlowExpressionContext flowExprContext, TreePath path, FlowExpressions.Receiver itself) {
        LockExpression lockExpression = new LockExpression(expression);
        if (DependentTypesError.isExpressionError(expression)) {
            lockExpression.error = DependentTypesError.unparse(expression);
            return lockExpression;
        }
        Matcher selfReceiverMatcher = SELF_RECEIVER_PATTERN.matcher(expression);
        try {
            if (selfReceiverMatcher.matches()) {
                String remainingExpression = selfReceiverMatcher.group(2);
                if (remainingExpression == null || remainingExpression.isEmpty()) {
                    lockExpression.lockExpression = itself;
                    if (!((LockAnnotatedTypeFactory)this.atypeFactory).isExpressionEffectivelyFinal(lockExpression.lockExpression)) {
                        this.checker.report(Result.failure("lock.expression.not.final", lockExpression.lockExpression), path.getLeaf());
                    }
                    return lockExpression;
                }
                lockExpression.lockExpression = FlowExpressionParseUtil.parse(itself.toString() + "." + remainingExpression, flowExprContext, path, true);
                if (!((LockAnnotatedTypeFactory)this.atypeFactory).isExpressionEffectivelyFinal(lockExpression.lockExpression)) {
                    this.checker.report(Result.failure("lock.expression.not.final", lockExpression.lockExpression), path.getLeaf());
                }
                return lockExpression;
            }
            lockExpression.lockExpression = FlowExpressionParseUtil.parse(expression, flowExprContext, path, true);
            return lockExpression;
        }
        catch (FlowExpressionParseUtil.FlowExpressionParseException ex) {
            lockExpression.error = new DependentTypesError(expression, ex);
            return lockExpression;
        }
    }

    private static class LockExpression {
        final String expressionString;
        FlowExpressions.Receiver lockExpression = null;
        DependentTypesError error = null;

        LockExpression(String expression) {
            this.expressionString = expression;
        }
    }
}

