/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.interning;

import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.checker.interning.qual.InternMethod;
import org.checkerframework.checker.interning.qual.Interned;
import org.checkerframework.checker.interning.qual.UnknownInterned;
import org.checkerframework.common.basetype.BaseAnnotatedTypeFactory;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.treeannotator.ListTreeAnnotator;
import org.checkerframework.framework.type.treeannotator.TreeAnnotator;
import org.checkerframework.framework.type.typeannotator.DefaultQualifierForUseTypeAnnotator;
import org.checkerframework.framework.type.typeannotator.ListTypeAnnotator;
import org.checkerframework.framework.type.typeannotator.TypeAnnotator;
import org.checkerframework.framework.util.AnnotationMirrorSet;
import org.checkerframework.javacutil.AnnotationBuilder;
import org.checkerframework.javacutil.ElementUtils;
import org.checkerframework.javacutil.TreeUtils;

public class InterningAnnotatedTypeFactory
extends BaseAnnotatedTypeFactory {
    final AnnotationMirror TOP;
    final AnnotationMirror INTERNED;

    public InterningAnnotatedTypeFactory(BaseTypeChecker checker) {
        super(checker);
        this.TOP = AnnotationBuilder.fromClass(this.elements, UnknownInterned.class);
        this.INTERNED = AnnotationBuilder.fromClass(this.elements, Interned.class);
        this.addAliasedAnnotation("com.sun.istack.internal.Interned", this.INTERNED);
        this.postInit();
    }

    @Override
    protected DefaultQualifierForUseTypeAnnotator createDefaultForUseTypeAnnotator() {
        return new InterningDefaultQualifierForUseTypeAnnotator(this);
    }

    @Override
    public Set<AnnotationMirror> getTypeDeclarationBounds(TypeMirror typeMirror) {
        if (typeMirror.getKind() == TypeKind.DECLARED && ((DeclaredType)typeMirror).asElement().getKind() == ElementKind.ENUM) {
            return AnnotationMirrorSet.singleElementSet(this.INTERNED);
        }
        return super.getTypeDeclarationBounds(typeMirror);
    }

    @Override
    protected TreeAnnotator createTreeAnnotator() {
        return new ListTreeAnnotator(super.createTreeAnnotator(), new InterningTreeAnnotator(this));
    }

    @Override
    protected TypeAnnotator createTypeAnnotator() {
        return new ListTypeAnnotator(new InterningTypeAnnotator(this), super.createTypeAnnotator());
    }

    @Override
    public void addComputedTypeAnnotations(Tree tree, AnnotatedTypeMirror type, boolean useFlow) {
        Element element = TreeUtils.elementFromTree(tree);
        if (!type.isAnnotatedInHierarchy(this.INTERNED) && ElementUtils.isCompileTimeConstant(element)) {
            type.addAnnotation(this.INTERNED);
        }
        super.addComputedTypeAnnotations(tree, type, useFlow);
    }

    @Override
    public void addComputedTypeAnnotations(Element element, AnnotatedTypeMirror type) {
        if (!type.isAnnotatedInHierarchy(this.INTERNED) && ElementUtils.isCompileTimeConstant(element)) {
            type.addAnnotation(this.INTERNED);
        }
        super.addComputedTypeAnnotations(element, type);
    }

    @Override
    public AnnotatedTypeMirror.AnnotatedPrimitiveType getUnboxedType(AnnotatedTypeMirror.AnnotatedDeclaredType type) {
        AnnotatedTypeMirror.AnnotatedPrimitiveType primitive = super.getUnboxedType(type);
        primitive.replaceAnnotation(this.INTERNED);
        return primitive;
    }

    private class InterningTypeAnnotator
    extends TypeAnnotator {
        InterningTypeAnnotator(InterningAnnotatedTypeFactory atypeFactory) {
            super(atypeFactory);
        }

        @Override
        public Void visitDeclared(AnnotatedTypeMirror.AnnotatedDeclaredType t, Void p) {
            Element elt = t.getUnderlyingType().asElement();
            assert (elt != null);
            if (elt.getKind() == ElementKind.ENUM) {
                t.replaceAnnotation(InterningAnnotatedTypeFactory.this.INTERNED);
            }
            return (Void)super.visitDeclared(t, p);
        }
    }

    private class InterningTreeAnnotator
    extends TreeAnnotator {
        InterningTreeAnnotator(InterningAnnotatedTypeFactory atypeFactory) {
            super(atypeFactory);
        }

        @Override
        public Void visitBinary(BinaryTree node, AnnotatedTypeMirror type) {
            if (TreeUtils.isCompileTimeString(node)) {
                type.replaceAnnotation(InterningAnnotatedTypeFactory.this.INTERNED);
            } else if (TreeUtils.isStringConcatenation(node)) {
                type.replaceAnnotation(InterningAnnotatedTypeFactory.this.TOP);
            } else if (type.getKind().isPrimitive() || node.getKind() == Tree.Kind.EQUAL_TO || node.getKind() == Tree.Kind.NOT_EQUAL_TO) {
                type.replaceAnnotation(InterningAnnotatedTypeFactory.this.INTERNED);
            } else {
                type.replaceAnnotation(InterningAnnotatedTypeFactory.this.TOP);
            }
            return super.visitBinary(node, type);
        }

        @Override
        public Void visitCompoundAssignment(CompoundAssignmentTree node, AnnotatedTypeMirror type) {
            type.replaceAnnotation(InterningAnnotatedTypeFactory.this.TOP);
            return (Void)super.visitCompoundAssignment(node, type);
        }
    }

    static class InterningDefaultQualifierForUseTypeAnnotator
    extends DefaultQualifierForUseTypeAnnotator {
        public InterningDefaultQualifierForUseTypeAnnotator(AnnotatedTypeFactory typeFactory) {
            super(typeFactory);
        }

        @Override
        public Void visitExecutable(AnnotatedTypeMirror.AnnotatedExecutableType type, Void p) {
            Symbol.MethodSymbol methodElt = (Symbol.MethodSymbol)type.getElement();
            if (methodElt == null || methodElt.getKind() != ElementKind.CONSTRUCTOR) {
                this.scan(type.getReturnType(), p);
            }
            if (type.getReceiverType() != null && this.typeFactory.getDeclAnnotation(methodElt, InternMethod.class) == null) {
                this.scanAndReduce(type.getReceiverType(), p, null);
            }
            this.scanAndReduce(type.getParameterTypes(), p, null);
            this.scanAndReduce(type.getThrownTypes(), p, null);
            this.scanAndReduce(type.getTypeVariables(), p, null);
            return null;
        }
    }
}

