/*
 * Decompiled with CFR 0.152.
 */
package annotator.scanner;

import annotator.scanner.CastScanner;
import annotator.scanner.InstanceOfScanner;
import annotator.scanner.LambdaScanner;
import annotator.scanner.LocalVariableScanner;
import annotator.scanner.MethodCallScanner;
import annotator.scanner.NewScanner;
import com.sun.tools.javac.util.Pair;
import org.checkerframework.org.objectweb.asmx.ClassReader;
import org.checkerframework.org.objectweb.asmx.ClassWriter;
import org.checkerframework.org.objectweb.asmx.Handle;
import org.checkerframework.org.objectweb.asmx.Label;
import org.checkerframework.org.objectweb.asmx.MethodAdapter;
import org.checkerframework.org.objectweb.asmx.MethodVisitor;
import scenelib.annotations.io.classfile.CodeOffsetAdapter;

public class MethodOffsetClassVisitor
extends ClassWriter {
    CodeOffsetAdapter codeOffsetAdapter;
    MethodVisitor methodCodeOffsetAdapter;
    private String methodName = "LocalVariableVisitor: DEFAULT_METHOD";

    public MethodOffsetClassVisitor(ClassReader classReader) {
        super(true, false);
        this.codeOffsetAdapter = new CodeOffsetAdapter(classReader);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        this.methodName = name + descriptor.substring(0, descriptor.indexOf(")") + 1);
        this.methodCodeOffsetAdapter = this.codeOffsetAdapter.visitMethod(access, name, descriptor, signature, exceptions);
        return new MethodOffsetMethodVisitor(super.visitMethod(access, name, descriptor, signature, exceptions));
    }

    private class MethodOffsetMethodVisitor
    extends MethodAdapter {
        private Label lastLabel;

        public MethodOffsetMethodVisitor(MethodVisitor mv) {
            super(mv);
            this.lastLabel = null;
        }

        private int labelOffset() {
            try {
                return this.lastLabel.getOffset();
            }
            catch (Exception ex) {
                return 0;
            }
        }

        @Override
        public void visitLocalVariable(String name, String descriptor, String signature, Label start, Label end, int index) {
            super.visitLocalVariable(name, descriptor, signature, start, end, index);
            LocalVariableScanner.addToMethodNameIndexMap(Pair.of(MethodOffsetClassVisitor.this.methodName, Pair.of(index, start.getOffset())), name);
            LocalVariableScanner.addToMethodNameCounter(MethodOffsetClassVisitor.this.methodName, name, start.getOffset());
            MethodOffsetClassVisitor.this.methodCodeOffsetAdapter.visitLocalVariable(name, descriptor, signature, start, end, index);
        }

        @Override
        public void visitLabel(Label label) {
            super.visitLabel(label);
            this.lastLabel = label;
            MethodOffsetClassVisitor.this.methodCodeOffsetAdapter.visitLabel(label);
        }

        @Override
        public void visitTypeInsn(int opcode, String descriptor) {
            super.visitTypeInsn(opcode, descriptor);
            switch (opcode) {
                case 192: {
                    CastScanner.addCastToMethod(MethodOffsetClassVisitor.this.methodName, MethodOffsetClassVisitor.this.codeOffsetAdapter.getMethodCodeOffset());
                    break;
                }
                case 187: 
                case 189: {
                    NewScanner.addNewToMethod(MethodOffsetClassVisitor.this.methodName, this.labelOffset());
                    break;
                }
                case 193: {
                    InstanceOfScanner.addInstanceOfToMethod(MethodOffsetClassVisitor.this.methodName, this.labelOffset() + 1);
                }
            }
            MethodOffsetClassVisitor.this.methodCodeOffsetAdapter.visitTypeInsn(opcode, descriptor);
        }

        @Override
        public void visitMultiANewArrayInsn(String descriptor, int dims) {
            super.visitMultiANewArrayInsn(descriptor, dims);
            NewScanner.addNewToMethod(MethodOffsetClassVisitor.this.methodName, this.labelOffset());
            MethodOffsetClassVisitor.this.methodCodeOffsetAdapter.visitMultiANewArrayInsn(descriptor, dims);
        }

        @Override
        public void visitIntInsn(int opcode, int operand) {
            super.visitIntInsn(opcode, operand);
            if (opcode == 188) {
                NewScanner.addNewToMethod(MethodOffsetClassVisitor.this.methodName, this.labelOffset());
            }
            MethodOffsetClassVisitor.this.methodCodeOffsetAdapter.visitIntInsn(opcode, operand);
        }

        @Override
        public void visitMethodInsn(int opcode, String owner, String name, String descriptor) {
            super.visitMethodInsn(opcode, owner, name, descriptor);
            switch (opcode) {
                case 182: 
                case 184: 
                case 185: {
                    MethodCallScanner.addMethodCallToMethod(MethodOffsetClassVisitor.this.methodName, this.labelOffset());
                    break;
                }
            }
            MethodOffsetClassVisitor.this.methodCodeOffsetAdapter.visitMethodInsn(opcode, owner, name, descriptor);
        }

        @Override
        public void visitInvokeDynamicInsn(String name, String descriptor, Handle bsm, Object ... bsmArgs) {
            super.visitInvokeDynamicInsn(name, descriptor, bsm, bsmArgs);
            LambdaScanner.addLambdaExpressionToMethod(MethodOffsetClassVisitor.this.methodName, this.labelOffset());
            MethodOffsetClassVisitor.this.methodCodeOffsetAdapter.visitInvokeDynamicInsn(name, descriptor, bsm, bsmArgs);
        }

        @Override
        public void visitCode() {
            super.visitCode();
            MethodOffsetClassVisitor.this.methodCodeOffsetAdapter.visitCode();
        }

        @Override
        public void visitInsn(int opcode) {
            super.visitInsn(opcode);
            MethodOffsetClassVisitor.this.methodCodeOffsetAdapter.visitInsn(opcode);
        }

        @Override
        public void visitVarInsn(int opcode, int var) {
            super.visitVarInsn(opcode, var);
            MethodOffsetClassVisitor.this.methodCodeOffsetAdapter.visitVarInsn(opcode, var);
        }

        @Override
        public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
            super.visitFieldInsn(opcode, owner, name, descriptor);
            MethodOffsetClassVisitor.this.methodCodeOffsetAdapter.visitFieldInsn(opcode, owner, name, descriptor);
        }

        @Override
        public void visitJumpInsn(int opcode, Label label) {
            super.visitJumpInsn(opcode, label);
            MethodOffsetClassVisitor.this.methodCodeOffsetAdapter.visitJumpInsn(opcode, label);
        }

        @Override
        public void visitLdcInsn(Object cst) {
            super.visitLdcInsn(cst);
            MethodOffsetClassVisitor.this.methodCodeOffsetAdapter.visitLdcInsn(cst);
        }

        @Override
        public void visitIincInsn(int var, int increment) {
            super.visitIincInsn(var, increment);
            MethodOffsetClassVisitor.this.methodCodeOffsetAdapter.visitIincInsn(var, increment);
        }

        @Override
        public void visitTableSwitchInsn(int min2, int max, Label dflt, Label[] labels) {
            super.visitTableSwitchInsn(min2, max, dflt, labels);
            MethodOffsetClassVisitor.this.methodCodeOffsetAdapter.visitTableSwitchInsn(min2, max, dflt, labels);
        }

        @Override
        public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
            super.visitLookupSwitchInsn(dflt, keys, labels);
            MethodOffsetClassVisitor.this.methodCodeOffsetAdapter.visitLookupSwitchInsn(dflt, keys, labels);
        }

        @Override
        public void visitEnd() {
            super.visitEnd();
            MethodOffsetClassVisitor.this.methodCodeOffsetAdapter.visitEnd();
        }
    }
}

