/*
 * Decompiled with CFR 0.152.
 */
package annotator.find;

import annotator.Main;
import annotator.find.Criteria;
import annotator.find.Criterion;
import annotator.scanner.InstanceOfScanner;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import scenelib.annotations.el.RelativeLocation;

public class InstanceOfCriterion
implements Criterion {
    private final String methodName;
    private final RelativeLocation loc;

    public InstanceOfCriterion(String methodName, RelativeLocation loc) {
        this.methodName = methodName.substring(0, methodName.lastIndexOf(")") + 1);
        this.loc = loc;
    }

    @Override
    public boolean isSatisfiedBy(TreePath path, Tree leaf) {
        if (path == null) {
            return false;
        }
        assert (path.getLeaf() == leaf);
        return this.isSatisfiedBy(path);
    }

    @Override
    public boolean isSatisfiedBy(TreePath path) {
        TreePath parentPath;
        if (path == null) {
            Criteria.dbug.debug("return null", new Object[0]);
            return false;
        }
        Tree leaf = path.getLeaf();
        if (Criteria.dbug.isEnabled()) {
            Criteria.dbug.debug("InstanceOfCriterion.isSatisfiedBy:%n", new Object[0]);
            Criteria.dbug.debug("  this: %s%n", this);
            Criteria.dbug.debug("  leaf: %s%n", Main.treeToString(leaf));
            Criteria.dbug.debug("  kind: %s%n", new Object[]{leaf.getKind()});
            Criteria.dbug.debug("  class: %s%n", leaf.getClass());
        }
        if ((parentPath = path.getParentPath()) == null) {
            Criteria.dbug.debug("return: parent path null%n", new Object[0]);
            return false;
        }
        Tree parent = parentPath.getLeaf();
        if (parent == null) {
            Criteria.dbug.debug("return: parent null%n", new Object[0]);
            return false;
        }
        if (parent.getKind() == Tree.Kind.INSTANCE_OF) {
            boolean b;
            InstanceOfTree instanceOfTree = (InstanceOfTree)parent;
            if (leaf != instanceOfTree.getType()) {
                Criteria.dbug.debug("return: not type part of instanceof%n", new Object[0]);
                return false;
            }
            int indexInSource = InstanceOfScanner.indexOfInstanceOfTree(path, parent);
            Criteria.dbug.debug("return source: %d%n", indexInSource);
            if (this.loc.isBytecodeOffset()) {
                int indexInClass = InstanceOfScanner.getMethodInstanceOfIndex(this.methodName, this.loc.offset);
                Criteria.dbug.debug("return class: %d%n", indexInClass);
                b = indexInSource == indexInClass;
            } else {
                b = indexInSource == this.loc.index;
                Criteria.dbug.debug("return loc.index: %d%n", this.loc.index);
            }
            Criteria.dbug.debug("return new: %b", b);
            return b;
        }
        boolean b = this.isSatisfiedBy(path.getParentPath());
        Criteria.dbug.debug("return parent: %b%n", b);
        return b;
    }

    @Override
    public Criterion.Kind getKind() {
        return Criterion.Kind.INSTANCE_OF;
    }

    public String toString() {
        return "InstanceOfCriterion: in method: " + this.methodName + " location: " + this.loc;
    }
}

