/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc.admin;

import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.wc.SVNAdminHelper;
import org.tmatesoft.svn.core.internal.wc.SVNCancellableEditor;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNSynchronizeEditor;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.ISVNReplayHandler;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.admin.SVNAdminClient;
import org.tmatesoft.svn.util.ISVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNReplayHandler
implements ISVNReplayHandler {
    private SVNRepository myTargetRepository;
    private boolean myHasCommitRevPropsCapability;
    private ISVNLogEntryHandler myLogEntryHandler;
    private ISVNDebugLog myDebugLog;
    private ISVNEventHandler myCanceller;
    private SVNSynchronizeEditor mySyncEditor;
    private SVNAdminClient myAdminClient;
    private int myNormalizedRevPropsCount;

    public SVNReplayHandler(SVNRepository targetRepository, boolean hasCommitRevPropsCapability, ISVNLogEntryHandler logEntryHandler, ISVNDebugLog debugLog, ISVNEventHandler canceller, SVNAdminClient adminClient) {
        this.myTargetRepository = targetRepository;
        this.myHasCommitRevPropsCapability = hasCommitRevPropsCapability;
        this.myLogEntryHandler = logEntryHandler;
        this.myDebugLog = debugLog;
        this.myCanceller = canceller;
        this.myAdminClient = adminClient;
        this.myNormalizedRevPropsCount = 0;
    }

    @Override
    public ISVNEditor handleStartRevision(long revision, SVNProperties revisionProperties) throws SVNException {
        this.myTargetRepository.setRevisionPropertyValue(0L, "svn:sync-currently-copying", SVNPropertyValue.create(SVNProperty.toString(revision)));
        SVNProperties filtered = new SVNProperties();
        this.filterProperties(revisionProperties, filtered, true);
        if (!filtered.containsName("svn:log")) {
            filtered.put("svn:log", "");
        }
        SVNProperties normalizedProps = SVNAdminClient.normalizeRevisionProperties(filtered);
        this.myNormalizedRevPropsCount += normalizedProps.size();
        if (this.mySyncEditor == null) {
            this.mySyncEditor = new SVNSynchronizeEditor(this.myTargetRepository, this.myLogEntryHandler, revision - 1L, filtered);
        } else {
            this.mySyncEditor.reset(revision - 1L, filtered);
        }
        ISVNEditor cancellableEditor = SVNCancellableEditor.newInstance(this.mySyncEditor, this.myCanceller, this.myDebugLog);
        return cancellableEditor;
    }

    @Override
    public void handleEndRevision(long revision, SVNProperties revisionProperties, ISVNEditor editor) throws SVNException {
        editor.closeEdit();
        if (this.mySyncEditor.getCommitInfo().getNewRevision() != revision) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Commit created rev {0} but should have created {1}", String.valueOf(this.mySyncEditor.getCommitInfo().getNewRevision()), String.valueOf(revision));
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        SVNProperties existingProperties = this.myTargetRepository.getRevisionProperties(revision, null);
        SVNProperties filtered = new SVNProperties();
        this.filterProperties(revisionProperties, filtered, false);
        SVNProperties normalizedProps = SVNAdminClient.normalizeRevisionProperties(filtered);
        this.myNormalizedRevPropsCount += normalizedProps.size();
        int filteredCount = SVNAdminHelper.writeRevisionProperties(this.myTargetRepository, revision, filtered);
        SVNAdminHelper.removePropertiesNotInSource(this.myTargetRepository, revision, revisionProperties, existingProperties);
        this.myTargetRepository.setRevisionPropertyValue(0L, "svn:sync-last-merged-rev", SVNPropertyValue.create(SVNProperty.toString(revision)));
        this.myTargetRepository.setRevisionPropertyValue(0L, "svn:sync-currently-copying", null);
        this.myAdminClient.handlePropertesCopied(filteredCount > 0, revision);
    }

    public int getNormalizedRevPropsCount() {
        return this.myNormalizedRevPropsCount;
    }

    public int getNormalizedNodePropsCount() {
        return this.mySyncEditor == null ? 0 : this.mySyncEditor.getNormalizedNodePropsCounter();
    }

    private int filterProperties(SVNProperties revProps, SVNProperties filteredProps, boolean isStart) {
        int filteredCount = 0;
        for (String propName : revProps.nameSet()) {
            SVNPropertyValue propValue = revProps.getSVNPropertyValue(propName);
            boolean filter = false;
            filter = isStart ? (this.myHasCommitRevPropsCapability ? this.filterExcludeDateAuthorSync(propName) : this.filterIncludeLog(propName)) : (this.myHasCommitRevPropsCapability ? this.filterIncludeDateAuthorSync(propName) : this.filterExcludeLog(propName));
            if (!filter) {
                filteredProps.put(propName, propValue);
                continue;
            }
            ++filteredCount;
        }
        return filteredCount;
    }

    private boolean filterIncludeDateAuthorSync(String propName) {
        return !this.filterExcludeDateAuthorSync(propName);
    }

    private boolean filterExcludeDateAuthorSync(String propName) {
        return "svn:author".equals(propName) || "svn:date".equals(propName) || propName.startsWith("svn:sync-");
    }

    private boolean filterIncludeLog(String propName) {
        return !this.filterExcludeLog(propName);
    }

    private boolean filterExcludeLog(String propName) {
        return "svn:log".equals(propName);
    }
}

