/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.svnlook;

import java.util.Collection;
import java.util.Collections;
import org.tmatesoft.svn.cli.AbstractSVNCommand;
import org.tmatesoft.svn.cli.svnlook.SVNLookCommandEnvironment;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.internal.io.fs.FSRepository;
import org.tmatesoft.svn.core.internal.io.fs.FSRoot;
import org.tmatesoft.svn.core.internal.io.fs.FSTransactionRoot;
import org.tmatesoft.svn.core.wc.SVNRevision;

public abstract class SVNLookCommand
extends AbstractSVNCommand {
    public SVNLookCommand(String name, String[] aliases) {
        super(name, aliases);
    }

    @Override
    public Collection getGlobalOptions() {
        return Collections.EMPTY_LIST;
    }

    protected SVNLookCommandEnvironment getSVNLookEnvironment() {
        return (SVNLookCommandEnvironment)this.getEnvironment();
    }

    @Override
    protected String getResourceBundleName() {
        return "org.tmatesoft.svn.cli.svnlook.commands";
    }

    protected FSRoot getFSRoot() throws SVNException {
        FSRepository repository = this.getSVNLookEnvironment().getRepository();
        if (this.getSVNLookEnvironment().isRevision()) {
            long rev = this.getSVNLookEnvironment().getRevision();
            if (rev < 0L) {
                rev = repository.getLatestRevision();
            }
            return repository.getFSFS().createRevisionRoot(rev);
        }
        return repository.getFSFS().createTransactionRoot(this.getSVNLookEnvironment().getTransactionInfo());
    }

    protected SVNProperties getProperties() throws SVNException {
        FSRoot root = this.getFSRoot();
        if (root instanceof FSTransactionRoot) {
            return root.getOwner().getTransactionProperties(((FSTransactionRoot)root).getTxnID());
        }
        return root.getOwner().getRevisionProperties(root.getRevision());
    }

    protected SVNRevision getRevisionObject() {
        if (!SVNRevision.isValidRevisionNumber(this.getSVNLookEnvironment().getRevision())) {
            return SVNRevision.HEAD;
        }
        return SVNRevision.create(this.getSVNLookEnvironment().getRevision());
    }
}

