/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.tmatesoft.svn.cli.AbstractSVNCommand;
import org.tmatesoft.svn.cli.SVNCommandLine;
import org.tmatesoft.svn.cli.SVNCommandUtil;
import org.tmatesoft.svn.cli.SVNOptionValue;
import org.tmatesoft.svn.core.ISVNCanceller;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNHashSet;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNPath;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.SVNBasicClient;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCClient;
import org.tmatesoft.svn.core.wc2.SvnGetInfo;
import org.tmatesoft.svn.core.wc2.SvnInfo;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public abstract class AbstractSVNCommandEnvironment
implements ISVNCanceller {
    private boolean ourIsCancelled;
    private InputStream myIn;
    private PrintStream myErr;
    private PrintStream myOut;
    private SVNClientManager myClientManager;
    private DefaultSVNOptions myOptions;
    private List myArguments;
    private String myProgramName;
    private AbstractSVNCommand myCommand;
    private String myCommandName;

    protected AbstractSVNCommandEnvironment(String programName, PrintStream out, PrintStream err, InputStream in) {
        this.myOut = out;
        this.myErr = err;
        this.myIn = in;
        this.myProgramName = programName;
    }

    public String getProgramName() {
        return this.myProgramName;
    }

    public PrintStream getOut() {
        return this.myOut;
    }

    public PrintStream getErr() {
        return this.myErr;
    }

    public InputStream getIn() {
        return this.myIn;
    }

    public SVNClientManager getClientManager() {
        return this.myClientManager;
    }

    public DefaultSVNOptions getOptions() {
        return this.myOptions;
    }

    public List getArguments() {
        return this.myArguments;
    }

    public AbstractSVNCommand getCommand() {
        return this.myCommand;
    }

    public String getCommandName() {
        return this.myCommandName;
    }

    public String popArgument() {
        if (this.myArguments.isEmpty()) {
            return null;
        }
        return (String)this.myArguments.remove(0);
    }

    protected void setArguments(List newArguments) {
        this.myArguments = newArguments;
    }

    public void init(SVNCommandLine commandLine) throws SVNException {
        this.initCommand(commandLine);
        this.initOptions(commandLine);
        this.validateOptions(commandLine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean run() {
        this.myCommand.init(this);
        try {
            this.myCommand.run();
        }
        catch (SVNException e) {
            SVNDebugLog.getDefaultLog().logSevere(SVNLogType.CLIENT, e);
            SVNErrorMessage err = e.getErrorMessage();
            if (err.getErrorCode() == SVNErrorCode.CL_INSUFFICIENT_ARGS || err.getErrorCode() == SVNErrorCode.CL_ARG_PARSING_ERROR) {
                err = err.wrap("Try ''{0} help'' for more info", this.getProgramName());
            }
            this.handleError(err);
            while (err != null) {
                if (err.getErrorCode() == SVNErrorCode.WC_LOCKED) {
                    this.getErr().println("svn: run 'jsvn cleanup' to remove locks (type 'jsvn help cleanup' for details)");
                    break;
                }
                err = err.getChildErrorMessage();
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.getOut().flush();
            this.getErr().flush();
        }
        return !this.myCommand.isFailed();
    }

    protected void initOptions(SVNCommandLine commandLine) throws SVNException {
        Iterator options = commandLine.optionValues();
        while (options.hasNext()) {
            SVNOptionValue optionValue = (SVNOptionValue)options.next();
            this.initOption(optionValue);
        }
        this.myArguments = new LinkedList(commandLine.getArguments());
    }

    protected abstract void initOption(SVNOptionValue var1) throws SVNException;

    protected void validateOptions(SVNCommandLine commandLine) throws SVNException {
        Iterator options = commandLine.optionValues();
        while (options.hasNext()) {
            SVNOptionValue optionValue = (SVNOptionValue)options.next();
            if (this.myCommand.isOptionSupported(optionValue.getOption())) continue;
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CL_ARG_PARSING_ERROR, "Subcommand ''{0}'' doesn''t accept option ''{1}''", this.myCommand.getName(), optionValue.getName());
            SVNErrorManager.error(err, SVNLogType.CLIENT);
        }
    }

    protected void initCommand(SVNCommandLine commandLine) throws SVNException {
        this.myCommandName = this.getCommandName(commandLine);
        this.myCommand = AbstractSVNCommand.getCommand(this.myCommandName);
        if (this.myCommand == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CL_ARG_PARSING_ERROR, "Unknown command ''{0}''", (Object)this.myCommandName);
            SVNErrorManager.error(err, SVNLogType.CLIENT);
        }
    }

    protected String getCommandName(SVNCommandLine commandLine) throws SVNException {
        String commandName = commandLine.getCommandName();
        return this.refineCommandName(commandName, commandLine);
    }

    protected abstract String refineCommandName(String var1, SVNCommandLine var2) throws SVNException;

    protected abstract DefaultSVNOptions createClientOptions() throws SVNException;

    protected abstract ISVNAuthenticationManager createClientAuthenticationManager();

    protected abstract String getCommandLineClientName();

    public void initClientManager() throws SVNException {
        this.myOptions = this.createClientOptions();
        this.myClientManager = this.createClientManager();
    }

    public void dispose() {
        if (this.myClientManager != null) {
            this.myClientManager.dispose();
            this.myClientManager = null;
        }
    }

    public List<String> combineTargets(Collection targets, boolean warnReserved) throws SVNException {
        LinkedList result = new LinkedList();
        result.addAll(this.getArguments());
        if (targets != null) {
            result.addAll(targets);
        }
        boolean hasRelativeURLs = false;
        SVNURL rootURL = null;
        for (String target : result) {
            if (!AbstractSVNCommandEnvironment.isReposRelative(target)) continue;
            hasRelativeURLs = true;
        }
        ArrayList<String> canonical = new ArrayList<String>(result.size());
        targets = new ArrayList<String>(result.size());
        for (String path : result) {
            if (AbstractSVNCommandEnvironment.isReposRelative(path)) {
                targets.add(path);
                continue;
            }
            if (SVNCommandUtil.isURL(path)) {
                path = SVNEncodingUtil.autoURIEncode(path);
                try {
                    SVNEncodingUtil.assertURISafe(path);
                }
                catch (SVNException e) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.BAD_URL, "URL '" + path + "' is not properly URI-encoded");
                    SVNErrorManager.error(err, SVNLogType.CLIENT);
                }
                if (path.indexOf("/../") >= 0 || path.endsWith("/..")) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.BAD_URL, "URL '" + path + "' contains '..' element");
                    SVNErrorManager.error(err, SVNLogType.CLIENT);
                }
                path = SVNPathUtil.canonicalizePath(path);
            } else {
                path = path.replace(File.separatorChar, '/');
                path = SVNPathUtil.canonicalizePath(path);
                String name = SVNPathUtil.tail(path);
                if (SVNFileUtil.getAdminDirectoryName().equals(name) || ".svn".equals(name) || "_svn".equals(name)) {
                    if (!warnReserved) continue;
                    this.getErr().printf("Skipping argument: E%d: '%s' ends in a reserved name\n", SVNErrorCode.RESERVED_FILENAME_SPECIFIED.getCode(), path);
                    continue;
                }
            }
            if (hasRelativeURLs) {
                rootURL = this.checkRootURLOfTarget(rootURL, path);
            }
            targets.add(path);
        }
        if (hasRelativeURLs) {
            if (rootURL == null) {
                SVNWCClient wcClient = this.getClientManager().getWCClient();
                rootURL = wcClient.getReposRoot(new File("").getAbsoluteFile(), null, SVNRevision.BASE);
            }
            for (String target : targets) {
                if (AbstractSVNCommandEnvironment.isReposRelative(target)) {
                    String pegRevisionString = null;
                    int ind = target.indexOf(64);
                    if (ind != -1) {
                        target = target.substring(0, ind);
                        pegRevisionString = target.substring(ind);
                    }
                    SVNURL targetURL = this.resolveRepositoryRelativeURL(rootURL, target);
                    target = targetURL.toString();
                    if (pegRevisionString != null) {
                        target = target + pegRevisionString;
                    }
                }
                canonical.add(target);
            }
        } else {
            canonical.addAll(targets);
        }
        return canonical;
    }

    public SVNRevision[] parseRevision(String revStr) {
        SVNRevision[] sVNRevisionArray;
        Matcher matcher = Pattern.compile("(\\{[^\\}]+\\}|[^:]+)((:)(.*))?").matcher(revStr);
        matcher.matches();
        boolean colon = ":".equals(matcher.group(3));
        SVNRevision r1 = SVNRevision.parse(matcher.group(1));
        SVNRevision r2 = SVNRevision.parse(matcher.group(4));
        if (colon && (r1 == SVNRevision.UNDEFINED || r2 == SVNRevision.UNDEFINED) || r1 == SVNRevision.UNDEFINED) {
            sVNRevisionArray = null;
        } else {
            SVNRevision[] sVNRevisionArray2 = new SVNRevision[2];
            sVNRevisionArray2[0] = r1;
            sVNRevisionArray = sVNRevisionArray2;
            sVNRevisionArray2[1] = r2;
        }
        return sVNRevisionArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readFromFile(File file) throws SVNException {
        InputStream is = null;
        ByteArrayOutputStream bos = null;
        try {
            int read;
            file = file.getAbsoluteFile();
            is = SVNFileUtil.openFileForReading(file);
            bos = new ByteArrayOutputStream();
            byte[] buffer = new byte[2048];
            while ((read = is.read(buffer)) >= 0) {
                bos.write(buffer, 0, read);
            }
        }
        catch (IOException e) {
            try {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getMessage());
                SVNErrorManager.error(err, SVNLogType.CLIENT);
            }
            catch (Throwable throwable) {
                SVNFileUtil.closeFile(is);
                throw throwable;
            }
            SVNFileUtil.closeFile(is);
        }
        SVNFileUtil.closeFile(is);
        return bos != null ? bos.toByteArray() : null;
    }

    public void handleError(SVNErrorMessage err) {
        SVNHashSet codes = new SVNHashSet();
        int count = 0;
        while (err != null && count < 3) {
            Object[] objects;
            SVNErrorCode errorCode = err.getErrorCode();
            if ("".equals(err.getMessageTemplate()) && codes.contains(errorCode)) {
                err = err.hasChildErrorMessage() ? err.getChildErrorMessage() : null;
                continue;
            }
            if ("".equals(err.getMessageTemplate())) {
                codes.add(errorCode);
            }
            if ((objects = err.getRelatedObjects()) != null && objects.length > 0) {
                String msg;
                String template = err.getMessageTemplate();
                for (int i = 0; i < objects.length; ++i) {
                    if (objects[i] instanceof File) {
                        objects[i] = SVNCommandUtil.getLocalPath(this.getRelativePath((File)objects[i]));
                        continue;
                    }
                    if (!(objects[i] instanceof Number)) continue;
                    objects[i] = objects[i].toString();
                }
                String message = template;
                if (objects.length > 0) {
                    try {
                        message = MessageFormat.format(template, objects);
                    }
                    catch (IllegalArgumentException e) {
                        message = template;
                    }
                }
                if (err.getType() == 1) {
                    msg = this.getCommandLineClientName() + ": warning: " + (err.isErrorCodeShouldShown() ? "W" + errorCode.getCode() + ": " : "") + message;
                    this.getErr().println(msg);
                } else {
                    msg = this.getCommandLineClientName() + ": " + (err.isErrorCodeShouldShown() ? "E" + errorCode.getCode() + ": " : "") + message;
                    this.getErr().println(msg);
                    ++count;
                }
            } else {
                this.getErr().println(err.getMessage());
                ++count;
            }
            err = err.hasChildErrorMessage() ? err.getChildErrorMessage() : null;
        }
    }

    public boolean handleWarning(SVNErrorMessage err, SVNErrorCode[] warningCodes, boolean quiet) throws SVNException {
        if (err == null) {
            return true;
        }
        SVNErrorCode code = err.getErrorCode();
        for (int i = 0; i < warningCodes.length; ++i) {
            if (code != warningCodes[i]) continue;
            if (!quiet) {
                err.setType(1);
                err.setChildErrorMessage(null);
                this.handleError(err);
            }
            return false;
        }
        throw new SVNException(err);
    }

    public String getRelativePath(File file) {
        String basePath;
        String inPath = file.getAbsolutePath().replace(File.separatorChar, '/');
        String commonRoot = AbstractSVNCommandEnvironment.getCommonAncestor(inPath, basePath = new File("").getAbsolutePath().replace(File.separatorChar, '/'));
        if (commonRoot != null && commonRoot.length() > 0) {
            if (AbstractSVNCommandEnvironment.equals(inPath, commonRoot)) {
                return "";
            }
            if (AbstractSVNCommandEnvironment.startsWith(inPath, commonRoot + "/") && !"/".equals(inPath)) {
                return inPath.substring(commonRoot.length() + 1);
            }
        }
        return inPath;
    }

    public SVNURL getURLFromTarget(String target) throws SVNException {
        if (SVNCommandUtil.isURL(target)) {
            return SVNURL.parseURIEncoded(target);
        }
        try {
            SvnGetInfo info = new SvnOperationFactory().createGetInfo();
            info.setSingleTarget(SvnTarget.fromFile(new File(target)));
            info.setDepth(SVNDepth.EMPTY);
            SvnInfo i = (SvnInfo)info.run();
            return i != null ? i.getUrl() : null;
        }
        catch (SVNException sVNException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isVersioned(String target) throws SVNException {
        SVNPath commandTarget = new SVNPath(target);
        if (SVNBasicClient.isWC17Supported()) {
            SVNWCContext context = null;
            try {
                context = new SVNWCContext(this.getOptions(), null);
                File file = commandTarget.getFile();
                if (file == null) return false;
                SVNNodeKind kind = context.readKind(file.getAbsoluteFile(), false);
                boolean bl = kind != null && kind != SVNNodeKind.NONE && kind != SVNNodeKind.UNKNOWN;
                return bl;
            }
            catch (SVNException e) {
                return false;
            }
            finally {
                if (context != null) {
                    context.close();
                }
            }
        }
        SVNWCAccess wcAccess = null;
        try {
            wcAccess = SVNWCAccess.newInstance(null);
            wcAccess.probeOpen(commandTarget.getFile(), false, 0);
            SVNEntry entry = wcAccess.getVersionedEntry(commandTarget.getFile(), false);
            boolean bl = entry != null;
            return bl;
        }
        catch (SVNException e) {
            return false;
        }
        finally {
            if (wcAccess != null) {
                wcAccess.close();
            }
        }
    }

    public void printCommitInfo(SVNCommitInfo info) {
        if (info != null && info.getNewRevision() >= 0L && info != SVNCommitInfo.NULL) {
            this.getOut().println("\nCommitted revision " + info.getNewRevision() + ".");
            if (info.getErrorMessage() != null && info.getErrorMessage().isWarning()) {
                this.getOut().println("\n" + info.getErrorMessage().getMessage());
            }
        }
    }

    private SVNURL resolveRepositoryRelativeURL(SVNURL rootURL, String relativeURL) throws SVNException {
        if (!AbstractSVNCommandEnvironment.isReposRelative(relativeURL)) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.BAD_URL, "Improper relative URL ''{0}''", (Object)relativeURL);
            SVNErrorManager.error(err, SVNLogType.CLIENT);
        }
        relativeURL = relativeURL.substring(2);
        SVNURL url = rootURL.appendPath(relativeURL, true);
        return url;
    }

    private SVNURL checkRootURLOfTarget(SVNURL rootURL, String target) throws SVNException {
        SVNPath svnPath = new SVNPath(target, true);
        SVNWCClient client = this.getClientManager().getWCClient();
        File path = svnPath.isFile() ? svnPath.getFile() : null;
        SVNURL url = svnPath.isURL() ? svnPath.getURL() : null;
        SVNURL tmpRootURL = null;
        try {
            tmpRootURL = client.getReposRoot(path, url, svnPath.getPegRevision());
        }
        catch (SVNException svne) {
            SVNErrorMessage err = svne.getErrorMessage();
            if (err.getErrorCode() == SVNErrorCode.ENTRY_NOT_FOUND || err.getErrorCode() == SVNErrorCode.WC_NOT_DIRECTORY) {
                return rootURL;
            }
            throw svne;
        }
        if (rootURL != null) {
            if (!rootURL.equals(tmpRootURL)) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "All non-relative targets must have the same root URL");
                SVNErrorManager.error(err, SVNLogType.CLIENT);
            }
            return rootURL;
        }
        return tmpRootURL;
    }

    private static boolean isReposRelative(String path) {
        return path != null && path.startsWith("^/");
    }

    private static boolean startsWith(String p1, String p2) {
        if (SVNFileUtil.isWindows || SVNFileUtil.isOpenVMS) {
            return p1.toLowerCase().startsWith(p2.toLowerCase());
        }
        return p1.startsWith(p2);
    }

    private static boolean equals(String p1, String p2) {
        if (SVNFileUtil.isWindows || SVNFileUtil.isOpenVMS) {
            return p1.toLowerCase().equals(p2.toLowerCase());
        }
        return p1.equals(p2);
    }

    private static String getCommonAncestor(String p1, String p2) {
        if (SVNFileUtil.isWindows || SVNFileUtil.isOpenVMS) {
            String ancestor = SVNPathUtil.getCommonPathAncestor(p1.toLowerCase(), p2.toLowerCase());
            if (AbstractSVNCommandEnvironment.equals(ancestor, p1)) {
                return p1;
            }
            if (AbstractSVNCommandEnvironment.equals(ancestor, p2)) {
                return p2;
            }
            if (AbstractSVNCommandEnvironment.startsWith(p1, ancestor)) {
                return p1.substring(0, ancestor.length());
            }
            return ancestor;
        }
        return SVNPathUtil.getCommonPathAncestor(p1, p2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkCancelled() throws SVNCancelException {
        Class<AbstractSVNCommandEnvironment> clazz = AbstractSVNCommandEnvironment.class;
        synchronized (AbstractSVNCommandEnvironment.class) {
            if (this.ourIsCancelled) {
                SVNErrorManager.cancel("operation cancelled", SVNLogType.CLIENT);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCancelled() {
        Class<AbstractSVNCommandEnvironment> clazz = AbstractSVNCommandEnvironment.class;
        synchronized (AbstractSVNCommandEnvironment.class) {
            this.ourIsCancelled = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public SVNClientManager createClientManager() {
        SVNClientManager clientManager = SVNClientManager.newInstance((ISVNOptions)this.myOptions, this.createClientAuthenticationManager());
        clientManager.setEventHandler(new ISVNEventHandler(){

            @Override
            public void handleEvent(SVNEvent event, double progress) throws SVNException {
            }

            @Override
            public void checkCancelled() throws SVNCancelException {
                AbstractSVNCommandEnvironment.this.checkCancelled();
            }
        });
        return clientManager;
    }
}

