/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.util.expressionannotations;

import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.VariableTree;
import javax.lang.model.element.Element;
import javax.lang.model.element.VariableElement;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.treeannotator.TreeAnnotator;
import org.checkerframework.framework.util.expressionannotations.ExpressionAnnotationHelper;
import org.checkerframework.javacutil.TreeUtils;

public class ExpressionAnnotationTreeAnnotator
extends TreeAnnotator {
    private final ExpressionAnnotationHelper helper;

    public ExpressionAnnotationTreeAnnotator(AnnotatedTypeFactory atypeFactory, ExpressionAnnotationHelper helper) {
        super(atypeFactory);
        this.helper = helper;
    }

    @Override
    public Void visitNewArray(NewArrayTree node, AnnotatedTypeMirror annotatedType) {
        this.helper.standardizeExpression(node, annotatedType);
        return (Void)super.visitNewArray(node, annotatedType);
    }

    @Override
    public Void visitNewClass(NewClassTree node, AnnotatedTypeMirror annotatedType) {
        this.helper.standardizeExpression(node, annotatedType);
        return (Void)super.visitNewClass(node, annotatedType);
    }

    @Override
    public Void visitTypeCast(TypeCastTree node, AnnotatedTypeMirror annotatedType) {
        this.helper.standardizeExpression(node, annotatedType);
        return (Void)super.visitTypeCast(node, annotatedType);
    }

    @Override
    public Void visitVariable(VariableTree node, AnnotatedTypeMirror annotatedTypeMirror) {
        VariableElement ele = TreeUtils.elementFromDeclaration(node);
        this.helper.standardizeVariable(node, annotatedTypeMirror, ele);
        return (Void)super.visitVariable(node, annotatedTypeMirror);
    }

    @Override
    public Void visitIdentifier(IdentifierTree node, AnnotatedTypeMirror annotatedTypeMirror) {
        Element ele = TreeUtils.elementFromUse(node);
        this.helper.standardizeVariable(node, annotatedTypeMirror, ele);
        return (Void)super.visitIdentifier(node, annotatedTypeMirror);
    }

    @Override
    public Void visitMemberSelect(MemberSelectTree node, AnnotatedTypeMirror type) {
        this.helper.standardizeFieldAccess(node, type);
        return (Void)super.visitMemberSelect(node, type);
    }
}

